
## 5.2.3 Zenotravel: Timed

The Timed version further complicates the timing of the actions. Boarding and disembarking times are constant but problem-specific and are defined in the respective problem definition as two new functions, boarding-time and debarking-time**. Refueling always fills the** plane to its maximum capacity, but consumes time relative to **the amount of fuel received** and the refuel-rate **of the aircraft. Each aircraft also has a** fast-speed **and a** slow-speed **with** corresponding fast-burn and slow-burn **fuel consumption. The distances between cities are**
specified using the distance(city1, city2) **function.**
In the Timed version, operator durations have to be correctly calculated with a precision of three decimals, prompting the TALplanner changes discussed in Sections 4.5 and 4.6. Once these extensions to TALplanner had been implemented, few changes were needed to transform the SimpleTime domain to the Timed version.

The most important difference was perhaps the fact that depending on the speed and fuel consumption values defined in each problem and the situation **where the operator is used, it** is sometimes better to use the fly **operator and sometimes better to use the** zoom **operator,** unlike the STRIPS version where fly **was always better and the SimpleTime domain where**
zoom **was always better.**
So when is zooming better than flying? It may seem like it would **be easy to answer**
this question, given that we are only interested in minimizing time: Just check whether refueling the aircraft sufficiently to be able to zoom, followed by zooming to the destination, would be faster than only refueling enough to be able to fly and **then flying more slowly to**
the destination. This is handled by the first clause in use-fly-instead-of-zoom **below. The** precondition of fly **is then altered to require that** use-fly-instead-of-zoom **be true, and the** precondition of zoom **requires that** use-fly-instead-of-zoom **be false. If we had been interested** in minimizing a combination of time and fuel usage, then this **could also have been taken** into account.

This is not quite sufficient to handle all problems, though. An **airplane has a maximum**
fuel capacity, so if its destination is too distant, it may not be able to zoom. This is handled by the second clause in use-fly-instead-of-zoom.

Yet another problem is that it is not possible to tie one refueling action to each flight, as one would expect in the real world. There are two reasons for this problem.

First, airplanes may already have some fuel in the initial state, so in some situations a plane might zoom to its destination without incurring any additional cost, again assuming that the time required for executing the plan is the only metric being used - the plane already had enough fuel anyway and never had to refuel.

Second, unlike the SimpleTime version, an airplane cannot refuel "just enough" - the refuel **operator always fills the tank completely. This change was most likely introduced in** order to make the planning task easier by reducing the number **of possible actions to choose**
from (for example, a planner that needs to create all ground instances of each operator might have some trouble if the refuel operator would take the **amount of fuel as a floating**
point argument). But despite the probable intention behind **this change, it introduces new** problems for our control formulas. If a plane's tank is half full and this is enough fuel to zoom from A to B, it might then have to fill the entire **tank before continuing to C, while** if it used the fly operator, it might be able to continue to C without refueling **at all. This**