means that one would have to take all possible future flights into account when determining whether to fly or zoom. If the domain had been modeled in more detail, this problem would not have existed.

Given these two complications, guaranteeing an optimal or near-optimal plan using a control rule is not easy, which is indeed only to be expected. **For the competition we decided**
to be satisfied with a heuristic compromise, adding a third clause to use-fly-instead-of-zoom ensuring that if zooming would require refueling immediately **but flying would not, the** fly operator would be used.

## // Fly Is (Probably) Better Than Zoom If: #Define [T] **Use-Fly-Instead-Of-Zoom(Aircraft, City1, City2)**:

// If fly is faster wrt speed and refueling.

([t] (10000 / slow-speed(aircraft) + 10000 * slow-burn(aircraft) / refuel-rate(aircraft)) <
(10000 / fast-speed(aircraft) +10000 * fast-burn(aircraft) / refuel-rate(aircraft))) ∨
// If zoom is impossible across the given distance.

([t] distance(city1, city2) * fast-burn(aircraft) > capacity(aircraft)) ∨
// If zoom has to refuel immediately but fly does not.

([t] fuel(aircraft) >= distance(city1, city2) * slow-burn(aircraft) ∧
fuel(aircraft) < distance(city1, city2) * fast-burn(aircraft))

## 5.2.4 Zenotravel: Discussion

Finding control rules that yield good (but usually suboptimal) plans is not too difficult in the ZenoTravel domain. There are no risks involved in flying a **plane to pick up passengers**
since all the passengers will always fit in the plane and refueling is possible in any city. In other words, it is not really possible to get stuck while looking for a solution. Also, since the graph of cities is fully connected, no route planning is necessary.

A fourth version of ZenoTravel, called Numeric, was available in the contest but due to lack of time we decided not to compete in this domain.

Among other things, the numeric version contains an additional constraint on the number of passengers that an aircraft can carry. At a first glance, this constraint may seem to introduce new problems. However, it is only enforced in the zoom operator, and since the numeric domain does not make use of durational operators, it **suffers from the same problem**
as the STRIPS domain: The zoom operator consumes more fuel and limits the number of passengers, but does not deliver any advantages because it is no faster than flying.

The real difficulty in the Numeric version comes from the use of **problem-specific metrics**
that measure the quality of a solution. For example, for one problem the planner may be required to minimize total-time + 3 * total-fuel-used**, while for another problem it may be** required to minimize total-time **only. Until now, we have usually been satisfied with finding** plans of good but not optimal quality, and this has been done by tuning control rules, for example by introducing the use-fly-instead-of-zoom **function to determine whether** fly or zoom should be used, as discussed above. This tuning is naturally **done on the domain level** rather than the problem level. An optimizing version of TALplanner is under development.