domain there may only be direct roads between some **locations (specified by a predicate**
link(from, to)), and a truck may have to move through several intermediate **locations in**
order to reach its destination. Consequently the control rules must be relaxed to allow trucks to visit locations that are not useful in themselves. **Nevertheless, some degree of** goal-directedness is still required. One possible method is to identify for each vehicle the set of locations where the vehicle might be useful, and to require that it chooses one such location and then takes the shortest path to its chosen destination. This method was used in the competition with the help of the built-in shortest path algorithm discussed in Section 4.8 and a control rule stating that each step (each invocation of drive or walk**) must**
decrease the distance to the current destination. The following definitions will be explained below:

#define [t] **reasonable-truck-location**(truck, location): // Omitted due to space constraints
\#distfeature **driving-distance-between**(from, to) :domain integer :link link
\#mindistfeature **driving-distance-to-location-satisfying-formula**
:distfeature driving-distance-between :domain integer
\#define [t] **driving-distance-to-reasonable-destination**(truck, location):
driving-distance-to-location-satisfying-formula(location, to,
[t] reasonable-truck-location(truck, to))
A boolean fluent reasonable-truck-location(truck, loc**) is defined in terms of a logic formula,** which specifies whether the given location is a reasonable destination for a given truck at the timepoint when it is evaluated. The driving-distance-between **function accesses the shortest** path algorithm to find the length of the shortest path between from and to**, given that**
the road links are specified by the link **predicate. The** driving-distance-to-location-satisfyingformula **function accesses another version of the shortest path algorithm and is used in**
driving-distance-to-reasonable-destination in order to find the shortest distance from **location**
to any location to **that satisfies** reasonable-truck-location**. Since all links have the same cost,**
it is then sufficient to require that whenever a truck moves, its driving-distance-to-reasonabledestination **decreases.**
Further changes were required due to the use of drivers. There may not be drivers for all trucks, so packages should not be loaded into a truck until the planner knows the truck will have a driver. Drivers should not disembark if there are **still packages in the truck, or** if there is a goal that the truck must be somewhere else. Drivers may have to walk along paths in order to reach a truck, so just like trucks, drivers must select one useful destination and then take the shortest path to their chosen destinations.

Additional control rules ensure that multiple trucks do not **choose the same destination**
unnecessarily, and that multiple drivers do not choose to walk to the same location.

SimpleTime. **In the SimpleTime version, loading and unloading objects takes two units**
of time, driving takes ten units, and walking takes twenty units. The operators are changed accordingly, and a going-to **fluent is introduced to keep track of drivers and trucks that are** moving towards a new location but have not yet arrived. A few minor adjustments must be made to the control rules.

Timed. **In the Timed version, the time required to walk or drive between two locations is**