determined by a pair of functions specified in each problem instance. Since individual road segments can have different lengths, the method we used to ensure drivers and trucks used the shortest path to their current destination is no longer sufficient, and must be modified slightly. Other than this, there are no major changes for the **Timed version.**

## 5.5 The Rovers Domain

The Rovers domain simulates a simplified planetary exploration expedition. A lander vessel carries a number of rovers to the planet surface and provides **a communication link back to** Earth. Each rover has a subset of the general capabilities, retrieving soil samples, retrieving rock samples and capturing images using cameras that support different imaging modes.

The cameras are mounted on the rovers, as are storage compartments, one for each rover, which can hold one soil sample or one rock sample. Data from a sample must be sent to the lander by a communication link. All missions revolve around navigating waypoints on the planets surface to collect samples and take images of specified objectives that are only visible from certain waypoints. The terrain may prevent rovers from going directly between two waypoints and different rovers handle different terrain so a list of routes each rover can use is provided.

STRIPS. **Following a control scheme similar to the one used in DriverLog, we limit the**
movements of rovers to locations where they can perform some **useful action like collecting**
a rock sample or capturing an image. The problem of finding a path from one waypoint to another is also solved in the same way as in DriverLog, except **that each rover has its own** set of routes between waypoints.

SimpleTime. The changes in the SimpleTime version are trivial: Operator **durations are**
changed, a few mutual exclusion relations need to be enforced, and a new fluent calibrating(camera) **keeps track of whether a certain camera is being calibrated.**
Timed. **The Timed version introduces the concept of energy, where each rover has a limited**
amount of energy and each action it does consumes some of the energy. This is similar to the use of fuel in the ZenoTravel domain, but there is also a major **difference: The rovers have** been equipped with solar panels that recharge the rover, but **only some of the waypoints** that a rover can go to are directly exposed to the sun, which is **a requirement for the solar** panels to work. The airplanes in the ZenoTravel domain can refuel anywhere, and so fuel usage is only relevant in terms of minimization of resource usage, whereas a rover that uses its energy unwisely can get stuck in the shade, unable to do anything or go anywhere. To prevent this we can either let the planner backtrack and search for a better plan, or we can introduce stricter rules that keep energy levels in mind **when deciding what a rover is** allowed to do. The latter approach is taken below.

The critical point is when a rover does not have enough energy **to reach a waypoint in**
the sun and recharge. Using the shortest path algorithm it is **possible for a control rule to** determine the distance to the closest waypoint that is exposed to the sun. In addition to all waypoints that were previously allowed, it is also reasonable for a rover to go to a waypoint that is exposed to the sun if the rover does not have enough energy to perform an action and then go recharge, or if there do not exist any other waypoints that are both affordable and reasonable to visit.