\#define [t] goal **direction**(satellite, direction):
[t] take image possible(satellite, direction) ∨
∃instrument [
[t] power on(instrument) ∧ ¬calibrated(instrument) ∧ [t] calibration target(instrument, direction) ∧ on board(instrument, satellite) ] ∨
goal(pointing(satellite, direction)) ∧ [t] all images collected The take image possible **function checks not only if an image is to be collected but also** that it has not already been taken and that the satellite has the necessary instrumentation ready. If the active instrument is not calibrated, the satellite may first have to turn towards another direction and calibrate it.

\#define [t] take image **possible**(satellite, direction):
∃mode [ goal (have image(direction, mode)) ∧
[t] ¬have image(direction, mode) ∧
∃instrument [
[t] power on(instrument) ∧ calibrated(instrument) ∧ [t] on board(instrument, satellite) ∧ supports(instrument, mode) ]]
The switch on and switch off **operators are still not regulated by control rules and the**
planner quickly takes up the habit of repeatedly flipping the **power to different instruments**
on and off. Once an instrument has been powered on and calibrated, using it as much as possible before switching to another instrument seems reasonable. A usefulness function, putting a value on the usefulness of a particular instrument, helps decide which instrument to power on first.

\#define [t] **usefulness**(instrument):
value(t, $sum(<mode>, [t] supports(instrument, mode) ∧ mode needed for goal(mode), 1))

#define [t] mode needed for **goal**(mode):
∃direction [ goal(have image(direction, mode)) ∧ [t] ¬have image(direction, mode) ]
Add one to the usefulness score of an instrument for each imaging mode that it supports and that is needed in some goal. This score is then used in a control rule that chooses a satellite's most useful instrument, if it has any. \#control :name "**use-the-most-useful-instrument**"
[t] ¬power on(instrument) ∧ [t+1] power on(instrument) →
[t] usefulness(instrument) > 0 ∧
¬∃satellite, instrument2 [
[t] usefulness(instrument2) > usefulness(instrument) ∧ [t] on board(instrument, satellite) ∧ on board(instrument2, satellite) ]
Switching off an instrument is only allowed if the instrument **is no longer required.** \#control :name "**don't-switch-instrument-off-if-you-don't-have-to**"
[t] power on(instrument) ∧ [t+1] ¬power on(instrument)) →
[t] ¬∃mode [ supports(instrument, mode) ∧ mode needed for goal(mode) ]
We have run out of more or less obvious improvements, but analyzing the planner output reveals one remaining inefficiency: The satellites often simultaneously decide to turn to the