same direction because a picture needs to be taken in that direction, despite the fact that only one satellite needs to take the picture. This is similar **to the situation in the ZenoTravel**
domain where a number of aircraft may concurrently choose to **pick up the same passenger,**
but there are some differences due to the fact that the only **reason for a satellite to point** in a certain direction is in order to calibrate itself or take **an image, which makes the task**
somewhat easier.

Therefore this problem can be solved in a different way, using **a resource for mutual**
exclusion. This resource, called point towards(direction**) and having a capacity of 1, can be** borrowed temporarily by turn to **for the duration of the turn. If one satellite turns towards a**
specific direction d, no other satellite can turn towards d **without causing a resource conflict.**
This still leaves one problem: When the first satellite has finished turning, it no longer owns the point towards(d) resource and therefore another satellite can immediately **start**
turning towards d**. It is no longer possible for more than one satellite to turn towards the**
same direction at once, but while the first satellite is taking pictures, other satellites can turn to that direction one by one, until finally all the desired pictures have been taken in that direction and goal direction **sees that there is no longer any valid reason to point**
towards d**. This can be solved either by changing the definition of** goal direction **or by letting**
take image **borrow the same resource.**
Clearly, this type of "swarming" problem occurs quite often **in concurrent domains and**
a more principled solution should be investigated in the future.

## 5.6.2 Satellite: Simpletime

The SimpleTime version changes the duration of some operators. Turning takes five time units, switching an instrument on takes two units, calibrating it takes five units and taking a picture takes seven units. A couple of helper fluents, turning towards, calibrating, have image generalized **(an image exists or is being taken) and** power on generalized **(power** is on or a switch on **action is being executed) keep track of actions that have begun but not** completed. The affected control rules are updated accordingly.

## 5.6.3 Satellite: Timed

The Timed version of the Satellite domain includes two new functions. The calibration time specifies the time required to calibrate, while the slew time **function represents the time** required for a satellite to turn between two directions. Neither of these changes prompts any significant changes to the SimpleTime control.

## 5.6.4 Satellite: Discussion

The Satellite domain does not provide a real challenge as long as the planner is only trying to find a correct plan. Finding a short plan is harder, especially in the Timed version, and would require additional analysis to determine in which order images should be collected and which satellites should be used for each image. Doing this using control rules seemed a bit like overkill, especially since we had not yet created control rules for the complex UMTranslog-2 domain. For this reason, we decided to be satisfied with what we had done so far, and were surprised when the plans we generated turned **out to be of considerably**
lower quality than those produced by some other planners.