The L(ND) language is designed to be easily extended for different **tasks, such as planning. An extension may take the shape of a new specialized macro or a new type of**
statement. As illustrated in Figure 1, a TALplanner goal narrative uses a version of L**(ND)**
called L(ND)∗, which contains some of the standard classes of L**(ND) statements together**
with several new types of planning-related statements. These extensions are accompanied by extensions to the translation function, so that the new variation of TAL can still share the same base language L**(FL).**
However, TALplanner does not use TAL
Goal Narrative L(ND)*
TALPlanner TAL
Plan Narrative L(ND)
this translation directly during the planning process. Instead, it makes direct use of the higher level L(ND)∗ **goal narrative**
in a forward-chaining search process and generates a plan narrative **where a set of** timed action occurrences (corresponding to a plan) has been added, and where the goal is entailed in the final state.

In this section, we will attempt to provide an intuitive understanding of TAL
and how it is used in domain specifications using concrete examples from the standard logistics planning domain, where a set of objects (packages) can be transported by truck between locations in the same city and by airplane between airports in different cities. The next section contains further information about the search process and the use of control rules. See Doherty et al. (1998)
for a more detailed description of TAL, and see Kvarnstr¨om and Doherty (2000) for more information about TALplanner.

Notation. All formulas and L**(ND) statements below will be shown using the input syntax**
for TALplanner, with the exception of some connectives and quantifiers that may be written using the ordinary logical symbols for increased clarity. All free variables are implicitly universally quantified.

L(FL)
1st−order theory T'
L(FL)
1st−order theory T

```
           + Circ(T)
L(FL) L(FL) + Quantifier Elimination
                                              1st−order
                                                    + Circ(T)
                                                    + Q.E.
     1st−order
      theory theory Goal

```

Figure 1: TAL/TALplanner relation

## 2.1 Types, Objects And State Variables

Although some planners are restricted to declaring an unstructured set of objects and representing types as unary predicates, TAL is order-sorted and allows the user to specify a hierarchy of object types (sorts). The logistics domain can **be modeled using the standard**
sort boolean = {true, false} **together with the seven user-specified types:** loc **(location) has**
the subtypes airport and city**, while** thing **has the subtypes** obj and vehicle**, the latter of** which has the subtypes truck and plane.

TALplanner also allows the use of numeric types. In order to keep the semantics of these types clear, only integers and fixed point numbers (that is, numbers with a fixed number of decimals) are allowed, and lower and upper bounds must be declared for each numeric type. All of the standard arithmetic operators are available for the numeric types and are given an interpretation through semantic attachment.

State variables are represented using TAL fluents, which are **not restricted to being**