After the contest, we were informed of the reason, or at least **the main reason: The**
automatic problem generator that created the problem instances randomized the slew times between every pair of directions and did not check for geometrical consistency that would be present in a real world situation. We had subconsciously assumed that the problem instances satisfied the triangle inequality, but this was not the case, **and the other planning teams had**
discovered this. For example, in handcoded problem 14, turning a satellite directly between phenomenon86 and groundstation4 **takes 82.860 units of time, while turning it through two** carefully selected intermediate directions requires 1.183 units of time.

Initial testing shows that taking this into consideration and once again using the built-in shortest path algorithm yields significantly shorter plans **when plan length is measured by** the time point at which the goals have been satisfied.

Another potential improvement would be to change the last clause in goal direction to allow satellites to turn towards a direction specified in the **goals as soon as one has started** taking the last picture, rather than waiting until one has finished taking the last picture.

## 5.7 The Umtranslog-2 Domain

The UMTranslog-2 domain is another logistics domain, but with 14 types, 38 predicates, 24 functions and 38 operators, its size and complexity is incomparable to the previously encountered logistics domains in the contest.

Since the formal domain definition was the only information provided about the domain and there was no high-level description, we had to work out all the information about the domain from the PDDL definition. This was not a major problem for the previous domains, since they were generally quite simple and easy to understand, but it did give us some problems in UMTranslog-2. A significant amount of time was spent trying to determine exactly how packages were allowed to move and how they can be loaded into and unloaded from various kinds of vehicles. In retrospect, it would probably have been better to do as some other teams did: Skip the UMTranslog-2 domain completely and spend that time on the Numeric and Complex versions of the other domains.

The domain. **Trucks, trains or aircraft transport packages between locations but they**
must follow strict movement patterns. A few locations are transportation hubs, some are transportation centers while the rest are ordinary locations. A package is only allowed to move up and down through this hierarchy once and only move between two locations in the same layer once. The longest possible route for a package is thus from an ordinary location to a transportation center to a hub to another hub to a transportation center and finally to another ordinary location.

The domain groups locations into cities, which are then grouped in regions. Trucks travel between any two locations in the same city or by an existing road route between two cities. Trains and planes always use predefined routes between transportation centers and hubs. A great number of restrictions further complicate **movements. Packages must be** compatible with the vehicle they are loaded into, the vehicle must have enough free space, not be loaded too heavily and not be wider, longer or higher than the route and destination location accepts. Finally, the locations, vehicles and routes must all be available for use.

Control rules. **As in previous domains, we specify what a reasonable location is and limit**
vehicle movements to destinations that are reasonable. A truck might want to pick up