or deliver a package at the location or, if the truck cannot reach the goal location of the package, unload the package at a transportation center to be **picked up by another vehicle.**
Our control rules do not allow trucks to pick up several packages. This makes finding optimal solutions impossible in the general case but simplifies the search for acceptable solutions a great deal. There is an imminent risk that any other packages the truck is carrying will end up at the wrong location if it is allowed to travel about, picking up more packages along the way. Since all packages must move according to the specified pattern of transportation centers and hubs, moving a package that has once arrived at a location that is not a transportation center is not allowed and the package **will be stuck there. Restricting** trucks to picking up one package at a time avoids this problem.

There is also a large group of loading and unloading rules controlling, among other things, the opening or closing of valves and doors and loading or unloading of packages.

Finally, packages are only loaded into vehicles that are actually able to take them to a useful location.

Creating control rules and meeting the contest deadline left no time to get the domain working with concurrent planning. Instead, we had to make do **with sequential planning.**
Given more time, the set of control rules could definitely be improved. If planning speed is less of an issue, more search can be allowed and higher quality plans generated. More and better problem instances would be needed as guidelines when developing better control rules since the contest problems did not make full use of the intended transportation scheme with transportation centers and hubs.

## 6. Improvements After The Competition

Though the planning competition ended during the AIPS-2002 **conference in April, 2002,**
our work on TALplanner naturally did not cease there. There are still many improvements that can be made, and a couple of them that are related to the development of new domains and control rules have been implemented during the summer of **2002.**

## 6.1 Domain Visualization

As was discussed in the description of the ZenoTravel domain, the process of creating control rules for a planning domain often involves incremental improvements. TALplanner is run on a number of problem instances using one set of control rules, **or possibly without any control** rules at all, and the beginning of the resulting search tree is analyzed in order to determine where bad choices were made and how they can be avoided using new or improved control rules. This is repeated until the planner consistently finds **plans of good quality.**
During this process, one must study not only the output of the **planner but also the**
structure of the particular problem instance being solved. **For example, in a DriverLog** problem it may be necessary to draw the road network being used in each problem instance using pen and paper, and then study the paths taken by trucks, **people, and packages** through the road network, in order to discover whether improvements would be possible. But often a particular inefficiency only appears in one or a few **out of a large set of problem** instances, and tracing the execution of each plan by hand is obviously a tedious and time consuming task that ought to be automated as far as possible.

This led to the development of TPVis, a generic graphical visualization framework for