emphasis on explaining the incremental analysis process that eventually leads to the final formulas, going into particular detail for the ZenoTravel domain.

As could be seen in the examples shown in this paper, control rules are often simple, natural common-sense rules, and not very difficult to generate given some basic knowledge about the planning domain. Some rules are more complex, **but still not difficult to**
understand or verify once someone has spent the effort to generate them. And then, unfortunately, there are a few rules that are quite unintuitive, rules that are too complex to be easily understood, and rules that occasionally forbid optimal plans.

To some extent, such rules might be avoided by gaining more experience in good practices for writing control rules, or by extending the expressivity **of the language in which control** rules are written so that complex conditions can be expressed more succinctly or in a more natural manner, or simply by spending a little bit more time on the control rules than was available during the planning competition when much of our time was spent teaching or working on the planner implementation. However, another **important cause for the**
complexity of certain rules is probably that we are attempting to express all search control knowledge in the same way: As control rules that prune the search tree to such a great extent that even a simple depth-first search algorithm is sufficient for efficiently finding good plans in the remainder of the tree.

Not all search control knowledge can easily be expressed in this manner, but this certainly does not mean that control rules should be abandoned altogether. Instead, what we learn from this experience is that control rules might not be **the one and only multi-purpose** planning tool that will efficiently and easily solve all our planning problems. Instead, just like one would expect, they are one very useful tool that deserves a place in our toolbox but should be combined with other approaches to planning. Just to mention one rather obvious example, it would be possible to devise a heuristic forward-chaining planner whose search tree would be pre-pruned using control rule techniques from **TALplanner. Control rules**
could be written to exclude plans where the heuristic gives a **suboptimal result, potentially**
providing plans that are closer to optimal, and even for domains where the heuristic search function provides good plans it may often be more efficient to state a number of constraints as explicit control rules.

Such extensions to TALplanner have been considered at least **since some time before**
the second planning competition in 2000, and it has long been **clear to us that this approach should eventually be examined and explored. Before we could start working on this,**
though, the strengths and weaknesses of control rules had to **be explored in more depth.** Up to now, our work has therefore focused mostly on investigating how far it is possible to take TALplanner in its current shape, with explicit control **rules being the only means for**
controlling the search process. This work has proved rather fruitful in itself, and TALplanner did well in IPC-2000 as well as in IPC-2002. The planner is **now becoming reasonably**
mature, and after a few more improvements have been made and the planner has been released for general use, it might be time to take a step back and consider its relation to other approaches in more depth than has been done previously **in order to investigate the** possible advantages of hybrid approaches.

Of course, this does not mean that there is nothing more to be done within the "pure" TALplanner framework. On the contrary, there are many additional topics to be pursued, including investigating the application of TALplanner to plan optimization problems (where