predicates but can take values from an arbitrary user-specified sort. For the logistics domain, one could use two boolean fluents, at(thing, loc**) and** in(obj, vehicle**), together with a** city**valued fluent** city of(loc**) denoting the city containing the location** loc.

## 2.2 The Initial State

Given the fluents that were defined above, the initial state of **a logistics problem instance** can be specified using L**(ND) observation statements:** \#obs [0] city of(pos1) ˆ= city1 ∧ city of(pos2) ˆ= city2 ∧ . . . \#obs [0] at(obj11, pos1) ∧ at(truck1, pos1) ∧ . . .

These observations consist of TAL-C fixed fluent formulas, formulas of the form [τ ] φ denoting the fact that the fluent formula φ holds at time τ **. A fluent formula is a boolean**
combination of elementary fluent formulas of the form f ˆ= v (f==v **in input notation),** denoting the fact that the fluent f takes on the value v**. For boolean fluents, as in the** second observation, the shorthand notation f or ¬f (!f **in input notation) is allowed. The**
notation is also extended for open, closed, and semi-open temporal intervals. In addition to these formulas, the function **value**(τ, f) denotes the value of f **at time** τ .

## 2.3 The Goal: Goal Statements And Goal Expressions

A statement class for goals (labeled goal) has been added to L(ND)∗**. A goal statement**
consists of a fluent formula that must hold in any goal state:

#goal at(obj11, airport1) ∧ at(obj23, pos1) ∧ . . .
The ability to test whether a formula is entailed by the (state-based) goal is very useful in temporally extended goals and domain-dependent control rules. Therefore, a new macro is added: The **goal expression** goal(φ) holds iff the goal of this problem instance (the conjunction of all goal statements) entails the fluent formula φ**. Stated differently,** goal(φ**) is true**
if φ must be true in every goal state. The translation into L**(FL) is somewhat complex;**
see Kvarnstr¨om and Doherty (2000) for further information.

Note that a valid plan must end in a goal state. It is not sufficient to visit a goal state temporarily, which could be the case when an operator has effects at multiple timepoints - first satisfying the goal and then destroying it - or when concurrent plans are being created. (If such plans were desired for some reason, it would of course be easy to modify the definition and the planner accordingly.)

## 2.4 Operator Definitions

Since TAL-C is a logic for reasoning about action and change, **it has a notion of actions** that can be used for modeling planning operators. Although TALplanner does use the same semantics, the extended planning language L(ND)∗**contains a new operator macro**
providing a syntax which facilitates the use of resource constraints and other planningoriented concepts that are not present in standard TAL-C. This is in line with the standard TAL practice of preserving the logical base language L**(FL) and its semantics but providing** different variations of the high-level macro language L**(ND) that are adapted to special**
tasks.