The examples below demonstrate the operator definition syntax using three of the six logistics operators. Further examples will be shown when the IPC-2002 benchmark domains are discussed.

\#operator **load-truck**(obj, truck, loc) :at s
:precond [s] at(obj, loc) ∧ at(truck, loc) :effects [s+1] at(obj, loc) := false, [s+1] in(obj, truck) := true
\#operator **unload-truck**(obj, truck, loc) :at s
:precond [s] in(obj, truck) ∧ at(truck, loc) :effects [s+1] in(obj, truck) := false, [s+1] at(obj, loc) := true
\#operator **drive**(truck, loc1, loc2) :at s
:precond [s] at(truck, loc1) ∧ city of(loc1) ˆ= city of(loc2) ∧ loc1 6= loc2
:effects [s+1] at(truck, loc1) := false, [s+1] at(truck, loc2) := true Although not used in the simple logistics operators above, TALplanner also allows the use of context-dependent and quantified effects as well as prevail conditions. Unlike pure preconditions, prevail conditions are not limited to the invocation state of an operator but can refer to the entire interval during which the operator is **executed. The interval at which** each prevail condition must hold is explicitly specified, which provides additional flexibility compared to requiring that a precondition must always hold throughout the execution of an action.

## 2.5 Resources

If TALplanner was limited to generating sequential plans, resource consumption and production could be handled using plain operator effects. For example, if loading a truck requires one unit of space, the amount of available space could be decreased as follows:
\#operator **load-truck**(obj, truck, loc) :at s
:precond [s] at(obj, loc) ∧ at(truck, loc) :effects [s+1] space(truck) := value(s, space(truck)) - 1, . . .

With concurrent planning, this is clearly not sufficient, since multiple parallel invocations of load-truck **would still only consume one unit of space. For this reason, TALplanner has** explicit support for resources (Kvarnstr¨om et al., 2000).

Resources can be declared in a manner similar to ordinary fluents: They can have parameters and can take values in an arbitrary integer or fixed point domain. Unlike some planners, TALplanner only provides one type of resource, but provides several types of resource effects. Resources can be produced and consumed. They can also be borrowed (and automatically returned), either exclusively, meaning that the borrower has exclusive use of the resource during the specified interval, or non-exclusively, where multiple actions can borrow the same units of a certain resource concurrently. The latter case may appear strange, but can be useful when one wants to use a resource as a **semaphore or mutex.** Finally, resources can be assigned a completely new value.