import os
import json

def check_downloads(num):
    json_file_path = f"output_json_files/file_{num}.json"
    download_dir = f'v{num}'
    failed_json_file_path = f"newoutput_json_files/failed_downloads_{num}.json"  # 新的 JSON 文件路径

    if not os.path.exists(json_file_path):
        print(f"JSON文件不存在: {json_file_path}")
        return

    if not os.path.exists(download_dir):
        print(f"下载目录不存在: {download_dir}")
        return

    with open(json_file_path, "r") as json_file:
        items = json.load(json_file)

    total_urls = len(items)
    print(f"检查下载情况: {total_urls} 个 URL")

    successful_downloads = []
    failed_downloads = []

    for item in items:
        video_clipid = item['clip_id']
        output_path = f"{download_dir}/{video_clipid}.mp4"

        if os.path.exists(output_path):
            successful_downloads.append(item)  # 将整个 item 添加到成功下载列表
        else:
            failed_downloads.append(item)  # 将整个 item 添加到失败下载列表

    # 将失败下载的视频信息写入新的 JSON 文件
    with open(failed_json_file_path, "w") as failed_json_file:
        json.dump(failed_downloads, failed_json_file, indent=4)

    print(f"成功下载的视频: {len(successful_downloads)} 个")
    print(f"未成功下载的视频: {len(failed_downloads)} 个，已保存到 {failed_json_file_path}")
    for clipid in failed_downloads:
        print(f" - {clipid['clip_id']}")

if __name__ == "__main__":
    # numlist = [str(num) for num in range(2, 35, 2)]  # 生成 2 到 34 的偶数
    numlist = [41, 42, 43, 44, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75]
    for num in numlist:
        check_downloads(num)
