import json
import os

# 读取大 JSON 文件
with open('vast.json', 'r', encoding='utf-8') as f:
    data = json.load(f)

# 计算每个小文件应该包含的条目数
total_entries = len(data)
entries_per_file = total_entries // 100
remainder = total_entries % 100

# 创建输出目录
output_dir = 'output_json_files'
os.makedirs(output_dir, exist_ok=True)

# 切割并保存小 JSON 文件
for i in range(100):
    start_index = i * entries_per_file
    end_index = start_index + entries_per_file + (1 if i < remainder else 0)  # 处理余数
    small_data = data[start_index:end_index]

    with open(os.path.join(output_dir, f'file_{i + 1}.json'), 'w', encoding='utf-8') as f:
        json.dump(small_data, f, ensure_ascii=False, indent=4)

print("切割完成！")
