import os
import shutil
from multiprocessing import Pool
from tqdm import tqdm
def merge_folders(batch):
    folderv, foldernv = batch
    for file in tqdm(os.listdir(foldernv)):
        src_path = os.path.join(foldernv, file)
        dest_path = os.path.join(folderv, file)
        shutil.move(src_path, dest_path)

import math

def split_file(file_path, num_parts=10):
    # 获取文件大小
    file_size = os.path.getsize(file_path)
    part_size = math.ceil(file_size / num_parts)  # 每份的大小
    part_files = []
    with open(file_path, "rb") as f:
        for i in range(num_parts):
            part_file_path = f"{file_path}.part{i+1}"
            with open(part_file_path, "wb") as part_file:
                part_file.write(f.read(part_size))
            part_files.append(part_file_path)
    return part_files

def compress_and_split(folder_path, output_path, format="gztar", num_parts=10):
    archive_path = shutil.make_archive(output_path, format, folder_path)
    part_files = split_file(archive_path, num_parts)
    
    # 删除原始压缩包
    os.remove(archive_path)
    print(f"已删除原始压缩包: {archive_path}")
    
    return part_files

if __name__ == "__main__":
    # 两批文件夹的根目录
    numlist = [41, 42, 43, 44, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75]
    # for num in numlist:
    #     batch = [(".\\v" + str(i), ".\\nv" + str(i)) for i in numlist]
    # num_processes = len(numlist)
    # print(num_processes)
    # with Pool(processes=num_processes) as pool:
    #     results = pool.imap_unordered(merge_folders, batch)
    #     for _ in tqdm(results):
    #         pass
    # print('end')
    # for num in numlist:
    #     batch = [".\\v" + str(i) for i in numlist]
    # sum = 0
    # for i in batch:
    #     x = len(os.listdir(i))
    #     print(i,': ', x)
    #     sum += x
    # print(sum)
        # 要压缩的文件夹路径
    folder_path = "path/to/your/folder"
    
    # 压缩包输出路径（不带扩展名）
    output_path = "path/to/output/archive"
    
    # 压缩并分割
    part_files = compress_and_split(folder_path, output_path, format="zip", num_parts=10)
    print("分割后的文件列表:", part_files)
    