import json
import os

# 遍历每个小 JSON 文件
for i in range(1, 101):
    json_file_path = f'output_json_files/file_{i}.json'
    txt_file_path = f'txt/file_{i}_urls.txt'  # 每个小文件对应的 TXT 文件名

    # 读取小 JSON 文件
    with open(json_file_path, 'r', encoding='utf-8') as f:
        data = json.load(f)

    # 创建并写入 TXT 文件
    with open(txt_file_path, 'w', encoding='utf-8') as txtfile:
        # 提取每个条目的 url 并写入 TXT
        for entry in data:
            txtfile.write(entry['url'] + '\n')  # 每个 URL 单独一行

print("每个小文件的 URL 已提取到对应的 TXT 文件中！")
