import json
import os
import csv

# 遍历每个小 JSON 文件
for i in range(1, 101):
    json_file_path = f'output_json_files/file_{i}.json'
    csv_file_path = f'output_csv_files/file_{i}_urls.csv'  # 每个小文件对应的 CSV 文件名

    # 读取小 JSON 文件
    with open(json_file_path, 'r', encoding='utf-8') as f:
        data = json.load(f)

    # 创建并写入 CSV 文件
    with open(csv_file_path, 'w', newline='', encoding='utf-8') as csvfile:
        csv_writer = csv.writer(csvfile)
        csv_writer.writerow(['url'])  # 写入表头

        # 提取每个条目的 url 并写入 CSV
        for entry in data:
            csv_writer.writerow([entry['url']])

print("每个小文件的 URL 已提取到对应的 CSV 文件中！")
