
import yt_dlp
import string
import random
import json
from tqdm import tqdm
import datetime
from multiprocessing import Pool, cpu_count


def time_str_to_seconds(time_str):
    time_obj = datetime.datetime.strptime(time_str, "%H:%M:%S.%f")
    seconds = time_obj.hour * 3600 + time_obj.minute * 60 + time_obj.second + time_obj.microsecond / 1e6
    return seconds


class DownloadManager:
    def __init__(self, download_dir=None):
        self.download_dir = download_dir
        self.characters = string.ascii_letters + string.digits

    def download_video(self, item):
        try:
            url = item['url']
            video_clipid = item['clip_id']
            output_path = f"{self.download_dir}/{video_clipid}.mp4"
            video_span = item["clip_span"]
            start_time = time_str_to_seconds(video_span[0])
            end_time = time_str_to_seconds(video_span[1])

            ydl_opts = {
                'extractor_args': 'youtube:player-client=ANDROID',
                'retries': 1,
                'file_access_retries': 1,
                'fragment_retries': 1,
                'extractor_retries': 1,
                'format': "best[height<=360][ext=mp4]",
                'outtmpl': output_path,
                'proxy': 'http://127.0.0.1:18081',
                'noprogress': True,  # 禁用进度条以减少干扰
                'hls_timeout': 30,     # 设置 HLS 下载的超时时间为10秒
                'http_timeout': 30,    # 设置 HTTP 下载的超时时间为10秒
                # 'verbose' : True,
                'download_ranges': lambda a, b: [{'start_time': start_time, 'end_time': end_time}],
                'socket_timeout': 10,
                'quit': True
            }

            with yt_dlp.YoutubeDL(ydl_opts) as ydl:
                ydl.download([url])
        except Exception as e:
            error_msg = str(e)
            print(f"失败: {url}, 错误: {error_msg}")


def main(num):
    import os
    json_file_path = f"newoutput_json_files/failed_downloads_{num}.json"
    download_dir = f'nv{num}'
    
    if not os.path.exists(download_dir):
        os.makedirs(download_dir)
        print(f"创建下载目录: {download_dir}")

    with open(json_file_path, "r") as json_file:
        items = json.load(json_file)

    total_urls = len(items)
    print(f"总共读取到 {total_urls} 个URL")

    # 检查已下载的文件并剔除
    existing_files = set(os.listdir(download_dir))
    items_to_download = []
    skipped_count = 0

    for item in items:
        video_clipid = item['clip_id']
        if f"{video_clipid}.mp4" in existing_files:
            skipped_count += 1  # 统计已存在的文件数量
        else:
            items_to_download.append(item)  # 仅保留未下载的项

    # 更新待下载的 URL 数量
    total_urls_after_skipping = len(items_to_download)
    print(f"剔除 {skipped_count} 个已下载的文件，剩余 {total_urls_after_skipping} 个待下载文件。")

    download_manager = DownloadManager(download_dir=download_dir)

    from time import time
    start = time()

    num_processes = 60  # 使用 CPU 核心数作为进程数
    with Pool(processes=num_processes) as pool:
        # 使用 imap_unordered 提交任务
        results = pool.imap_unordered(download_manager.download_video, items_to_download)

        # 等待所有任务完成并显示进度
        for _ in tqdm(results, total=total_urls_after_skipping):
            pass  # 这里可以处理结果，如果需要的话

if __name__ == "__main__":
    numlist = [41, 42, 43, 44, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75]
    # numlist = [62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75]
    for i in numlist:
        try:
            main(i)
        except Exception as e:
            print(f"处理 {i} 时发生错误: {e}")
