#given a folder, zip all the files in the folder to a zip file as the all.zip file.
import os
import zipfile

def zip_all(folder_path):
    with zipfile.ZipFile(os.path.join(folder_path, 'all_2.zip'), 'w') as zipf:
        for root, dirs, files in os.walk(folder_path):
            for file in files:
                # in checkpints folder but not in checkpoints/{dataset}/none/
                if 'checkpoints' in root and 'none' not in root:
                    continue
                if ".zip" in file:
                    continue
                zipf.write(os.path.join(root, file), os.path.relpath(os.path.join(root, file), folder_path))

zip_all('RecSys')
