---
slug: /sdk/cue/457544/container-images
displayed_sidebar: 'current'
---

# Building container images

You can use the Dagger Engine to build container images, either by executing a Dockerfile, or specifying the build steps natively in CUE. Which method to choose depends on the requirements of your project. You can mix and match builds from both methods in the same plan.

:::tip

Check out the [docker package](./966156-docker.md) guide for more detailed information on the actions seen here.

:::

## Executing a Dockerfile

The Dagger Engine can natively load and execute Dockerfiles. This is recommended in cases where compatibility with existing Dockerfiles is more important than fully leveraging the power of CUE.

Here's a simple example of a [Dockerfile](https://docs.docker.com/develop/develop-images/dockerfile_best-practices/) build:

```cue file=../../tests/guides/container-images/simple/with-dockerfile.cue

```

## Specifying a build in CUE

You can specify your container build natively in CUE, using the official Docker package: `universe.dagger.io/docker`. This is recommended when you don't need to worry about Dockerfile compatibility, and want to take advantage of the full power of CUE and the Dagger Engine's APIs.

Native CUE builds have the same backend as Dockerfile builds, so all the same features are available. Since CUE is a more powerful language than the Dockerfile syntax, every Dockerfile can be ported to an equivalent CUE configuration, but the opposite is not true. The following example produces the same image as above.

```cue file=../../tests/guides/container-images/simple/build.cue

```

Because this build configuration is pure CUE, it can leverage the full power of the Dagger Engine's composition model.

## Automation

Building images in CUE gives you greater flexibility. For example, you can automate building multiple versions of an image, and deploy, all using the Dagger Engine:

```cue file=../../tests/guides/container-images/template/dagger.cue

```

Now you can deploy all versions:

```shell
dagger-cue do versions
```

Or just build a specific version, without pushing:

```shell
dagger-cue do versions 8.0 build
```

## Multi-stage build

Another common pattern is [multi-stage builds](https://docs.docker.com/develop/develop-images/multistage-build/#use-multi-stage-builds). This allows you to have heavier build images during the build process, and copy the built artifacts into a cleaner and lighter image to run in production.

```cue file=../../tests/guides/container-images/multi-stage/dagger.cue

```
