// Copyright 2016-2022, Pulumi Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package client

import (
	"bytes"
	"encoding/json"

	"github.com/pulumi/pulumi/sdk/v3/go/common/apitype"
)

// Unlike json.Marshal preserves possible indentation in req.Deployment.
func marshalVerbatimCheckpointRequest(req apitype.PatchUpdateVerbatimCheckpointRequest) (json.RawMessage, error) {
	sentinel := []byte(`"*"`)
	cp := req
	cp.UntypedDeployment = sentinel
	pattern, err := json.Marshal(cp)
	if err != nil {
		return nil, err
	}
	f := bytes.ReplaceAll(pattern, sentinel, req.UntypedDeployment)
	return f, nil
}
