package httpstate

import (
	"testing"

	"github.com/pulumi/pulumi/sdk/v3/go/common/resource/config"
	"github.com/pulumi/pulumi/sdk/v3/go/common/workspace"
	"github.com/stretchr/testify/assert"
)

func TestChangeProjectStackSecretDetails(t *testing.T) {
	t.Parallel()

	tests := []struct {
		TestName     string
		ProjectStack workspace.ProjectStack
		Expected     bool
	}{
		{
			TestName: "Expects to save stack when existing secrets manager is cloud",
			ProjectStack: workspace.ProjectStack{
				Config:          make(config.Map),
				SecretsProvider: "awskms://alias/TestProvider?region=us-west-2",
				EncryptedKey:    "AQICAHhAA+FYp21DcGwS7xUizcOsoZihxKtWVCjZpgsK7owkfQF3sftIrKkJOJ0VYq69rHxvAAAAfjB8Bgkqhk",
			},
			Expected: true,
		},
		{
			TestName: "Expects to save stack when existing secrets manager is passphrase",
			ProjectStack: workspace.ProjectStack{
				Config:         make(config.Map),
				EncryptionSalt: "v1:/AQICAHhAA+FYp21DcGwS7xUizcOsoZihxKtWVCjZpgsK7owkfQF3sftIrKkJOJ0VYq69rHxvAAAAfjB8Bgkqhk",
			},
			Expected: true,
		},
		{
			TestName: "Does not expect to save stack when existing secrets manager is service",
			ProjectStack: workspace.ProjectStack{
				Config: make(config.Map),
			},
			Expected: false,
		},
	}

	//nolint:paralleltest // false positive because range var isn't used directly in t.Run(name) arg
	for _, test := range tests {
		test := test
		t.Run(test.TestName, func(t *testing.T) {
			requiresProjectSave := changeProjectStackSecretDetails(&test.ProjectStack)
			assert.Equal(t, test.Expected, requiresProjectSave)
		})
	}
}
