# coding=utf-8
# *** WARNING: this file was generated by test. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['NurseryArgs', 'Nursery']

@pulumi.input_type
class NurseryArgs:
    def __init__(__self__, *,
                 varieties: pulumi.Input[Sequence[pulumi.Input['RubberTreeVariety']]],
                 sizes: Optional[pulumi.Input[Mapping[str, pulumi.Input['TreeSize']]]] = None):
        """
        The set of arguments for constructing a Nursery resource.
        :param pulumi.Input[Sequence[pulumi.Input['RubberTreeVariety']]] varieties: The varieties available
        :param pulumi.Input[Mapping[str, pulumi.Input['TreeSize']]] sizes: The sizes of trees available
        """
        pulumi.set(__self__, "varieties", varieties)
        if sizes is not None:
            pulumi.set(__self__, "sizes", sizes)

    @property
    @pulumi.getter
    def varieties(self) -> pulumi.Input[Sequence[pulumi.Input['RubberTreeVariety']]]:
        """
        The varieties available
        """
        return pulumi.get(self, "varieties")

    @varieties.setter
    def varieties(self, value: pulumi.Input[Sequence[pulumi.Input['RubberTreeVariety']]]):
        pulumi.set(self, "varieties", value)

    @property
    @pulumi.getter
    def sizes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['TreeSize']]]]:
        """
        The sizes of trees available
        """
        return pulumi.get(self, "sizes")

    @sizes.setter
    def sizes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['TreeSize']]]]):
        pulumi.set(self, "sizes", value)


class Nursery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 sizes: Optional[pulumi.Input[Mapping[str, pulumi.Input['TreeSize']]]] = None,
                 varieties: Optional[pulumi.Input[Sequence[pulumi.Input['RubberTreeVariety']]]] = None,
                 __props__=None):
        """
        Create a Nursery resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input['TreeSize']]] sizes: The sizes of trees available
        :param pulumi.Input[Sequence[pulumi.Input['RubberTreeVariety']]] varieties: The varieties available
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NurseryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Nursery resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param NurseryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NurseryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 sizes: Optional[pulumi.Input[Mapping[str, pulumi.Input['TreeSize']]]] = None,
                 varieties: Optional[pulumi.Input[Sequence[pulumi.Input['RubberTreeVariety']]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NurseryArgs.__new__(NurseryArgs)

            __props__.__dict__["sizes"] = sizes
            if varieties is None and not opts.urn:
                raise TypeError("Missing required property 'varieties'")
            __props__.__dict__["varieties"] = varieties
        super(Nursery, __self__).__init__(
            'plant:tree/v1:Nursery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Nursery':
        """
        Get an existing Nursery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NurseryArgs.__new__(NurseryArgs)

        return Nursery(resource_name, opts=opts, __props__=__props__)

