# coding=utf-8
# *** WARNING: this file was generated by test. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'KubeClientSettings',
]

@pulumi.output_type
class KubeClientSettings(dict):
    """
    Options for tuning the Kubernetes client used by a Provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recTest":
            suggest = "rec_test"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubeClientSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubeClientSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubeClientSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 burst: Optional[int] = None,
                 qps: Optional[float] = None,
                 rec_test: Optional['outputs.KubeClientSettings'] = None):
        """
        Options for tuning the Kubernetes client used by a Provider.
        :param int burst: Maximum burst for throttle. Default value is 10.
        :param float qps: Maximum queries per second (QPS) to the API server from this client. Default value is 5.
        """
        if burst is None:
            burst = _utilities.get_env_int('PULUMI_K8S_CLIENT_BURST')
        if burst is not None:
            pulumi.set(__self__, "burst", burst)
        if qps is None:
            qps = _utilities.get_env_float('PULUMI_K8S_CLIENT_QPS')
        if qps is not None:
            pulumi.set(__self__, "qps", qps)
        if rec_test is not None:
            pulumi.set(__self__, "rec_test", rec_test)

    @property
    @pulumi.getter
    def burst(self) -> Optional[int]:
        """
        Maximum burst for throttle. Default value is 10.
        """
        return pulumi.get(self, "burst")

    @property
    @pulumi.getter
    def qps(self) -> Optional[float]:
        """
        Maximum queries per second (QPS) to the API server from this client. Default value is 5.
        """
        return pulumi.get(self, "qps")

    @property
    @pulumi.getter(name="recTest")
    def rec_test(self) -> Optional['outputs.KubeClientSettings']:
        return pulumi.get(self, "rec_test")


