// Copyright 2016-2018, Pulumi Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.20.1
// source: pulumi/analyzer.proto

package pulumirpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// EnforcementLevel indicates the severity of a policy violation.
type EnforcementLevel int32

const (
	EnforcementLevel_ADVISORY  EnforcementLevel = 0 // Displayed to users, but does not block deployment.
	EnforcementLevel_MANDATORY EnforcementLevel = 1 // Stops deployment, cannot be overridden.
	EnforcementLevel_DISABLED  EnforcementLevel = 2 // Disabled policies do not run during a deployment.
)

// Enum value maps for EnforcementLevel.
var (
	EnforcementLevel_name = map[int32]string{
		0: "ADVISORY",
		1: "MANDATORY",
		2: "DISABLED",
	}
	EnforcementLevel_value = map[string]int32{
		"ADVISORY":  0,
		"MANDATORY": 1,
		"DISABLED":  2,
	}
)

func (x EnforcementLevel) Enum() *EnforcementLevel {
	p := new(EnforcementLevel)
	*p = x
	return p
}

func (x EnforcementLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnforcementLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_pulumi_analyzer_proto_enumTypes[0].Descriptor()
}

func (EnforcementLevel) Type() protoreflect.EnumType {
	return &file_pulumi_analyzer_proto_enumTypes[0]
}

func (x EnforcementLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnforcementLevel.Descriptor instead.
func (EnforcementLevel) EnumDescriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{0}
}

type AnalyzeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type       string                    `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`             // the type token of the resource.
	Properties *structpb.Struct          `protobuf:"bytes,2,opt,name=properties,proto3" json:"properties,omitempty"` // the full properties to use for validation.
	Urn        string                    `protobuf:"bytes,3,opt,name=urn,proto3" json:"urn,omitempty"`               // the URN of the resource.
	Name       string                    `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`             // the name for the resource's URN.
	Options    *AnalyzerResourceOptions  `protobuf:"bytes,5,opt,name=options,proto3" json:"options,omitempty"`       // the resource options.
	Provider   *AnalyzerProviderResource `protobuf:"bytes,6,opt,name=provider,proto3" json:"provider,omitempty"`     // the resource's provider.
}

func (x *AnalyzeRequest) Reset() {
	*x = AnalyzeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeRequest) ProtoMessage() {}

func (x *AnalyzeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{0}
}

func (x *AnalyzeRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AnalyzeRequest) GetProperties() *structpb.Struct {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *AnalyzeRequest) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *AnalyzeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnalyzeRequest) GetOptions() *AnalyzerResourceOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *AnalyzeRequest) GetProvider() *AnalyzerProviderResource {
	if x != nil {
		return x.Provider
	}
	return nil
}

// AnalyzerResource defines the view of a Pulumi-managed resource as sent to Analyzers. The properties
// of the resource are specific to the type of analysis being performed. See the Analyzer
// service definition for more information.
type AnalyzerResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type                 string                                   `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`                                                                                                                         // the type token of the resource.
	Properties           *structpb.Struct                         `protobuf:"bytes,2,opt,name=properties,proto3" json:"properties,omitempty"`                                                                                                             // the full properties to use for validation.
	Urn                  string                                   `protobuf:"bytes,3,opt,name=urn,proto3" json:"urn,omitempty"`                                                                                                                           // the URN of the resource.
	Name                 string                                   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`                                                                                                                         // the name for the resource's URN.
	Options              *AnalyzerResourceOptions                 `protobuf:"bytes,5,opt,name=options,proto3" json:"options,omitempty"`                                                                                                                   // the resource options.
	Provider             *AnalyzerProviderResource                `protobuf:"bytes,6,opt,name=provider,proto3" json:"provider,omitempty"`                                                                                                                 // the resource's provider.
	Parent               string                                   `protobuf:"bytes,7,opt,name=parent,proto3" json:"parent,omitempty"`                                                                                                                     // an optional parent URN that this child resource belongs to.
	Dependencies         []string                                 `protobuf:"bytes,8,rep,name=dependencies,proto3" json:"dependencies,omitempty"`                                                                                                         // a list of URNs that this resource depends on.
	PropertyDependencies map[string]*AnalyzerPropertyDependencies `protobuf:"bytes,9,rep,name=propertyDependencies,proto3" json:"propertyDependencies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // a map from property keys to the dependencies of the property.
}

func (x *AnalyzerResource) Reset() {
	*x = AnalyzerResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerResource) ProtoMessage() {}

func (x *AnalyzerResource) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerResource.ProtoReflect.Descriptor instead.
func (*AnalyzerResource) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{1}
}

func (x *AnalyzerResource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AnalyzerResource) GetProperties() *structpb.Struct {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *AnalyzerResource) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *AnalyzerResource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnalyzerResource) GetOptions() *AnalyzerResourceOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *AnalyzerResource) GetProvider() *AnalyzerProviderResource {
	if x != nil {
		return x.Provider
	}
	return nil
}

func (x *AnalyzerResource) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AnalyzerResource) GetDependencies() []string {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *AnalyzerResource) GetPropertyDependencies() map[string]*AnalyzerPropertyDependencies {
	if x != nil {
		return x.PropertyDependencies
	}
	return nil
}

// AnalyzerResourceOptions defines the options associated with a resource.
type AnalyzerResourceOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Protect                    bool                                    `protobuf:"varint,1,opt,name=protect,proto3" json:"protect,omitempty"`                                       // true if the resource should be marked protected.
	IgnoreChanges              []string                                `protobuf:"bytes,2,rep,name=ignoreChanges,proto3" json:"ignoreChanges,omitempty"`                            // a list of property names to ignore during changes.
	DeleteBeforeReplace        bool                                    `protobuf:"varint,3,opt,name=deleteBeforeReplace,proto3" json:"deleteBeforeReplace,omitempty"`               // true if this resource should be deleted before replacement.
	DeleteBeforeReplaceDefined bool                                    `protobuf:"varint,4,opt,name=deleteBeforeReplaceDefined,proto3" json:"deleteBeforeReplaceDefined,omitempty"` // true if the deleteBeforeReplace property should be treated as defined even if it is false.
	AdditionalSecretOutputs    []string                                `protobuf:"bytes,5,rep,name=additionalSecretOutputs,proto3" json:"additionalSecretOutputs,omitempty"`        // a list of output properties that should also be treated as secret, in addition to ones we detect.
	Aliases                    []string                                `protobuf:"bytes,6,rep,name=aliases,proto3" json:"aliases,omitempty"`                                        // a list of additional URNs that shoud be considered the same.
	CustomTimeouts             *AnalyzerResourceOptions_CustomTimeouts `protobuf:"bytes,7,opt,name=customTimeouts,proto3" json:"customTimeouts,omitempty"`                          // a config block that will be used to configure timeouts for CRUD operations.
}

func (x *AnalyzerResourceOptions) Reset() {
	*x = AnalyzerResourceOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerResourceOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerResourceOptions) ProtoMessage() {}

func (x *AnalyzerResourceOptions) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerResourceOptions.ProtoReflect.Descriptor instead.
func (*AnalyzerResourceOptions) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{2}
}

func (x *AnalyzerResourceOptions) GetProtect() bool {
	if x != nil {
		return x.Protect
	}
	return false
}

func (x *AnalyzerResourceOptions) GetIgnoreChanges() []string {
	if x != nil {
		return x.IgnoreChanges
	}
	return nil
}

func (x *AnalyzerResourceOptions) GetDeleteBeforeReplace() bool {
	if x != nil {
		return x.DeleteBeforeReplace
	}
	return false
}

func (x *AnalyzerResourceOptions) GetDeleteBeforeReplaceDefined() bool {
	if x != nil {
		return x.DeleteBeforeReplaceDefined
	}
	return false
}

func (x *AnalyzerResourceOptions) GetAdditionalSecretOutputs() []string {
	if x != nil {
		return x.AdditionalSecretOutputs
	}
	return nil
}

func (x *AnalyzerResourceOptions) GetAliases() []string {
	if x != nil {
		return x.Aliases
	}
	return nil
}

func (x *AnalyzerResourceOptions) GetCustomTimeouts() *AnalyzerResourceOptions_CustomTimeouts {
	if x != nil {
		return x.CustomTimeouts
	}
	return nil
}

// AnalyzerProviderResource provides information about a resource's provider.
type AnalyzerProviderResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type       string           `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`             // the type token of the resource.
	Properties *structpb.Struct `protobuf:"bytes,2,opt,name=properties,proto3" json:"properties,omitempty"` // the full properties to use for validation.
	Urn        string           `protobuf:"bytes,3,opt,name=urn,proto3" json:"urn,omitempty"`               // the URN of the resource.
	Name       string           `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`             // the name for the resource's URN.
}

func (x *AnalyzerProviderResource) Reset() {
	*x = AnalyzerProviderResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerProviderResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerProviderResource) ProtoMessage() {}

func (x *AnalyzerProviderResource) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerProviderResource.ProtoReflect.Descriptor instead.
func (*AnalyzerProviderResource) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{3}
}

func (x *AnalyzerProviderResource) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AnalyzerProviderResource) GetProperties() *structpb.Struct {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *AnalyzerProviderResource) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *AnalyzerProviderResource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// AnalyzerPropertyDependencies describes the resources that a particular property depends on.
type AnalyzerPropertyDependencies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Urns []string `protobuf:"bytes,1,rep,name=urns,proto3" json:"urns,omitempty"` // A list of URNs this property depends on.
}

func (x *AnalyzerPropertyDependencies) Reset() {
	*x = AnalyzerPropertyDependencies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerPropertyDependencies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerPropertyDependencies) ProtoMessage() {}

func (x *AnalyzerPropertyDependencies) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerPropertyDependencies.ProtoReflect.Descriptor instead.
func (*AnalyzerPropertyDependencies) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{4}
}

func (x *AnalyzerPropertyDependencies) GetUrns() []string {
	if x != nil {
		return x.Urns
	}
	return nil
}

type AnalyzeStackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Resources []*AnalyzerResource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
}

func (x *AnalyzeStackRequest) Reset() {
	*x = AnalyzeStackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeStackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeStackRequest) ProtoMessage() {}

func (x *AnalyzeStackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeStackRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeStackRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{5}
}

func (x *AnalyzeStackRequest) GetResources() []*AnalyzerResource {
	if x != nil {
		return x.Resources
	}
	return nil
}

type AnalyzeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Diagnostics []*AnalyzeDiagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"` // information about policy violations.
}

func (x *AnalyzeResponse) Reset() {
	*x = AnalyzeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeResponse) ProtoMessage() {}

func (x *AnalyzeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{6}
}

func (x *AnalyzeResponse) GetDiagnostics() []*AnalyzeDiagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type AnalyzeDiagnostic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PolicyName        string           `protobuf:"bytes,1,opt,name=policyName,proto3" json:"policyName,omitempty"`                                              // Name of the violated policy.
	PolicyPackName    string           `protobuf:"bytes,2,opt,name=policyPackName,proto3" json:"policyPackName,omitempty"`                                      // Name of the policy pack the policy is in.
	PolicyPackVersion string           `protobuf:"bytes,3,opt,name=policyPackVersion,proto3" json:"policyPackVersion,omitempty"`                                // Version of the policy pack.
	Description       string           `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`                                            // Description of policy rule. e.g., "encryption enabled."
	Message           string           `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`                                                    // Message to display on policy violation, e.g., remediation steps.
	Tags              []string         `protobuf:"bytes,6,rep,name=tags,proto3" json:"tags,omitempty"`                                                          // Keywords/terms to associate with a policy, e.g., "cost".
	EnforcementLevel  EnforcementLevel `protobuf:"varint,7,opt,name=enforcementLevel,proto3,enum=pulumirpc.EnforcementLevel" json:"enforcementLevel,omitempty"` // Severity of the policy violation.
	Urn               string           `protobuf:"bytes,8,opt,name=urn,proto3" json:"urn,omitempty"`                                                            // URN of the resource that violates the policy.
}

func (x *AnalyzeDiagnostic) Reset() {
	*x = AnalyzeDiagnostic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeDiagnostic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeDiagnostic) ProtoMessage() {}

func (x *AnalyzeDiagnostic) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeDiagnostic.ProtoReflect.Descriptor instead.
func (*AnalyzeDiagnostic) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{7}
}

func (x *AnalyzeDiagnostic) GetPolicyName() string {
	if x != nil {
		return x.PolicyName
	}
	return ""
}

func (x *AnalyzeDiagnostic) GetPolicyPackName() string {
	if x != nil {
		return x.PolicyPackName
	}
	return ""
}

func (x *AnalyzeDiagnostic) GetPolicyPackVersion() string {
	if x != nil {
		return x.PolicyPackVersion
	}
	return ""
}

func (x *AnalyzeDiagnostic) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AnalyzeDiagnostic) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *AnalyzeDiagnostic) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AnalyzeDiagnostic) GetEnforcementLevel() EnforcementLevel {
	if x != nil {
		return x.EnforcementLevel
	}
	return EnforcementLevel_ADVISORY
}

func (x *AnalyzeDiagnostic) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

// AnalyzerInfo provides metadata about a PolicyPack inside an analyzer.
type AnalyzerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name           string                   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                                                                                                           // Name of the PolicyPack.
	DisplayName    string                   `protobuf:"bytes,2,opt,name=displayName,proto3" json:"displayName,omitempty"`                                                                                             // Pretty name for the PolicyPack.
	Policies       []*PolicyInfo            `protobuf:"bytes,3,rep,name=policies,proto3" json:"policies,omitempty"`                                                                                                   // Metadata about policies contained in PolicyPack.
	Version        string                   `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`                                                                                                     // Version of the Policy Pack.
	SupportsConfig bool                     `protobuf:"varint,5,opt,name=supportsConfig,proto3" json:"supportsConfig,omitempty"`                                                                                      // Whether the Policy Pack supports config.
	InitialConfig  map[string]*PolicyConfig `protobuf:"bytes,6,rep,name=initialConfig,proto3" json:"initialConfig,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Map of policy name to config.
}

func (x *AnalyzerInfo) Reset() {
	*x = AnalyzerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerInfo) ProtoMessage() {}

func (x *AnalyzerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerInfo.ProtoReflect.Descriptor instead.
func (*AnalyzerInfo) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{8}
}

func (x *AnalyzerInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnalyzerInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AnalyzerInfo) GetPolicies() []*PolicyInfo {
	if x != nil {
		return x.Policies
	}
	return nil
}

func (x *AnalyzerInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AnalyzerInfo) GetSupportsConfig() bool {
	if x != nil {
		return x.SupportsConfig
	}
	return false
}

func (x *AnalyzerInfo) GetInitialConfig() map[string]*PolicyConfig {
	if x != nil {
		return x.InitialConfig
	}
	return nil
}

// PolicyInfo provides metadata about a policy within a Policy Pack.
type PolicyInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name             string              `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`                                                          // Name of the policy.
	DisplayName      string              `protobuf:"bytes,2,opt,name=displayName,proto3" json:"displayName,omitempty"`                                            // Pretty name for the policy.
	Description      string              `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`                                            // Description of policy rule. e.g., "encryption enabled."
	Message          string              `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`                                                    // Message to display on policy violation, e.g., remediation steps.
	EnforcementLevel EnforcementLevel    `protobuf:"varint,5,opt,name=enforcementLevel,proto3,enum=pulumirpc.EnforcementLevel" json:"enforcementLevel,omitempty"` // Severity of the policy violation.
	ConfigSchema     *PolicyConfigSchema `protobuf:"bytes,6,opt,name=configSchema,proto3" json:"configSchema,omitempty"`                                          // Config schema for the policy.
}

func (x *PolicyInfo) Reset() {
	*x = PolicyInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyInfo) ProtoMessage() {}

func (x *PolicyInfo) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyInfo.ProtoReflect.Descriptor instead.
func (*PolicyInfo) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{9}
}

func (x *PolicyInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PolicyInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PolicyInfo) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PolicyInfo) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *PolicyInfo) GetEnforcementLevel() EnforcementLevel {
	if x != nil {
		return x.EnforcementLevel
	}
	return EnforcementLevel_ADVISORY
}

func (x *PolicyInfo) GetConfigSchema() *PolicyConfigSchema {
	if x != nil {
		return x.ConfigSchema
	}
	return nil
}

// PolicyConfigSchema provides the schema for a policy's configuration.
type PolicyConfigSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Properties *structpb.Struct `protobuf:"bytes,1,opt,name=properties,proto3" json:"properties,omitempty"` // JSON schema for each property.
	Required   []string         `protobuf:"bytes,2,rep,name=required,proto3" json:"required,omitempty"`     // Required properties.
}

func (x *PolicyConfigSchema) Reset() {
	*x = PolicyConfigSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfigSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfigSchema) ProtoMessage() {}

func (x *PolicyConfigSchema) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfigSchema.ProtoReflect.Descriptor instead.
func (*PolicyConfigSchema) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{10}
}

func (x *PolicyConfigSchema) GetProperties() *structpb.Struct {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *PolicyConfigSchema) GetRequired() []string {
	if x != nil {
		return x.Required
	}
	return nil
}

// PolicyConfig provides configuration for a policy.
type PolicyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EnforcementLevel EnforcementLevel `protobuf:"varint,1,opt,name=enforcementLevel,proto3,enum=pulumirpc.EnforcementLevel" json:"enforcementLevel,omitempty"` // Enforcement level of the policy.
	Properties       *structpb.Struct `protobuf:"bytes,2,opt,name=properties,proto3" json:"properties,omitempty"`                                              // Configuration properties of the policy.
}

func (x *PolicyConfig) Reset() {
	*x = PolicyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyConfig) ProtoMessage() {}

func (x *PolicyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyConfig.ProtoReflect.Descriptor instead.
func (*PolicyConfig) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{11}
}

func (x *PolicyConfig) GetEnforcementLevel() EnforcementLevel {
	if x != nil {
		return x.EnforcementLevel
	}
	return EnforcementLevel_ADVISORY
}

func (x *PolicyConfig) GetProperties() *structpb.Struct {
	if x != nil {
		return x.Properties
	}
	return nil
}

// ConfigureAnalyzerRequest provides configuration information to the analyzer.
type ConfigureAnalyzerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PolicyConfig map[string]*PolicyConfig `protobuf:"bytes,1,rep,name=policyConfig,proto3" json:"policyConfig,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Map of policy name to config.
}

func (x *ConfigureAnalyzerRequest) Reset() {
	*x = ConfigureAnalyzerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigureAnalyzerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureAnalyzerRequest) ProtoMessage() {}

func (x *ConfigureAnalyzerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureAnalyzerRequest.ProtoReflect.Descriptor instead.
func (*ConfigureAnalyzerRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{12}
}

func (x *ConfigureAnalyzerRequest) GetPolicyConfig() map[string]*PolicyConfig {
	if x != nil {
		return x.PolicyConfig
	}
	return nil
}

// CustomTimeouts allows a user to be able to create a set of custom timeout parameters.
type AnalyzerResourceOptions_CustomTimeouts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Create float64 `protobuf:"fixed64,1,opt,name=create,proto3" json:"create,omitempty"` // The create resource timeout in seconds.
	Update float64 `protobuf:"fixed64,2,opt,name=update,proto3" json:"update,omitempty"` // The update resource timeout in seconds.
	Delete float64 `protobuf:"fixed64,3,opt,name=delete,proto3" json:"delete,omitempty"` // The delete resource timeout in seconds.
}

func (x *AnalyzerResourceOptions_CustomTimeouts) Reset() {
	*x = AnalyzerResourceOptions_CustomTimeouts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_analyzer_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerResourceOptions_CustomTimeouts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerResourceOptions_CustomTimeouts) ProtoMessage() {}

func (x *AnalyzerResourceOptions_CustomTimeouts) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_analyzer_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerResourceOptions_CustomTimeouts.ProtoReflect.Descriptor instead.
func (*AnalyzerResourceOptions_CustomTimeouts) Descriptor() ([]byte, []int) {
	return file_pulumi_analyzer_proto_rawDescGZIP(), []int{2, 0}
}

func (x *AnalyzerResourceOptions_CustomTimeouts) GetCreate() float64 {
	if x != nil {
		return x.Create
	}
	return 0
}

func (x *AnalyzerResourceOptions_CustomTimeouts) GetUpdate() float64 {
	if x != nil {
		return x.Update
	}
	return 0
}

func (x *AnalyzerResourceOptions_CustomTimeouts) GetDelete() float64 {
	if x != nil {
		return x.Delete
	}
	return 0
}

var File_pulumi_analyzer_proto protoreflect.FileDescriptor

var file_pulumi_analyzer_proto_rawDesc = []byte{
	0x0a, 0x15, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72,
	0x70, 0x63, 0x1a, 0x13, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x82, 0x02, 0x0a, 0x0e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x75, 0x72, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x75, 0x6c, 0x75,
	0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d,
	0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x22, 0x9d, 0x04, 0x0a, 0x10, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x37, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x3c, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x16,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x69, 0x0a, 0x14, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d,
	0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x14, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x70, 0x0a, 0x19, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd4, 0x03, 0x0a, 0x17, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x12, 0x24, 0x0a,
	0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x1a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42,
	0x65, 0x66, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x44, 0x65, 0x66, 0x69,
	0x6e, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x44, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x17, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x17, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x0e, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x73, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x73, 0x1a, 0x58, 0x0a, 0x0e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x22, 0x8d,
	0x01, 0x0a, 0x18, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x37, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x32,
	0x0a, 0x1c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x75, 0x72, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72,
	0x6e, 0x73, 0x22, 0x50, 0x0a, 0x13, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70,
	0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x22, 0x51, 0x0a, 0x0f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x0b, 0x64, 0x69, 0x61, 0x67, 0x6e,
	0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x70,
	0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x52, 0x0b, 0x64, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0xb4, 0x02, 0x0a, 0x11, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x12, 0x1e, 0x0a,
	0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x61, 0x63, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x61, 0x63,
	0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x11, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50,
	0x61, 0x63, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x61, 0x63, 0x6b, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x12, 0x47, 0x0a, 0x10, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e,
	0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x10, 0x65, 0x6e, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x22, 0xe6,
	0x02, 0x0a, 0x0c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x72, 0x70, 0x63, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x0d, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x59, 0x0a, 0x12,
	0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x8a, 0x02, 0x0a, 0x0a, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x47, 0x0a, 0x10, 0x65, 0x6e, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x45,
	0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52,
	0x10, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x12, 0x41, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x72, 0x70, 0x63, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x22, 0x69, 0x0a, 0x12, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x22,
	0x90, 0x01, 0x0a, 0x0c, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x47, 0x0a, 0x10, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c,
	0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x10, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x22, 0xcf, 0x01, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x59, 0x0a, 0x0c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70,
	0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x58, 0x0a, 0x11, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x2d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x2a, 0x3d, 0x0a, 0x10, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x44, 0x56, 0x49,
	0x53, 0x4f, 0x52, 0x59, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x41, 0x4e, 0x44, 0x41, 0x54,
	0x4f, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x44, 0x10, 0x02, 0x32, 0xf0, 0x02, 0x0a, 0x08, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72,
	0x12, 0x42, 0x0a, 0x07, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x12, 0x19, 0x2e, 0x70, 0x75,
	0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72,
	0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x4c, 0x0a, 0x0c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53,
	0x74, 0x61, 0x63, 0x6b, 0x12, 0x1e, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x44, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x17, 0x2e,
	0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x40, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x50,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x1a, 0x15, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x4a, 0x0a, 0x09, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x12, 0x23, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x00, 0x42, 0x34, 0x5a, 0x32, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x70, 0x75, 0x6c, 0x75,
	0x6d, 0x69, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x3b, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pulumi_analyzer_proto_rawDescOnce sync.Once
	file_pulumi_analyzer_proto_rawDescData = file_pulumi_analyzer_proto_rawDesc
)

func file_pulumi_analyzer_proto_rawDescGZIP() []byte {
	file_pulumi_analyzer_proto_rawDescOnce.Do(func() {
		file_pulumi_analyzer_proto_rawDescData = protoimpl.X.CompressGZIP(file_pulumi_analyzer_proto_rawDescData)
	})
	return file_pulumi_analyzer_proto_rawDescData
}

var file_pulumi_analyzer_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_pulumi_analyzer_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_pulumi_analyzer_proto_goTypes = []interface{}{
	(EnforcementLevel)(0),                          // 0: pulumirpc.EnforcementLevel
	(*AnalyzeRequest)(nil),                         // 1: pulumirpc.AnalyzeRequest
	(*AnalyzerResource)(nil),                       // 2: pulumirpc.AnalyzerResource
	(*AnalyzerResourceOptions)(nil),                // 3: pulumirpc.AnalyzerResourceOptions
	(*AnalyzerProviderResource)(nil),               // 4: pulumirpc.AnalyzerProviderResource
	(*AnalyzerPropertyDependencies)(nil),           // 5: pulumirpc.AnalyzerPropertyDependencies
	(*AnalyzeStackRequest)(nil),                    // 6: pulumirpc.AnalyzeStackRequest
	(*AnalyzeResponse)(nil),                        // 7: pulumirpc.AnalyzeResponse
	(*AnalyzeDiagnostic)(nil),                      // 8: pulumirpc.AnalyzeDiagnostic
	(*AnalyzerInfo)(nil),                           // 9: pulumirpc.AnalyzerInfo
	(*PolicyInfo)(nil),                             // 10: pulumirpc.PolicyInfo
	(*PolicyConfigSchema)(nil),                     // 11: pulumirpc.PolicyConfigSchema
	(*PolicyConfig)(nil),                           // 12: pulumirpc.PolicyConfig
	(*ConfigureAnalyzerRequest)(nil),               // 13: pulumirpc.ConfigureAnalyzerRequest
	nil,                                            // 14: pulumirpc.AnalyzerResource.PropertyDependenciesEntry
	(*AnalyzerResourceOptions_CustomTimeouts)(nil), // 15: pulumirpc.AnalyzerResourceOptions.CustomTimeouts
	nil,                     // 16: pulumirpc.AnalyzerInfo.InitialConfigEntry
	nil,                     // 17: pulumirpc.ConfigureAnalyzerRequest.PolicyConfigEntry
	(*structpb.Struct)(nil), // 18: google.protobuf.Struct
	(*emptypb.Empty)(nil),   // 19: google.protobuf.Empty
	(*PluginInfo)(nil),      // 20: pulumirpc.PluginInfo
}
var file_pulumi_analyzer_proto_depIdxs = []int32{
	18, // 0: pulumirpc.AnalyzeRequest.properties:type_name -> google.protobuf.Struct
	3,  // 1: pulumirpc.AnalyzeRequest.options:type_name -> pulumirpc.AnalyzerResourceOptions
	4,  // 2: pulumirpc.AnalyzeRequest.provider:type_name -> pulumirpc.AnalyzerProviderResource
	18, // 3: pulumirpc.AnalyzerResource.properties:type_name -> google.protobuf.Struct
	3,  // 4: pulumirpc.AnalyzerResource.options:type_name -> pulumirpc.AnalyzerResourceOptions
	4,  // 5: pulumirpc.AnalyzerResource.provider:type_name -> pulumirpc.AnalyzerProviderResource
	14, // 6: pulumirpc.AnalyzerResource.propertyDependencies:type_name -> pulumirpc.AnalyzerResource.PropertyDependenciesEntry
	15, // 7: pulumirpc.AnalyzerResourceOptions.customTimeouts:type_name -> pulumirpc.AnalyzerResourceOptions.CustomTimeouts
	18, // 8: pulumirpc.AnalyzerProviderResource.properties:type_name -> google.protobuf.Struct
	2,  // 9: pulumirpc.AnalyzeStackRequest.resources:type_name -> pulumirpc.AnalyzerResource
	8,  // 10: pulumirpc.AnalyzeResponse.diagnostics:type_name -> pulumirpc.AnalyzeDiagnostic
	0,  // 11: pulumirpc.AnalyzeDiagnostic.enforcementLevel:type_name -> pulumirpc.EnforcementLevel
	10, // 12: pulumirpc.AnalyzerInfo.policies:type_name -> pulumirpc.PolicyInfo
	16, // 13: pulumirpc.AnalyzerInfo.initialConfig:type_name -> pulumirpc.AnalyzerInfo.InitialConfigEntry
	0,  // 14: pulumirpc.PolicyInfo.enforcementLevel:type_name -> pulumirpc.EnforcementLevel
	11, // 15: pulumirpc.PolicyInfo.configSchema:type_name -> pulumirpc.PolicyConfigSchema
	18, // 16: pulumirpc.PolicyConfigSchema.properties:type_name -> google.protobuf.Struct
	0,  // 17: pulumirpc.PolicyConfig.enforcementLevel:type_name -> pulumirpc.EnforcementLevel
	18, // 18: pulumirpc.PolicyConfig.properties:type_name -> google.protobuf.Struct
	17, // 19: pulumirpc.ConfigureAnalyzerRequest.policyConfig:type_name -> pulumirpc.ConfigureAnalyzerRequest.PolicyConfigEntry
	5,  // 20: pulumirpc.AnalyzerResource.PropertyDependenciesEntry.value:type_name -> pulumirpc.AnalyzerPropertyDependencies
	12, // 21: pulumirpc.AnalyzerInfo.InitialConfigEntry.value:type_name -> pulumirpc.PolicyConfig
	12, // 22: pulumirpc.ConfigureAnalyzerRequest.PolicyConfigEntry.value:type_name -> pulumirpc.PolicyConfig
	1,  // 23: pulumirpc.Analyzer.Analyze:input_type -> pulumirpc.AnalyzeRequest
	6,  // 24: pulumirpc.Analyzer.AnalyzeStack:input_type -> pulumirpc.AnalyzeStackRequest
	19, // 25: pulumirpc.Analyzer.GetAnalyzerInfo:input_type -> google.protobuf.Empty
	19, // 26: pulumirpc.Analyzer.GetPluginInfo:input_type -> google.protobuf.Empty
	13, // 27: pulumirpc.Analyzer.Configure:input_type -> pulumirpc.ConfigureAnalyzerRequest
	7,  // 28: pulumirpc.Analyzer.Analyze:output_type -> pulumirpc.AnalyzeResponse
	7,  // 29: pulumirpc.Analyzer.AnalyzeStack:output_type -> pulumirpc.AnalyzeResponse
	9,  // 30: pulumirpc.Analyzer.GetAnalyzerInfo:output_type -> pulumirpc.AnalyzerInfo
	20, // 31: pulumirpc.Analyzer.GetPluginInfo:output_type -> pulumirpc.PluginInfo
	19, // 32: pulumirpc.Analyzer.Configure:output_type -> google.protobuf.Empty
	28, // [28:33] is the sub-list for method output_type
	23, // [23:28] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_pulumi_analyzer_proto_init() }
func file_pulumi_analyzer_proto_init() {
	if File_pulumi_analyzer_proto != nil {
		return
	}
	file_pulumi_plugin_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_pulumi_analyzer_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerResourceOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerProviderResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerPropertyDependencies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeStackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeDiagnostic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfigSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigureAnalyzerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_analyzer_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerResourceOptions_CustomTimeouts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pulumi_analyzer_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pulumi_analyzer_proto_goTypes,
		DependencyIndexes: file_pulumi_analyzer_proto_depIdxs,
		EnumInfos:         file_pulumi_analyzer_proto_enumTypes,
		MessageInfos:      file_pulumi_analyzer_proto_msgTypes,
	}.Build()
	File_pulumi_analyzer_proto = out.File
	file_pulumi_analyzer_proto_rawDesc = nil
	file_pulumi_analyzer_proto_goTypes = nil
	file_pulumi_analyzer_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AnalyzerClient is the client API for Analyzer service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AnalyzerClient interface {
	// Analyze analyzes a single resource object, and returns any errors that it finds.
	// Called with the "inputs" to the resource, before it is updated.
	Analyze(ctx context.Context, in *AnalyzeRequest, opts ...grpc.CallOption) (*AnalyzeResponse, error)
	// AnalyzeStack analyzes all resources within a stack, at the end of a successful
	// preview or update. The provided resources are the "outputs", after any mutations
	// have taken place.
	AnalyzeStack(ctx context.Context, in *AnalyzeStackRequest, opts ...grpc.CallOption) (*AnalyzeResponse, error)
	// GetAnalyzerInfo returns metadata about the analyzer (e.g., list of policies contained).
	GetAnalyzerInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*AnalyzerInfo, error)
	// GetPluginInfo returns generic information about this plugin, like its version.
	GetPluginInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PluginInfo, error)
	// Configure configures the analyzer, passing configuration properties for each policy.
	Configure(ctx context.Context, in *ConfigureAnalyzerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type analyzerClient struct {
	cc grpc.ClientConnInterface
}

func NewAnalyzerClient(cc grpc.ClientConnInterface) AnalyzerClient {
	return &analyzerClient{cc}
}

func (c *analyzerClient) Analyze(ctx context.Context, in *AnalyzeRequest, opts ...grpc.CallOption) (*AnalyzeResponse, error) {
	out := new(AnalyzeResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.Analyzer/Analyze", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyzerClient) AnalyzeStack(ctx context.Context, in *AnalyzeStackRequest, opts ...grpc.CallOption) (*AnalyzeResponse, error) {
	out := new(AnalyzeResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.Analyzer/AnalyzeStack", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyzerClient) GetAnalyzerInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*AnalyzerInfo, error) {
	out := new(AnalyzerInfo)
	err := c.cc.Invoke(ctx, "/pulumirpc.Analyzer/GetAnalyzerInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyzerClient) GetPluginInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PluginInfo, error) {
	out := new(PluginInfo)
	err := c.cc.Invoke(ctx, "/pulumirpc.Analyzer/GetPluginInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyzerClient) Configure(ctx context.Context, in *ConfigureAnalyzerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/pulumirpc.Analyzer/Configure", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnalyzerServer is the server API for Analyzer service.
type AnalyzerServer interface {
	// Analyze analyzes a single resource object, and returns any errors that it finds.
	// Called with the "inputs" to the resource, before it is updated.
	Analyze(context.Context, *AnalyzeRequest) (*AnalyzeResponse, error)
	// AnalyzeStack analyzes all resources within a stack, at the end of a successful
	// preview or update. The provided resources are the "outputs", after any mutations
	// have taken place.
	AnalyzeStack(context.Context, *AnalyzeStackRequest) (*AnalyzeResponse, error)
	// GetAnalyzerInfo returns metadata about the analyzer (e.g., list of policies contained).
	GetAnalyzerInfo(context.Context, *emptypb.Empty) (*AnalyzerInfo, error)
	// GetPluginInfo returns generic information about this plugin, like its version.
	GetPluginInfo(context.Context, *emptypb.Empty) (*PluginInfo, error)
	// Configure configures the analyzer, passing configuration properties for each policy.
	Configure(context.Context, *ConfigureAnalyzerRequest) (*emptypb.Empty, error)
}

// UnimplementedAnalyzerServer can be embedded to have forward compatible implementations.
type UnimplementedAnalyzerServer struct {
}

func (*UnimplementedAnalyzerServer) Analyze(context.Context, *AnalyzeRequest) (*AnalyzeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Analyze not implemented")
}
func (*UnimplementedAnalyzerServer) AnalyzeStack(context.Context, *AnalyzeStackRequest) (*AnalyzeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeStack not implemented")
}
func (*UnimplementedAnalyzerServer) GetAnalyzerInfo(context.Context, *emptypb.Empty) (*AnalyzerInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnalyzerInfo not implemented")
}
func (*UnimplementedAnalyzerServer) GetPluginInfo(context.Context, *emptypb.Empty) (*PluginInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPluginInfo not implemented")
}
func (*UnimplementedAnalyzerServer) Configure(context.Context, *ConfigureAnalyzerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Configure not implemented")
}

func RegisterAnalyzerServer(s *grpc.Server, srv AnalyzerServer) {
	s.RegisterService(&_Analyzer_serviceDesc, srv)
}

func _Analyzer_Analyze_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyzerServer).Analyze(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.Analyzer/Analyze",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyzerServer).Analyze(ctx, req.(*AnalyzeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Analyzer_AnalyzeStack_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeStackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyzerServer).AnalyzeStack(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.Analyzer/AnalyzeStack",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyzerServer).AnalyzeStack(ctx, req.(*AnalyzeStackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Analyzer_GetAnalyzerInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyzerServer).GetAnalyzerInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.Analyzer/GetAnalyzerInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyzerServer).GetAnalyzerInfo(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Analyzer_GetPluginInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyzerServer).GetPluginInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.Analyzer/GetPluginInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyzerServer).GetPluginInfo(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Analyzer_Configure_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureAnalyzerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyzerServer).Configure(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.Analyzer/Configure",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyzerServer).Configure(ctx, req.(*ConfigureAnalyzerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Analyzer_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pulumirpc.Analyzer",
	HandlerType: (*AnalyzerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Analyze",
			Handler:    _Analyzer_Analyze_Handler,
		},
		{
			MethodName: "AnalyzeStack",
			Handler:    _Analyzer_AnalyzeStack_Handler,
		},
		{
			MethodName: "GetAnalyzerInfo",
			Handler:    _Analyzer_GetAnalyzerInfo_Handler,
		},
		{
			MethodName: "GetPluginInfo",
			Handler:    _Analyzer_GetPluginInfo_Handler,
		},
		{
			MethodName: "Configure",
			Handler:    _Analyzer_Configure_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "pulumi/analyzer.proto",
}
