// Copyright 2016-2018, Pulumi Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.20.1
// source: pulumi/language.proto

package pulumirpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AboutResponse returns runtime information about the language.
type AboutResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Executable string            `protobuf:"bytes,1,opt,name=executable,proto3" json:"executable,omitempty"`                                                                                     // the primary executable for the runtime of this language.
	Version    string            `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`                                                                                           // the version of the runtime for this language.
	Metadata   map[string]string `protobuf:"bytes,3,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // other information about this language.
}

func (x *AboutResponse) Reset() {
	*x = AboutResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AboutResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AboutResponse) ProtoMessage() {}

func (x *AboutResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AboutResponse.ProtoReflect.Descriptor instead.
func (*AboutResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{0}
}

func (x *AboutResponse) GetExecutable() string {
	if x != nil {
		return x.Executable
	}
	return ""
}

func (x *AboutResponse) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AboutResponse) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type GetProgramDependenciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Project                string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`                                // the project name.
	Pwd                    string `protobuf:"bytes,2,opt,name=pwd,proto3" json:"pwd,omitempty"`                                        // the program's working directory.
	Program                string `protobuf:"bytes,3,opt,name=program,proto3" json:"program,omitempty"`                                // the path to the program.
	TransitiveDependencies bool   `protobuf:"varint,4,opt,name=transitiveDependencies,proto3" json:"transitiveDependencies,omitempty"` // if transitive dependencies should be included in the result.
}

func (x *GetProgramDependenciesRequest) Reset() {
	*x = GetProgramDependenciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProgramDependenciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProgramDependenciesRequest) ProtoMessage() {}

func (x *GetProgramDependenciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProgramDependenciesRequest.ProtoReflect.Descriptor instead.
func (*GetProgramDependenciesRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{1}
}

func (x *GetProgramDependenciesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *GetProgramDependenciesRequest) GetPwd() string {
	if x != nil {
		return x.Pwd
	}
	return ""
}

func (x *GetProgramDependenciesRequest) GetProgram() string {
	if x != nil {
		return x.Program
	}
	return ""
}

func (x *GetProgramDependenciesRequest) GetTransitiveDependencies() bool {
	if x != nil {
		return x.TransitiveDependencies
	}
	return false
}

type DependencyInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name    string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`       // The name of the dependency.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"` // The version of the dependency.
}

func (x *DependencyInfo) Reset() {
	*x = DependencyInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DependencyInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DependencyInfo) ProtoMessage() {}

func (x *DependencyInfo) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DependencyInfo.ProtoReflect.Descriptor instead.
func (*DependencyInfo) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{2}
}

func (x *DependencyInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DependencyInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type GetProgramDependenciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Dependencies []*DependencyInfo `protobuf:"bytes,1,rep,name=dependencies,proto3" json:"dependencies,omitempty"` // the dependencies of this program
}

func (x *GetProgramDependenciesResponse) Reset() {
	*x = GetProgramDependenciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProgramDependenciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProgramDependenciesResponse) ProtoMessage() {}

func (x *GetProgramDependenciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProgramDependenciesResponse.ProtoReflect.Descriptor instead.
func (*GetProgramDependenciesResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{3}
}

func (x *GetProgramDependenciesResponse) GetDependencies() []*DependencyInfo {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

type GetRequiredPluginsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"` // the project name.
	Pwd     string `protobuf:"bytes,2,opt,name=pwd,proto3" json:"pwd,omitempty"`         // the program's working directory.
	Program string `protobuf:"bytes,3,opt,name=program,proto3" json:"program,omitempty"` // the path to the program.
}

func (x *GetRequiredPluginsRequest) Reset() {
	*x = GetRequiredPluginsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRequiredPluginsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRequiredPluginsRequest) ProtoMessage() {}

func (x *GetRequiredPluginsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRequiredPluginsRequest.ProtoReflect.Descriptor instead.
func (*GetRequiredPluginsRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{4}
}

func (x *GetRequiredPluginsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *GetRequiredPluginsRequest) GetPwd() string {
	if x != nil {
		return x.Pwd
	}
	return ""
}

func (x *GetRequiredPluginsRequest) GetProgram() string {
	if x != nil {
		return x.Program
	}
	return ""
}

type GetRequiredPluginsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Plugins []*PluginDependency `protobuf:"bytes,1,rep,name=plugins,proto3" json:"plugins,omitempty"` // a list of plugins required by this program.
}

func (x *GetRequiredPluginsResponse) Reset() {
	*x = GetRequiredPluginsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRequiredPluginsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRequiredPluginsResponse) ProtoMessage() {}

func (x *GetRequiredPluginsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRequiredPluginsResponse.ProtoReflect.Descriptor instead.
func (*GetRequiredPluginsResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{5}
}

func (x *GetRequiredPluginsResponse) GetPlugins() []*PluginDependency {
	if x != nil {
		return x.Plugins
	}
	return nil
}

// RunRequest asks the interpreter to execute a program.
type RunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Project          string            `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`                                                                                       // the project name.
	Stack            string            `protobuf:"bytes,2,opt,name=stack,proto3" json:"stack,omitempty"`                                                                                           // the name of the stack being deployed into.
	Pwd              string            `protobuf:"bytes,3,opt,name=pwd,proto3" json:"pwd,omitempty"`                                                                                               // the program's working directory.
	Program          string            `protobuf:"bytes,4,opt,name=program,proto3" json:"program,omitempty"`                                                                                       // the path to the program to execute.
	Args             []string          `protobuf:"bytes,5,rep,name=args,proto3" json:"args,omitempty"`                                                                                             // any arguments to pass to the program.
	Config           map[string]string `protobuf:"bytes,6,rep,name=config,proto3" json:"config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // the configuration variables to apply before running.
	DryRun           bool              `protobuf:"varint,7,opt,name=dryRun,proto3" json:"dryRun,omitempty"`                                                                                        // true if we're only doing a dryrun (preview).
	Parallel         int32             `protobuf:"varint,8,opt,name=parallel,proto3" json:"parallel,omitempty"`                                                                                    // the degree of parallelism for resource operations (<=1 for serial).
	MonitorAddress   string            `protobuf:"bytes,9,opt,name=monitor_address,json=monitorAddress,proto3" json:"monitor_address,omitempty"`                                                   // the address for communicating back to the resource monitor.
	QueryMode        bool              `protobuf:"varint,10,opt,name=queryMode,proto3" json:"queryMode,omitempty"`                                                                                 // true if we're only doing a query.
	ConfigSecretKeys []string          `protobuf:"bytes,11,rep,name=configSecretKeys,proto3" json:"configSecretKeys,omitempty"`                                                                    // the configuration keys that have secret values.
	Organization     string            `protobuf:"bytes,12,opt,name=organization,proto3" json:"organization,omitempty"`                                                                            // the organization of the stack being deployed into.
}

func (x *RunRequest) Reset() {
	*x = RunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunRequest) ProtoMessage() {}

func (x *RunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunRequest.ProtoReflect.Descriptor instead.
func (*RunRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{6}
}

func (x *RunRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *RunRequest) GetStack() string {
	if x != nil {
		return x.Stack
	}
	return ""
}

func (x *RunRequest) GetPwd() string {
	if x != nil {
		return x.Pwd
	}
	return ""
}

func (x *RunRequest) GetProgram() string {
	if x != nil {
		return x.Program
	}
	return ""
}

func (x *RunRequest) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *RunRequest) GetConfig() map[string]string {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *RunRequest) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

func (x *RunRequest) GetParallel() int32 {
	if x != nil {
		return x.Parallel
	}
	return 0
}

func (x *RunRequest) GetMonitorAddress() string {
	if x != nil {
		return x.MonitorAddress
	}
	return ""
}

func (x *RunRequest) GetQueryMode() bool {
	if x != nil {
		return x.QueryMode
	}
	return false
}

func (x *RunRequest) GetConfigSecretKeys() []string {
	if x != nil {
		return x.ConfigSecretKeys
	}
	return nil
}

func (x *RunRequest) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

// RunResponse is the response back from the interpreter/source back to the monitor.
type RunResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An unhandled error if any occurred.
	Error string `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// An error happened.  And it was reported to the user.  Work should stop immediately
	// with nothing further to print to the user.  This corresponds to a "result.Bail()"
	// value in the 'go' layer.
	Bail bool `protobuf:"varint,2,opt,name=bail,proto3" json:"bail,omitempty"`
}

func (x *RunResponse) Reset() {
	*x = RunResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunResponse) ProtoMessage() {}

func (x *RunResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunResponse.ProtoReflect.Descriptor instead.
func (*RunResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{7}
}

func (x *RunResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *RunResponse) GetBail() bool {
	if x != nil {
		return x.Bail
	}
	return false
}

type InstallDependenciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Directory  string `protobuf:"bytes,1,opt,name=directory,proto3" json:"directory,omitempty"`                      // the program's working directory.
	IsTerminal bool   `protobuf:"varint,2,opt,name=is_terminal,json=isTerminal,proto3" json:"is_terminal,omitempty"` // if we are running in a terminal and should use ANSI codes
}

func (x *InstallDependenciesRequest) Reset() {
	*x = InstallDependenciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallDependenciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallDependenciesRequest) ProtoMessage() {}

func (x *InstallDependenciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallDependenciesRequest.ProtoReflect.Descriptor instead.
func (*InstallDependenciesRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{8}
}

func (x *InstallDependenciesRequest) GetDirectory() string {
	if x != nil {
		return x.Directory
	}
	return ""
}

func (x *InstallDependenciesRequest) GetIsTerminal() bool {
	if x != nil {
		return x.IsTerminal
	}
	return false
}

type InstallDependenciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Stdout []byte `protobuf:"bytes,1,opt,name=stdout,proto3" json:"stdout,omitempty"` // a line of stdout text.
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr,proto3" json:"stderr,omitempty"` // a line of stderr text.
}

func (x *InstallDependenciesResponse) Reset() {
	*x = InstallDependenciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallDependenciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallDependenciesResponse) ProtoMessage() {}

func (x *InstallDependenciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallDependenciesResponse.ProtoReflect.Descriptor instead.
func (*InstallDependenciesResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{9}
}

func (x *InstallDependenciesResponse) GetStdout() []byte {
	if x != nil {
		return x.Stdout
	}
	return nil
}

func (x *InstallDependenciesResponse) GetStderr() []byte {
	if x != nil {
		return x.Stderr
	}
	return nil
}

type RunPluginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Pwd     string   `protobuf:"bytes,1,opt,name=pwd,proto3" json:"pwd,omitempty"`         // the program's working directory.
	Program string   `protobuf:"bytes,2,opt,name=program,proto3" json:"program,omitempty"` // the path to the program to execute.
	Args    []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`       // any arguments to pass to the program.
	Env     []string `protobuf:"bytes,4,rep,name=env,proto3" json:"env,omitempty"`         // any environment variables to set as part of the program.
}

func (x *RunPluginRequest) Reset() {
	*x = RunPluginRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPluginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPluginRequest) ProtoMessage() {}

func (x *RunPluginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPluginRequest.ProtoReflect.Descriptor instead.
func (*RunPluginRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{10}
}

func (x *RunPluginRequest) GetPwd() string {
	if x != nil {
		return x.Pwd
	}
	return ""
}

func (x *RunPluginRequest) GetProgram() string {
	if x != nil {
		return x.Program
	}
	return ""
}

func (x *RunPluginRequest) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *RunPluginRequest) GetEnv() []string {
	if x != nil {
		return x.Env
	}
	return nil
}

type RunPluginResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Output:
	//	*RunPluginResponse_Stdout
	//	*RunPluginResponse_Stderr
	//	*RunPluginResponse_Exitcode
	Output isRunPluginResponse_Output `protobuf_oneof:"output"`
}

func (x *RunPluginResponse) Reset() {
	*x = RunPluginResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_language_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunPluginResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunPluginResponse) ProtoMessage() {}

func (x *RunPluginResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_language_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunPluginResponse.ProtoReflect.Descriptor instead.
func (*RunPluginResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_language_proto_rawDescGZIP(), []int{11}
}

func (m *RunPluginResponse) GetOutput() isRunPluginResponse_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *RunPluginResponse) GetStdout() []byte {
	if x, ok := x.GetOutput().(*RunPluginResponse_Stdout); ok {
		return x.Stdout
	}
	return nil
}

func (x *RunPluginResponse) GetStderr() []byte {
	if x, ok := x.GetOutput().(*RunPluginResponse_Stderr); ok {
		return x.Stderr
	}
	return nil
}

func (x *RunPluginResponse) GetExitcode() int32 {
	if x, ok := x.GetOutput().(*RunPluginResponse_Exitcode); ok {
		return x.Exitcode
	}
	return 0
}

type isRunPluginResponse_Output interface {
	isRunPluginResponse_Output()
}

type RunPluginResponse_Stdout struct {
	Stdout []byte `protobuf:"bytes,1,opt,name=stdout,proto3,oneof"` // a line of stdout text.
}

type RunPluginResponse_Stderr struct {
	Stderr []byte `protobuf:"bytes,2,opt,name=stderr,proto3,oneof"` // a line of stderr text.
}

type RunPluginResponse_Exitcode struct {
	Exitcode int32 `protobuf:"varint,3,opt,name=exitcode,proto3,oneof"` // the exit code of the provider.
}

func (*RunPluginResponse_Stdout) isRunPluginResponse_Output() {}

func (*RunPluginResponse_Stderr) isRunPluginResponse_Output() {}

func (*RunPluginResponse_Exitcode) isRunPluginResponse_Output() {}

var File_pulumi_language_proto protoreflect.FileDescriptor

var file_pulumi_language_proto_rawDesc = []byte{
	0x0a, 0x15, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72,
	0x70, 0x63, 0x1a, 0x13, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xca, 0x01, 0x0a, 0x0d, 0x41, 0x62, 0x6f, 0x75, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x42, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x41,
	0x62, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x9d, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x70, 0x77, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70, 0x77, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x36, 0x0a, 0x16, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x22, 0x3e, 0x0a, 0x0e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x5f, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x44,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x75,
	0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x22, 0x61, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x77, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70, 0x77, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x22, 0x53, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63,
	0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x79, 0x52, 0x07, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x22, 0xbd, 0x03, 0x0a, 0x0a, 0x52,
	0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x77, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x70, 0x77, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12, 0x39, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x70, 0x75, 0x6c, 0x75,
	0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x1c, 0x0a, 0x09, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x2a, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b,
	0x65, 0x79, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0x39, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37, 0x0a, 0x0b, 0x52, 0x75,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x62, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x62,
	0x61, 0x69, 0x6c, 0x22, 0x5b, 0x0a, 0x1a, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12,
	0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c,
	0x22, 0x4d, 0x0a, 0x1b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x22,
	0x64, 0x0a, 0x10, 0x52, 0x75, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x77, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x70, 0x77, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12,
	0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61,
	0x72, 0x67, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x03, 0x65, 0x6e, 0x76, 0x22, 0x6f, 0x0a, 0x11, 0x52, 0x75, 0x6e, 0x50, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x73, 0x74,
	0x64, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74,
	0x64, 0x6f, 0x75, 0x74, 0x12, 0x18, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x12, 0x1c,
	0x0a, 0x08, 0x65, 0x78, 0x69, 0x74, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x08, 0x0a, 0x06,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x32, 0xd4, 0x04, 0x0a, 0x0f, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x12, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73,
	0x12, 0x24, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72,
	0x70, 0x63, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x36, 0x0a, 0x03, 0x52, 0x75, 0x6e, 0x12, 0x15, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72,
	0x70, 0x63, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x40, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x1a, 0x15, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x50, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x68, 0x0a, 0x13, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73,
	0x12, 0x25, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x72, 0x70, 0x63, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x30, 0x01, 0x12, 0x3b, 0x0a, 0x05, 0x41, 0x62, 0x6f, 0x75, 0x74, 0x12, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x1a, 0x18, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63,
	0x2e, 0x41, 0x62, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x6f, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x28, 0x2e, 0x70, 0x75, 0x6c,
	0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63,
	0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x4a, 0x0a, 0x09, 0x52, 0x75, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x1b,
	0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x6c,
	0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70, 0x75,
	0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x75, 0x6e, 0x50, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x42, 0x34, 0x5a,
	0x32, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x70, 0x75, 0x6c, 0x75,
	0x6d, 0x69, 0x2f, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x33,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x3b, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x72, 0x70, 0x63, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pulumi_language_proto_rawDescOnce sync.Once
	file_pulumi_language_proto_rawDescData = file_pulumi_language_proto_rawDesc
)

func file_pulumi_language_proto_rawDescGZIP() []byte {
	file_pulumi_language_proto_rawDescOnce.Do(func() {
		file_pulumi_language_proto_rawDescData = protoimpl.X.CompressGZIP(file_pulumi_language_proto_rawDescData)
	})
	return file_pulumi_language_proto_rawDescData
}

var file_pulumi_language_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_pulumi_language_proto_goTypes = []interface{}{
	(*AboutResponse)(nil),                  // 0: pulumirpc.AboutResponse
	(*GetProgramDependenciesRequest)(nil),  // 1: pulumirpc.GetProgramDependenciesRequest
	(*DependencyInfo)(nil),                 // 2: pulumirpc.DependencyInfo
	(*GetProgramDependenciesResponse)(nil), // 3: pulumirpc.GetProgramDependenciesResponse
	(*GetRequiredPluginsRequest)(nil),      // 4: pulumirpc.GetRequiredPluginsRequest
	(*GetRequiredPluginsResponse)(nil),     // 5: pulumirpc.GetRequiredPluginsResponse
	(*RunRequest)(nil),                     // 6: pulumirpc.RunRequest
	(*RunResponse)(nil),                    // 7: pulumirpc.RunResponse
	(*InstallDependenciesRequest)(nil),     // 8: pulumirpc.InstallDependenciesRequest
	(*InstallDependenciesResponse)(nil),    // 9: pulumirpc.InstallDependenciesResponse
	(*RunPluginRequest)(nil),               // 10: pulumirpc.RunPluginRequest
	(*RunPluginResponse)(nil),              // 11: pulumirpc.RunPluginResponse
	nil,                                    // 12: pulumirpc.AboutResponse.MetadataEntry
	nil,                                    // 13: pulumirpc.RunRequest.ConfigEntry
	(*PluginDependency)(nil),               // 14: pulumirpc.PluginDependency
	(*emptypb.Empty)(nil),                  // 15: google.protobuf.Empty
	(*PluginInfo)(nil),                     // 16: pulumirpc.PluginInfo
}
var file_pulumi_language_proto_depIdxs = []int32{
	12, // 0: pulumirpc.AboutResponse.metadata:type_name -> pulumirpc.AboutResponse.MetadataEntry
	2,  // 1: pulumirpc.GetProgramDependenciesResponse.dependencies:type_name -> pulumirpc.DependencyInfo
	14, // 2: pulumirpc.GetRequiredPluginsResponse.plugins:type_name -> pulumirpc.PluginDependency
	13, // 3: pulumirpc.RunRequest.config:type_name -> pulumirpc.RunRequest.ConfigEntry
	4,  // 4: pulumirpc.LanguageRuntime.GetRequiredPlugins:input_type -> pulumirpc.GetRequiredPluginsRequest
	6,  // 5: pulumirpc.LanguageRuntime.Run:input_type -> pulumirpc.RunRequest
	15, // 6: pulumirpc.LanguageRuntime.GetPluginInfo:input_type -> google.protobuf.Empty
	8,  // 7: pulumirpc.LanguageRuntime.InstallDependencies:input_type -> pulumirpc.InstallDependenciesRequest
	15, // 8: pulumirpc.LanguageRuntime.About:input_type -> google.protobuf.Empty
	1,  // 9: pulumirpc.LanguageRuntime.GetProgramDependencies:input_type -> pulumirpc.GetProgramDependenciesRequest
	10, // 10: pulumirpc.LanguageRuntime.RunPlugin:input_type -> pulumirpc.RunPluginRequest
	5,  // 11: pulumirpc.LanguageRuntime.GetRequiredPlugins:output_type -> pulumirpc.GetRequiredPluginsResponse
	7,  // 12: pulumirpc.LanguageRuntime.Run:output_type -> pulumirpc.RunResponse
	16, // 13: pulumirpc.LanguageRuntime.GetPluginInfo:output_type -> pulumirpc.PluginInfo
	9,  // 14: pulumirpc.LanguageRuntime.InstallDependencies:output_type -> pulumirpc.InstallDependenciesResponse
	0,  // 15: pulumirpc.LanguageRuntime.About:output_type -> pulumirpc.AboutResponse
	3,  // 16: pulumirpc.LanguageRuntime.GetProgramDependencies:output_type -> pulumirpc.GetProgramDependenciesResponse
	11, // 17: pulumirpc.LanguageRuntime.RunPlugin:output_type -> pulumirpc.RunPluginResponse
	11, // [11:18] is the sub-list for method output_type
	4,  // [4:11] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_pulumi_language_proto_init() }
func file_pulumi_language_proto_init() {
	if File_pulumi_language_proto != nil {
		return
	}
	file_pulumi_plugin_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_pulumi_language_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AboutResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProgramDependenciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DependencyInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProgramDependenciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRequiredPluginsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRequiredPluginsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallDependenciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallDependenciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPluginRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_language_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunPluginResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_pulumi_language_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*RunPluginResponse_Stdout)(nil),
		(*RunPluginResponse_Stderr)(nil),
		(*RunPluginResponse_Exitcode)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pulumi_language_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pulumi_language_proto_goTypes,
		DependencyIndexes: file_pulumi_language_proto_depIdxs,
		MessageInfos:      file_pulumi_language_proto_msgTypes,
	}.Build()
	File_pulumi_language_proto = out.File
	file_pulumi_language_proto_rawDesc = nil
	file_pulumi_language_proto_goTypes = nil
	file_pulumi_language_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LanguageRuntimeClient is the client API for LanguageRuntime service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LanguageRuntimeClient interface {
	// GetRequiredPlugins computes the complete set of anticipated plugins required by a program.
	GetRequiredPlugins(ctx context.Context, in *GetRequiredPluginsRequest, opts ...grpc.CallOption) (*GetRequiredPluginsResponse, error)
	// Run executes a program and returns its result.
	Run(ctx context.Context, in *RunRequest, opts ...grpc.CallOption) (*RunResponse, error)
	// GetPluginInfo returns generic information about this plugin, like its version.
	GetPluginInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PluginInfo, error)
	// InstallDependencies will install dependencies for the project, e.g. by running `npm install` for nodejs projects.
	InstallDependencies(ctx context.Context, in *InstallDependenciesRequest, opts ...grpc.CallOption) (LanguageRuntime_InstallDependenciesClient, error)
	// About returns information about the runtime for this language.
	About(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*AboutResponse, error)
	// GetProgramDependencies returns the set of dependencies required by the program.
	GetProgramDependencies(ctx context.Context, in *GetProgramDependenciesRequest, opts ...grpc.CallOption) (*GetProgramDependenciesResponse, error)
	// RunPlugin executes a plugin program and returns its result asynchronously.
	RunPlugin(ctx context.Context, in *RunPluginRequest, opts ...grpc.CallOption) (LanguageRuntime_RunPluginClient, error)
}

type languageRuntimeClient struct {
	cc grpc.ClientConnInterface
}

func NewLanguageRuntimeClient(cc grpc.ClientConnInterface) LanguageRuntimeClient {
	return &languageRuntimeClient{cc}
}

func (c *languageRuntimeClient) GetRequiredPlugins(ctx context.Context, in *GetRequiredPluginsRequest, opts ...grpc.CallOption) (*GetRequiredPluginsResponse, error) {
	out := new(GetRequiredPluginsResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.LanguageRuntime/GetRequiredPlugins", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageRuntimeClient) Run(ctx context.Context, in *RunRequest, opts ...grpc.CallOption) (*RunResponse, error) {
	out := new(RunResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.LanguageRuntime/Run", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageRuntimeClient) GetPluginInfo(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*PluginInfo, error) {
	out := new(PluginInfo)
	err := c.cc.Invoke(ctx, "/pulumirpc.LanguageRuntime/GetPluginInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageRuntimeClient) InstallDependencies(ctx context.Context, in *InstallDependenciesRequest, opts ...grpc.CallOption) (LanguageRuntime_InstallDependenciesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_LanguageRuntime_serviceDesc.Streams[0], "/pulumirpc.LanguageRuntime/InstallDependencies", opts...)
	if err != nil {
		return nil, err
	}
	x := &languageRuntimeInstallDependenciesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type LanguageRuntime_InstallDependenciesClient interface {
	Recv() (*InstallDependenciesResponse, error)
	grpc.ClientStream
}

type languageRuntimeInstallDependenciesClient struct {
	grpc.ClientStream
}

func (x *languageRuntimeInstallDependenciesClient) Recv() (*InstallDependenciesResponse, error) {
	m := new(InstallDependenciesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *languageRuntimeClient) About(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*AboutResponse, error) {
	out := new(AboutResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.LanguageRuntime/About", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageRuntimeClient) GetProgramDependencies(ctx context.Context, in *GetProgramDependenciesRequest, opts ...grpc.CallOption) (*GetProgramDependenciesResponse, error) {
	out := new(GetProgramDependenciesResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.LanguageRuntime/GetProgramDependencies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *languageRuntimeClient) RunPlugin(ctx context.Context, in *RunPluginRequest, opts ...grpc.CallOption) (LanguageRuntime_RunPluginClient, error) {
	stream, err := c.cc.NewStream(ctx, &_LanguageRuntime_serviceDesc.Streams[1], "/pulumirpc.LanguageRuntime/RunPlugin", opts...)
	if err != nil {
		return nil, err
	}
	x := &languageRuntimeRunPluginClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type LanguageRuntime_RunPluginClient interface {
	Recv() (*RunPluginResponse, error)
	grpc.ClientStream
}

type languageRuntimeRunPluginClient struct {
	grpc.ClientStream
}

func (x *languageRuntimeRunPluginClient) Recv() (*RunPluginResponse, error) {
	m := new(RunPluginResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// LanguageRuntimeServer is the server API for LanguageRuntime service.
type LanguageRuntimeServer interface {
	// GetRequiredPlugins computes the complete set of anticipated plugins required by a program.
	GetRequiredPlugins(context.Context, *GetRequiredPluginsRequest) (*GetRequiredPluginsResponse, error)
	// Run executes a program and returns its result.
	Run(context.Context, *RunRequest) (*RunResponse, error)
	// GetPluginInfo returns generic information about this plugin, like its version.
	GetPluginInfo(context.Context, *emptypb.Empty) (*PluginInfo, error)
	// InstallDependencies will install dependencies for the project, e.g. by running `npm install` for nodejs projects.
	InstallDependencies(*InstallDependenciesRequest, LanguageRuntime_InstallDependenciesServer) error
	// About returns information about the runtime for this language.
	About(context.Context, *emptypb.Empty) (*AboutResponse, error)
	// GetProgramDependencies returns the set of dependencies required by the program.
	GetProgramDependencies(context.Context, *GetProgramDependenciesRequest) (*GetProgramDependenciesResponse, error)
	// RunPlugin executes a plugin program and returns its result asynchronously.
	RunPlugin(*RunPluginRequest, LanguageRuntime_RunPluginServer) error
}

// UnimplementedLanguageRuntimeServer can be embedded to have forward compatible implementations.
type UnimplementedLanguageRuntimeServer struct {
}

func (*UnimplementedLanguageRuntimeServer) GetRequiredPlugins(context.Context, *GetRequiredPluginsRequest) (*GetRequiredPluginsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRequiredPlugins not implemented")
}
func (*UnimplementedLanguageRuntimeServer) Run(context.Context, *RunRequest) (*RunResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Run not implemented")
}
func (*UnimplementedLanguageRuntimeServer) GetPluginInfo(context.Context, *emptypb.Empty) (*PluginInfo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPluginInfo not implemented")
}
func (*UnimplementedLanguageRuntimeServer) InstallDependencies(*InstallDependenciesRequest, LanguageRuntime_InstallDependenciesServer) error {
	return status.Errorf(codes.Unimplemented, "method InstallDependencies not implemented")
}
func (*UnimplementedLanguageRuntimeServer) About(context.Context, *emptypb.Empty) (*AboutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method About not implemented")
}
func (*UnimplementedLanguageRuntimeServer) GetProgramDependencies(context.Context, *GetProgramDependenciesRequest) (*GetProgramDependenciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProgramDependencies not implemented")
}
func (*UnimplementedLanguageRuntimeServer) RunPlugin(*RunPluginRequest, LanguageRuntime_RunPluginServer) error {
	return status.Errorf(codes.Unimplemented, "method RunPlugin not implemented")
}

func RegisterLanguageRuntimeServer(s *grpc.Server, srv LanguageRuntimeServer) {
	s.RegisterService(&_LanguageRuntime_serviceDesc, srv)
}

func _LanguageRuntime_GetRequiredPlugins_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRequiredPluginsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageRuntimeServer).GetRequiredPlugins(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.LanguageRuntime/GetRequiredPlugins",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageRuntimeServer).GetRequiredPlugins(ctx, req.(*GetRequiredPluginsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageRuntime_Run_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageRuntimeServer).Run(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.LanguageRuntime/Run",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageRuntimeServer).Run(ctx, req.(*RunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageRuntime_GetPluginInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageRuntimeServer).GetPluginInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.LanguageRuntime/GetPluginInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageRuntimeServer).GetPluginInfo(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageRuntime_InstallDependencies_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InstallDependenciesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LanguageRuntimeServer).InstallDependencies(m, &languageRuntimeInstallDependenciesServer{stream})
}

type LanguageRuntime_InstallDependenciesServer interface {
	Send(*InstallDependenciesResponse) error
	grpc.ServerStream
}

type languageRuntimeInstallDependenciesServer struct {
	grpc.ServerStream
}

func (x *languageRuntimeInstallDependenciesServer) Send(m *InstallDependenciesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _LanguageRuntime_About_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageRuntimeServer).About(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.LanguageRuntime/About",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageRuntimeServer).About(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageRuntime_GetProgramDependencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProgramDependenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LanguageRuntimeServer).GetProgramDependencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.LanguageRuntime/GetProgramDependencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LanguageRuntimeServer).GetProgramDependencies(ctx, req.(*GetProgramDependenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LanguageRuntime_RunPlugin_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(RunPluginRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LanguageRuntimeServer).RunPlugin(m, &languageRuntimeRunPluginServer{stream})
}

type LanguageRuntime_RunPluginServer interface {
	Send(*RunPluginResponse) error
	grpc.ServerStream
}

type languageRuntimeRunPluginServer struct {
	grpc.ServerStream
}

func (x *languageRuntimeRunPluginServer) Send(m *RunPluginResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _LanguageRuntime_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pulumirpc.LanguageRuntime",
	HandlerType: (*LanguageRuntimeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRequiredPlugins",
			Handler:    _LanguageRuntime_GetRequiredPlugins_Handler,
		},
		{
			MethodName: "Run",
			Handler:    _LanguageRuntime_Run_Handler,
		},
		{
			MethodName: "GetPluginInfo",
			Handler:    _LanguageRuntime_GetPluginInfo_Handler,
		},
		{
			MethodName: "About",
			Handler:    _LanguageRuntime_About_Handler,
		},
		{
			MethodName: "GetProgramDependencies",
			Handler:    _LanguageRuntime_GetProgramDependencies_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "InstallDependencies",
			Handler:       _LanguageRuntime_InstallDependencies_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RunPlugin",
			Handler:       _LanguageRuntime_RunPlugin_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "pulumi/language.proto",
}
