// Copyright 2016-2022, Pulumi Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.20.1
// source: pulumi/resource.proto

package pulumirpc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// SupportsFeatureRequest allows a client to test if the resource monitor supports a certain feature, which it may use
// to control the format or types of messages it sends.
type SupportsFeatureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"` // the ID of the feature to test support for.
}

func (x *SupportsFeatureRequest) Reset() {
	*x = SupportsFeatureRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportsFeatureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportsFeatureRequest) ProtoMessage() {}

func (x *SupportsFeatureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportsFeatureRequest.ProtoReflect.Descriptor instead.
func (*SupportsFeatureRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{0}
}

func (x *SupportsFeatureRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type SupportsFeatureResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HasSupport bool `protobuf:"varint,1,opt,name=hasSupport,proto3" json:"hasSupport,omitempty"` // true when the resource monitor supports this feature.
}

func (x *SupportsFeatureResponse) Reset() {
	*x = SupportsFeatureResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupportsFeatureResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupportsFeatureResponse) ProtoMessage() {}

func (x *SupportsFeatureResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupportsFeatureResponse.ProtoReflect.Descriptor instead.
func (*SupportsFeatureResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{1}
}

func (x *SupportsFeatureResponse) GetHasSupport() bool {
	if x != nil {
		return x.HasSupport
	}
	return false
}

// ReadResourceRequest contains enough information to uniquely qualify and read a resource's state.
type ReadResourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id                      string           `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`                                            // the ID of the resource to read.
	Type                    string           `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`                                        // the type of the resource object.
	Name                    string           `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`                                        // the name, for URN purposes, of the object.
	Parent                  string           `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`                                    // an optional parent URN that this child resource belongs to.
	Properties              *structpb.Struct `protobuf:"bytes,5,opt,name=properties,proto3" json:"properties,omitempty"`                            // optional state sufficient to uniquely identify the resource.
	Dependencies            []string         `protobuf:"bytes,6,rep,name=dependencies,proto3" json:"dependencies,omitempty"`                        // a list of URNs that this read depends on, as observed by the language host.
	Provider                string           `protobuf:"bytes,7,opt,name=provider,proto3" json:"provider,omitempty"`                                // an optional reference to the provider to use for this read.
	Version                 string           `protobuf:"bytes,8,opt,name=version,proto3" json:"version,omitempty"`                                  // the version of the provider to use when servicing this request.
	AcceptSecrets           bool             `protobuf:"varint,9,opt,name=acceptSecrets,proto3" json:"acceptSecrets,omitempty"`                     // when true operations should return secrets as strongly typed.
	AdditionalSecretOutputs []string         `protobuf:"bytes,10,rep,name=additionalSecretOutputs,proto3" json:"additionalSecretOutputs,omitempty"` // a list of output properties that should also be treated as secret, in addition to ones we detect.
	AcceptResources         bool             `protobuf:"varint,12,opt,name=acceptResources,proto3" json:"acceptResources,omitempty"`                // when true operations should return resource references as strongly typed.
	PluginDownloadURL       string           `protobuf:"bytes,13,opt,name=pluginDownloadURL,proto3" json:"pluginDownloadURL,omitempty"`             // the server url of the provider to use when servicing this request.
}

func (x *ReadResourceRequest) Reset() {
	*x = ReadResourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadResourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResourceRequest) ProtoMessage() {}

func (x *ReadResourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResourceRequest.ProtoReflect.Descriptor instead.
func (*ReadResourceRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{2}
}

func (x *ReadResourceRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ReadResourceRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ReadResourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReadResourceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ReadResourceRequest) GetProperties() *structpb.Struct {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *ReadResourceRequest) GetDependencies() []string {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *ReadResourceRequest) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *ReadResourceRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ReadResourceRequest) GetAcceptSecrets() bool {
	if x != nil {
		return x.AcceptSecrets
	}
	return false
}

func (x *ReadResourceRequest) GetAdditionalSecretOutputs() []string {
	if x != nil {
		return x.AdditionalSecretOutputs
	}
	return nil
}

func (x *ReadResourceRequest) GetAcceptResources() bool {
	if x != nil {
		return x.AcceptResources
	}
	return false
}

func (x *ReadResourceRequest) GetPluginDownloadURL() string {
	if x != nil {
		return x.PluginDownloadURL
	}
	return ""
}

// ReadResourceResponse contains the result of reading a resource's state.
type ReadResourceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Urn        string           `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`               // the URN for this resource.
	Properties *structpb.Struct `protobuf:"bytes,2,opt,name=properties,proto3" json:"properties,omitempty"` // the state of the resource read from the live environment.
}

func (x *ReadResourceResponse) Reset() {
	*x = ReadResourceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadResourceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResourceResponse) ProtoMessage() {}

func (x *ReadResourceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResourceResponse.ProtoReflect.Descriptor instead.
func (*ReadResourceResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{3}
}

func (x *ReadResourceResponse) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *ReadResourceResponse) GetProperties() *structpb.Struct {
	if x != nil {
		return x.Properties
	}
	return nil
}

// RegisterResourceRequest contains information about a resource object that was newly allocated.
type RegisterResourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type                       string                                                   `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`                                                                                                                         // the type of the object allocated.
	Name                       string                                                   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`                                                                                                                         // the name, for URN purposes, of the object.
	Parent                     string                                                   `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`                                                                                                                     // an optional parent URN that this child resource belongs to.
	Custom                     bool                                                     `protobuf:"varint,4,opt,name=custom,proto3" json:"custom,omitempty"`                                                                                                                    // true if the resource is a custom, managed by a plugin's CRUD operations.
	Object                     *structpb.Struct                                         `protobuf:"bytes,5,opt,name=object,proto3" json:"object,omitempty"`                                                                                                                     // an object produced by the interpreter/source.
	Protect                    bool                                                     `protobuf:"varint,6,opt,name=protect,proto3" json:"protect,omitempty"`                                                                                                                  // true if the resource should be marked protected.
	Dependencies               []string                                                 `protobuf:"bytes,7,rep,name=dependencies,proto3" json:"dependencies,omitempty"`                                                                                                         // a list of URNs that this resource depends on, as observed by the language host.
	Provider                   string                                                   `protobuf:"bytes,8,opt,name=provider,proto3" json:"provider,omitempty"`                                                                                                                 // an optional reference to the provider to manage this resource's CRUD operations.
	PropertyDependencies       map[string]*RegisterResourceRequest_PropertyDependencies `protobuf:"bytes,9,rep,name=propertyDependencies,proto3" json:"propertyDependencies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // a map from property keys to the dependencies of the property.
	DeleteBeforeReplace        bool                                                     `protobuf:"varint,10,opt,name=deleteBeforeReplace,proto3" json:"deleteBeforeReplace,omitempty"`                                                                                         // true if this resource should be deleted before replacement.
	Version                    string                                                   `protobuf:"bytes,11,opt,name=version,proto3" json:"version,omitempty"`                                                                                                                  // the version of the provider to use when servicing this request.
	IgnoreChanges              []string                                                 `protobuf:"bytes,12,rep,name=ignoreChanges,proto3" json:"ignoreChanges,omitempty"`                                                                                                      // a list of property selectors to ignore during updates.
	AcceptSecrets              bool                                                     `protobuf:"varint,13,opt,name=acceptSecrets,proto3" json:"acceptSecrets,omitempty"`                                                                                                     // when true operations should return secrets as strongly typed.
	AdditionalSecretOutputs    []string                                                 `protobuf:"bytes,14,rep,name=additionalSecretOutputs,proto3" json:"additionalSecretOutputs,omitempty"`                                                                                  // a list of output properties that should also be treated as secret, in addition to ones we detect.
	AliasURNs                  []string                                                 `protobuf:"bytes,15,rep,name=aliasURNs,proto3" json:"aliasURNs,omitempty"`                                                                                                              // a list of additional URNs that should be considered the same.
	ImportId                   string                                                   `protobuf:"bytes,16,opt,name=importId,proto3" json:"importId,omitempty"`                                                                                                                // if set, this resource's state should be imported from the given ID.
	CustomTimeouts             *RegisterResourceRequest_CustomTimeouts                  `protobuf:"bytes,17,opt,name=customTimeouts,proto3" json:"customTimeouts,omitempty"`                                                                                                    // ability to pass a custom Timeout block.
	DeleteBeforeReplaceDefined bool                                                     `protobuf:"varint,18,opt,name=deleteBeforeReplaceDefined,proto3" json:"deleteBeforeReplaceDefined,omitempty"`                                                                           // true if the deleteBeforeReplace property should be treated as defined even if it is false.
	SupportsPartialValues      bool                                                     `protobuf:"varint,19,opt,name=supportsPartialValues,proto3" json:"supportsPartialValues,omitempty"`                                                                                     // true if the request is from an SDK that supports partially-known properties during preview.
	Remote                     bool                                                     `protobuf:"varint,20,opt,name=remote,proto3" json:"remote,omitempty"`                                                                                                                   // true if the resource is a plugin-managed component resource.
	AcceptResources            bool                                                     `protobuf:"varint,21,opt,name=acceptResources,proto3" json:"acceptResources,omitempty"`                                                                                                 // when true operations should return resource references as strongly typed.
	Providers                  map[string]string                                        `protobuf:"bytes,22,rep,name=providers,proto3" json:"providers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`                      // an optional reference to the provider map to manage this resource's CRUD operations.
	ReplaceOnChanges           []string                                                 `protobuf:"bytes,23,rep,name=replaceOnChanges,proto3" json:"replaceOnChanges,omitempty"`                                                                                                // a list of properties that if changed should force a replacement.
	PluginDownloadURL          string                                                   `protobuf:"bytes,24,opt,name=pluginDownloadURL,proto3" json:"pluginDownloadURL,omitempty"`                                                                                              // the server URL of the provider to use when servicing this request.
	RetainOnDelete             bool                                                     `protobuf:"varint,25,opt,name=retainOnDelete,proto3" json:"retainOnDelete,omitempty"`                                                                                                   // if true the engine will not call the resource providers delete method for this resource.
	Aliases                    []*Alias                                                 `protobuf:"bytes,26,rep,name=aliases,proto3" json:"aliases,omitempty"`                                                                                                                  // a list of additional aliases that should be considered the same.
	DeletedWith                string                                                   `protobuf:"bytes,27,opt,name=deletedWith,proto3" json:"deletedWith,omitempty"`                                                                                                          // if set the engine will not call the resource providers delete method for this resource when specified resource is deleted.
}

func (x *RegisterResourceRequest) Reset() {
	*x = RegisterResourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResourceRequest) ProtoMessage() {}

func (x *RegisterResourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResourceRequest.ProtoReflect.Descriptor instead.
func (*RegisterResourceRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{4}
}

func (x *RegisterResourceRequest) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *RegisterResourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RegisterResourceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *RegisterResourceRequest) GetCustom() bool {
	if x != nil {
		return x.Custom
	}
	return false
}

func (x *RegisterResourceRequest) GetObject() *structpb.Struct {
	if x != nil {
		return x.Object
	}
	return nil
}

func (x *RegisterResourceRequest) GetProtect() bool {
	if x != nil {
		return x.Protect
	}
	return false
}

func (x *RegisterResourceRequest) GetDependencies() []string {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

func (x *RegisterResourceRequest) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *RegisterResourceRequest) GetPropertyDependencies() map[string]*RegisterResourceRequest_PropertyDependencies {
	if x != nil {
		return x.PropertyDependencies
	}
	return nil
}

func (x *RegisterResourceRequest) GetDeleteBeforeReplace() bool {
	if x != nil {
		return x.DeleteBeforeReplace
	}
	return false
}

func (x *RegisterResourceRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *RegisterResourceRequest) GetIgnoreChanges() []string {
	if x != nil {
		return x.IgnoreChanges
	}
	return nil
}

func (x *RegisterResourceRequest) GetAcceptSecrets() bool {
	if x != nil {
		return x.AcceptSecrets
	}
	return false
}

func (x *RegisterResourceRequest) GetAdditionalSecretOutputs() []string {
	if x != nil {
		return x.AdditionalSecretOutputs
	}
	return nil
}

func (x *RegisterResourceRequest) GetAliasURNs() []string {
	if x != nil {
		return x.AliasURNs
	}
	return nil
}

func (x *RegisterResourceRequest) GetImportId() string {
	if x != nil {
		return x.ImportId
	}
	return ""
}

func (x *RegisterResourceRequest) GetCustomTimeouts() *RegisterResourceRequest_CustomTimeouts {
	if x != nil {
		return x.CustomTimeouts
	}
	return nil
}

func (x *RegisterResourceRequest) GetDeleteBeforeReplaceDefined() bool {
	if x != nil {
		return x.DeleteBeforeReplaceDefined
	}
	return false
}

func (x *RegisterResourceRequest) GetSupportsPartialValues() bool {
	if x != nil {
		return x.SupportsPartialValues
	}
	return false
}

func (x *RegisterResourceRequest) GetRemote() bool {
	if x != nil {
		return x.Remote
	}
	return false
}

func (x *RegisterResourceRequest) GetAcceptResources() bool {
	if x != nil {
		return x.AcceptResources
	}
	return false
}

func (x *RegisterResourceRequest) GetProviders() map[string]string {
	if x != nil {
		return x.Providers
	}
	return nil
}

func (x *RegisterResourceRequest) GetReplaceOnChanges() []string {
	if x != nil {
		return x.ReplaceOnChanges
	}
	return nil
}

func (x *RegisterResourceRequest) GetPluginDownloadURL() string {
	if x != nil {
		return x.PluginDownloadURL
	}
	return ""
}

func (x *RegisterResourceRequest) GetRetainOnDelete() bool {
	if x != nil {
		return x.RetainOnDelete
	}
	return false
}

func (x *RegisterResourceRequest) GetAliases() []*Alias {
	if x != nil {
		return x.Aliases
	}
	return nil
}

func (x *RegisterResourceRequest) GetDeletedWith() string {
	if x != nil {
		return x.DeletedWith
	}
	return ""
}

// RegisterResourceResponse is returned by the engine after a resource has finished being initialized.  It includes the
// auto-assigned URN, the provider-assigned ID, and any other properties initialized by the engine.
type RegisterResourceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Urn                  string                                                    `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`                                                                                                                           // the URN assigned by the engine.
	Id                   string                                                    `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`                                                                                                                             // the unique ID assigned by the provider.
	Object               *structpb.Struct                                          `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`                                                                                                                     // the resulting object properties, including provider defaults.
	Stable               bool                                                      `protobuf:"varint,4,opt,name=stable,proto3" json:"stable,omitempty"`                                                                                                                    // if true, the object's state is stable and may be trusted not to change.
	Stables              []string                                                  `protobuf:"bytes,5,rep,name=stables,proto3" json:"stables,omitempty"`                                                                                                                   // an optional list of guaranteed-stable properties.
	PropertyDependencies map[string]*RegisterResourceResponse_PropertyDependencies `protobuf:"bytes,6,rep,name=propertyDependencies,proto3" json:"propertyDependencies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // a map from property keys to the dependencies of the property.
}

func (x *RegisterResourceResponse) Reset() {
	*x = RegisterResourceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResourceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResourceResponse) ProtoMessage() {}

func (x *RegisterResourceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResourceResponse.ProtoReflect.Descriptor instead.
func (*RegisterResourceResponse) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{5}
}

func (x *RegisterResourceResponse) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *RegisterResourceResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *RegisterResourceResponse) GetObject() *structpb.Struct {
	if x != nil {
		return x.Object
	}
	return nil
}

func (x *RegisterResourceResponse) GetStable() bool {
	if x != nil {
		return x.Stable
	}
	return false
}

func (x *RegisterResourceResponse) GetStables() []string {
	if x != nil {
		return x.Stables
	}
	return nil
}

func (x *RegisterResourceResponse) GetPropertyDependencies() map[string]*RegisterResourceResponse_PropertyDependencies {
	if x != nil {
		return x.PropertyDependencies
	}
	return nil
}

// RegisterResourceOutputsRequest adds extra resource outputs created by the program after registration has occurred.
type RegisterResourceOutputsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Urn     string           `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`         // the URN for the resource to attach output properties to.
	Outputs *structpb.Struct `protobuf:"bytes,2,opt,name=outputs,proto3" json:"outputs,omitempty"` // additional output properties to add to the existing resource.
}

func (x *RegisterResourceOutputsRequest) Reset() {
	*x = RegisterResourceOutputsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResourceOutputsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResourceOutputsRequest) ProtoMessage() {}

func (x *RegisterResourceOutputsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResourceOutputsRequest.ProtoReflect.Descriptor instead.
func (*RegisterResourceOutputsRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{6}
}

func (x *RegisterResourceOutputsRequest) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *RegisterResourceOutputsRequest) GetOutputs() *structpb.Struct {
	if x != nil {
		return x.Outputs
	}
	return nil
}

type ResourceInvokeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Tok               string           `protobuf:"bytes,1,opt,name=tok,proto3" json:"tok,omitempty"`                             // the function token to invoke.
	Args              *structpb.Struct `protobuf:"bytes,2,opt,name=args,proto3" json:"args,omitempty"`                           // the arguments for the function invocation.
	Provider          string           `protobuf:"bytes,3,opt,name=provider,proto3" json:"provider,omitempty"`                   // an optional reference to the provider version to use for this invoke.
	Version           string           `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`                     // the version of the provider to use when servicing this request.
	AcceptResources   bool             `protobuf:"varint,5,opt,name=acceptResources,proto3" json:"acceptResources,omitempty"`    // when true operations should return resource references as strongly typed.
	PluginDownloadURL string           `protobuf:"bytes,6,opt,name=pluginDownloadURL,proto3" json:"pluginDownloadURL,omitempty"` // an optional reference to the provider url to use for this invoke.
}

func (x *ResourceInvokeRequest) Reset() {
	*x = ResourceInvokeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceInvokeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceInvokeRequest) ProtoMessage() {}

func (x *ResourceInvokeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceInvokeRequest.ProtoReflect.Descriptor instead.
func (*ResourceInvokeRequest) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{7}
}

func (x *ResourceInvokeRequest) GetTok() string {
	if x != nil {
		return x.Tok
	}
	return ""
}

func (x *ResourceInvokeRequest) GetArgs() *structpb.Struct {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *ResourceInvokeRequest) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *ResourceInvokeRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ResourceInvokeRequest) GetAcceptResources() bool {
	if x != nil {
		return x.AcceptResources
	}
	return false
}

func (x *ResourceInvokeRequest) GetPluginDownloadURL() string {
	if x != nil {
		return x.PluginDownloadURL
	}
	return ""
}

// PropertyDependencies describes the resources that a particular property depends on.
type RegisterResourceRequest_PropertyDependencies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Urns []string `protobuf:"bytes,1,rep,name=urns,proto3" json:"urns,omitempty"` // A list of URNs this property depends on.
}

func (x *RegisterResourceRequest_PropertyDependencies) Reset() {
	*x = RegisterResourceRequest_PropertyDependencies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResourceRequest_PropertyDependencies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResourceRequest_PropertyDependencies) ProtoMessage() {}

func (x *RegisterResourceRequest_PropertyDependencies) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResourceRequest_PropertyDependencies.ProtoReflect.Descriptor instead.
func (*RegisterResourceRequest_PropertyDependencies) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{4, 0}
}

func (x *RegisterResourceRequest_PropertyDependencies) GetUrns() []string {
	if x != nil {
		return x.Urns
	}
	return nil
}

// CustomTimeouts allows a user to be able to create a set of custom timeout parameters.
type RegisterResourceRequest_CustomTimeouts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Create string `protobuf:"bytes,1,opt,name=create,proto3" json:"create,omitempty"` // The create resource timeout represented as a string e.g. 5m.
	Update string `protobuf:"bytes,2,opt,name=update,proto3" json:"update,omitempty"` // The update resource timeout represented as a string e.g. 5m.
	Delete string `protobuf:"bytes,3,opt,name=delete,proto3" json:"delete,omitempty"` // The delete resource timeout represented as a string e.g. 5m.
}

func (x *RegisterResourceRequest_CustomTimeouts) Reset() {
	*x = RegisterResourceRequest_CustomTimeouts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResourceRequest_CustomTimeouts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResourceRequest_CustomTimeouts) ProtoMessage() {}

func (x *RegisterResourceRequest_CustomTimeouts) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResourceRequest_CustomTimeouts.ProtoReflect.Descriptor instead.
func (*RegisterResourceRequest_CustomTimeouts) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{4, 1}
}

func (x *RegisterResourceRequest_CustomTimeouts) GetCreate() string {
	if x != nil {
		return x.Create
	}
	return ""
}

func (x *RegisterResourceRequest_CustomTimeouts) GetUpdate() string {
	if x != nil {
		return x.Update
	}
	return ""
}

func (x *RegisterResourceRequest_CustomTimeouts) GetDelete() string {
	if x != nil {
		return x.Delete
	}
	return ""
}

// PropertyDependencies describes the resources that a particular property depends on.
type RegisterResourceResponse_PropertyDependencies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Urns []string `protobuf:"bytes,1,rep,name=urns,proto3" json:"urns,omitempty"` // A list of URNs this property depends on.
}

func (x *RegisterResourceResponse_PropertyDependencies) Reset() {
	*x = RegisterResourceResponse_PropertyDependencies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pulumi_resource_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterResourceResponse_PropertyDependencies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterResourceResponse_PropertyDependencies) ProtoMessage() {}

func (x *RegisterResourceResponse_PropertyDependencies) ProtoReflect() protoreflect.Message {
	mi := &file_pulumi_resource_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterResourceResponse_PropertyDependencies.ProtoReflect.Descriptor instead.
func (*RegisterResourceResponse_PropertyDependencies) Descriptor() ([]byte, []int) {
	return file_pulumi_resource_proto_rawDescGZIP(), []int{5, 0}
}

func (x *RegisterResourceResponse_PropertyDependencies) GetUrns() []string {
	if x != nil {
		return x.Urns
	}
	return nil
}

var File_pulumi_resource_proto protoreflect.FileDescriptor

var file_pulumi_resource_proto_rawDesc = []byte{
	0x0a, 0x15, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72,
	0x70, 0x63, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x70,
	0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x61, 0x6c, 0x69,
	0x61, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x28, 0x0a, 0x16, 0x53, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x22, 0x39, 0x0a, 0x17, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1e, 0x0a,
	0x0a, 0x68, 0x61, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x68, 0x61, 0x73, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x22, 0xbf, 0x03,
	0x0a, 0x13, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x22,
	0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0d, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x38,
	0x0a, 0x17, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x17, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x2c, 0x0a, 0x11, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x55, 0x52, 0x4c, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70,
	0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x52, 0x4c,
	0x4a, 0x04, 0x08, 0x0b, 0x10, 0x0c, 0x52, 0x07, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x22,
	0x61, 0x0a, 0x14, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x22, 0xf5, 0x0b, 0x0a, 0x17, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x12, 0x2f, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x74, 0x65,
	0x63, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63,
	0x74, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x12, 0x70, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x24, 0x0a, 0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x63,
	0x63, 0x65, 0x70, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x38, 0x0a, 0x17, 0x61,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x52, 0x17, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x55, 0x52,
	0x4e, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x55,
	0x52, 0x4e, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x12,
	0x59, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x1a, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x12, 0x34, 0x0a, 0x15, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x4f, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70,
	0x63, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x2a, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4f, 0x6e,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x72,
	0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x4f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12,
	0x2c, 0x0a, 0x11, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x55, 0x52, 0x4c, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x52, 0x4c, 0x12, 0x26, 0x0a,
	0x0e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x4f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18,
	0x19, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x4f, 0x6e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x07, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73,
	0x18, 0x1a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72,
	0x70, 0x63, 0x2e, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x52, 0x07, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65,
	0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x57, 0x69, 0x74, 0x68,
	0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x57,
	0x69, 0x74, 0x68, 0x1a, 0x2a, 0x0a, 0x14, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75,
	0x72, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x6e, 0x73, 0x1a,
	0x58, 0x0a, 0x0e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x73, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x1a, 0x80, 0x01, 0x0a, 0x19, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4d, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d,
	0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3c, 0x0a, 0x0e,
	0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc2, 0x03, 0x0a, 0x18, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x2f, 0x0a, 0x06, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x73, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x07, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x14,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x70, 0x75, 0x6c,
	0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x1a,
	0x2a, 0x0a, 0x14, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x72, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x6e, 0x73, 0x1a, 0x81, 0x01, 0x0a, 0x19,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4e, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x70, 0x75, 0x6c,
	0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x69, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x65, 0x0a, 0x1e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x6e, 0x12, 0x31, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x22, 0xe4, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x10, 0x0a, 0x03, 0x74, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x74,
	0x6f, 0x6b, 0x12, 0x2b, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x04, 0x61, 0x72, 0x67, 0x73, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x2c, 0x0a, 0x11, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x55, 0x52, 0x4c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x52, 0x4c, 0x32, 0xd4, 0x04,
	0x0a, 0x0f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x12, 0x5a, 0x0a, 0x0f, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x12, 0x21, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x47, 0x0a,
	0x06, 0x49, 0x6e, 0x76, 0x6f, 0x6b, 0x65, 0x12, 0x20, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x76, 0x6f,
	0x6b, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x75,
	0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4f, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x49, 0x6e, 0x76, 0x6f, 0x6b, 0x65, 0x12, 0x20, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72,
	0x70, 0x63, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x6b,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d,
	0x69, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6e, 0x76, 0x6f, 0x6b, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x39, 0x0a, 0x04, 0x43, 0x61, 0x6c, 0x6c, 0x12,
	0x16, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x17, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x72, 0x70, 0x63, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x51, 0x0a, 0x0c, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x1e, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52,
	0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52,
	0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5d, 0x0a, 0x10, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x22, 0x2e, 0x70, 0x75, 0x6c, 0x75,
	0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e,
	0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x5e, 0x0a, 0x17, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12,
	0x29, 0x2e, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x00, 0x42, 0x34, 0x5a, 0x32, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x2f, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x3b, 0x70, 0x75, 0x6c, 0x75, 0x6d, 0x69, 0x72, 0x70, 0x63, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_pulumi_resource_proto_rawDescOnce sync.Once
	file_pulumi_resource_proto_rawDescData = file_pulumi_resource_proto_rawDesc
)

func file_pulumi_resource_proto_rawDescGZIP() []byte {
	file_pulumi_resource_proto_rawDescOnce.Do(func() {
		file_pulumi_resource_proto_rawDescData = protoimpl.X.CompressGZIP(file_pulumi_resource_proto_rawDescData)
	})
	return file_pulumi_resource_proto_rawDescData
}

var file_pulumi_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_pulumi_resource_proto_goTypes = []interface{}{
	(*SupportsFeatureRequest)(nil),                       // 0: pulumirpc.SupportsFeatureRequest
	(*SupportsFeatureResponse)(nil),                      // 1: pulumirpc.SupportsFeatureResponse
	(*ReadResourceRequest)(nil),                          // 2: pulumirpc.ReadResourceRequest
	(*ReadResourceResponse)(nil),                         // 3: pulumirpc.ReadResourceResponse
	(*RegisterResourceRequest)(nil),                      // 4: pulumirpc.RegisterResourceRequest
	(*RegisterResourceResponse)(nil),                     // 5: pulumirpc.RegisterResourceResponse
	(*RegisterResourceOutputsRequest)(nil),               // 6: pulumirpc.RegisterResourceOutputsRequest
	(*ResourceInvokeRequest)(nil),                        // 7: pulumirpc.ResourceInvokeRequest
	(*RegisterResourceRequest_PropertyDependencies)(nil), // 8: pulumirpc.RegisterResourceRequest.PropertyDependencies
	(*RegisterResourceRequest_CustomTimeouts)(nil),       // 9: pulumirpc.RegisterResourceRequest.CustomTimeouts
	nil, // 10: pulumirpc.RegisterResourceRequest.PropertyDependenciesEntry
	nil, // 11: pulumirpc.RegisterResourceRequest.ProvidersEntry
	(*RegisterResourceResponse_PropertyDependencies)(nil), // 12: pulumirpc.RegisterResourceResponse.PropertyDependencies
	nil,                     // 13: pulumirpc.RegisterResourceResponse.PropertyDependenciesEntry
	(*structpb.Struct)(nil), // 14: google.protobuf.Struct
	(*Alias)(nil),           // 15: pulumirpc.Alias
	(*CallRequest)(nil),     // 16: pulumirpc.CallRequest
	(*InvokeResponse)(nil),  // 17: pulumirpc.InvokeResponse
	(*CallResponse)(nil),    // 18: pulumirpc.CallResponse
	(*emptypb.Empty)(nil),   // 19: google.protobuf.Empty
}
var file_pulumi_resource_proto_depIdxs = []int32{
	14, // 0: pulumirpc.ReadResourceRequest.properties:type_name -> google.protobuf.Struct
	14, // 1: pulumirpc.ReadResourceResponse.properties:type_name -> google.protobuf.Struct
	14, // 2: pulumirpc.RegisterResourceRequest.object:type_name -> google.protobuf.Struct
	10, // 3: pulumirpc.RegisterResourceRequest.propertyDependencies:type_name -> pulumirpc.RegisterResourceRequest.PropertyDependenciesEntry
	9,  // 4: pulumirpc.RegisterResourceRequest.customTimeouts:type_name -> pulumirpc.RegisterResourceRequest.CustomTimeouts
	11, // 5: pulumirpc.RegisterResourceRequest.providers:type_name -> pulumirpc.RegisterResourceRequest.ProvidersEntry
	15, // 6: pulumirpc.RegisterResourceRequest.aliases:type_name -> pulumirpc.Alias
	14, // 7: pulumirpc.RegisterResourceResponse.object:type_name -> google.protobuf.Struct
	13, // 8: pulumirpc.RegisterResourceResponse.propertyDependencies:type_name -> pulumirpc.RegisterResourceResponse.PropertyDependenciesEntry
	14, // 9: pulumirpc.RegisterResourceOutputsRequest.outputs:type_name -> google.protobuf.Struct
	14, // 10: pulumirpc.ResourceInvokeRequest.args:type_name -> google.protobuf.Struct
	8,  // 11: pulumirpc.RegisterResourceRequest.PropertyDependenciesEntry.value:type_name -> pulumirpc.RegisterResourceRequest.PropertyDependencies
	12, // 12: pulumirpc.RegisterResourceResponse.PropertyDependenciesEntry.value:type_name -> pulumirpc.RegisterResourceResponse.PropertyDependencies
	0,  // 13: pulumirpc.ResourceMonitor.SupportsFeature:input_type -> pulumirpc.SupportsFeatureRequest
	7,  // 14: pulumirpc.ResourceMonitor.Invoke:input_type -> pulumirpc.ResourceInvokeRequest
	7,  // 15: pulumirpc.ResourceMonitor.StreamInvoke:input_type -> pulumirpc.ResourceInvokeRequest
	16, // 16: pulumirpc.ResourceMonitor.Call:input_type -> pulumirpc.CallRequest
	2,  // 17: pulumirpc.ResourceMonitor.ReadResource:input_type -> pulumirpc.ReadResourceRequest
	4,  // 18: pulumirpc.ResourceMonitor.RegisterResource:input_type -> pulumirpc.RegisterResourceRequest
	6,  // 19: pulumirpc.ResourceMonitor.RegisterResourceOutputs:input_type -> pulumirpc.RegisterResourceOutputsRequest
	1,  // 20: pulumirpc.ResourceMonitor.SupportsFeature:output_type -> pulumirpc.SupportsFeatureResponse
	17, // 21: pulumirpc.ResourceMonitor.Invoke:output_type -> pulumirpc.InvokeResponse
	17, // 22: pulumirpc.ResourceMonitor.StreamInvoke:output_type -> pulumirpc.InvokeResponse
	18, // 23: pulumirpc.ResourceMonitor.Call:output_type -> pulumirpc.CallResponse
	3,  // 24: pulumirpc.ResourceMonitor.ReadResource:output_type -> pulumirpc.ReadResourceResponse
	5,  // 25: pulumirpc.ResourceMonitor.RegisterResource:output_type -> pulumirpc.RegisterResourceResponse
	19, // 26: pulumirpc.ResourceMonitor.RegisterResourceOutputs:output_type -> google.protobuf.Empty
	20, // [20:27] is the sub-list for method output_type
	13, // [13:20] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_pulumi_resource_proto_init() }
func file_pulumi_resource_proto_init() {
	if File_pulumi_resource_proto != nil {
		return
	}
	file_pulumi_provider_proto_init()
	file_pulumi_alias_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_pulumi_resource_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportsFeatureRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupportsFeatureResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadResourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadResourceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResourceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResourceOutputsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceInvokeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResourceRequest_PropertyDependencies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResourceRequest_CustomTimeouts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pulumi_resource_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterResourceResponse_PropertyDependencies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pulumi_resource_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pulumi_resource_proto_goTypes,
		DependencyIndexes: file_pulumi_resource_proto_depIdxs,
		MessageInfos:      file_pulumi_resource_proto_msgTypes,
	}.Build()
	File_pulumi_resource_proto = out.File
	file_pulumi_resource_proto_rawDesc = nil
	file_pulumi_resource_proto_goTypes = nil
	file_pulumi_resource_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ResourceMonitorClient is the client API for ResourceMonitor service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResourceMonitorClient interface {
	SupportsFeature(ctx context.Context, in *SupportsFeatureRequest, opts ...grpc.CallOption) (*SupportsFeatureResponse, error)
	Invoke(ctx context.Context, in *ResourceInvokeRequest, opts ...grpc.CallOption) (*InvokeResponse, error)
	StreamInvoke(ctx context.Context, in *ResourceInvokeRequest, opts ...grpc.CallOption) (ResourceMonitor_StreamInvokeClient, error)
	Call(ctx context.Context, in *CallRequest, opts ...grpc.CallOption) (*CallResponse, error)
	ReadResource(ctx context.Context, in *ReadResourceRequest, opts ...grpc.CallOption) (*ReadResourceResponse, error)
	RegisterResource(ctx context.Context, in *RegisterResourceRequest, opts ...grpc.CallOption) (*RegisterResourceResponse, error)
	RegisterResourceOutputs(ctx context.Context, in *RegisterResourceOutputsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type resourceMonitorClient struct {
	cc grpc.ClientConnInterface
}

func NewResourceMonitorClient(cc grpc.ClientConnInterface) ResourceMonitorClient {
	return &resourceMonitorClient{cc}
}

func (c *resourceMonitorClient) SupportsFeature(ctx context.Context, in *SupportsFeatureRequest, opts ...grpc.CallOption) (*SupportsFeatureResponse, error) {
	out := new(SupportsFeatureResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.ResourceMonitor/SupportsFeature", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceMonitorClient) Invoke(ctx context.Context, in *ResourceInvokeRequest, opts ...grpc.CallOption) (*InvokeResponse, error) {
	out := new(InvokeResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.ResourceMonitor/Invoke", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceMonitorClient) StreamInvoke(ctx context.Context, in *ResourceInvokeRequest, opts ...grpc.CallOption) (ResourceMonitor_StreamInvokeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ResourceMonitor_serviceDesc.Streams[0], "/pulumirpc.ResourceMonitor/StreamInvoke", opts...)
	if err != nil {
		return nil, err
	}
	x := &resourceMonitorStreamInvokeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ResourceMonitor_StreamInvokeClient interface {
	Recv() (*InvokeResponse, error)
	grpc.ClientStream
}

type resourceMonitorStreamInvokeClient struct {
	grpc.ClientStream
}

func (x *resourceMonitorStreamInvokeClient) Recv() (*InvokeResponse, error) {
	m := new(InvokeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *resourceMonitorClient) Call(ctx context.Context, in *CallRequest, opts ...grpc.CallOption) (*CallResponse, error) {
	out := new(CallResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.ResourceMonitor/Call", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceMonitorClient) ReadResource(ctx context.Context, in *ReadResourceRequest, opts ...grpc.CallOption) (*ReadResourceResponse, error) {
	out := new(ReadResourceResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.ResourceMonitor/ReadResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceMonitorClient) RegisterResource(ctx context.Context, in *RegisterResourceRequest, opts ...grpc.CallOption) (*RegisterResourceResponse, error) {
	out := new(RegisterResourceResponse)
	err := c.cc.Invoke(ctx, "/pulumirpc.ResourceMonitor/RegisterResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceMonitorClient) RegisterResourceOutputs(ctx context.Context, in *RegisterResourceOutputsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/pulumirpc.ResourceMonitor/RegisterResourceOutputs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResourceMonitorServer is the server API for ResourceMonitor service.
type ResourceMonitorServer interface {
	SupportsFeature(context.Context, *SupportsFeatureRequest) (*SupportsFeatureResponse, error)
	Invoke(context.Context, *ResourceInvokeRequest) (*InvokeResponse, error)
	StreamInvoke(*ResourceInvokeRequest, ResourceMonitor_StreamInvokeServer) error
	Call(context.Context, *CallRequest) (*CallResponse, error)
	ReadResource(context.Context, *ReadResourceRequest) (*ReadResourceResponse, error)
	RegisterResource(context.Context, *RegisterResourceRequest) (*RegisterResourceResponse, error)
	RegisterResourceOutputs(context.Context, *RegisterResourceOutputsRequest) (*emptypb.Empty, error)
}

// UnimplementedResourceMonitorServer can be embedded to have forward compatible implementations.
type UnimplementedResourceMonitorServer struct {
}

func (*UnimplementedResourceMonitorServer) SupportsFeature(context.Context, *SupportsFeatureRequest) (*SupportsFeatureResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SupportsFeature not implemented")
}
func (*UnimplementedResourceMonitorServer) Invoke(context.Context, *ResourceInvokeRequest) (*InvokeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Invoke not implemented")
}
func (*UnimplementedResourceMonitorServer) StreamInvoke(*ResourceInvokeRequest, ResourceMonitor_StreamInvokeServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamInvoke not implemented")
}
func (*UnimplementedResourceMonitorServer) Call(context.Context, *CallRequest) (*CallResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Call not implemented")
}
func (*UnimplementedResourceMonitorServer) ReadResource(context.Context, *ReadResourceRequest) (*ReadResourceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadResource not implemented")
}
func (*UnimplementedResourceMonitorServer) RegisterResource(context.Context, *RegisterResourceRequest) (*RegisterResourceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterResource not implemented")
}
func (*UnimplementedResourceMonitorServer) RegisterResourceOutputs(context.Context, *RegisterResourceOutputsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterResourceOutputs not implemented")
}

func RegisterResourceMonitorServer(s *grpc.Server, srv ResourceMonitorServer) {
	s.RegisterService(&_ResourceMonitor_serviceDesc, srv)
}

func _ResourceMonitor_SupportsFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SupportsFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceMonitorServer).SupportsFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.ResourceMonitor/SupportsFeature",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceMonitorServer).SupportsFeature(ctx, req.(*SupportsFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceMonitor_Invoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResourceInvokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceMonitorServer).Invoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.ResourceMonitor/Invoke",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceMonitorServer).Invoke(ctx, req.(*ResourceInvokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceMonitor_StreamInvoke_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ResourceInvokeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ResourceMonitorServer).StreamInvoke(m, &resourceMonitorStreamInvokeServer{stream})
}

type ResourceMonitor_StreamInvokeServer interface {
	Send(*InvokeResponse) error
	grpc.ServerStream
}

type resourceMonitorStreamInvokeServer struct {
	grpc.ServerStream
}

func (x *resourceMonitorStreamInvokeServer) Send(m *InvokeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ResourceMonitor_Call_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceMonitorServer).Call(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.ResourceMonitor/Call",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceMonitorServer).Call(ctx, req.(*CallRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceMonitor_ReadResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceMonitorServer).ReadResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.ResourceMonitor/ReadResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceMonitorServer).ReadResource(ctx, req.(*ReadResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceMonitor_RegisterResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceMonitorServer).RegisterResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.ResourceMonitor/RegisterResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceMonitorServer).RegisterResource(ctx, req.(*RegisterResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceMonitor_RegisterResourceOutputs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterResourceOutputsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceMonitorServer).RegisterResourceOutputs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pulumirpc.ResourceMonitor/RegisterResourceOutputs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceMonitorServer).RegisterResourceOutputs(ctx, req.(*RegisterResourceOutputsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResourceMonitor_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pulumirpc.ResourceMonitor",
	HandlerType: (*ResourceMonitorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SupportsFeature",
			Handler:    _ResourceMonitor_SupportsFeature_Handler,
		},
		{
			MethodName: "Invoke",
			Handler:    _ResourceMonitor_Invoke_Handler,
		},
		{
			MethodName: "Call",
			Handler:    _ResourceMonitor_Call_Handler,
		},
		{
			MethodName: "ReadResource",
			Handler:    _ResourceMonitor_ReadResource_Handler,
		},
		{
			MethodName: "RegisterResource",
			Handler:    _ResourceMonitor_RegisterResource_Handler,
		},
		{
			MethodName: "RegisterResourceOutputs",
			Handler:    _ResourceMonitor_RegisterResourceOutputs_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamInvoke",
			Handler:       _ResourceMonitor_StreamInvoke_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "pulumi/resource.proto",
}
