"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2016-2018, Pulumi Corporation.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import abc
import google.protobuf.empty_pb2
import grpc
import grpc.aio
import typing
import pulumi.analyzer_pb2
import pulumi.plugin_pb2

class AnalyzerStub:
    """Analyzer provides a pluggable interface for checking resource definitions against some number of
    resource policies. It is intentionally open-ended, allowing for implementations that check
    everything from raw resource definitions to entire projects/stacks/snapshots for arbitrary
    issues -- style, policy, correctness, security, and so on.
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    Analyze: grpc.UnaryUnaryMultiCallable[
        pulumi.analyzer_pb2.AnalyzeRequest,
        pulumi.analyzer_pb2.AnalyzeResponse,
    ]
    """Analyze analyzes a single resource object, and returns any errors that it finds.
    Called with the "inputs" to the resource, before it is updated.
    """
    AnalyzeStack: grpc.UnaryUnaryMultiCallable[
        pulumi.analyzer_pb2.AnalyzeStackRequest,
        pulumi.analyzer_pb2.AnalyzeResponse,
    ]
    """AnalyzeStack analyzes all resources within a stack, at the end of a successful
    preview or update. The provided resources are the "outputs", after any mutations
    have taken place.
    """
    GetAnalyzerInfo: grpc.UnaryUnaryMultiCallable[
        google.protobuf.empty_pb2.Empty,
        pulumi.analyzer_pb2.AnalyzerInfo,
    ]
    """GetAnalyzerInfo returns metadata about the analyzer (e.g., list of policies contained)."""
    GetPluginInfo: grpc.UnaryUnaryMultiCallable[
        google.protobuf.empty_pb2.Empty,
        pulumi.plugin_pb2.PluginInfo,
    ]
    """GetPluginInfo returns generic information about this plugin, like its version."""
    Configure: grpc.UnaryUnaryMultiCallable[
        pulumi.analyzer_pb2.ConfigureAnalyzerRequest,
        google.protobuf.empty_pb2.Empty,
    ]
    """Configure configures the analyzer, passing configuration properties for each policy."""

class AnalyzerServicer(metaclass=abc.ABCMeta):
    """Analyzer provides a pluggable interface for checking resource definitions against some number of
    resource policies. It is intentionally open-ended, allowing for implementations that check
    everything from raw resource definitions to entire projects/stacks/snapshots for arbitrary
    issues -- style, policy, correctness, security, and so on.
    """

    
    def Analyze(
        self,
        request: pulumi.analyzer_pb2.AnalyzeRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.analyzer_pb2.AnalyzeResponse:
        """Analyze analyzes a single resource object, and returns any errors that it finds.
        Called with the "inputs" to the resource, before it is updated.
        """
    
    def AnalyzeStack(
        self,
        request: pulumi.analyzer_pb2.AnalyzeStackRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.analyzer_pb2.AnalyzeResponse:
        """AnalyzeStack analyzes all resources within a stack, at the end of a successful
        preview or update. The provided resources are the "outputs", after any mutations
        have taken place.
        """
    
    def GetAnalyzerInfo(
        self,
        request: google.protobuf.empty_pb2.Empty,
        context: grpc.ServicerContext,
    ) -> pulumi.analyzer_pb2.AnalyzerInfo:
        """GetAnalyzerInfo returns metadata about the analyzer (e.g., list of policies contained)."""
    
    def GetPluginInfo(
        self,
        request: google.protobuf.empty_pb2.Empty,
        context: grpc.ServicerContext,
    ) -> pulumi.plugin_pb2.PluginInfo:
        """GetPluginInfo returns generic information about this plugin, like its version."""
    
    def Configure(
        self,
        request: pulumi.analyzer_pb2.ConfigureAnalyzerRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Configure configures the analyzer, passing configuration properties for each policy."""

def add_AnalyzerServicer_to_server(servicer: AnalyzerServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
