"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2016-2018, Pulumi Corporation.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import abc
import google.protobuf.empty_pb2
import grpc
import grpc.aio
import typing
import pulumi.engine_pb2

class EngineStub:
    """Engine is an auxiliary service offered to language and resource provider plugins. Its main purpose today is
    to serve as a common logging endpoint, but it also serves as a state storage mechanism for language hosts
    that can't store their own global state.
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    Log: grpc.UnaryUnaryMultiCallable[
        pulumi.engine_pb2.LogRequest,
        google.protobuf.empty_pb2.Empty,
    ]
    """Log logs a global message in the engine, including errors and warnings."""
    GetRootResource: grpc.UnaryUnaryMultiCallable[
        pulumi.engine_pb2.GetRootResourceRequest,
        pulumi.engine_pb2.GetRootResourceResponse,
    ]
    """GetRootResource gets the URN of the root resource, the resource that should be the root of all
    otherwise-unparented resources.
    """
    SetRootResource: grpc.UnaryUnaryMultiCallable[
        pulumi.engine_pb2.SetRootResourceRequest,
        pulumi.engine_pb2.SetRootResourceResponse,
    ]
    """SetRootResource sets the URN of the root resource."""

class EngineServicer(metaclass=abc.ABCMeta):
    """Engine is an auxiliary service offered to language and resource provider plugins. Its main purpose today is
    to serve as a common logging endpoint, but it also serves as a state storage mechanism for language hosts
    that can't store their own global state.
    """

    
    def Log(
        self,
        request: pulumi.engine_pb2.LogRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Log logs a global message in the engine, including errors and warnings."""
    
    def GetRootResource(
        self,
        request: pulumi.engine_pb2.GetRootResourceRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.engine_pb2.GetRootResourceResponse:
        """GetRootResource gets the URN of the root resource, the resource that should be the root of all
        otherwise-unparented resources.
        """
    
    def SetRootResource(
        self,
        request: pulumi.engine_pb2.SetRootResourceRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.engine_pb2.SetRootResourceResponse:
        """SetRootResource sets the URN of the root resource."""

def add_EngineServicer_to_server(servicer: EngineServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
