"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2016-2018, Pulumi Corporation.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class GetSchemaRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    version: builtins.int
    """the schema version."""
    def __init__(
        self,
        *,
        version: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["version", b"version"]) -> None: ...

global___GetSchemaRequest = GetSchemaRequest

@typing_extensions.final
class GetSchemaResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SCHEMA_FIELD_NUMBER: builtins.int
    schema: builtins.str
    """the JSON-encoded schema."""
    def __init__(
        self,
        *,
        schema: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["schema", b"schema"]) -> None: ...

global___GetSchemaResponse = GetSchemaResponse

@typing_extensions.final
class ConfigureRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class VariablesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    VARIABLES_FIELD_NUMBER: builtins.int
    ARGS_FIELD_NUMBER: builtins.int
    ACCEPTSECRETS_FIELD_NUMBER: builtins.int
    ACCEPTRESOURCES_FIELD_NUMBER: builtins.int
    @property
    def variables(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """a map of configuration keys to values."""
    @property
    def args(self) -> google.protobuf.struct_pb2.Struct:
        """the input properties for the provider. Only filled in for newer providers."""
    acceptSecrets: builtins.bool
    """when true, operations should return secrets as strongly typed."""
    acceptResources: builtins.bool
    """when true, operations should return resources as strongly typed values to the provider."""
    def __init__(
        self,
        *,
        variables: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        args: google.protobuf.struct_pb2.Struct | None = ...,
        acceptSecrets: builtins.bool = ...,
        acceptResources: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["args", b"args"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["acceptResources", b"acceptResources", "acceptSecrets", b"acceptSecrets", "args", b"args", "variables", b"variables"]) -> None: ...

global___ConfigureRequest = ConfigureRequest

@typing_extensions.final
class ConfigureResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACCEPTSECRETS_FIELD_NUMBER: builtins.int
    SUPPORTSPREVIEW_FIELD_NUMBER: builtins.int
    ACCEPTRESOURCES_FIELD_NUMBER: builtins.int
    ACCEPTOUTPUTS_FIELD_NUMBER: builtins.int
    acceptSecrets: builtins.bool
    """when true, the engine should pass secrets as strongly typed values to the provider."""
    supportsPreview: builtins.bool
    """when true, the engine should invoke create and update with preview=true during previews."""
    acceptResources: builtins.bool
    """when true, the engine should pass resources as strongly typed values to the provider."""
    acceptOutputs: builtins.bool
    """when true, the engine should pass output values to the provider."""
    def __init__(
        self,
        *,
        acceptSecrets: builtins.bool = ...,
        supportsPreview: builtins.bool = ...,
        acceptResources: builtins.bool = ...,
        acceptOutputs: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["acceptOutputs", b"acceptOutputs", "acceptResources", b"acceptResources", "acceptSecrets", b"acceptSecrets", "supportsPreview", b"supportsPreview"]) -> None: ...

global___ConfigureResponse = ConfigureResponse

@typing_extensions.final
class ConfigureErrorMissingKeys(google.protobuf.message.Message):
    """ConfigureErrorMissingKeys is sent as a Detail on an error returned from `ResourceProvider.Configure`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class MissingKey(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        DESCRIPTION_FIELD_NUMBER: builtins.int
        name: builtins.str
        """the Pulumi name (not the provider name!) of the missing config key."""
        description: builtins.str
        """a description of the missing config key, as reported by the provider."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            description: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "name", b"name"]) -> None: ...

    MISSINGKEYS_FIELD_NUMBER: builtins.int
    @property
    def missingKeys(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConfigureErrorMissingKeys.MissingKey]:
        """a list of required configuration keys that were not supplied."""
    def __init__(
        self,
        *,
        missingKeys: collections.abc.Iterable[global___ConfigureErrorMissingKeys.MissingKey] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["missingKeys", b"missingKeys"]) -> None: ...

global___ConfigureErrorMissingKeys = ConfigureErrorMissingKeys

@typing_extensions.final
class InvokeRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOK_FIELD_NUMBER: builtins.int
    ARGS_FIELD_NUMBER: builtins.int
    tok: builtins.str
    """the function token to invoke."""
    @property
    def args(self) -> google.protobuf.struct_pb2.Struct:
        """the arguments for the function invocation."""
    def __init__(
        self,
        *,
        tok: builtins.str = ...,
        args: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["args", b"args"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["args", b"args", "tok", b"tok"]) -> None: ...

global___InvokeRequest = InvokeRequest

@typing_extensions.final
class InvokeResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RETURN_FIELD_NUMBER: builtins.int
    FAILURES_FIELD_NUMBER: builtins.int
    @property
    def failures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CheckFailure]:
        """the failures if any arguments didn't pass verification."""
    def __init__(
        self,
        *,
        failures: collections.abc.Iterable[global___CheckFailure] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["return", b"return"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["failures", b"failures", "return", b"return"]) -> None: ...

global___InvokeResponse = InvokeResponse

@typing_extensions.final
class CallRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ArgumentDependencies(google.protobuf.message.Message):
        """ArgumentDependencies describes the resources that a particular argument depends on."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URNS_FIELD_NUMBER: builtins.int
        @property
        def urns(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """A list of URNs this argument depends on."""
        def __init__(
            self,
            *,
            urns: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["urns", b"urns"]) -> None: ...

    @typing_extensions.final
    class ArgDependenciesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___CallRequest.ArgumentDependencies: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___CallRequest.ArgumentDependencies | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class ConfigEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    TOK_FIELD_NUMBER: builtins.int
    ARGS_FIELD_NUMBER: builtins.int
    ARGDEPENDENCIES_FIELD_NUMBER: builtins.int
    PROVIDER_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    PLUGINDOWNLOADURL_FIELD_NUMBER: builtins.int
    PROJECT_FIELD_NUMBER: builtins.int
    STACK_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    CONFIGSECRETKEYS_FIELD_NUMBER: builtins.int
    DRYRUN_FIELD_NUMBER: builtins.int
    PARALLEL_FIELD_NUMBER: builtins.int
    MONITORENDPOINT_FIELD_NUMBER: builtins.int
    ORGANIZATION_FIELD_NUMBER: builtins.int
    tok: builtins.str
    """the function token to invoke."""
    @property
    def args(self) -> google.protobuf.struct_pb2.Struct:
        """the arguments for the function invocation."""
    @property
    def argDependencies(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___CallRequest.ArgumentDependencies]:
        """a map from argument keys to the dependencies of the argument."""
    provider: builtins.str
    """an optional reference to the provider to use for this invoke."""
    version: builtins.str
    """the version of the provider to use when servicing this request."""
    pluginDownloadURL: builtins.str
    """the pluginDownloadURL of the provider to use when servicing this request."""
    project: builtins.str
    """the project name."""
    stack: builtins.str
    """the name of the stack being deployed into."""
    @property
    def config(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """the configuration variables to apply before running."""
    @property
    def configSecretKeys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the configuration keys that have secret values."""
    dryRun: builtins.bool
    """true if we're only doing a dryrun (preview)."""
    parallel: builtins.int
    """the degree of parallelism for resource operations (<=1 for serial)."""
    monitorEndpoint: builtins.str
    """the address for communicating back to the resource monitor."""
    organization: builtins.str
    """the organization of the stack being deployed into."""
    def __init__(
        self,
        *,
        tok: builtins.str = ...,
        args: google.protobuf.struct_pb2.Struct | None = ...,
        argDependencies: collections.abc.Mapping[builtins.str, global___CallRequest.ArgumentDependencies] | None = ...,
        provider: builtins.str = ...,
        version: builtins.str = ...,
        pluginDownloadURL: builtins.str = ...,
        project: builtins.str = ...,
        stack: builtins.str = ...,
        config: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        configSecretKeys: collections.abc.Iterable[builtins.str] | None = ...,
        dryRun: builtins.bool = ...,
        parallel: builtins.int = ...,
        monitorEndpoint: builtins.str = ...,
        organization: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["args", b"args"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["argDependencies", b"argDependencies", "args", b"args", "config", b"config", "configSecretKeys", b"configSecretKeys", "dryRun", b"dryRun", "monitorEndpoint", b"monitorEndpoint", "organization", b"organization", "parallel", b"parallel", "pluginDownloadURL", b"pluginDownloadURL", "project", b"project", "provider", b"provider", "stack", b"stack", "tok", b"tok", "version", b"version"]) -> None: ...

global___CallRequest = CallRequest

@typing_extensions.final
class CallResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ReturnDependencies(google.protobuf.message.Message):
        """ReturnDependencies describes the resources that a particular return value depends on."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URNS_FIELD_NUMBER: builtins.int
        @property
        def urns(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """A list of URNs this return value depends on."""
        def __init__(
            self,
            *,
            urns: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["urns", b"urns"]) -> None: ...

    @typing_extensions.final
    class ReturnDependenciesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___CallResponse.ReturnDependencies: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___CallResponse.ReturnDependencies | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    RETURN_FIELD_NUMBER: builtins.int
    RETURNDEPENDENCIES_FIELD_NUMBER: builtins.int
    FAILURES_FIELD_NUMBER: builtins.int
    @property
    def returnDependencies(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___CallResponse.ReturnDependencies]:
        """a map from return value keys to the dependencies of the return value."""
    @property
    def failures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CheckFailure]:
        """the failures if any arguments didn't pass verification."""
    def __init__(
        self,
        *,
        returnDependencies: collections.abc.Mapping[builtins.str, global___CallResponse.ReturnDependencies] | None = ...,
        failures: collections.abc.Iterable[global___CheckFailure] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["return", b"return"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["failures", b"failures", "return", b"return", "returnDependencies", b"returnDependencies"]) -> None: ...

global___CallResponse = CallResponse

@typing_extensions.final
class CheckRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URN_FIELD_NUMBER: builtins.int
    OLDS_FIELD_NUMBER: builtins.int
    NEWS_FIELD_NUMBER: builtins.int
    RANDOMSEED_FIELD_NUMBER: builtins.int
    urn: builtins.str
    """the Pulumi URN for this resource."""
    @property
    def olds(self) -> google.protobuf.struct_pb2.Struct:
        """the old Pulumi inputs for this resource, if any."""
    @property
    def news(self) -> google.protobuf.struct_pb2.Struct:
        """the new Pulumi inputs for this resource."""
    randomSeed: builtins.bytes
    """a deterministically random hash, primarily intended for global unique naming."""
    def __init__(
        self,
        *,
        urn: builtins.str = ...,
        olds: google.protobuf.struct_pb2.Struct | None = ...,
        news: google.protobuf.struct_pb2.Struct | None = ...,
        randomSeed: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["news", b"news", "olds", b"olds"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["news", b"news", "olds", b"olds", "randomSeed", b"randomSeed", "urn", b"urn"]) -> None: ...

global___CheckRequest = CheckRequest

@typing_extensions.final
class CheckResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INPUTS_FIELD_NUMBER: builtins.int
    FAILURES_FIELD_NUMBER: builtins.int
    @property
    def inputs(self) -> google.protobuf.struct_pb2.Struct:
        """the provider inputs for this resource."""
    @property
    def failures(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CheckFailure]:
        """any validation failures that occurred."""
    def __init__(
        self,
        *,
        inputs: google.protobuf.struct_pb2.Struct | None = ...,
        failures: collections.abc.Iterable[global___CheckFailure] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["inputs", b"inputs"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["failures", b"failures", "inputs", b"inputs"]) -> None: ...

global___CheckResponse = CheckResponse

@typing_extensions.final
class CheckFailure(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROPERTY_FIELD_NUMBER: builtins.int
    REASON_FIELD_NUMBER: builtins.int
    property: builtins.str
    """the property that failed validation."""
    reason: builtins.str
    """the reason that the property failed validation."""
    def __init__(
        self,
        *,
        property: builtins.str = ...,
        reason: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["property", b"property", "reason", b"reason"]) -> None: ...

global___CheckFailure = CheckFailure

@typing_extensions.final
class DiffRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    URN_FIELD_NUMBER: builtins.int
    OLDS_FIELD_NUMBER: builtins.int
    NEWS_FIELD_NUMBER: builtins.int
    IGNORECHANGES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the ID of the resource to diff."""
    urn: builtins.str
    """the Pulumi URN for this resource."""
    @property
    def olds(self) -> google.protobuf.struct_pb2.Struct:
        """the old values of provider inputs to diff."""
    @property
    def news(self) -> google.protobuf.struct_pb2.Struct:
        """the new values of provider inputs to diff."""
    @property
    def ignoreChanges(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a set of property paths that should be treated as unchanged."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        urn: builtins.str = ...,
        olds: google.protobuf.struct_pb2.Struct | None = ...,
        news: google.protobuf.struct_pb2.Struct | None = ...,
        ignoreChanges: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["news", b"news", "olds", b"olds"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "ignoreChanges", b"ignoreChanges", "news", b"news", "olds", b"olds", "urn", b"urn"]) -> None: ...

global___DiffRequest = DiffRequest

@typing_extensions.final
class PropertyDiff(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Kind:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _KindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PropertyDiff._Kind.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ADD: PropertyDiff._Kind.ValueType  # 0
        """this property was added"""
        ADD_REPLACE: PropertyDiff._Kind.ValueType  # 1
        """this property was added, and this change requires a replace"""
        DELETE: PropertyDiff._Kind.ValueType  # 2
        """this property was removed"""
        DELETE_REPLACE: PropertyDiff._Kind.ValueType  # 3
        """this property was removed, and this change requires a replace"""
        UPDATE: PropertyDiff._Kind.ValueType  # 4
        """this property's value was changed"""
        UPDATE_REPLACE: PropertyDiff._Kind.ValueType  # 5
        """this property's value was changed, and this change requires a replace"""

    class Kind(_Kind, metaclass=_KindEnumTypeWrapper): ...
    ADD: PropertyDiff.Kind.ValueType  # 0
    """this property was added"""
    ADD_REPLACE: PropertyDiff.Kind.ValueType  # 1
    """this property was added, and this change requires a replace"""
    DELETE: PropertyDiff.Kind.ValueType  # 2
    """this property was removed"""
    DELETE_REPLACE: PropertyDiff.Kind.ValueType  # 3
    """this property was removed, and this change requires a replace"""
    UPDATE: PropertyDiff.Kind.ValueType  # 4
    """this property's value was changed"""
    UPDATE_REPLACE: PropertyDiff.Kind.ValueType  # 5
    """this property's value was changed, and this change requires a replace"""

    KIND_FIELD_NUMBER: builtins.int
    INPUTDIFF_FIELD_NUMBER: builtins.int
    kind: global___PropertyDiff.Kind.ValueType
    """The kind of diff asdsociated with this property."""
    inputDiff: builtins.bool
    """The difference is between old and new inputs, not old and new state."""
    def __init__(
        self,
        *,
        kind: global___PropertyDiff.Kind.ValueType = ...,
        inputDiff: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["inputDiff", b"inputDiff", "kind", b"kind"]) -> None: ...

global___PropertyDiff = PropertyDiff

@typing_extensions.final
class DiffResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DiffChanges:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DiffChangesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DiffResponse._DiffChanges.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DIFF_UNKNOWN: DiffResponse._DiffChanges.ValueType  # 0
        """unknown whether there are changes or not (legacy behavior)."""
        DIFF_NONE: DiffResponse._DiffChanges.ValueType  # 1
        """the diff was performed, and no changes were detected that require an update."""
        DIFF_SOME: DiffResponse._DiffChanges.ValueType  # 2
        """the diff was performed, and changes were detected that require an update or replacement."""

    class DiffChanges(_DiffChanges, metaclass=_DiffChangesEnumTypeWrapper): ...
    DIFF_UNKNOWN: DiffResponse.DiffChanges.ValueType  # 0
    """unknown whether there are changes or not (legacy behavior)."""
    DIFF_NONE: DiffResponse.DiffChanges.ValueType  # 1
    """the diff was performed, and no changes were detected that require an update."""
    DIFF_SOME: DiffResponse.DiffChanges.ValueType  # 2
    """the diff was performed, and changes were detected that require an update or replacement."""

    @typing_extensions.final
    class DetailedDiffEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___PropertyDiff: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___PropertyDiff | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    REPLACES_FIELD_NUMBER: builtins.int
    STABLES_FIELD_NUMBER: builtins.int
    DELETEBEFOREREPLACE_FIELD_NUMBER: builtins.int
    CHANGES_FIELD_NUMBER: builtins.int
    DIFFS_FIELD_NUMBER: builtins.int
    DETAILEDDIFF_FIELD_NUMBER: builtins.int
    HASDETAILEDDIFF_FIELD_NUMBER: builtins.int
    @property
    def replaces(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """if this update requires a replacement, the set of properties triggering it."""
    @property
    def stables(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """an optional list of properties that will not ever change."""
    deleteBeforeReplace: builtins.bool
    """if true, this resource must be deleted before replacing it."""
    changes: global___DiffResponse.DiffChanges.ValueType
    """if true, this diff represents an actual difference and thus requires an update."""
    @property
    def diffs(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a list of the properties that changed."""
    @property
    def detailedDiff(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___PropertyDiff]:
        """detailedDiff is an optional field that contains map from each changed property to the type of the change.

        The keys of this map are property paths. These paths are essentially Javascript property access expressions
        in which all elements are literals, and obey the following EBNF-ish grammar:

          propertyName := [a-zA-Z_$] { [a-zA-Z0-9_$] }
          quotedPropertyName := '"' ( '\\' '"' | [^"] ) { ( '\\' '"' | [^"] ) } '"'
          arrayIndex := { [0-9] }

          propertyIndex := '[' ( quotedPropertyName | arrayIndex ) ']'
          rootProperty := ( propertyName | propertyIndex )
          propertyAccessor := ( ( '.' propertyName ) |  propertyIndex )
          path := rootProperty { propertyAccessor }

        Examples of valid keys:
        - root
        - root.nested
        - root["nested"]
        - root.double.nest
        - root["double"].nest
        - root["double"]["nest"]
        - root.array[0]
        - root.array[100]
        - root.array[0].nested
        - root.array[0][1].nested
        - root.nested.array[0].double[1]
        - root["key with \\"escaped\\" quotes"]
        - root["key with a ."]
        - ["root key with \\"escaped\\" quotes"].nested
        - ["root key with a ."][100]
        a detailed diff appropriate for display.
        """
    hasDetailedDiff: builtins.bool
    """true if this response contains a detailed diff."""
    def __init__(
        self,
        *,
        replaces: collections.abc.Iterable[builtins.str] | None = ...,
        stables: collections.abc.Iterable[builtins.str] | None = ...,
        deleteBeforeReplace: builtins.bool = ...,
        changes: global___DiffResponse.DiffChanges.ValueType = ...,
        diffs: collections.abc.Iterable[builtins.str] | None = ...,
        detailedDiff: collections.abc.Mapping[builtins.str, global___PropertyDiff] | None = ...,
        hasDetailedDiff: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["changes", b"changes", "deleteBeforeReplace", b"deleteBeforeReplace", "detailedDiff", b"detailedDiff", "diffs", b"diffs", "hasDetailedDiff", b"hasDetailedDiff", "replaces", b"replaces", "stables", b"stables"]) -> None: ...

global___DiffResponse = DiffResponse

@typing_extensions.final
class CreateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URN_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    PREVIEW_FIELD_NUMBER: builtins.int
    urn: builtins.str
    """the Pulumi URN for this resource."""
    @property
    def properties(self) -> google.protobuf.struct_pb2.Struct:
        """the provider inputs to set during creation."""
    timeout: builtins.float
    """the create request timeout represented in seconds."""
    preview: builtins.bool
    """true if this is a preview and the provider should not actually create the resource."""
    def __init__(
        self,
        *,
        urn: builtins.str = ...,
        properties: google.protobuf.struct_pb2.Struct | None = ...,
        timeout: builtins.float = ...,
        preview: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["properties", b"properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["preview", b"preview", "properties", b"properties", "timeout", b"timeout", "urn", b"urn"]) -> None: ...

global___CreateRequest = CreateRequest

@typing_extensions.final
class CreateResponse(google.protobuf.message.Message):
    """NOTE: The partial-update-error equivalent of this message is `ErrorResourceInitFailed`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the ID of the created resource."""
    @property
    def properties(self) -> google.protobuf.struct_pb2.Struct:
        """any properties that were computed during creation."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        properties: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["properties", b"properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "properties", b"properties"]) -> None: ...

global___CreateResponse = CreateResponse

@typing_extensions.final
class ReadRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    URN_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the ID of the resource to read."""
    urn: builtins.str
    """the Pulumi URN for this resource."""
    @property
    def properties(self) -> google.protobuf.struct_pb2.Struct:
        """the current state (sufficiently complete to identify the resource)."""
    @property
    def inputs(self) -> google.protobuf.struct_pb2.Struct:
        """the current inputs, if any (only populated during refresh)."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        urn: builtins.str = ...,
        properties: google.protobuf.struct_pb2.Struct | None = ...,
        inputs: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "properties", b"properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "inputs", b"inputs", "properties", b"properties", "urn", b"urn"]) -> None: ...

global___ReadRequest = ReadRequest

@typing_extensions.final
class ReadResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the ID of the resource read back (or empty if missing)."""
    @property
    def properties(self) -> google.protobuf.struct_pb2.Struct:
        """the state of the resource read from the live environment."""
    @property
    def inputs(self) -> google.protobuf.struct_pb2.Struct:
        """the inputs for this resource that would be returned from Check."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        properties: google.protobuf.struct_pb2.Struct | None = ...,
        inputs: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "properties", b"properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "inputs", b"inputs", "properties", b"properties"]) -> None: ...

global___ReadResponse = ReadResponse

@typing_extensions.final
class UpdateRequest(google.protobuf.message.Message):
    """NOTE: The partial-update-error equivalent of this message is `ErrorResourceInitFailed`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    URN_FIELD_NUMBER: builtins.int
    OLDS_FIELD_NUMBER: builtins.int
    NEWS_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    IGNORECHANGES_FIELD_NUMBER: builtins.int
    PREVIEW_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the ID of the resource to update."""
    urn: builtins.str
    """the Pulumi URN for this resource."""
    @property
    def olds(self) -> google.protobuf.struct_pb2.Struct:
        """the old values of provider inputs for the resource to update."""
    @property
    def news(self) -> google.protobuf.struct_pb2.Struct:
        """the new values of provider inputs for the resource to update."""
    timeout: builtins.float
    """the update request timeout represented in seconds."""
    @property
    def ignoreChanges(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a set of property paths that should be treated as unchanged."""
    preview: builtins.bool
    """true if this is a preview and the provider should not actually create the resource."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        urn: builtins.str = ...,
        olds: google.protobuf.struct_pb2.Struct | None = ...,
        news: google.protobuf.struct_pb2.Struct | None = ...,
        timeout: builtins.float = ...,
        ignoreChanges: collections.abc.Iterable[builtins.str] | None = ...,
        preview: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["news", b"news", "olds", b"olds"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "ignoreChanges", b"ignoreChanges", "news", b"news", "olds", b"olds", "preview", b"preview", "timeout", b"timeout", "urn", b"urn"]) -> None: ...

global___UpdateRequest = UpdateRequest

@typing_extensions.final
class UpdateResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def properties(self) -> google.protobuf.struct_pb2.Struct:
        """any properties that were computed during updating."""
    def __init__(
        self,
        *,
        properties: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["properties", b"properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["properties", b"properties"]) -> None: ...

global___UpdateResponse = UpdateResponse

@typing_extensions.final
class DeleteRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    URN_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the ID of the resource to delete."""
    urn: builtins.str
    """the Pulumi URN for this resource."""
    @property
    def properties(self) -> google.protobuf.struct_pb2.Struct:
        """the current properties on the resource."""
    timeout: builtins.float
    """the delete request timeout represented in seconds."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        urn: builtins.str = ...,
        properties: google.protobuf.struct_pb2.Struct | None = ...,
        timeout: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["properties", b"properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "properties", b"properties", "timeout", b"timeout", "urn", b"urn"]) -> None: ...

global___DeleteRequest = DeleteRequest

@typing_extensions.final
class ConstructRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class PropertyDependencies(google.protobuf.message.Message):
        """PropertyDependencies describes the resources that a particular property depends on."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URNS_FIELD_NUMBER: builtins.int
        @property
        def urns(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """A list of URNs this property depends on."""
        def __init__(
            self,
            *,
            urns: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["urns", b"urns"]) -> None: ...

    @typing_extensions.final
    class ConfigEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class InputDependenciesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ConstructRequest.PropertyDependencies: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ConstructRequest.PropertyDependencies | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class ProvidersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    PROJECT_FIELD_NUMBER: builtins.int
    STACK_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    DRYRUN_FIELD_NUMBER: builtins.int
    PARALLEL_FIELD_NUMBER: builtins.int
    MONITORENDPOINT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    INPUTDEPENDENCIES_FIELD_NUMBER: builtins.int
    PROTECT_FIELD_NUMBER: builtins.int
    PROVIDERS_FIELD_NUMBER: builtins.int
    ALIASES_FIELD_NUMBER: builtins.int
    DEPENDENCIES_FIELD_NUMBER: builtins.int
    CONFIGSECRETKEYS_FIELD_NUMBER: builtins.int
    ORGANIZATION_FIELD_NUMBER: builtins.int
    project: builtins.str
    """the project name."""
    stack: builtins.str
    """the name of the stack being deployed into."""
    @property
    def config(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """the configuration variables to apply before running."""
    dryRun: builtins.bool
    """true if we're only doing a dryrun (preview)."""
    parallel: builtins.int
    """the degree of parallelism for resource operations (<=1 for serial)."""
    monitorEndpoint: builtins.str
    """the address for communicating back to the resource monitor."""
    type: builtins.str
    """the type of the object allocated."""
    name: builtins.str
    """the name, for URN purposes, of the object."""
    parent: builtins.str
    """an optional parent URN that this child resource belongs to."""
    @property
    def inputs(self) -> google.protobuf.struct_pb2.Struct:
        """the inputs to the resource constructor."""
    @property
    def inputDependencies(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ConstructRequest.PropertyDependencies]:
        """a map from property keys to the dependencies of the property."""
    protect: builtins.bool
    """true if the resource should be marked protected."""
    @property
    def providers(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """the map of providers to use for this resource's children."""
    @property
    def aliases(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a list of additional URNs that shoud be considered the same."""
    @property
    def dependencies(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """a list of URNs that this resource depends on, as observed by the language host."""
    @property
    def configSecretKeys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """the configuration keys that have secret values."""
    organization: builtins.str
    """the organization of the stack being deployed into."""
    def __init__(
        self,
        *,
        project: builtins.str = ...,
        stack: builtins.str = ...,
        config: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        dryRun: builtins.bool = ...,
        parallel: builtins.int = ...,
        monitorEndpoint: builtins.str = ...,
        type: builtins.str = ...,
        name: builtins.str = ...,
        parent: builtins.str = ...,
        inputs: google.protobuf.struct_pb2.Struct | None = ...,
        inputDependencies: collections.abc.Mapping[builtins.str, global___ConstructRequest.PropertyDependencies] | None = ...,
        protect: builtins.bool = ...,
        providers: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        aliases: collections.abc.Iterable[builtins.str] | None = ...,
        dependencies: collections.abc.Iterable[builtins.str] | None = ...,
        configSecretKeys: collections.abc.Iterable[builtins.str] | None = ...,
        organization: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["inputs", b"inputs"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["aliases", b"aliases", "config", b"config", "configSecretKeys", b"configSecretKeys", "dependencies", b"dependencies", "dryRun", b"dryRun", "inputDependencies", b"inputDependencies", "inputs", b"inputs", "monitorEndpoint", b"monitorEndpoint", "name", b"name", "organization", b"organization", "parallel", b"parallel", "parent", b"parent", "project", b"project", "protect", b"protect", "providers", b"providers", "stack", b"stack", "type", b"type"]) -> None: ...

global___ConstructRequest = ConstructRequest

@typing_extensions.final
class ConstructResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class PropertyDependencies(google.protobuf.message.Message):
        """PropertyDependencies describes the resources that a particular property depends on."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URNS_FIELD_NUMBER: builtins.int
        @property
        def urns(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """A list of URNs this property depends on."""
        def __init__(
            self,
            *,
            urns: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["urns", b"urns"]) -> None: ...

    @typing_extensions.final
    class StateDependenciesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ConstructResponse.PropertyDependencies: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ConstructResponse.PropertyDependencies | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    URN_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    STATEDEPENDENCIES_FIELD_NUMBER: builtins.int
    urn: builtins.str
    """the URN of the component resource."""
    @property
    def state(self) -> google.protobuf.struct_pb2.Struct:
        """any properties that were computed during construction."""
    @property
    def stateDependencies(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ConstructResponse.PropertyDependencies]:
        """a map from property keys to the dependencies of the property."""
    def __init__(
        self,
        *,
        urn: builtins.str = ...,
        state: google.protobuf.struct_pb2.Struct | None = ...,
        stateDependencies: collections.abc.Mapping[builtins.str, global___ConstructResponse.PropertyDependencies] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["state", b"state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["state", b"state", "stateDependencies", b"stateDependencies", "urn", b"urn"]) -> None: ...

global___ConstructResponse = ConstructResponse

@typing_extensions.final
class ErrorResourceInitFailed(google.protobuf.message.Message):
    """ErrorResourceInitFailed is sent as a Detail `ResourceProvider.{Create, Update}` fail because a
    resource was created successfully, but failed to initialize.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    REASONS_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """the ID of the created resource."""
    @property
    def properties(self) -> google.protobuf.struct_pb2.Struct:
        """any properties that were computed during updating."""
    @property
    def reasons(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """error messages associated with initialization failure."""
    @property
    def inputs(self) -> google.protobuf.struct_pb2.Struct:
        """the current inputs to this resource (only applicable for Read)"""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        properties: google.protobuf.struct_pb2.Struct | None = ...,
        reasons: collections.abc.Iterable[builtins.str] | None = ...,
        inputs: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["inputs", b"inputs", "properties", b"properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "inputs", b"inputs", "properties", b"properties", "reasons", b"reasons"]) -> None: ...

global___ErrorResourceInitFailed = ErrorResourceInitFailed

@typing_extensions.final
class GetMappingRequest(google.protobuf.message.Message):
    """GetMappingRequest allows providers to return ecosystem specific information to allow the provider to be
    converted from a source markup to Pulumi. It's expected that provider bridges that target a given ecosystem
    (e.g. Terraform, Kubernetes) would also publish a conversion plugin to convert markup from that ecosystem
    to Pulumi, using the bridged providers.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    key: builtins.str
    """the conversion key for the mapping being requested."""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key"]) -> None: ...

global___GetMappingRequest = GetMappingRequest

@typing_extensions.final
class GetMappingResponse(google.protobuf.message.Message):
    """GetMappingResponse returns convert plugin specific data for this provider. This will normally be human
    readable JSON, but the engine doesn't mandate any form.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    provider: builtins.str
    """the provider key this is mapping for. For example the Pulumi provider "terraform-template" would return "template" for this."""
    data: builtins.bytes
    """the conversion plugin specific data."""
    def __init__(
        self,
        *,
        provider: builtins.str = ...,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "provider", b"provider"]) -> None: ...

global___GetMappingResponse = GetMappingResponse
