"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2016-2018, Pulumi Corporation.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import abc
import collections.abc
import google.protobuf.empty_pb2
import grpc
import grpc.aio
import typing
import pulumi.plugin_pb2
import pulumi.provider_pb2

class ResourceProviderStub:
    """ResourceProvider is a service that understands how to create, read, update, or delete resources for types defined
    within a single package.  It is driven by the overall planning engine in response to resource diffs.
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    GetSchema: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.GetSchemaRequest,
        pulumi.provider_pb2.GetSchemaResponse,
    ]
    """GetSchema fetches the schema for this resource provider."""
    CheckConfig: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.CheckRequest,
        pulumi.provider_pb2.CheckResponse,
    ]
    """CheckConfig validates the configuration for this resource provider."""
    DiffConfig: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.DiffRequest,
        pulumi.provider_pb2.DiffResponse,
    ]
    """DiffConfig checks the impact a hypothetical change to this provider's configuration will have on the provider."""
    Configure: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.ConfigureRequest,
        pulumi.provider_pb2.ConfigureResponse,
    ]
    """Configure configures the resource provider with "globals" that control its behavior."""
    Invoke: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.InvokeRequest,
        pulumi.provider_pb2.InvokeResponse,
    ]
    """Invoke dynamically executes a built-in function in the provider."""
    StreamInvoke: grpc.UnaryStreamMultiCallable[
        pulumi.provider_pb2.InvokeRequest,
        pulumi.provider_pb2.InvokeResponse,
    ]
    """StreamInvoke dynamically executes a built-in function in the provider, which returns a stream
    of responses.
    """
    Call: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.CallRequest,
        pulumi.provider_pb2.CallResponse,
    ]
    """Call dynamically executes a method in the provider associated with a component resource."""
    Check: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.CheckRequest,
        pulumi.provider_pb2.CheckResponse,
    ]
    """Check validates that the given property bag is valid for a resource of the given type and returns the inputs
    that should be passed to successive calls to Diff, Create, or Update for this resource. As a rule, the provider
    inputs returned by a call to Check should preserve the original representation of the properties as present in
    the program inputs. Though this rule is not required for correctness, violations thereof can negatively impact
    the end-user experience, as the provider inputs are using for detecting and rendering diffs.
    """
    Diff: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.DiffRequest,
        pulumi.provider_pb2.DiffResponse,
    ]
    """Diff checks what impacts a hypothetical update will have on the resource's properties."""
    Create: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.CreateRequest,
        pulumi.provider_pb2.CreateResponse,
    ]
    """Create allocates a new instance of the provided resource and returns its unique ID afterwards.  (The input ID
    must be blank.)  If this call fails, the resource must not have been created (i.e., it is "transactional").
    """
    Read: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.ReadRequest,
        pulumi.provider_pb2.ReadResponse,
    ]
    """Read the current live state associated with a resource.  Enough state must be include in the inputs to uniquely
    identify the resource; this is typically just the resource ID, but may also include some properties.
    """
    Update: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.UpdateRequest,
        pulumi.provider_pb2.UpdateResponse,
    ]
    """Update updates an existing resource with new values."""
    Delete: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.DeleteRequest,
        google.protobuf.empty_pb2.Empty,
    ]
    """Delete tears down an existing resource with the given ID.  If it fails, the resource is assumed to still exist."""
    Construct: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.ConstructRequest,
        pulumi.provider_pb2.ConstructResponse,
    ]
    """Construct creates a new instance of the provided component resource and returns its state."""
    Cancel: grpc.UnaryUnaryMultiCallable[
        google.protobuf.empty_pb2.Empty,
        google.protobuf.empty_pb2.Empty,
    ]
    """Cancel signals the provider to gracefully shut down and abort any ongoing resource operations.
    Operations aborted in this way will return an error (e.g., `Update` and `Create` will either return a
    creation error or an initialization error). Since Cancel is advisory and non-blocking, it is up
    to the host to decide how long to wait after Cancel is called before (e.g.)
    hard-closing any gRPC connection.
    """
    GetPluginInfo: grpc.UnaryUnaryMultiCallable[
        google.protobuf.empty_pb2.Empty,
        pulumi.plugin_pb2.PluginInfo,
    ]
    """GetPluginInfo returns generic information about this plugin, like its version."""
    Attach: grpc.UnaryUnaryMultiCallable[
        pulumi.plugin_pb2.PluginAttach,
        google.protobuf.empty_pb2.Empty,
    ]
    """Attach sends the engine address to an already running plugin."""
    GetMapping: grpc.UnaryUnaryMultiCallable[
        pulumi.provider_pb2.GetMappingRequest,
        pulumi.provider_pb2.GetMappingResponse,
    ]
    """GetMapping fetches the mapping for this resource provider, if any. A provider should return an empty
    response (not an error) if it doesn't have a mapping for the given key.
    """

class ResourceProviderServicer(metaclass=abc.ABCMeta):
    """ResourceProvider is a service that understands how to create, read, update, or delete resources for types defined
    within a single package.  It is driven by the overall planning engine in response to resource diffs.
    """

    
    def GetSchema(
        self,
        request: pulumi.provider_pb2.GetSchemaRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.GetSchemaResponse:
        """GetSchema fetches the schema for this resource provider."""
    
    def CheckConfig(
        self,
        request: pulumi.provider_pb2.CheckRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.CheckResponse:
        """CheckConfig validates the configuration for this resource provider."""
    
    def DiffConfig(
        self,
        request: pulumi.provider_pb2.DiffRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.DiffResponse:
        """DiffConfig checks the impact a hypothetical change to this provider's configuration will have on the provider."""
    
    def Configure(
        self,
        request: pulumi.provider_pb2.ConfigureRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.ConfigureResponse:
        """Configure configures the resource provider with "globals" that control its behavior."""
    
    def Invoke(
        self,
        request: pulumi.provider_pb2.InvokeRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.InvokeResponse:
        """Invoke dynamically executes a built-in function in the provider."""
    
    def StreamInvoke(
        self,
        request: pulumi.provider_pb2.InvokeRequest,
        context: grpc.ServicerContext,
    ) -> collections.abc.Iterator[pulumi.provider_pb2.InvokeResponse]:
        """StreamInvoke dynamically executes a built-in function in the provider, which returns a stream
        of responses.
        """
    
    def Call(
        self,
        request: pulumi.provider_pb2.CallRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.CallResponse:
        """Call dynamically executes a method in the provider associated with a component resource."""
    
    def Check(
        self,
        request: pulumi.provider_pb2.CheckRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.CheckResponse:
        """Check validates that the given property bag is valid for a resource of the given type and returns the inputs
        that should be passed to successive calls to Diff, Create, or Update for this resource. As a rule, the provider
        inputs returned by a call to Check should preserve the original representation of the properties as present in
        the program inputs. Though this rule is not required for correctness, violations thereof can negatively impact
        the end-user experience, as the provider inputs are using for detecting and rendering diffs.
        """
    
    def Diff(
        self,
        request: pulumi.provider_pb2.DiffRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.DiffResponse:
        """Diff checks what impacts a hypothetical update will have on the resource's properties."""
    
    def Create(
        self,
        request: pulumi.provider_pb2.CreateRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.CreateResponse:
        """Create allocates a new instance of the provided resource and returns its unique ID afterwards.  (The input ID
        must be blank.)  If this call fails, the resource must not have been created (i.e., it is "transactional").
        """
    
    def Read(
        self,
        request: pulumi.provider_pb2.ReadRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.ReadResponse:
        """Read the current live state associated with a resource.  Enough state must be include in the inputs to uniquely
        identify the resource; this is typically just the resource ID, but may also include some properties.
        """
    
    def Update(
        self,
        request: pulumi.provider_pb2.UpdateRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.UpdateResponse:
        """Update updates an existing resource with new values."""
    
    def Delete(
        self,
        request: pulumi.provider_pb2.DeleteRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Delete tears down an existing resource with the given ID.  If it fails, the resource is assumed to still exist."""
    
    def Construct(
        self,
        request: pulumi.provider_pb2.ConstructRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.ConstructResponse:
        """Construct creates a new instance of the provided component resource and returns its state."""
    
    def Cancel(
        self,
        request: google.protobuf.empty_pb2.Empty,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Cancel signals the provider to gracefully shut down and abort any ongoing resource operations.
        Operations aborted in this way will return an error (e.g., `Update` and `Create` will either return a
        creation error or an initialization error). Since Cancel is advisory and non-blocking, it is up
        to the host to decide how long to wait after Cancel is called before (e.g.)
        hard-closing any gRPC connection.
        """
    
    def GetPluginInfo(
        self,
        request: google.protobuf.empty_pb2.Empty,
        context: grpc.ServicerContext,
    ) -> pulumi.plugin_pb2.PluginInfo:
        """GetPluginInfo returns generic information about this plugin, like its version."""
    
    def Attach(
        self,
        request: pulumi.plugin_pb2.PluginAttach,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Attach sends the engine address to an already running plugin."""
    
    def GetMapping(
        self,
        request: pulumi.provider_pb2.GetMappingRequest,
        context: grpc.ServicerContext,
    ) -> pulumi.provider_pb2.GetMappingResponse:
        """GetMapping fetches the mapping for this resource provider, if any. A provider should return an empty
        response (not an error) if it doesn't have a mapping for the given key.
        """

def add_ResourceProviderServicer_to_server(servicer: ResourceProviderServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
