﻿// Copyright 2016-2019, Pulumi Corporation.  All rights reserved.

using System.Collections.Generic;
using System.Threading.Tasks;
using Pulumi;

class Program
{
    static Task<int> Main(string[] args)
    {
        return Deployment.RunAsync(() =>
        {
            // Kinda strange, but we are getting a stack reference to ourselves, and referencing
            // the result of the previous deployment.

            var slug = $"{Deployment.Instance.OrganizationName}/{Deployment.Instance.ProjectName}/{Deployment.Instance.StackName}";
            var sr = new StackReference(slug);

            return new Dictionary<string, object>
            {
                { "normal", Output.Create("normal") },
                { "secret", Output.CreateSecret("secret") },
                { "refNormal", sr.GetOutput("normal") },
                { "refSecret", sr.GetOutput("secret") },
            };
        });
    }
}
