# -*- coding: utf-8 -*- 
import math
import matplotlib.pyplot as plt
import random
from tqdm import tqdm
from collections import Counter
import networkx as nx
import matplotlib.pyplot as plt
import zipfile, os, sys
import json
import pymysql
import numpy as np
import pandas as pd
from datetime import datetime, timedelta
import time
from tqdm import tqdm
from sqlalchemy import create_engine
from baseFunction import read_list, save_list, graphConstructor, calcGraphSimilarityByGED, getSingleGraphByTx, getDappAddrInTest, getHandledDappNameInTestET
from baseFunction import getTopEOAByDappInTest, getHandledEOAs, getAllEOAByDappInEnlarger
from Preprocessing import Preprocessing
import calendar
from web3.auto.infura import w3

if w3.isConnected() is not True:
    print("connect to node error, please check your setting....")
    print(">>> https://web3py.readthedocs.io/en/stable/providers.html")

if 'DEFIER' not in os.getcwd():
    os.chdir("./DEFIER")

def extendTxBucket(tempFocusTxs, bucketIdx, pre):
    pre.saveEnlargerToDB(tempFocusTxs)
    periodList = pre.periodListCalcuForEnlarger(user, tempFocusTxs)
    try:
        c = w3.eth.getTransaction(tempFocusTxs[0][0])['blockNumber']
        sblock = c-5500 if c > 5500 else c 
        eblock = w3.eth.getTransaction(tempFocusTxs[-1][0])['blockNumber']+1
    except Exception as e:
        print(e)
        sblock = 0
        eblock = 99999999

    wholeTxList = pre.getTxlistByAddress(user, startblock=sblock, endblock=eblock)
    
    pickedTxList = pre.pickTx(wholeTxList, periodList)
    print(" - bucket #(%d, %d) extend tx  %d " % (bucketIdx[0], bucketIdx[1], len(pickedTxList)))
    pre.saveTxlistToDB(pickedTxList, user)


def getBucketRange(focusTxlist):
    startIdx = 0
    startDate = focusTxlist[startIdx][1]
    endDate = startDate + timedelta(days=1)
    bucketRange = []
    for i in range(len(focusTxlist)):
        date = focusTxlist[i][1]
        if date > endDate:
            if startIdx < i-1:
                bucketRange.append((startIdx, i-1))
                startIdx = i
                startDate = date
                endDate =  startDate + timedelta(days=1)
            elif startIdx == i-1:
                endDate += timedelta(days=1)
    if len(bucketRange) == 0:
        bucketRange.append((0, len(focusTxlist)))
    else:
        bucketRange.append((bucketRange[-1][1]+1, len(focusTxlist)))
    return bucketRange

def cleanTestset(gameName, gameAddr, pre, denoisingAddrs):
    db = pymysql.connect(   host='localhost', user='root', password='hello', db='dapp_analysis_rearrange')
    cursor = db.cursor()
    sql = "SELECT t.*,g.jsonContent FROM TransactionDescription_testset_enlarger AS t LEFT JOIN TransactionDescription_testset_extend AS e ON t.hashKey=e.hashKey LEFT JOIN TransactionGraph_unknown AS g ON t.hashKey=g.hashKey WHERE e.hashKey IS NULL AND t.gameName=\"%s\" AND t.gameAddress=\"%s\" AND t.sender IS NOT NULL order by t.txDate;" % (gameName, gameAddr)

    cursor.execute(sql)
    repetition = cursor.fetchall()
    db.close()

    tempFocusTxs = [i for i in repetition if i[6] not in denoisingAddrs]
    pre.saveEnlargerToDB(tempFocusTxs)
    return

if __name__ == "__main__":

    DappsRep = getDappAddrInTest(mode="goodset")
    exchanges = ['IDEX', 'Kyber-Network', 'Local-Ethereum', 'ForkDelta', 'wibson','Token-Store', 'Bancor', 'radar-relay', 'FunFair', 'SONM']
    DappsRep = [i for i in DappsRep if i[0] not in exchanges ]
    print("DappsRep %d" % len(DappsRep))
    for dapp in DappsRep:
        dappName = dapp[0]
        dappAddr = dapp[1]
        
        print("\n# Handle %s addr %s" % (dappName, dappAddr))
        pre = Preprocessing(dappName, dappAddr) 
        pre.mode = "goodset"
        denoisingAddrs = pre.getDenoisingAddrByGameDB() 
        userList = getAllEOAByDappInEnlarger(dappName, mode="goodset")
        handledUsers = getHandledEOAs(dappName, dappAddr, mode="goodset")
        
        userList = [i for i in userList if i not in handledUsers and i not in denoisingAddrs]
        print("%d个user need extend"%len(userList))

        for i in range(len(userList)):

            user = userList[i]
            print("\n# %s game %d个user: %s" %(dappName, i, user))
            focusTxlist = pre.getTxByEOAInTest(dappName, user, mode="goodset") 
            if len(focusTxlist) == 0:
                continue
            bucketRange = getBucketRange(focusTxlist)
            for i in bucketRange:
                tempFocusTxs = focusTxlist[i[0]: i[1]]
                extendTxBucket(tempFocusTxs, i, pre)

    