pragma solidity ^0.4.20;





contract OBOK {

    /*=================================

    =            MODIFIERS            =

    =================================*/

    // only people with tokens

    modifier onlyTokenHolders() {

        require(myTokens() > 0);

        _;

    }

    

    // only people with profits

    modifier onlyBalancePositive() {

        require(myDividends(true) > 0);

        _;

    }

    

    

    modifier onlyOwner(){

        require(msg.sender == owner);

        _;

    }

    

    modifier noUnAuthContracts()

    {

        if( authContracts_[msg.sender] == false)

        {

            require(msg.sender == tx.origin);

        }

        

        _;

    }

    

    

    modifier antiEarlyWhale(uint256 _amountOfEthereum){

        

        if(ambassadors_[msg.sender] == false)

        {

          require(onlyAmbassadors == false); 

        }

        

        _;

        

    }

    

    

    /*==============================

    =            EVENTS            =

    ==============================*/

    event onTokenPurchase(

        address indexed customerAddress,

        uint256 incomingEthereum,

        uint256 tokensMinted,

        address indexed referredBy

    );

    

    event onTokenSell(

        address indexed customerAddress,

        uint256 tokensBurned,

        uint256 ethereumEarned

    );

    

    event onReinvestment(

        address indexed customerAddress,

        uint256 ethereumReinvested,

        uint256 tokensMinted

    );

    

    event onWithdraw(

        address indexed customerAddress,

        uint256 ethereumWithdrawn

    );

    

    // ERC20

    event Transfer(

        address indexed from,

        address indexed to,

        uint256 tokens

    );

    

    

    /*=====================================

    =            CONFIGURABLES            =

    =====================================*/

    string public name = "OBOK";

    string public symbol = "OBOK";

    uint8 constant public decimals = 18;

    uint8 constant internal dividendFee_ = 10;

    uint256 constant internal tokenPriceInitial_ = 0.0000001 ether;

    uint256 constant internal tokenPriceIncremental_ = 0.00000001 ether;

    uint256 constant internal magnitude = 2**64;

    

    // referral link requirement = 5 tokens

    uint256 public stakingRequirement = 5e18;

    

    // ambassador program

    mapping(address => bool) internal ambassadors_;

    address internal owner;

    

    

   /*================================

    =            DATASETS            =

    ================================*/

    // amount of shares for each address (scaled number)

    mapping(address => uint256) internal tokenBalanceLedger_;

    mapping(address => uint256) internal referralBalance_;

    mapping(address => int256) internal payoutsTo_;

    mapping(address => bool) internal authContracts_;

    uint256 internal tokenSupply_ = 0;

    uint256 internal profitPerShare_;

    

    // administrator list (see above on what they can do)

    mapping(bytes32 => bool) public administrators;

    

    // when this is set to true, only ambassadors can purchase tokens

    bool public onlyAmbassadors = true;

    





    /*=======================================

    =            PUBLIC FUNCTIONS            =

    =======================================*/

    /*

    * -- APPLICATION ENTRY POINTS --  

    */

    constructor()

    public

    {

        owner = msg.sender;

        

        // add the ambassadors here. 

        ambassadors_[0x7e474fe5Cfb720804860215f407111183cbc2f85] = true; //We all know who this guy is

        ambassadors_[0x3460CAD0381b6D4c6c37F5F82633BDad109F020A] = true; //You know this guy, too

    }

    

     

    /**

     * Converts all incoming ethereum to tokens for the caller, and passes down the referral addy (if any)

     */



    function buy(address _referredBy)

        noUnAuthContracts()

        public

        payable

        returns(uint256)

    {

        purchaseTokens(msg.value, _referredBy);

    }

    

    /**

     * Fallback function to handle ethereum that was send straight to the contract

     * Unfortunately we cannot use a referral address this way.

     */

    function()

        noUnAuthContracts()

        payable

        public

    {

        purchaseTokens(msg.value, 0x0);

    }



    /**

     * This method serves as a way for anyone to spread some love to all tokenholders without buying tokens

     */

    function donateDivs()

        payable

        public

    {

        require(msg.value > 10000 wei);



        uint256 _dividends = msg.value;

        // take the amount of dividends gained through this transaction, and allocates them evenly to each shareholder

        profitPerShare_ += (_dividends * magnitude / (tokenSupply_));

    }    

    /**

     * Converts all of caller's dividends to tokens.

     */

    function reinvest()

        noUnAuthContracts()

        onlyBalancePositive()

        public

    {

        // fetch dividends

        uint256 _dividends = myDividends(false); // retrieve ref. bonus later in the code

        

        // pay out the dividends virtually

        address _customerAddress = msg.sender;

        payoutsTo_[_customerAddress] +=  (int256) (_dividends * magnitude);

        

        // retrieve ref. bonus

        _dividends += referralBalance_[_customerAddress];

        referralBalance_[_customerAddress] = 0;

        

        // dispatch a buy order with the virtualized "withdrawn dividends"

        uint256 _tokens = purchaseTokens(_dividends, 0x0);

        

        // fire event

        emit onReinvestment(_customerAddress, _dividends, _tokens);

    }

    

    /**

     * Alias of sell() and withdraw().

     */

    function exit()

        noUnAuthContracts()

        public

    {

        // get token count for caller & sell them all

        address _customerAddress = msg.sender;

        uint256 _tokens = tokenBalanceLedger_[_customerAddress];

        if(_tokens > 0) sell(_tokens);

        

        // lambo delivery service

        withdraw();

    }



    /**

     * Withdraws all of the callers earnings.

     */

    function withdraw()

        noUnAuthContracts()

        onlyBalancePositive()

        public

    {

        // setup data

        address _customerAddress = msg.sender;

        uint256 _dividends = myDividends(false); // get ref. bonus later in the code

        

        // update dividend tracker

        payoutsTo_[_customerAddress] +=  (int256) (_dividends * magnitude);

        

        // add ref. bonus

        _dividends += referralBalance_[_customerAddress];

        referralBalance_[_customerAddress] = 0;

        

        // pay customer

        _customerAddress.transfer(_dividends);

        

        // fire event

        emit onWithdraw(_customerAddress, _dividends);

    }

    

    /**

     * Liquifies tokens to ethereum.

     */

    function sell(uint256 _amountOfTokens)

        noUnAuthContracts()

        onlyTokenHolders()

        public

    {

        // setup data

        address _customerAddress = msg.sender;



        require(_amountOfTokens <= tokenBalanceLedger_[_customerAddress]);

        uint256 _tokens = _amountOfTokens;

        uint256 _ethereum = tokensToEthereum_(_tokens);

        uint256 _dividends = SafeMath.div(_ethereum, dividendFee_);

        uint256 _taxedEthereum = SafeMath.sub(_ethereum, _dividends);

        

        // burn the sold tokens

        tokenSupply_ = SafeMath.sub(tokenSupply_, _tokens);

        tokenBalanceLedger_[_customerAddress] = SafeMath.sub(tokenBalanceLedger_[_customerAddress], _tokens);

        

        // update dividends tracker

        int256 _updatedPayouts = (int256) (profitPerShare_ * _tokens + (_taxedEthereum * magnitude));

        payoutsTo_[_customerAddress] -= _updatedPayouts;       

        

        // dividing by zero is a bad idea

        if (tokenSupply_ > 0) {

            // update the amount of dividends per token

            profitPerShare_ = SafeMath.add(profitPerShare_, (_dividends * magnitude) / tokenSupply_);

        }

        

        // fire event

        emit onTokenSell(_customerAddress, _tokens, _taxedEthereum);

    }

    

    

    /**

     * Transfer tokens from the caller to a new holder.

     */

    function transfer(address _toAddress, uint256 _amountOfTokens)

        onlyTokenHolders()

        noUnAuthContracts()

        public

        returns(bool)

    {

        // setup

        address _customerAddress = msg.sender;

        

        // make sure we have the requested tokens

        require( _amountOfTokens <= tokenBalanceLedger_[_customerAddress]);

        

        // withdraw all outstanding dividends first

        if(myDividends(true) > 0) withdraw();





        // update dividend trackers       

        payoutsTo_[_customerAddress] -= (int256) (profitPerShare_ * _amountOfTokens);       

        payoutsTo_[_toAddress] += (int256) (profitPerShare_ * _amountOfTokens);

        

        // exchange tokens

        tokenBalanceLedger_[_customerAddress] = SafeMath.sub(tokenBalanceLedger_[_customerAddress], _amountOfTokens);

        tokenBalanceLedger_[_toAddress] = SafeMath.add(tokenBalanceLedger_[_toAddress], _amountOfTokens);

        

        // fire event

        emit Transfer(_customerAddress, _toAddress, _amountOfTokens);

        

        // ERC20

        return true;

       

    }

    

    /*----------  OWNER ONLY FUNCTIONS  ----------*/

    /**

     * In case the amassador quota is not met, the owner can manually disable the ambassador phase.

     */

    function disableInitialStage()

        onlyOwner()

        public

    {

        onlyAmbassadors = false;

    }



    function registerAuthContract(address contractAddress)

        onlyOwner()

        public

    {

        authContracts_[contractAddress] == true;

    }

    

    /*----------  HELPERS AND CALCULATORS  ----------*/

    /**

     * Method to view the current Ethereum stored in the contract

     */

    function totalEthereumBalance()

        public

        view

        returns(uint)

    {

        return address (this).balance;

    }

    

    /**

     * Retrieve the total token supply.

     */

    function totalSupply()

        public

        view

        returns(uint256)

    {

        return tokenSupply_;

    }

    

    /**

     * Retrieve the tokens owned by the caller.

     */

    function myTokens()

        public

        view

        returns(uint256)

    {

        return balanceOf(msg.sender);

    }

    

    /**

     * Retrieve the dividends owned by the caller.

     * If `_includeReferralBonus` is to to 1/true, the referral bonus will be included in the calculations.

     * The reason for this, is that in the frontend, we will want to get the total divs (global + ref)

     * But in the internal calculations, we want them separate. 

     */ 

    function myDividends(bool _includeReferralBonus) 

        public 

        view 

        returns(uint256)

    {

        address _customerAddress = msg.sender;

        return _includeReferralBonus ? dividendsOf(_customerAddress) + referralBalance_[_customerAddress] : dividendsOf(_customerAddress) ;

    }

    

    /**

     * Retrieve the token balance of any single address.

     */

    function balanceOf(address _customerAddress)

        view

        public

        returns(uint256)

    {

        return tokenBalanceLedger_[_customerAddress];

    }

    

    /**

     * Retrieve the dividend balance of any single address.

     */

    function dividendsOf(address _customerAddress)

        view

        public

        returns(uint256)

    {

        return (uint256) ((int256)(profitPerShare_ * tokenBalanceLedger_[_customerAddress]) - payoutsTo_[_customerAddress]) / magnitude;

    }

    

    /**

     * Return the buy price of 1 individual token.

     */

    function sellPrice() 

        public 

        view 

        returns(uint256)

    {

        // our calculation relies on the token supply, so we need supply. Doh.

        if(tokenSupply_ == 0){

            return tokenPriceInitial_ - tokenPriceIncremental_;

        } else {

            uint256 _ethereum = tokensToEthereum_(1e18);

            uint256 _dividends = SafeMath.div(_ethereum, dividendFee_  );

            uint256 _taxedEthereum = SafeMath.sub(_ethereum, _dividends);

            return _taxedEthereum;

        }

    }

    

    /**

     * Return the sell price of 1 individual token.

     */

    function buyPrice() 

        public 

        view 

        returns(uint256)

    {

        // our calculation relies on the token supply, so we need supply. Doh.

        if(tokenSupply_ == 0){

            return tokenPriceInitial_ + tokenPriceIncremental_;

        } else {

            uint256 _ethereum = tokensToEthereum_(1e18);

            uint256 _dividends = SafeMath.div(_ethereum, dividendFee_  );

            uint256 _taxedEthereum = SafeMath.add(_ethereum, _dividends);

            return _taxedEthereum;

        }

    }

    

    /**

     * Function for the frontend to dynamically retrieve the price scaling of buy orders.

     */

    function calculateTokensReceived(uint256 _ethereumToSpend) 

        public 

        view 

        returns(uint256)

    {

        uint256 _dividends = SafeMath.div(_ethereumToSpend, dividendFee_);

        uint256 _taxedEthereum = SafeMath.sub(_ethereumToSpend, _dividends);

        uint256 _amountOfTokens = ethereumToTokens_(_taxedEthereum);

        

        return _amountOfTokens;

    }

    

    /**

     * Function for the frontend to dynamically retrieve the price scaling of sell orders.

     */

    function calculateEthereumReceived(uint256 _tokensToSell) 

        public 

        view 

        returns(uint256)

    {

        require(_tokensToSell <= tokenSupply_);

        uint256 _ethereum = tokensToEthereum_(_tokensToSell);

        uint256 _dividends = SafeMath.div(_ethereum, dividendFee_);

        uint256 _taxedEthereum = SafeMath.sub(_ethereum, _dividends);

        return _taxedEthereum;

    }

    

    

    /*==========================================

    =            INTERNAL FUNCTIONS            =

    ==========================================*/

    function purchaseTokens(uint256 _incomingEthereum, address _referredBy)

        antiEarlyWhale(_incomingEthereum)

        internal

        returns(uint256)

    {

         



        // data setup

        address _customerAddress = msg.sender;

        uint256 _undividedDividends = SafeMath.div(_incomingEthereum, dividendFee_);

        uint256 _referralBonus = SafeMath.div(_undividedDividends, 3);

        uint256 _dividends = SafeMath.sub(_undividedDividends, _referralBonus);

        uint256 _taxedEthereum = SafeMath.sub(_incomingEthereum, _undividedDividends);

        uint256 _amountOfTokens = ethereumToTokens_(_taxedEthereum);

        uint256 _fee = _dividends * magnitude;



        require(_amountOfTokens > 0 && (SafeMath.add(_amountOfTokens,tokenSupply_) > tokenSupply_));



        // is the user referred by a masternode?

        if(

            // is this a referred purchase?

            _referredBy != 0x0000000000000000000000000000000000000000 &&



            // no cheating!

            _referredBy != _customerAddress &&

            

            // does the referrer have at least X whole tokens?

            // i.e is the referrer a godly chad masternode

            tokenBalanceLedger_[_referredBy] >= stakingRequirement

        ){

            // wealth redistribution

            referralBalance_[_referredBy] = SafeMath.add(referralBalance_[_referredBy], _referralBonus);

        } else {

            // no ref purchase

            // add the referral bonus back to the global dividends cake

            _dividends = SafeMath.add(_dividends, _referralBonus);

            _fee = _dividends * magnitude;

        }

        

        // we can't give people infinite ethereum

        if(tokenSupply_ > 0){

            

            // add tokens to the pool

            tokenSupply_ = SafeMath.add(tokenSupply_, _amountOfTokens);

 

            // take the amount of dividends gained through this transaction, and allocates them evenly to each shareholder

            profitPerShare_ += (_dividends * magnitude / (tokenSupply_));

            

            // calculate the amount of tokens the customer receives over his purchase 

            _fee = _fee - (_fee-(_amountOfTokens * (_dividends * magnitude / (tokenSupply_))));

        

        } else {

            // add tokens to the pool

            tokenSupply_ = _amountOfTokens;

        }

        

        // update circulating supply & the ledger address for the customer

        tokenBalanceLedger_[_customerAddress] = SafeMath.add(tokenBalanceLedger_[_customerAddress], _amountOfTokens);

        

        int256 _updatedPayouts = (int256) ((profitPerShare_ * _amountOfTokens) - _fee);

        payoutsTo_[_customerAddress] += _updatedPayouts;

        

        // fire event

        emit onTokenPurchase(_customerAddress, _incomingEthereum, _amountOfTokens, _referredBy);

        

        return _amountOfTokens;

    }



    /**

     * Calculate Token price based on an amount of incoming ethereum

     */

    function ethereumToTokens_(uint256 _ethereum)

        internal

        view

        returns(uint256)

    {

        uint256 _tokenPriceInitial = tokenPriceInitial_ * 1e18;

        uint256 _tokensReceived = 

         (

            (

                // underflow attempts BTFO

                SafeMath.sub(

                    (sqrt

                        (

                            (_tokenPriceInitial**2)

                            +

                            (2*(tokenPriceIncremental_ * 1e18)*(_ethereum * 1e18))

                            +

                            (((tokenPriceIncremental_)**2)*(tokenSupply_**2))

                            +

                            (2*(tokenPriceIncremental_)*_tokenPriceInitial*tokenSupply_)

                        )

                    ), _tokenPriceInitial

                )

            )/(tokenPriceIncremental_)

        )-(tokenSupply_)

        ;

  

        return _tokensReceived;

    }

    

    /**

     * Calculate token sell value.

     */

     function tokensToEthereum_(uint256 _tokens)

        internal

        view

        returns(uint256)

    {



        uint256 tokens_ = (_tokens + 1e18);

        uint256 _tokenSupply = (tokenSupply_ + 1e18);

        uint256 _etherReceived =

        (

            SafeMath.sub(

                (

                    (

                        (

                            tokenPriceInitial_ +(tokenPriceIncremental_ * (_tokenSupply/1e18))

                        )-tokenPriceIncremental_

                    )*(tokens_ - 1e18)

                ),(tokenPriceIncremental_*((tokens_**2-tokens_)/1e18))/2

            )

        /1e18);

        return _etherReceived;

    }

    

    

    function sqrt(uint x) internal pure returns (uint y) {

        uint z = (x + 1) / 2;

        y = x;

        while (z < y) {

            y = z;

            z = (x / z + z) / 2;

        }

    }

}



/**

 * @title SafeMath

 * @dev Math operations with safety checks that throw on error

 */

library SafeMath {



    /**

    * @dev Multiplies two numbers, throws on overflow.

    */

    function mul(uint256 a, uint256 b) internal pure returns (uint256) {

        if (a == 0) {

            return 0;

        }

        uint256 c = a * b;

        assert(c / a == b);

        return c;

    }



    /**

    * @dev Integer division of two numbers, truncating the quotient.

    */

    function div(uint256 a, uint256 b) internal pure returns (uint256) {

        // assert(b > 0); // Solidity automatically throws when dividing by 0

        uint256 c = a / b;

        // assert(a == b * c + a % b); // There is no case in which this doesn't hold

        return c;

    }



    /**

    * @dev Substracts two numbers, throws on overflow (i.e. if subtrahend is greater than minuend).

    */

    function sub(uint256 a, uint256 b) internal pure returns (uint256) {

        assert(b <= a);

        return a - b;

    }



    /**

    * @dev Adds two numbers, throws on overflow.

    */

    function add(uint256 a, uint256 b) internal pure returns (uint256) {

        uint256 c = a + b;

        assert(c >= a);

        return c;

    }

}