// Abstract contract for the full ERC 20 Token standard

// https://github.com/ethereum/EIPs/issues/20

pragma solidity ^0.4.15;



contract Token {

    /* This is a slight change to the ERC20 base standard.*/

    /// total amount of tokens

    uint256 public totalSupply;



    /// @param _owner The address from which the balance will be retrieved

    /// @return The balance

    function balanceOf(address _owner) public constant returns (uint256 balance);



    /// @notice send `_value` token to `_to` from `msg.sender`

    /// @param _to The address of the recipient

    /// @param _value The amount of token to be transferred

    /// @return Whether the transfer was successful or not

    function transfer(address _to, uint256 _value) public returns (bool success);



    /// @notice send `_value` token to `_to` from `_from` on the condition it is approved by `_from`

    /// @param _from The address of the sender

    /// @param _to The address of the recipient

    /// @param _value The amount of token to be transferred

    /// @return Whether the transfer was successful or not

    function transferFrom(address _from, address _to, uint256 _value) public returns (bool success);



    /// @notice `msg.sender` approves `_spender` to spend `_value` tokens

    /// @param _spender The address of the account able to transfer the tokens

    /// @param _value The amount of tokens to be approved for transfer

    /// @return Whether the approval was successful or not

    function approve(address _spender, uint256 _value) public returns (bool success);



    /// @param _owner The address of the account owning tokens

    /// @param _spender The address of the account able to transfer the tokens

    /// @return Amount of remaining tokens allowed to spent

    function allowance(address _owner, address _spender) public constant returns (uint256 remaining);



    event Transfer(address indexed _from, address indexed _to, uint256 _value);

    event Approval(address indexed _owner, address indexed _spender, uint256 _value);

}





contract StandardToken is Token {



    function transfer(address _to, uint256 _value) public returns (bool success) {

        //Default assumes totalSupply can't be over max (2^256 - 1).

        //If your token leaves out totalSupply and can issue more tokens as time goes on, you need to check if it doesn't wrap.

        //Replace the if with this one instead.

        if (balances[msg.sender] >= _value && balances[_to] + _value > balances[_to]) {

            balances[msg.sender] -= _value;

            balances[_to] += _value;

            Transfer(msg.sender, _to, _value);

            return true;

        } else { return false; }

    }



    function transferFrom(address _from, address _to, uint256 _value) public returns (bool success) {

        //same as above. Replace this line with the following if you want to protect against wrapping uints.

        if (balances[_from] >= _value && allowed[_from][msg.sender] >= _value && balances[_to] + _value > balances[_to]) {

            balances[_to] += _value;

            balances[_from] -= _value;

            allowed[_from][msg.sender] -= _value;

            Transfer(_from, _to, _value);

            return true;

        } else { return false; }

    }



    function balanceOf(address _owner) public constant returns (uint256 balance) {

        return balances[_owner];

    }



    function approve(address _spender, uint256 _value) public returns (bool success) {

        allowed[msg.sender][_spender] = _value;

        Approval(msg.sender, _spender, _value);

        return true;

    }



    function allowance(address _owner, address _spender) public constant returns (uint256 remaining) {

      return allowed[_owner][_spender];

    }



    mapping (address => uint256) balances;

    mapping (address => mapping (address => uint256)) allowed;

}



contract SMART is StandardToken {



    function () public payable {

        require(msg.value > 0 && receivedWei < targetWei);

        require(now > releaseTime);

        receivedWei += msg.value;

        walletAddress.transfer(msg.value);

        NewSale(msg.sender, msg.value);

        assert(receivedWei >= msg.value);

    }



    string public name = "SmartMesh Token";                   //fancy name

    uint8 public decimals = 18;                //How many decimals to show. ie. There could 1000 base units with 3 decimals. Meaning 0.980 SBX = 980 base units. It's like comparing 1 wei to 1 ether.

    string public symbol = "SMART";                 //An identifier

    string public version = 'v0.1';       //SMART 0.1 standard. Just an arbitrary versioning scheme.



    address public founder; // The address of the founder

    uint256 public targetWei;// The target eth of ico

    uint256 public receivedWei;//The received nummber of eth

    uint256 public releaseTime;//The start time of ico

    uint256 public allocateEndTime;

    address public walletAddress;//Address of wallet



    event NewSale(address indexed _from, uint256 _amount);

    

    

    // The nonce for avoid transfer replay attacks

    mapping(address => uint256) nonces;



    function SMART(address _walletAddress) public {

        founder = msg.sender;

        walletAddress = _walletAddress;

        releaseTime = 1511917200;

        allocateEndTime = releaseTime + 37 days;

        targetWei = 3900 ether;

    }



    /*

     * Proxy transfer SMART token. When some users of the ethereum account has no ether,

     * he or she can authorize the agent for broadcast transactions, and agents may charge agency fees

     * @param _from

     * @param _to

     * @param _value

     * @param feeSmart

     * @param _v

     * @param _r

     * @param _s

     */

    function transferProxy(address _from, address _to, uint256 _value, uint256 _feeSmart,

        uint8 _v,bytes32 _r, bytes32 _s) public returns (bool){



        if(balances[_from] < _feeSmart + _value) revert();



        uint256 nonce = nonces[_from];

        bytes32 h = keccak256(_from,_to,_value,_feeSmart,nonce);

        if(_from != ecrecover(h,_v,_r,_s)) revert();



        if(balances[_to] + _value < balances[_to]

            || balances[msg.sender] + _feeSmart < balances[msg.sender]) revert();

        balances[_to] += _value;

        Transfer(_from, _to, _value);



        balances[msg.sender] += _feeSmart;

        Transfer(_from, msg.sender, _feeSmart);



        balances[_from] -= _value + _feeSmart;

        nonces[_from] = nonce + 1;

        return true;

    }



    /*

     * Proxy approve that some one can authorize the agent for broadcast transaction

     * which call approve method, and agents may charge agency fees

     * @param _from The address which should tranfer SMART to others

     * @param _spender The spender who allowed by _from

     * @param _value The value that should be tranfered.

     * @param _v

     * @param _r

     * @param _s

     */

    function approveProxy(address _from, address _spender, uint256 _value,

        uint8 _v,bytes32 _r, bytes32 _s) public returns (bool success) {



        uint256 nonce = nonces[_from];

        bytes32 hash = keccak256(_from,_spender,_value,nonce);

        if(_from != ecrecover(hash,_v,_r,_s)) revert();

        allowed[_from][_spender] = _value;

        Approval(_from, _spender, _value);

        nonces[_from] = nonce + 1;

        return true;

    }





    /*

     * Get the nonce

     * @param _addr

     */

    function getNonce(address _addr) public constant returns (uint256){

        return nonces[_addr];

    }



    /* Approves and then calls the receiving contract */

    function approveAndCall(address _spender, uint256 _value, bytes _extraData) public returns (bool success) {

        allowed[msg.sender][_spender] = _value;

        Approval(msg.sender, _spender, _value);



        //call the receiveApproval function on the contract you want to be notified. This crafts the function signature manually so one doesn't have to include a contract in here just for this.

        //receiveApproval(address _from, uint256 _value, address _tokenContract, bytes _extraData)

        //it is assumed that when does this that the call *should* succeed, otherwise one would use vanilla approve instead.

        if(!_spender.call(bytes4(bytes32(keccak256("receiveApproval(address,uint256,address,bytes)"))), msg.sender, _value, this, _extraData)) { revert(); }

        return true;

    }



    /* Approves and then calls the contract code*/

    function approveAndCallcode(address _spender, uint256 _value, bytes _extraData) public returns (bool success) {

        allowed[msg.sender][_spender] = _value;

        Approval(msg.sender, _spender, _value);



        //Call the contract code

        if(!_spender.call(_extraData)) { revert(); }

        return true;

    }



    // Allocate tokens to the users

    // @param _owners The owners list of the token

    // @param _values The value list of the token

    function allocateTokens(address[] _owners, uint256[] _values) public {



        if(msg.sender != founder) revert();

        if(allocateEndTime < now) revert();

        if(_owners.length != _values.length) revert();



        for(uint256 i = 0; i < _owners.length ; i++){

            address owner = _owners[i];

            uint256 value = _values[i];

            if(totalSupply + value <= totalSupply || balances[owner] + value <= balances[owner]) revert();

            totalSupply += value;

            balances[owner] += value;

        }

    }

}