pragma solidity ^0.4.24;

/*

 * -PlayerBook - v0.3.14

 * ┌┬┐┌─┐┌─┐┌┬┐   ╦╦ ╦╔═╗╔╦╗  ┌─┐┬─┐┌─┐┌─┐┌─┐┌┐┌┌┬┐┌─┐

 *  │ ├┤ ├─┤│││   ║║ ║╚═╗ ║   ├─┘├┬┘├┤ └─┐├┤ │││ │ └─┐

 *  ┴ └─┘┴ ┴┴ ┴  ╚╝╚═╝╚═╝ ╩   ┴  ┴└─└─┘└─┘└─┘┘└┘ ┴ └─┘

 *                                  _____                      _____

 *                                 (, /     /)       /) /)    (, /      /)          /)

 *          ┌─┐                      /   _ (/_      // //       /  _   // _   __  _(/

 *          ├─┤                  ___/___(/_/(__(_/_(/_(/_   ___/__/_)_(/_(_(_/ (_(_(_

 *          ┴ ┴                /   /          .-/ _____   (__ /

 *                            (__ /          (_/ (, /                                      /)™

 *                                                 /  __  __ __ __  _   __ __  _  _/_ _  _(/

 * ┌─┐┬─┐┌─┐┌┬┐┬ ┬┌─┐┌┬┐                          /__/ (_(__(_)/ (_/_)_(_)/ (_(_(_(__(/_(_(_

 * ├─┘├┬┘│ │ │││ ││   │                      (__ /              .-/  © Jekyll Island Inc. 2018

 * ┴  ┴└─└─┘─┴┘└─┘└─┘ ┴                                        (_/

 *     ______   _                                 ______                 _          

 *====(_____ \=| |===============================(____  \===============| |=============*

 *     _____) )| |  _____  _   _  _____   ____    ____)  )  ___    ___  | |  _

 *    |  ____/ | | (____ || | | || ___ | / ___)  |  __  (  / _ \  / _ \ | |_/ )

 *    | |      | | / ___ || |_| || ____|| |      | |__)  )| |_| || |_| ||  _ (

 *====|_|=======\_)\_____|=\__  ||_____)|_|======|______/==\___/==\___/=|_|=\_)=========*

 *                        (____/

 * ╔═╗┌─┐┌┐┌┌┬┐┬─┐┌─┐┌─┐┌┬┐  ╔═╗┌─┐┌┬┐┌─┐ ┌──────────┐                       

 * ║  │ ││││ │ ├┬┘├─┤│   │   ║  │ │ ││├┤  │ Inventor │                      

 * ╚═╝└─┘┘└┘ ┴ ┴└─┴ ┴└─┘ ┴   ╚═╝└─┘─┴┘└─┘ └──────────┘    

 */



interface JIincForwarderInterface {

    function deposit() external payable returns(bool);

    function status() external view returns(address, address, bool);

    function startMigration(address _newCorpBank) external returns(bool);

    function cancelMigration() external returns(bool);

    function finishMigration() external returns(bool);

    function setup(address _firstCorpBank) external;

}



interface PlayerBookReceiverInterface {

    function receivePlayerInfo(uint256 _pID, address _addr, bytes32 _name, uint256 _laff) external;

    function receivePlayerNameList(uint256 _pID, bytes32 _name) external;

}



interface TeamJustInterface {

    function requiredSignatures() external view returns(uint256);

    function requiredDevSignatures() external view returns(uint256);

    function adminCount() external view returns(uint256);

    function devCount() external view returns(uint256);

    function adminName(address _who) external view returns(bytes32);

    function isAdmin(address _who) external view returns(bool);

    function isDev(address _who) external view returns(bool);

}



contract PlayerBook {

    using NameFilter for string;

    using SafeMath for uint256;

    

    JIincForwarderInterface constant private Jekyll_Island_Inc = JIincForwarderInterface(0xdd4950F977EE28D2C132f1353D1595035Db444EE);

    TeamJustInterface constant private TeamJust = TeamJustInterface(0x464904238b5CdBdCE12722A7E6014EC1C0B66928);

    

    MSFun.Data private msData;

    function multiSigDev(bytes32 _whatFunction) private returns (bool) {return(MSFun.multiSig(msData, TeamJust.requiredDevSignatures(), _whatFunction));}

    function deleteProposal(bytes32 _whatFunction) private {MSFun.deleteProposal(msData, _whatFunction);}

    function deleteAnyProposal(bytes32 _whatFunction) onlyDevs() public {MSFun.deleteProposal(msData, _whatFunction);}

    function checkData(bytes32 _whatFunction) onlyDevs() public view returns(bytes32, uint256) {return(MSFun.checkMsgData(msData, _whatFunction), MSFun.checkCount(msData, _whatFunction));}

    function checkSignersByAddress(bytes32 _whatFunction, uint256 _signerA, uint256 _signerB, uint256 _signerC) onlyDevs() public view returns(address, address, address) {return(MSFun.checkSigner(msData, _whatFunction, _signerA), MSFun.checkSigner(msData, _whatFunction, _signerB), MSFun.checkSigner(msData, _whatFunction, _signerC));}

    function checkSignersByName(bytes32 _whatFunction, uint256 _signerA, uint256 _signerB, uint256 _signerC) onlyDevs() public view returns(bytes32, bytes32, bytes32) {return(TeamJust.adminName(MSFun.checkSigner(msData, _whatFunction, _signerA)), TeamJust.adminName(MSFun.checkSigner(msData, _whatFunction, _signerB)), TeamJust.adminName(MSFun.checkSigner(msData, _whatFunction, _signerC)));}

//==============================================================================

//     _| _ _|_ _    _ _ _|_    _   .

//    (_|(_| | (_|  _\(/_ | |_||_)  .

//=============================|================================================    

    uint256 public registrationFee_ = 10 finney;            // price to register a name

    mapping(uint256 => PlayerBookReceiverInterface) public games_;  // mapping of our game interfaces for sending your account info to games

    mapping(address => bytes32) public gameNames_;          // lookup a games name

    mapping(address => uint256) public gameIDs_;            // lokup a games ID

    uint256 public gID_;        // total number of games

    uint256 public pID_;        // total number of players

    mapping (address => uint256) public pIDxAddr_;          // (addr => pID) returns player id by address

    mapping (bytes32 => uint256) public pIDxName_;          // (name => pID) returns player id by name

    mapping (uint256 => Player) public plyr_;               // (pID => data) player data

    mapping (uint256 => mapping (bytes32 => bool)) public plyrNames_; // (pID => name => bool) list of names a player owns.  (used so you can change your display name amoungst any name you own)

    mapping (uint256 => mapping (uint256 => bytes32)) public plyrNameList_; // (pID => nameNum => name) list of names a player owns

    struct Player {

        address addr;

        bytes32 name;

        uint256 laff;

        uint256 names;

    }

//==============================================================================

//     _ _  _  __|_ _    __|_ _  _  .

//    (_(_)| |_\ | | |_|(_ | (_)|   .  (initial data setup upon contract deploy)

//==============================================================================    

    constructor()

        public

    {

        // premine the dev names (sorry not sorry)

            // No keys are purchased with this method, it's simply locking our addresses,

            // PID's and names for referral codes.

        plyr_[1].addr = 0x8e0d985f3Ec1857BEc39B76aAabDEa6B31B67d53;

        plyr_[1].name = "justo";

        plyr_[1].names = 1;

        pIDxAddr_[0x8e0d985f3Ec1857BEc39B76aAabDEa6B31B67d53] = 1;

        pIDxName_["justo"] = 1;

        plyrNames_[1]["justo"] = true;

        plyrNameList_[1][1] = "justo";

        

        plyr_[2].addr = 0x8b4DA1827932D71759687f925D17F81Fc94e3A9D;

        plyr_[2].name = "mantso";

        plyr_[2].names = 1;

        pIDxAddr_[0x8b4DA1827932D71759687f925D17F81Fc94e3A9D] = 2;

        pIDxName_["mantso"] = 2;

        plyrNames_[2]["mantso"] = true;

        plyrNameList_[2][1] = "mantso";

        

        plyr_[3].addr = 0x7ac74Fcc1a71b106F12c55ee8F802C9F672Ce40C;

        plyr_[3].name = "sumpunk";

        plyr_[3].names = 1;

        pIDxAddr_[0x7ac74Fcc1a71b106F12c55ee8F802C9F672Ce40C] = 3;

        pIDxName_["sumpunk"] = 3;

        plyrNames_[3]["sumpunk"] = true;

        plyrNameList_[3][1] = "sumpunk";

        

        plyr_[4].addr = 0x18E90Fc6F70344f53EBd4f6070bf6Aa23e2D748C;

        plyr_[4].name = "inventor";

        plyr_[4].names = 1;

        pIDxAddr_[0x18E90Fc6F70344f53EBd4f6070bf6Aa23e2D748C] = 4;

        pIDxName_["inventor"] = 4;

        plyrNames_[4]["inventor"] = true;

        plyrNameList_[4][1] = "inventor";

        

        pID_ = 4;

    }

//==============================================================================

//     _ _  _  _|. |`. _  _ _  .

//    | | |(_)(_||~|~|(/_| _\  .  (these are safety checks)

//==============================================================================    

    /**

     * @dev prevents contracts from interacting with fomo3d 

     */

    modifier isHuman() {

        address _addr = msg.sender;

        uint256 _codeLength;

        

        assembly {_codeLength := extcodesize(_addr)}

        require(_codeLength == 0, "sorry humans only");

        _;

    }

    

    modifier onlyDevs() 

    {

        require(TeamJust.isDev(msg.sender) == true, "msg sender is not a dev");

        _;

    }

    

    modifier isRegisteredGame()

    {

        require(gameIDs_[msg.sender] != 0);

        _;

    }

//==============================================================================

//     _    _  _ _|_ _  .

//    (/_\/(/_| | | _\  .

//==============================================================================    

    // fired whenever a player registers a name

    event onNewName

    (

        uint256 indexed playerID,

        address indexed playerAddress,

        bytes32 indexed playerName,

        bool isNewPlayer,

        uint256 affiliateID,

        address affiliateAddress,

        bytes32 affiliateName,

        uint256 amountPaid,

        uint256 timeStamp

    );

//==============================================================================

//     _  _ _|__|_ _  _ _  .

//    (_|(/_ |  | (/_| _\  . (for UI & viewing things on etherscan)

//=====_|=======================================================================

    function checkIfNameValid(string _nameStr)

        public

        view

        returns(bool)

    {

        bytes32 _name = _nameStr.nameFilter();

        if (pIDxName_[_name] == 0)

            return (true);

        else 

            return (false);

    }

//==============================================================================

//     _    |_ |. _   |`    _  __|_. _  _  _  .

//    |_)|_||_)||(_  ~|~|_|| |(_ | |(_)| |_\  .  (use these to interact with contract)

//====|=========================================================================    

    /**

     * @dev registers a name.  UI will always display the last name you registered.

     * but you will still own all previously registered names to use as affiliate 

     * links.

     * - must pay a registration fee.

     * - name must be unique

     * - names will be converted to lowercase

     * - name cannot start or end with a space 

     * - cannot have more than 1 space in a row

     * - cannot be only numbers

     * - cannot start with 0x 

     * - name must be at least 1 char

     * - max length of 32 characters long

     * - allowed characters: a-z, 0-9, and space

     * -functionhash- 0x921dec21 (using ID for affiliate)

     * -functionhash- 0x3ddd4698 (using address for affiliate)

     * -functionhash- 0x685ffd83 (using name for affiliate)

     * @param _nameString players desired name

     * @param _affCode affiliate ID, address, or name of who refered you

     * @param _all set to true if you want this to push your info to all games 

     * (this might cost a lot of gas)

     */

    function registerNameXID(string _nameString, uint256 _affCode, bool _all)

        isHuman()

        public

        payable 

    {

        // make sure name fees paid

        require (msg.value >= registrationFee_, "umm.....  you have to pay the name fee");

        

        // filter name + condition checks

        bytes32 _name = NameFilter.nameFilter(_nameString);

        

        // set up address 

        address _addr = msg.sender;

        

        // set up our tx event data and determine if player is new or not

        bool _isNewPlayer = determinePID(_addr);

        

        // fetch player id

        uint256 _pID = pIDxAddr_[_addr];

        

        // manage affiliate residuals

        // if no affiliate code was given, no new affiliate code was given, or the 

        // player tried to use their own pID as an affiliate code, lolz

        if (_affCode != 0 && _affCode != plyr_[_pID].laff && _affCode != _pID) 

        {

            // update last affiliate 

            plyr_[_pID].laff = _affCode;

        } else if (_affCode == _pID) {

            _affCode = 0;

        }

        

        // register name 

        registerNameCore(_pID, _addr, _affCode, _name, _isNewPlayer, _all);

    }

    

    function registerNameXaddr(string _nameString, address _affCode, bool _all)

        isHuman()

        public

        payable 

    {

        // make sure name fees paid

        require (msg.value >= registrationFee_, "umm.....  you have to pay the name fee");

        

        // filter name + condition checks

        bytes32 _name = NameFilter.nameFilter(_nameString);

        

        // set up address 

        address _addr = msg.sender;

        

        // set up our tx event data and determine if player is new or not

        bool _isNewPlayer = determinePID(_addr);

        

        // fetch player id

        uint256 _pID = pIDxAddr_[_addr];

        

        // manage affiliate residuals

        // if no affiliate code was given or player tried to use their own, lolz

        uint256 _affID;

        if (_affCode != address(0) && _affCode != _addr)

        {

            // get affiliate ID from aff Code 

            _affID = pIDxAddr_[_affCode];

            

            // if affID is not the same as previously stored 

            if (_affID != plyr_[_pID].laff)

            {

                // update last affiliate

                plyr_[_pID].laff = _affID;

            }

        }

        

        // register name 

        registerNameCore(_pID, _addr, _affID, _name, _isNewPlayer, _all);

    }

    

    function registerNameXname(string _nameString, bytes32 _affCode, bool _all)

        isHuman()

        public

        payable 

    {

        // make sure name fees paid

        require (msg.value >= registrationFee_, "umm.....  you have to pay the name fee");

        

        // filter name + condition checks

        bytes32 _name = NameFilter.nameFilter(_nameString);

        

        // set up address 

        address _addr = msg.sender;

        

        // set up our tx event data and determine if player is new or not

        bool _isNewPlayer = determinePID(_addr);

        

        // fetch player id

        uint256 _pID = pIDxAddr_[_addr];

        

        // manage affiliate residuals

        // if no affiliate code was given or player tried to use their own, lolz

        uint256 _affID;

        if (_affCode != "" && _affCode != _name)

        {

            // get affiliate ID from aff Code 

            _affID = pIDxName_[_affCode];

            

            // if affID is not the same as previously stored 

            if (_affID != plyr_[_pID].laff)

            {

                // update last affiliate

                plyr_[_pID].laff = _affID;

            }

        }

        

        // register name 

        registerNameCore(_pID, _addr, _affID, _name, _isNewPlayer, _all);

    }

    

    /**

     * @dev players, if you registered a profile, before a game was released, or

     * set the all bool to false when you registered, use this function to push

     * your profile to a single game.  also, if you've  updated your name, you

     * can use this to push your name to games of your choosing.

     * -functionhash- 0x81c5b206

     * @param _gameID game id 

     */

    function addMeToGame(uint256 _gameID)

        isHuman()

        public

    {

        require(_gameID <= gID_, "silly player, that game doesn't exist yet");

        address _addr = msg.sender;

        uint256 _pID = pIDxAddr_[_addr];

        require(_pID != 0, "hey there buddy, you dont even have an account");

        uint256 _totalNames = plyr_[_pID].names;

        

        // add players profile and most recent name

        games_[_gameID].receivePlayerInfo(_pID, _addr, plyr_[_pID].name, plyr_[_pID].laff);

        

        // add list of all names

        if (_totalNames > 1)

            for (uint256 ii = 1; ii <= _totalNames; ii++)

                games_[_gameID].receivePlayerNameList(_pID, plyrNameList_[_pID][ii]);

    }

    

    /**

     * @dev players, use this to push your player profile to all registered games.

     * -functionhash- 0x0c6940ea

     */

    function addMeToAllGames()

        isHuman()

        public

    {

        address _addr = msg.sender;

        uint256 _pID = pIDxAddr_[_addr];

        require(_pID != 0, "hey there buddy, you dont even have an account");

        uint256 _laff = plyr_[_pID].laff;

        uint256 _totalNames = plyr_[_pID].names;

        bytes32 _name = plyr_[_pID].name;

        

        for (uint256 i = 1; i <= gID_; i++)

        {

            games_[i].receivePlayerInfo(_pID, _addr, _name, _laff);

            if (_totalNames > 1)

                for (uint256 ii = 1; ii <= _totalNames; ii++)

                    games_[i].receivePlayerNameList(_pID, plyrNameList_[_pID][ii]);

        }

                

    }

    

    /**

     * @dev players use this to change back to one of your old names.  tip, you'll

     * still need to push that info to existing games.

     * -functionhash- 0xb9291296

     * @param _nameString the name you want to use 

     */

    function useMyOldName(string _nameString)

        isHuman()

        public 

    {

        // filter name, and get pID

        bytes32 _name = _nameString.nameFilter();

        uint256 _pID = pIDxAddr_[msg.sender];

        

        // make sure they own the name 

        require(plyrNames_[_pID][_name] == true, "umm... thats not a name you own");

        

        // update their current name 

        plyr_[_pID].name = _name;

    }

    

//==============================================================================

//     _ _  _ _   | _  _ . _  .

//    (_(_)| (/_  |(_)(_||(_  . 

//=====================_|=======================================================    

    function registerNameCore(uint256 _pID, address _addr, uint256 _affID, bytes32 _name, bool _isNewPlayer, bool _all)

        private

    {

        // if names already has been used, require that current msg sender owns the name

        if (pIDxName_[_name] != 0)

            require(plyrNames_[_pID][_name] == true, "sorry that names already taken");

        

        // add name to player profile, registry, and name book

        plyr_[_pID].name = _name;

        pIDxName_[_name] = _pID;

        if (plyrNames_[_pID][_name] == false)

        {

            plyrNames_[_pID][_name] = true;

            plyr_[_pID].names++;

            plyrNameList_[_pID][plyr_[_pID].names] = _name;

        }

        

        // registration fee goes directly to community rewards

        Jekyll_Island_Inc.deposit.value(address(this).balance)();

        

        // push player info to games

        if (_all == true)

            for (uint256 i = 1; i <= gID_; i++)

                games_[i].receivePlayerInfo(_pID, _addr, _name, _affID);

        

        // fire event

        emit onNewName(_pID, _addr, _name, _isNewPlayer, _affID, plyr_[_affID].addr, plyr_[_affID].name, msg.value, now);

    }

//==============================================================================

//    _|_ _  _ | _  .

//     | (_)(_)|_\  .

//==============================================================================    

    function determinePID(address _addr)

        private

        returns (bool)

    {

        if (pIDxAddr_[_addr] == 0)

        {

            pID_++;

            pIDxAddr_[_addr] = pID_;

            plyr_[pID_].addr = _addr;

            

            // set the new player bool to true

            return (true);

        } else {

            return (false);

        }

    }

//==============================================================================

//   _   _|_ _  _ _  _ |   _ _ || _  .

//  (/_>< | (/_| | |(_||  (_(_|||_\  .

//==============================================================================

    function getPlayerID(address _addr)

        isRegisteredGame()

        external

        returns (uint256)

    {

        determinePID(_addr);

        return (pIDxAddr_[_addr]);

    }

    function getPlayerName(uint256 _pID)

        external

        view

        returns (bytes32)

    {

        return (plyr_[_pID].name);

    }

    function getPlayerLAff(uint256 _pID)

        external

        view

        returns (uint256)

    {

        return (plyr_[_pID].laff);

    }

    function getPlayerAddr(uint256 _pID)

        external

        view

        returns (address)

    {

        return (plyr_[_pID].addr);

    }

    function getNameFee()

        external

        view

        returns (uint256)

    {

        return(registrationFee_);

    }

    function registerNameXIDFromDapp(address _addr, bytes32 _name, uint256 _affCode, bool _all)

        isRegisteredGame()

        external

        payable

        returns(bool, uint256)

    {

        // make sure name fees paid

        require (msg.value >= registrationFee_, "umm.....  you have to pay the name fee");

        

        // set up our tx event data and determine if player is new or not

        bool _isNewPlayer = determinePID(_addr);

        

        // fetch player id

        uint256 _pID = pIDxAddr_[_addr];

        

        // manage affiliate residuals

        // if no affiliate code was given, no new affiliate code was given, or the 

        // player tried to use their own pID as an affiliate code, lolz

        uint256 _affID = _affCode;

        if (_affID != 0 && _affID != plyr_[_pID].laff && _affID != _pID) 

        {

            // update last affiliate 

            plyr_[_pID].laff = _affID;

        } else if (_affID == _pID) {

            _affID = 0;

        }

        

        // register name 

        registerNameCore(_pID, _addr, _affID, _name, _isNewPlayer, _all);

        

        return(_isNewPlayer, _affID);

    }

    function registerNameXaddrFromDapp(address _addr, bytes32 _name, address _affCode, bool _all)

        isRegisteredGame()

        external

        payable

        returns(bool, uint256)

    {

        // make sure name fees paid

        require (msg.value >= registrationFee_, "umm.....  you have to pay the name fee");

        

        // set up our tx event data and determine if player is new or not

        bool _isNewPlayer = determinePID(_addr);

        

        // fetch player id

        uint256 _pID = pIDxAddr_[_addr];

        

        // manage affiliate residuals

        // if no affiliate code was given or player tried to use their own, lolz

        uint256 _affID;

        if (_affCode != address(0) && _affCode != _addr)

        {

            // get affiliate ID from aff Code 

            _affID = pIDxAddr_[_affCode];

            

            // if affID is not the same as previously stored 

            if (_affID != plyr_[_pID].laff)

            {

                // update last affiliate

                plyr_[_pID].laff = _affID;

            }

        }

        

        // register name 

        registerNameCore(_pID, _addr, _affID, _name, _isNewPlayer, _all);

        

        return(_isNewPlayer, _affID);

    }

    function registerNameXnameFromDapp(address _addr, bytes32 _name, bytes32 _affCode, bool _all)

        isRegisteredGame()

        external

        payable

        returns(bool, uint256)

    {

        // make sure name fees paid

        require (msg.value >= registrationFee_, "umm.....  you have to pay the name fee");

        

        // set up our tx event data and determine if player is new or not

        bool _isNewPlayer = determinePID(_addr);

        

        // fetch player id

        uint256 _pID = pIDxAddr_[_addr];

        

        // manage affiliate residuals

        // if no affiliate code was given or player tried to use their own, lolz

        uint256 _affID;

        if (_affCode != "" && _affCode != _name)

        {

            // get affiliate ID from aff Code 

            _affID = pIDxName_[_affCode];

            

            // if affID is not the same as previously stored 

            if (_affID != plyr_[_pID].laff)

            {

                // update last affiliate

                plyr_[_pID].laff = _affID;

            }

        }

        

        // register name 

        registerNameCore(_pID, _addr, _affID, _name, _isNewPlayer, _all);

        

        return(_isNewPlayer, _affID);

    }

    

//==============================================================================

//   _ _ _|_    _   .

//  _\(/_ | |_||_)  .

//=============|================================================================

    function addGame(address _gameAddress, string _gameNameStr)

        onlyDevs()

        public

    {

        require(gameIDs_[_gameAddress] == 0, "derp, that games already been registered");

        

        if (multiSigDev("addGame") == true)

        {deleteProposal("addGame");

            gID_++;

            bytes32 _name = _gameNameStr.nameFilter();

            gameIDs_[_gameAddress] = gID_;

            gameNames_[_gameAddress] = _name;

            games_[gID_] = PlayerBookReceiverInterface(_gameAddress);

        

            games_[gID_].receivePlayerInfo(1, plyr_[1].addr, plyr_[1].name, 0);

            games_[gID_].receivePlayerInfo(2, plyr_[2].addr, plyr_[2].name, 0);

            games_[gID_].receivePlayerInfo(3, plyr_[3].addr, plyr_[3].name, 0);

            games_[gID_].receivePlayerInfo(4, plyr_[4].addr, plyr_[4].name, 0);

        }

    }

    

    function setRegistrationFee(uint256 _fee)

        onlyDevs()

        public

    {

        if (multiSigDev("setRegistrationFee") == true)

        {deleteProposal("setRegistrationFee");

            registrationFee_ = _fee;

        }

    }

        

} 



/**

* @title -Name Filter- v0.1.9

* ┌┬┐┌─┐┌─┐┌┬┐   ╦╦ ╦╔═╗╔╦╗  ┌─┐┬─┐┌─┐┌─┐┌─┐┌┐┌┌┬┐┌─┐

*  │ ├┤ ├─┤│││   ║║ ║╚═╗ ║   ├─┘├┬┘├┤ └─┐├┤ │││ │ └─┐

*  ┴ └─┘┴ ┴┴ ┴  ╚╝╚═╝╚═╝ ╩   ┴  ┴└─└─┘└─┘└─┘┘└┘ ┴ └─┘

*                                  _____                      _____

*                                 (, /     /)       /) /)    (, /      /)          /)

*          ┌─┐                      /   _ (/_      // //       /  _   // _   __  _(/

*          ├─┤                  ___/___(/_/(__(_/_(/_(/_   ___/__/_)_(/_(_(_/ (_(_(_

*          ┴ ┴                /   /          .-/ _____   (__ /                               

*                            (__ /          (_/ (, /                                      /)™ 

*                                                 /  __  __ __ __  _   __ __  _  _/_ _  _(/

* ┌─┐┬─┐┌─┐┌┬┐┬ ┬┌─┐┌┬┐                          /__/ (_(__(_)/ (_/_)_(_)/ (_(_(_(__(/_(_(_

* ├─┘├┬┘│ │ │││ ││   │                      (__ /              .-/  © Jekyll Island Inc. 2018

* ┴  ┴└─└─┘─┴┘└─┘└─┘ ┴                                        (_/

*              _       __    _      ____      ____  _   _    _____  ____  ___  

*=============| |\ |  / /\  | |\/| | |_ =====| |_  | | | |    | |  | |_  | |_)==============*

*=============|_| \| /_/--\ |_|  | |_|__=====|_|   |_| |_|__  |_|  |_|__ |_| \==============*

*

* ╔═╗┌─┐┌┐┌┌┬┐┬─┐┌─┐┌─┐┌┬┐  ╔═╗┌─┐┌┬┐┌─┐ ┌──────────┐

* ║  │ ││││ │ ├┬┘├─┤│   │   ║  │ │ ││├┤  │ Inventor │

* ╚═╝└─┘┘└┘ ┴ ┴└─┴ ┴└─┘ ┴   ╚═╝└─┘─┴┘└─┘ └──────────┘

*/

library NameFilter {

    

    /**

     * @dev filters name strings

     * -converts uppercase to lower case.  

     * -makes sure it does not start/end with a space

     * -makes sure it does not contain multiple spaces in a row

     * -cannot be only numbers

     * -cannot start with 0x 

     * -restricts characters to A-Z, a-z, 0-9, and space.

     * @return reprocessed string in bytes32 format

     */

    function nameFilter(string _input)

        internal

        pure

        returns(bytes32)

    {

        bytes memory _temp = bytes(_input);

        uint256 _length = _temp.length;

        

        //sorry limited to 32 characters

        require (_length <= 32 && _length > 0, "string must be between 1 and 32 characters");

        // make sure it doesnt start with or end with space

        require(_temp[0] != 0x20 && _temp[_length-1] != 0x20, "string cannot start or end with space");

        // make sure first two characters are not 0x

        if (_temp[0] == 0x30)

        {

            require(_temp[1] != 0x78, "string cannot start with 0x");

            require(_temp[1] != 0x58, "string cannot start with 0X");

        }

        

        // create a bool to track if we have a non number character

        bool _hasNonNumber;

        

        // convert & check

        for (uint256 i = 0; i < _length; i++)

        {

            // if its uppercase A-Z

            if (_temp[i] > 0x40 && _temp[i] < 0x5b)

            {

                // convert to lower case a-z

                _temp[i] = byte(uint(_temp[i]) + 32);

                

                // we have a non number

                if (_hasNonNumber == false)

                    _hasNonNumber = true;

            } else {

                require

                (

                    // require character is a space

                    _temp[i] == 0x20 || 

                    // OR lowercase a-z

                    (_temp[i] > 0x60 && _temp[i] < 0x7b) ||

                    // or 0-9

                    (_temp[i] > 0x2f && _temp[i] < 0x3a),

                    "string contains invalid characters"

                );

                // make sure theres not 2x spaces in a row

                if (_temp[i] == 0x20)

                    require( _temp[i+1] != 0x20, "string cannot contain consecutive spaces");

                

                // see if we have a character other than a number

                if (_hasNonNumber == false && (_temp[i] < 0x30 || _temp[i] > 0x39))

                    _hasNonNumber = true;    

            }

        }

        

        require(_hasNonNumber == true, "string cannot be only numbers");

        

        bytes32 _ret;

        assembly {

            _ret := mload(add(_temp, 32))

        }

        return (_ret);

    }

}



/**

 * @title SafeMath v0.1.9

 * @dev Math operations with safety checks that throw on error

 * change notes:  original SafeMath library from OpenZeppelin modified by Inventor

 * - added sqrt

 * - added sq

 * - added pwr 

 * - changed asserts to requires with error log outputs

 * - removed div, its useless

 */

library SafeMath {

    

    /**

    * @dev Multiplies two numbers, throws on overflow.

    */

    function mul(uint256 a, uint256 b) 

        internal 

        pure 

        returns (uint256 c) 

    {

        if (a == 0) {

            return 0;

        }

        c = a * b;

        require(c / a == b, "SafeMath mul failed");

        return c;

    }



    /**

    * @dev Subtracts two numbers, throws on overflow (i.e. if subtrahend is greater than minuend).

    */

    function sub(uint256 a, uint256 b)

        internal

        pure

        returns (uint256) 

    {

        require(b <= a, "SafeMath sub failed");

        return a - b;

    }



    /**

    * @dev Adds two numbers, throws on overflow.

    */

    function add(uint256 a, uint256 b)

        internal

        pure

        returns (uint256 c) 

    {

        c = a + b;

        require(c >= a, "SafeMath add failed");

        return c;

    }

    

    /**

     * @dev gives square root of given x.

     */

    function sqrt(uint256 x)

        internal

        pure

        returns (uint256 y) 

    {

        uint256 z = ((add(x,1)) / 2);

        y = x;

        while (z < y) 

        {

            y = z;

            z = ((add((x / z),z)) / 2);

        }

    }

    

    /**

     * @dev gives square. multiplies x by x

     */

    function sq(uint256 x)

        internal

        pure

        returns (uint256)

    {

        return (mul(x,x));

    }

    

    /**

     * @dev x to the power of y 

     */

    function pwr(uint256 x, uint256 y)

        internal 

        pure 

        returns (uint256)

    {

        if (x==0)

            return (0);

        else if (y==0)

            return (1);

        else 

        {

            uint256 z = x;

            for (uint256 i=1; i < y; i++)

                z = mul(z,x);

            return (z);

        }

    }

}



/** @title -MSFun- v0.2.4

 * ┌┬┐┌─┐┌─┐┌┬┐   ╦╦ ╦╔═╗╔╦╗  ┌─┐┬─┐┌─┐┌─┐┌─┐┌┐┌┌┬┐┌─┐

 *  │ ├┤ ├─┤│││   ║║ ║╚═╗ ║   ├─┘├┬┘├┤ └─┐├┤ │││ │ └─┐

 *  ┴ └─┘┴ ┴┴ ┴  ╚╝╚═╝╚═╝ ╩   ┴  ┴└─└─┘└─┘└─┘┘└┘ ┴ └─┘

 *                                  _____                      _____

 *                                 (, /     /)       /) /)    (, /      /)          /)

 *          ┌─┐                      /   _ (/_      // //       /  _   // _   __  _(/

 *          ├─┤                  ___/___(/_/(__(_/_(/_(/_   ___/__/_)_(/_(_(_/ (_(_(_

 *          ┴ ┴                /   /          .-/ _____   (__ /                               

 *                            (__ /          (_/ (, /                                      /)™ 

 *                                                 /  __  __ __ __  _   __ __  _  _/_ _  _(/

 * ┌─┐┬─┐┌─┐┌┬┐┬ ┬┌─┐┌┬┐                          /__/ (_(__(_)/ (_/_)_(_)/ (_(_(_(__(/_(_(_

 * ├─┘├┬┘│ │ │││ ││   │                      (__ /              .-/  © Jekyll Island Inc. 2018

 * ┴  ┴└─└─┘─┴┘└─┘└─┘ ┴                                        (_/

 *  _           _             _  _  _  _             _  _  _  _  _                                      

 *=(_) _     _ (_)==========_(_)(_)(_)(_)_==========(_)(_)(_)(_)(_)================================*

 * (_)(_)   (_)(_)         (_)          (_)         (_)       _         _    _  _  _  _                 

 * (_) (_)_(_) (_)         (_)_  _  _  _            (_) _  _ (_)       (_)  (_)(_)(_)(_)_               

 * (_)   (_)   (_)           (_)(_)(_)(_)_          (_)(_)(_)(_)       (_)  (_)        (_)              

 * (_)         (_)  _  _    _           (_)  _  _   (_)      (_)       (_)  (_)        (_)  _  _        

 *=(_)=========(_)=(_)(_)==(_)_  _  _  _(_)=(_)(_)==(_)======(_)_  _  _(_)_ (_)========(_)=(_)(_)==*

 * (_)         (_) (_)(_)    (_)(_)(_)(_)   (_)(_)  (_)        (_)(_)(_) (_)(_)        (_) (_)(_)

 *

 * ╔═╗┌─┐┌┐┌┌┬┐┬─┐┌─┐┌─┐┌┬┐  ╔═╗┌─┐┌┬┐┌─┐ ┌──────────┐

 * ║  │ ││││ │ ├┬┘├─┤│   │   ║  │ │ ││├┤  │ Inventor │

 * ╚═╝└─┘┘└┘ ┴ ┴└─┴ ┴└─┘ ┴   ╚═╝└─┘─┴┘└─┘ └──────────┘

 *  

 *         ┌──────────────────────────────────────────────────────────────────────┐

 *         │ MSFun, is an importable library that gives your contract the ability │

 *         │ add multiSig requirement to functions.                               │

 *         └──────────────────────────────────────────────────────────────────────┘

 *                                ┌────────────────────┐

 *                                │ Setup Instructions │

 *                                └────────────────────┘

 * (Step 1) import the library into your contract

 * 

 *    import "./MSFun.sol";

 *

 * (Step 2) set up the signature data for msFun

 * 

 *     MSFun.Data private msData;

 *                                ┌────────────────────┐

 *                                │ Usage Instructions │

 *                                └────────────────────┘

 * at the beginning of a function

 * 

 *     function functionName() 

 *     {

 *         if (MSFun.multiSig(msData, required signatures, "functionName") == true)

 *         {

 *             MSFun.deleteProposal(msData, "functionName");

 * 

 *             // put function body here 

 *         }

 *     }

 *                           ┌────────────────────────────────┐

 *                           │ Optional Wrappers For TeamJust │

 *                           └────────────────────────────────┘

 * multiSig wrapper function (cuts down on inputs, improves readability)

 * this wrapper is HIGHLY recommended

 * 

 *     function multiSig(bytes32 _whatFunction) private returns (bool) {return(MSFun.multiSig(msData, TeamJust.requiredSignatures(), _whatFunction));}

 *     function multiSigDev(bytes32 _whatFunction) private returns (bool) {return(MSFun.multiSig(msData, TeamJust.requiredDevSignatures(), _whatFunction));}

 *

 * wrapper for delete proposal (makes code cleaner)

 *     

 *     function deleteProposal(bytes32 _whatFunction) private {MSFun.deleteProposal(msData, _whatFunction);}

 *                             ┌────────────────────────────┐

 *                             │ Utility & Vanity Functions │

 *                             └────────────────────────────┘

 * delete any proposal is highly recommended.  without it, if an admin calls a multiSig

 * function, with argument inputs that the other admins do not agree upon, the function

 * can never be executed until the undesirable arguments are approved.

 * 

 *     function deleteAnyProposal(bytes32 _whatFunction) onlyDevs() public {MSFun.deleteProposal(msData, _whatFunction);}

 * 

 * for viewing who has signed a proposal & proposal data

 *     

 *     function checkData(bytes32 _whatFunction) onlyAdmins() public view returns(bytes32, uint256) {return(MSFun.checkMsgData(msData, _whatFunction), MSFun.checkCount(msData, _whatFunction));}

 *

 * lets you check address of up to 3 signers (address)

 * 

 *     function checkSignersByAddress(bytes32 _whatFunction, uint256 _signerA, uint256 _signerB, uint256 _signerC) onlyAdmins() public view returns(address, address, address) {return(MSFun.checkSigner(msData, _whatFunction, _signerA), MSFun.checkSigner(msData, _whatFunction, _signerB), MSFun.checkSigner(msData, _whatFunction, _signerC));}

 *

 * same as above but will return names in string format.

 *

 *     function checkSignersByName(bytes32 _whatFunction, uint256 _signerA, uint256 _signerB, uint256 _signerC) onlyAdmins() public view returns(bytes32, bytes32, bytes32) {return(TeamJust.adminName(MSFun.checkSigner(msData, _whatFunction, _signerA)), TeamJust.adminName(MSFun.checkSigner(msData, _whatFunction, _signerB)), TeamJust.adminName(MSFun.checkSigner(msData, _whatFunction, _signerC)));}

 *                             ┌──────────────────────────┐

 *                             │ Functions In Depth Guide │

 *                             └──────────────────────────┘

 * In the following examples, the Data is the proposal set for this library.  And

 * the bytes32 is the name of the function.

 *

 * MSFun.multiSig(Data, uint256, bytes32) - Manages creating/updating multiSig 

 *      proposal for the function being called.  The uint256 is the required 

 *      number of signatures needed before the multiSig will return true.  

 *      Upon first call, multiSig will create a proposal and store the arguments 

 *      passed with the function call as msgData.  Any admins trying to sign the 

 *      function call will need to send the same argument values. Once required

 *      number of signatures is reached this will return a bool of true.

 * 

 * MSFun.deleteProposal(Data, bytes32) - once multiSig unlocks the function body,

 *      you will want to delete the proposal data.  This does that.

 *

 * MSFun.checkMsgData(Data, bytes32) - checks the message data for any given proposal 

 * 

 * MSFun.checkCount(Data, bytes32) - checks the number of admins that have signed

 *      the proposal 

 * 

 * MSFun.checkSigners(data, bytes32, uint256) - checks the address of a given signer.

 *      the uint256, is the log number of the signer (ie 1st signer, 2nd signer)

 */



library MSFun {

    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

    // DATA SETS

    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

    // contact data setup

    struct Data 

    {

        mapping (bytes32 => ProposalData) proposal_;

    }

    struct ProposalData 

    {

        // a hash of msg.data 

        bytes32 msgData;

        // number of signers

        uint256 count;

        // tracking of wither admins have signed

        mapping (address => bool) admin;

        // list of admins who have signed

        mapping (uint256 => address) log;

    }

    

    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

    // MULTI SIG FUNCTIONS

    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

    function multiSig(Data storage self, uint256 _requiredSignatures, bytes32 _whatFunction)

        internal

        returns(bool) 

    {

        // our proposal key will be a hash of our function name + our contracts address 

        // by adding our contracts address to this, we prevent anyone trying to circumvent

        // the proposal's security via external calls.

        bytes32 _whatProposal = whatProposal(_whatFunction);

        

        // this is just done to make the code more readable.  grabs the signature count

        uint256 _currentCount = self.proposal_[_whatProposal].count;

        

        // store the address of the person sending the function call.  we use msg.sender 

        // here as a layer of security.  in case someone imports our contract and tries to 

        // circumvent function arguments.  still though, our contract that imports this

        // library and calls multisig, needs to use onlyAdmin modifiers or anyone who

        // calls the function will be a signer. 

        address _whichAdmin = msg.sender;

        

        // prepare our msg data.  by storing this we are able to verify that all admins

        // are approving the same argument input to be executed for the function.  we hash 

        // it and store in bytes32 so its size is known and comparable

        bytes32 _msgData = keccak256(msg.data);

        

        // check to see if this is a new execution of this proposal or not

        if (_currentCount == 0)

        {

            // if it is, lets record the original signers data

            self.proposal_[_whatProposal].msgData = _msgData;

            

            // record original senders signature

            self.proposal_[_whatProposal].admin[_whichAdmin] = true;        

            

            // update log (used to delete records later, and easy way to view signers)

            // also useful if the calling function wants to give something to a 

            // specific signer.  

            self.proposal_[_whatProposal].log[_currentCount] = _whichAdmin;  

            

            // track number of signatures

            self.proposal_[_whatProposal].count += 1;  

            

            // if we now have enough signatures to execute the function, lets

            // return a bool of true.  we put this here in case the required signatures

            // is set to 1.

            if (self.proposal_[_whatProposal].count == _requiredSignatures) {

                return(true);

            }            

        // if its not the first execution, lets make sure the msgData matches

        } else if (self.proposal_[_whatProposal].msgData == _msgData) {

            // msgData is a match

            // make sure admin hasnt already signed

            if (self.proposal_[_whatProposal].admin[_whichAdmin] == false) 

            {

                // record their signature

                self.proposal_[_whatProposal].admin[_whichAdmin] = true;        

                

                // update log (used to delete records later, and easy way to view signers)

                self.proposal_[_whatProposal].log[_currentCount] = _whichAdmin;  

                

                // track number of signatures

                self.proposal_[_whatProposal].count += 1;  

            }

            

            // if we now have enough signatures to execute the function, lets

            // return a bool of true.

            // we put this here for a few reasons.  (1) in normal operation, if 

            // that last recorded signature got us to our required signatures.  we 

            // need to return bool of true.  (2) if we have a situation where the 

            // required number of signatures was adjusted to at or lower than our current 

            // signature count, by putting this here, an admin who has already signed,

            // can call the function again to make it return a true bool.  but only if

            // they submit the correct msg data

            if (self.proposal_[_whatProposal].count == _requiredSignatures) {

                return(true);

            }

        }

    }

    

    

    // deletes proposal signature data after successfully executing a multiSig function

    function deleteProposal(Data storage self, bytes32 _whatFunction)

        internal

    {

        //done for readability sake

        bytes32 _whatProposal = whatProposal(_whatFunction);

        address _whichAdmin;

        

        //delete the admins votes & log.   i know for loops are terrible.  but we have to do this 

        //for our data stored in mappings.  simply deleting the proposal itself wouldn't accomplish this.

        for (uint256 i=0; i < self.proposal_[_whatProposal].count; i++) {

            _whichAdmin = self.proposal_[_whatProposal].log[i];

            delete self.proposal_[_whatProposal].admin[_whichAdmin];

            delete self.proposal_[_whatProposal].log[i];

        }

        //delete the rest of the data in the record

        delete self.proposal_[_whatProposal];

    }

    

    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

    // HELPER FUNCTIONS

    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^



    function whatProposal(bytes32 _whatFunction)

        private

        view

        returns(bytes32)

    {

        return(keccak256(abi.encodePacked(_whatFunction,this)));

    }

    

    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

    // VANITY FUNCTIONS

    //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

    // returns a hashed version of msg.data sent by original signer for any given function

    function checkMsgData (Data storage self, bytes32 _whatFunction)

        internal

        view

        returns (bytes32 msg_data)

    {

        bytes32 _whatProposal = whatProposal(_whatFunction);

        return (self.proposal_[_whatProposal].msgData);

    }

    

    // returns number of signers for any given function

    function checkCount (Data storage self, bytes32 _whatFunction)

        internal

        view

        returns (uint256 signature_count)

    {

        bytes32 _whatProposal = whatProposal(_whatFunction);

        return (self.proposal_[_whatProposal].count);

    }

    

    // returns address of an admin who signed for any given function

    function checkSigner (Data storage self, bytes32 _whatFunction, uint256 _signer)

        internal

        view

        returns (address signer)

    {

        require(_signer > 0, "MSFun checkSigner failed - 0 not allowed");

        bytes32 _whatProposal = whatProposal(_whatFunction);

        return (self.proposal_[_whatProposal].log[_signer - 1]);

    }

}