pragma solidity ^0.4.18;



library SafeMath {

    function add(uint a, uint b) internal pure returns (uint c) {

        c = a + b;

        require(c >= a);

    }

    function sub(uint a, uint b) internal pure returns (uint c) {

        require(b <= a);

        c = a - b;

    }

    function mul(uint a, uint b) internal pure returns (uint c) {

        c = a * b;

        require(a == 0 || c / a == b);

    }

    function div(uint a, uint b) internal pure returns (uint c) {

        require(b > 0);

        c = a / b;

    }

}





// ----------------------------------------------------------------------------

// ERC Token Standard #20 Interface

// https://github.com/ethereum/EIPs/blob/master/EIPS/eip-20.md

// ----------------------------------------------------------------------------

contract ERC20Interface {

    function totalSupply() public constant returns (uint);

    function balanceOf(address tokenOwner) public constant returns (uint balance);

    function allowance(address tokenOwner, address spender) public constant returns (uint remaining);

    function transfer(address to, uint tokens) public returns (bool success);

    function approve(address spender, uint tokens) public returns (bool success);

    function transferFrom(address from, address to, uint tokens) public returns (bool success);



    event Transfer(address indexed from, address indexed to, uint tokens);

    event Approval(address indexed tokenOwner, address indexed spender, uint tokens);

}





// ----------------------------------------------------------------------------

// Contract function to receive approval and execute function in one call

//

// Borrowed from MiniMeToken

// ----------------------------------------------------------------------------

contract ApproveAndCallFallBack {

    function receiveApproval(address from, uint256 tokens, address token, bytes data) public;

}





// ----------------------------------------------------------------------------

// Owned contract

// ----------------------------------------------------------------------------

contract Owned {

    address public owner;

    address public newOwner;



    event OwnershipTransferred(address indexed _from, address indexed _to);



    function Owned() public {

        owner = msg.sender;

    }



    modifier onlyOwner {

        require(msg.sender == owner);

        _;

    }



    function transferOwnership(address _newOwner) public onlyOwner {

        newOwner = _newOwner;

    }

    function acceptOwnership() public {

        require(msg.sender == newOwner);

        OwnershipTransferred(owner, newOwner);

        owner = newOwner;

        newOwner = address(0);

    }

}





// ----------------------------------------------------------------------------

// ERC20 Token, with the addition of symbol, name and decimals and a

// fixed supply

// ----------------------------------------------------------------------------

contract RyToken is ERC20Interface, Owned {

    using SafeMath for uint;



    string public symbol;

    string public  name;

    uint8 public decimals;

    uint _totalSupply;



    mapping(address => uint) balances;

    mapping(address => mapping(address => uint)) allowed;





    // ------------------------------------------------------------------------

    // Constructor

    // ------------------------------------------------------------------------

    function RyToken() public {

        symbol = "RY";

        name = "RYToken";

        decimals = 18;

        _totalSupply = 500000000 * 10**uint(decimals);

        balances[owner] = _totalSupply;

        Transfer(address(0), owner, _totalSupply);

    }





    // ------------------------------------------------------------------------

    // Total supply

    // ------------------------------------------------------------------------

    function totalSupply() public view returns (uint) {

        return _totalSupply.sub(balances[address(0)]);

    }





    // ------------------------------------------------------------------------

    // Get the token balance for account `tokenOwner`

    // ------------------------------------------------------------------------

    function balanceOf(address tokenOwner) public view returns (uint balance) {

        return balances[tokenOwner];

    }





    // ------------------------------------------------------------------------

    // Transfer the balance from token owner's account to `to` account

    // - Owner's account must have sufficient balance to transfer

    // - 0 value transfers are allowed

    // ------------------------------------------------------------------------

    function transfer(address to, uint tokens) public returns (bool success) {

        balances[msg.sender] = balances[msg.sender].sub(tokens);

        balances[to] = balances[to].add(tokens);

        Transfer(msg.sender, to, tokens);

        return true;

    }





    // ------------------------------------------------------------------------

    // Token owner can approve for `spender` to transferFrom(...) `tokens`

    // from the token owner's account

    //

    // https://github.com/ethereum/EIPs/blob/master/EIPS/eip-20-token-standard.md

    // recommends that there are no checks for the approval double-spend attack

    // as this should be implemented in user interfaces 

    // ------------------------------------------------------------------------

    function approve(address spender, uint tokens) public returns (bool success) {

        allowed[msg.sender][spender] = tokens;

        Approval(msg.sender, spender, tokens);

        return true;

    }





    // ------------------------------------------------------------------------

    // Transfer `tokens` from the `from` account to the `to` account

    // 

    // The calling account must already have sufficient tokens approve(...)-d

    // for spending from the `from` account and

    // - From account must have sufficient balance to transfer

    // - Spender must have sufficient allowance to transfer

    // - 0 value transfers are allowed

    // ------------------------------------------------------------------------

    function transferFrom(address from, address to, uint tokens) public returns (bool success) {

        balances[from] = balances[from].sub(tokens);

        allowed[from][msg.sender] = allowed[from][msg.sender].sub(tokens);

        balances[to] = balances[to].add(tokens);

        Transfer(from, to, tokens);

        return true;

    }





    // ------------------------------------------------------------------------

    // Returns the amount of tokens approved by the owner that can be

    // transferred to the spender's account

    // ------------------------------------------------------------------------

    function allowance(address tokenOwner, address spender) public view returns (uint remaining) {

        return allowed[tokenOwner][spender];

    }





    // ------------------------------------------------------------------------

    // Token owner can approve for `spender` to transferFrom(...) `tokens`

    // from the token owner's account. The `spender` contract function

    // `receiveApproval(...)` is then executed

    // ------------------------------------------------------------------------

    function approveAndCall(address spender, uint tokens, bytes data) public returns (bool success) {

        allowed[msg.sender][spender] = tokens;

        Approval(msg.sender, spender, tokens);

        ApproveAndCallFallBack(spender).receiveApproval(msg.sender, tokens, this, data);

        return true;

    }





    // ------------------------------------------------------------------------

    // Don't accept ETH

    // ------------------------------------------------------------------------

    function () public payable {

        revert();

    }





    // ------------------------------------------------------------------------

    // Owner can transfer out any accidentally sent ERC20 tokens

    // ------------------------------------------------------------------------

    function transferAnyERC20Token(address tokenAddress, uint tokens) public onlyOwner returns (bool success) {

        return ERC20Interface(tokenAddress).transfer(owner, tokens);

    }

}



interface token {

    function transfer(address receiver, uint amount) external;

}



contract Crowdsale {

    address public beneficiary;

    uint public fundingGoal;

    uint public amountRaised;

    uint public deadline;

    uint public price;

    token public tokenReward;

    mapping(address => uint256) public balanceOf;

    bool fundingGoalReached = false;

    bool crowdsaleClosed = false;

    uint8 public decimals;



    event GoalReached(address recipient, uint totalAmountRaised);

    event FundTransfer(address backer, uint amount, bool isContribution);



    function Crowdsale(

        address ifSuccessfulSendTo,

        uint fundingGoalInEthers,

        uint durationInMinutes,

        uint etherCostOfEachToken,

        address addressOfTokenUsedAsReward

    ) public {

        beneficiary = ifSuccessfulSendTo;

        fundingGoal = fundingGoalInEthers * 1 ether;

        deadline = now + durationInMinutes * 1 minutes;

        price = etherCostOfEachToken * 1 ether;

        tokenReward = token(addressOfTokenUsedAsReward);

        decimals = 18;

    }



    /**

     * Fallback function

     *

     * The function without name is the default function that is called whenever anyone sends funds to a contract

     */

    function () payable public {

        require(!crowdsaleClosed);

        uint amount = msg.value;

        balanceOf[msg.sender] += amount;

        amountRaised += amount;

        tokenReward.transfer(msg.sender, (amount / price) * 10**uint(decimals) );

        FundTransfer(msg.sender, amount, true);

    }



    modifier afterDeadline() { if (now >= deadline) _; }



    /**

     * Check if goal was reached

     *

     * Checks if the goal or time limit has been reached and ends the campaign

     */

    function checkGoalReached() public afterDeadline {

        if (amountRaised >= fundingGoal){

            fundingGoalReached = true;

            GoalReached(beneficiary, amountRaised);

        }

        crowdsaleClosed = true;

    }





    /**

     * Withdraw the funds

     *

     * Checks to see if goal or time limit has been reached, and if so, and the funding goal was reached,

     * sends the entire amount to the beneficiary. If goal was not reached, each contributor can withdraw

     * the amount they contributed.

     */

    function safeWithdrawal() public afterDeadline {

        if (!fundingGoalReached) {

            uint amount = balanceOf[msg.sender];

            balanceOf[msg.sender] = 0;

            if (amount > 0) {

                if (msg.sender.send(amount)) {

                   FundTransfer(msg.sender, amount, false);

                } else {

                    balanceOf[msg.sender] = amount;

                }

            }

        }



        if (fundingGoalReached && beneficiary == msg.sender) {

            if (beneficiary.send(amountRaised)) {

               FundTransfer(beneficiary, amountRaised, false);

            } else {

                //If we fail to send the funds to beneficiary, unlock funders balance

                fundingGoalReached = false;

            }

        }

    }



    function getDeadline() public view returns (uint){

        return deadline;

    }



    function getFundingGoal() public view returns (uint){

        return fundingGoal;

    } 



    function getamountRaised() public view returns (uint){

        return amountRaised;

    } 



}