pragma solidity ^0.4.20;



contract AccessAdmin {

    bool public isPaused = false;

    address public addrAdmin;  



    event AdminTransferred(address indexed preAdmin, address indexed newAdmin);



    function AccessAdmin() public {

        addrAdmin = msg.sender;

    }  





    modifier onlyAdmin() {

        require(msg.sender == addrAdmin);

        _;

    }



    modifier whenNotPaused() {

        require(!isPaused);

        _;

    }



    modifier whenPaused {

        require(isPaused);

        _;

    }



    function setAdmin(address _newAdmin) external onlyAdmin {

        require(_newAdmin != address(0));

        AdminTransferred(addrAdmin, _newAdmin);

        addrAdmin = _newAdmin;

    }



    function doPause() external onlyAdmin whenNotPaused {

        isPaused = true;

    }



    function doUnpause() external onlyAdmin whenPaused {

        isPaused = false;

    }

}





contract AccessService is AccessAdmin {

    address public addrService;

    address public addrFinance;



    modifier onlyService() {

        require(msg.sender == addrService);

        _;

    }



    modifier onlyFinance() {

        require(msg.sender == addrFinance);

        _;

    }



    function setService(address _newService) external {

        require(msg.sender == addrService || msg.sender == addrAdmin);

        require(_newService != address(0));

        addrService = _newService;

    }



    function setFinance(address _newFinance) external {

        require(msg.sender == addrFinance || msg.sender == addrAdmin);

        require(_newFinance != address(0));

        addrFinance = _newFinance;

    }



    function withdraw(address _target, uint256 _amount) 

        external 

    {

        require(msg.sender == addrFinance || msg.sender == addrAdmin);

        require(_amount > 0);

        address receiver = _target == address(0) ? addrFinance : _target;

        uint256 balance = this.balance;

        if (_amount < balance) {

            receiver.transfer(_amount);

        } else {

            receiver.transfer(this.balance);

        }      

    }

}



interface tokenRecipient { 

    function receiveApproval(address _from, uint256 _value, address _token, bytes _extraData) external;

}



contract TokenTycoonIGO is AccessService {

    uint8 public decimals = 18;

    uint256 public totalSupply = 850 * (10 ** uint256(decimals));

    string public name = "Token Tycoon Coin";

    string public symbol = "TTC";

    bytes32 private emptyHash;



    mapping (address => uint256) balances;

    mapping (address => mapping(address => uint256)) allowed;

    mapping (address => string) addressToAccount;

    mapping (bytes32 => address) accHashToAddress;

    



    event Transfer(address indexed _from, address indexed _to, uint256 _value);

    event Approval(address indexed _owner, address indexed _spender, uint256 _value);

    event BuyIGO(address indexed _from, string _account, uint256 _ethVal, uint256 _tthVal);



    function TokenTycoonIGO() public {

        addrAdmin = msg.sender;

        addrService = msg.sender;

        addrFinance = msg.sender;



        balances[this] = totalSupply;

        emptyHash = keccak256("");

    }



    function() external payable {



    }



    function balanceOf(address _owner) external view returns (uint256) {

        return balances[_owner];

    }



    function approve(address _spender, uint256 _value) public returns (bool) {

        allowed[msg.sender][_spender] = _value;

        Approval(msg.sender, _spender, _value);

        return true;

    }



    function allowance(address _owner, address _spender) external view returns (uint256) {

        return allowed[_owner][_spender];

    }



    function transferFrom(address _from, address _to, uint256 _value) external returns (bool) {

        require(_value <= allowed[_from][msg.sender]);

        allowed[_from][msg.sender] -= _value;

        return _transfer(_from, _to, _value);

    }



    function transfer(address _to, uint256 _value) external returns (bool) {

        return _transfer(msg.sender, _to, _value);     

    }



    function approveAndCall(address _spender, uint256 _value, bytes _extraData)

        external

        returns (bool success) {

        tokenRecipient spender = tokenRecipient(_spender);

        if (approve(_spender, _value)) {

            spender.receiveApproval(msg.sender, _value, this, _extraData);

            return true;

        }

    }



    function _transfer(address _from, address _to, uint256 _value) internal returns (bool) {

        require(_to != address(0));

        uint256 oldFromVal = balances[_from];

        require(_value > 0 && oldFromVal >= _value);

        uint256 oldToVal = balances[_to];

        uint256 newToVal = oldToVal + _value;

        require(newToVal > oldToVal);

        uint256 newFromVal = oldFromVal - _value;

        balances[_from] = newFromVal;

        balances[_to] = newToVal;



        assert((oldFromVal + oldToVal) == (newFromVal + newToVal));

        Transfer(_from, _to, _value);



        return true;

    }



    function buy(string _account) external payable whenNotPaused {  

        uint256 val = msg.value;

        uint256 tthVal;

        if (val == 1 ether) {

            tthVal = 1100000000000000000;

        } else if (val == 3 ether) {

            tthVal = 3600000000000000000;

        } else if (val == 5 ether) {

            tthVal = 6500000000000000000;

        } else if (val == 10 ether) {

            tthVal = 15000000000000000000;

        } else if (val == 20 ether) {

            tthVal = 34000000000000000000;

        } else {

            require(false);

        }

        uint256 b = balances[this];

        require(b >= tthVal);



        bytes32 hashAccount = keccak256(_account);

        require(hashAccount != emptyHash);



        address preAddr = accHashToAddress[hashAccount];

        string storage preAcc = addressToAccount[msg.sender];

        bytes32 hashPreAcc = keccak256(preAcc);



        if (preAddr == address(0)) {

            require(hashPreAcc == emptyHash);

            // first buy

            accHashToAddress[hashAccount] = msg.sender;

            addressToAccount[msg.sender] = _account;

            _transfer(this, msg.sender, tthVal);

        } else if(preAddr == msg.sender) {

            require(hashPreAcc == hashAccount);

            // multi buy

            _transfer(this, msg.sender, tthVal);

        } else {

            require(false);

        }



        BuyIGO(msg.sender, _account, val, tthVal);

    }



    function getCanSellBalance() external view returns(uint256) {

        return balances[this];

    }



    function getBalanceByAccount(string _account) external view returns(uint256) {

        bytes32 hashAccount = keccak256(_account);

        address addr = accHashToAddress[hashAccount];

        if (addr == address(0)) {

            return 0;

        } else {

            return balances[addr];

        }

    }



    function getIGOAccoountByAddr(address _addr) external view returns(string) {

        return addressToAccount[_addr];

    }

}