{{
  "language": "Solidity",
  "sources": {
    "contracts/multisend/Multisend.sol": {
      "content": "/*\n  .oooooo.              o8o                           o8o                     \n d8P'  `Y8b             `\"'                           `\"'                     \n888           .ooooo.  oooo  ooo. .oo.   oooo    ooo oooo   .oooo.o  .ooooo.  \n888          d88' `88b `888  `888P\"Y88b   `88.  .8'  `888  d88(  \"8 d88' `88b \n888          888   888  888   888   888    `88..8'    888  `\"Y88b.  888ooo888 \n`88b    ooo  888   888  888   888   888     `888'     888  o.  )88b 888    .o \n `Y8bood8P'  `Y8bod8P' o888o o888o o888o     `8'     o888o 8\"\"888P' `Y8bod8P' \n*/\n\n// SPDX-License-Identifier: MIT\npragma solidity ^0.8.0;\n\ninterface IERC20 {\n  function transfer(address to, uint256 value) external returns (bool);\n\n  function transferFrom(\n    address from,\n    address to,\n    uint256 value\n  ) external returns (bool);\n}\n\ncontract Multisend {\n  function multisendEther(address[] memory recipients, uint256[] memory values)\n    external\n    payable\n  {\n    for (uint256 i = 0; i < recipients.length; i++)\n      payable(recipients[i]).transfer(values[i]);\n    uint256 balance = address(this).balance;\n    if (balance > 0) payable(msg.sender).transfer(balance);\n  }\n\n  function multisendToken(\n    IERC20 token,\n    address[] memory recipients,\n    uint256[] memory values\n  ) external {\n    uint256 total = 0;\n    for (uint256 i = 0; i < recipients.length; i++) total += values[i];\n    require(token.transferFrom(msg.sender, address(this), total));\n    for (uint256 i = 0; i < recipients.length; i++)\n      require(token.transfer(recipients[i], values[i]));\n  }\n}\n"
    }
  },
  "settings": {
    "optimizer": {
      "enabled": true,
      "runs": 200
    },
    "outputSelection": {
      "*": {
        "*": [
          "evm.bytecode",
          "evm.deployedBytecode",
          "devdoc",
          "userdoc",
          "metadata",
          "abi"
        ]
      }
    },
    "libraries": {}
  }
}}