{"coshiToken.sol":{"content":"// https://corgishiba.dog\n\n// SPDX-License-Identifier: Unlicensed\n\npragma solidity ^0.6.12;\n\nabstract contract Context {\n    function _msgSender() internal view virtual returns (address payable) {\n        return msg.sender;\n    }\n\n    function _msgData() internal view virtual returns (bytes memory) {\n        this; // silence state mutability warning without generating bytecode - see https://github.com/ethereum/solidity/issues/2691\n        return msg.data;\n    }\n}\n\ninterface IERC20 {\n    /**\n     * @dev Returns the amount of tokens in existence.\n     */\n    function totalSupply() external view returns (uint256);\n\n    /**\n     * @dev Returns the amount of tokens owned by `account`.\n     */\n    function balanceOf(address account) external view returns (uint256);\n\n    /**\n     * @dev Moves `amount` tokens from the caller\u0027s account to `recipient`.\n     *\n     * Returns a boolean value indicating whether the operation succeeded.\n     *\n     * Emits a {Transfer} event.\n     */\n    function transfer(address recipient, uint256 amount) external returns (bool);\n\n    /**\n     * @dev Returns the remaining number of tokens that `spender` will be\n     * allowed to spend on behalf of `owner` through {transferFrom}. This is\n     * zero by default.\n     *\n     * This value changes when {approve} or {transferFrom} are called.\n     */\n    function allowance(address owner, address spender) external view returns (uint256);\n\n    /**\n     * @dev Sets `amount` as the allowance of `spender` over the caller\u0027s tokens.\n     *\n     * Returns a boolean value indicating whether the operation succeeded.\n     *\n     * IMPORTANT: Beware that changing an allowance with this method brings the risk\n     * that someone may use both the old and the new allowance by unfortunate\n     * transaction ordering. One possible solution to mitigate this race\n     * condition is to first reduce the spender\u0027s allowance to 0 and set the\n     * desired value afterwards:\n     * https://github.com/ethereum/EIPs/issues/20#issuecomment-263524729\n     *\n     * Emits an {Approval} event.\n     */\n    function approve(address spender, uint256 amount) external returns (bool);\n\n    /**\n     * @dev Moves `amount` tokens from `sender` to `recipient` using the\n     * allowance mechanism. `amount` is then deducted from the caller\u0027s\n     * allowance.\n     *\n     * Returns a boolean value indicating whether the operation succeeded.\n     *\n     * Emits a {Transfer} event.\n     */\n    function transferFrom(address sender, address recipient, uint256 amount) external returns (bool);\n\n    /**\n     * @dev Emitted when `value` tokens are moved from one account (`from`) to\n     * another (`to`).\n     *\n     * Note that `value` may be zero.\n     */\n    event Transfer(address indexed from, address indexed to, uint256 value);\n\n    /**\n     * @dev Emitted when the allowance of a `spender` for an `owner` is set by\n     * a call to {approve}. `value` is the new allowance.\n     */\n    event Approval(address indexed owner, address indexed spender, uint256 value);\n}\n\nlibrary SafeMath {\n    /**\n     * @dev Returns the addition of two unsigned integers, reverting on\n     * overflow.\n     *\n     * Counterpart to Solidity\u0027s `+` operator.\n     *\n     * Requirements:\n     *\n     * - Addition cannot overflow.\n     */\n    function add(uint256 a, uint256 b) internal pure returns (uint256) {\n        uint256 c = a + b;\n        require(c \u003e= a, \"SafeMath: addition overflow\");\n\n        return c;\n    }\n\n    /**\n     * @dev Returns the subtraction of two unsigned integers, reverting on\n     * overflow (when the result is negative).\n     *\n     * Counterpart to Solidity\u0027s `-` operator.\n     *\n     * Requirements:\n     *\n     * - Subtraction cannot overflow.\n     */\n    function sub(uint256 a, uint256 b) internal pure returns (uint256) {\n        return sub(a, b, \"SafeMath: subtraction overflow\");\n    }\n\n    /**\n     * @dev Returns the subtraction of two unsigned integers, reverting with custom message on\n     * overflow (when the result is negative).\n     *\n     * Counterpart to Solidity\u0027s `-` operator.\n     *\n     * Requirements:\n     *\n     * - Subtraction cannot overflow.\n     */\n    function sub(uint256 a, uint256 b, string memory errorMessage) internal pure returns (uint256) {\n        require(b \u003c= a, errorMessage);\n        uint256 c = a - b;\n\n        return c;\n    }\n\n    /**\n     * @dev Returns the multiplication of two unsigned integers, reverting on\n     * overflow.\n     *\n     * Counterpart to Solidity\u0027s `*` operator.\n     *\n     * Requirements:\n     *\n     * - Multiplication cannot overflow.\n     */\n    function mul(uint256 a, uint256 b) internal pure returns (uint256) {\n        // Gas optimization: this is cheaper than requiring \u0027a\u0027 not being zero, but the\n        // benefit is lost if \u0027b\u0027 is also tested.\n        // See: https://github.com/OpenZeppelin/openzeppelin-contracts/pull/522\n        if (a == 0) {\n            return 0;\n        }\n\n        uint256 c = a * b;\n        require(c / a == b, \"SafeMath: multiplication overflow\");\n\n        return c;\n    }\n\n    /**\n     * @dev Returns the integer division of two unsigned integers. Reverts on\n     * division by zero. The result is rounded towards zero.\n     *\n     * Counterpart to Solidity\u0027s `/` operator. Note: this function uses a\n     * `revert` opcode (which leaves remaining gas untouched) while Solidity\n     * uses an invalid opcode to revert (consuming all remaining gas).\n     *\n     * Requirements:\n     *\n     * - The divisor cannot be zero.\n     */\n    function div(uint256 a, uint256 b) internal pure returns (uint256) {\n        return div(a, b, \"SafeMath: division by zero\");\n    }\n\n    /**\n     * @dev Returns the integer division of two unsigned integers. Reverts with custom message on\n     * division by zero. The result is rounded towards zero.\n     *\n     * Counterpart to Solidity\u0027s `/` operator. Note: this function uses a\n     * `revert` opcode (which leaves remaining gas untouched) while Solidity\n     * uses an invalid opcode to revert (consuming all remaining gas).\n     *\n     * Requirements:\n     *\n     * - The divisor cannot be zero.\n     */\n    function div(uint256 a, uint256 b, string memory errorMessage) internal pure returns (uint256) {\n        require(b \u003e 0, errorMessage);\n        uint256 c = a / b;\n        // assert(a == b * c + a % b); // There is no case in which this doesn\u0027t hold\n\n        return c;\n    }\n\n    /**\n     * @dev Returns the remainder of dividing two unsigned integers. (unsigned integer modulo),\n     * Reverts when dividing by zero.\n     *\n     * Counterpart to Solidity\u0027s `%` operator. This function uses a `revert`\n     * opcode (which leaves remaining gas untouched) while Solidity uses an\n     * invalid opcode to revert (consuming all remaining gas).\n     *\n     * Requirements:\n     *\n     * - The divisor cannot be zero.\n     */\n    function mod(uint256 a, uint256 b) internal pure returns (uint256) {\n        return mod(a, b, \"SafeMath: modulo by zero\");\n    }\n\n    /**\n     * @dev Returns the remainder of dividing two unsigned integers. (unsigned integer modulo),\n     * Reverts with custom message when dividing by zero.\n     *\n     * Counterpart to Solidity\u0027s `%` operator. This function uses a `revert`\n     * opcode (which leaves remaining gas untouched) while Solidity uses an\n     * invalid opcode to revert (consuming all remaining gas).\n     *\n     * Requirements:\n     *\n     * - The divisor cannot be zero.\n     */\n    function mod(uint256 a, uint256 b, string memory errorMessage) internal pure returns (uint256) {\n        require(b != 0, errorMessage);\n        return a % b;\n    }\n}\n\nlibrary Address {\n    /**\n     * @dev Returns true if `account` is a contract.\n     *\n     * [IMPORTANT]\n     * ====\n     * It is unsafe to assume that an address for which this function returns\n     * false is an externally-owned account (EOA) and not a contract.\n     *\n     * Among others, `isContract` will return false for the following\n     * types of addresses:\n     *\n     *  - an externally-owned account\n     *  - a contract in construction\n     *  - an address where a contract will be created\n     *  - an address where a contract lived, but was destroyed\n     * ====\n     */\n    function isContract(address account) internal view returns (bool) {\n        // According to EIP-1052, 0x0 is the value returned for not-yet created accounts\n        // and 0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470 is returned\n        // for accounts without code, i.e. `keccak256(\u0027\u0027)`\n        bytes32 codehash;\n        bytes32 accountHash = 0xc5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470;\n        // solhint-disable-next-line no-inline-assembly\n        assembly { codehash := extcodehash(account) }\n        return (codehash != accountHash \u0026\u0026 codehash != 0x0);\n    }\n\n    /**\n     * @dev Replacement for Solidity\u0027s `transfer`: sends `amount` wei to\n     * `recipient`, forwarding all available gas and reverting on errors.\n     *\n     * https://eips.ethereum.org/EIPS/eip-1884[EIP1884] increases the gas cost\n     * of certain opcodes, possibly making contracts go over the 2300 gas limit\n     * imposed by `transfer`, making them unable to receive funds via\n     * `transfer`. {sendValue} removes this limitation.\n     *\n     * https://diligence.consensys.net/posts/2019/09/stop-using-soliditys-transfer-now/[Learn more].\n     *\n     * IMPORTANT: because control is transferred to `recipient`, care must be\n     * taken to not create reentrancy vulnerabilities. Consider using\n     * {ReentrancyGuard} or the\n     * https://solidity.readthedocs.io/en/v0.5.11/security-considerations.html#use-the-checks-effects-interactions-pattern[checks-effects-interactions pattern].\n     */\n    function sendValue(address payable recipient, uint256 amount) internal {\n        require(address(this).balance \u003e= amount, \"Address: insufficient balance\");\n\n        // solhint-disable-next-line avoid-low-level-calls, avoid-call-value\n        (bool success, ) = recipient.call{ value: amount }(\"\");\n        require(success, \"Address: unable to send value, recipient may have reverted\");\n    }\n\n    /**\n     * @dev Performs a Solidity function call using a low level `call`. A\n     * plain`call` is an unsafe replacement for a function call: use this\n     * function instead.\n     *\n     * If `target` reverts with a revert reason, it is bubbled up by this\n     * function (like regular Solidity function calls).\n     *\n     * Returns the raw returned data. To convert to the expected return value,\n     * use https://solidity.readthedocs.io/en/latest/units-and-global-variables.html?highlight=abi.decode#abi-encoding-and-decoding-functions[`abi.decode`].\n     *\n     * Requirements:\n     *\n     * - `target` must be a contract.\n     * - calling `target` with `data` must not revert.\n     *\n     * _Available since v3.1._\n     */\n    function functionCall(address target, bytes memory data) internal returns (bytes memory) {\n      return functionCall(target, data, \"Address: low-level call failed\");\n    }\n\n    /**\n     * @dev Same as {xref-Address-functionCall-address-bytes-}[`functionCall`], but with\n     * `errorMessage` as a fallback revert reason when `target` reverts.\n     *\n     * _Available since v3.1._\n     */\n    function functionCall(address target, bytes memory data, string memory errorMessage) internal returns (bytes memory) {\n        return _functionCallWithValue(target, data, 0, errorMessage);\n    }\n\n    /**\n     * @dev Same as {xref-Address-functionCall-address-bytes-}[`functionCall`],\n     * but also transferring `value` wei to `target`.\n     *\n     * Requirements:\n     *\n     * - the calling contract must have an ETH balance of at least `value`.\n     * - the called Solidity function must be `payable`.\n     *\n     * _Available since v3.1._\n     */\n    function functionCallWithValue(address target, bytes memory data, uint256 value) internal returns (bytes memory) {\n        return functionCallWithValue(target, data, value, \"Address: low-level call with value failed\");\n    }\n\n    /**\n     * @dev Same as {xref-Address-functionCallWithValue-address-bytes-uint256-}[`functionCallWithValue`], but\n     * with `errorMessage` as a fallback revert reason when `target` reverts.\n     *\n     * _Available since v3.1._\n     */\n    function functionCallWithValue(address target, bytes memory data, uint256 value, string memory errorMessage) internal returns (bytes memory) {\n        require(address(this).balance \u003e= value, \"Address: insufficient balance for call\");\n        return _functionCallWithValue(target, data, value, errorMessage);\n    }\n\n    function _functionCallWithValue(address target, bytes memory data, uint256 weiValue, string memory errorMessage) private returns (bytes memory) {\n        require(isContract(target), \"Address: call to non-contract\");\n\n        // solhint-disable-next-line avoid-low-level-calls\n        (bool success, bytes memory returndata) = target.call{ value: weiValue }(data);\n        if (success) {\n            return returndata;\n        } else {\n            // Look for revert reason and bubble it up if present\n            if (returndata.length \u003e 0) {\n                // The easiest way to bubble the revert reason is using memory via assembly\n\n                // solhint-disable-next-line no-inline-assembly\n                assembly {\n                    let returndata_size := mload(returndata)\n                    revert(add(32, returndata), returndata_size)\n                }\n            } else {\n                revert(errorMessage);\n            }\n        }\n    }\n}\n\ncontract Ownable is Context {\n    address private _owner;\n\n    event OwnershipTransferred(address indexed previousOwner, address indexed newOwner);\n\n    /**\n     * @dev Initializes the contract setting the deployer as the initial owner.\n     */\n    constructor () internal {\n        address msgSender = _msgSender();\n        _owner = msgSender;\n        emit OwnershipTransferred(address(0), msgSender);\n    }\n\n    /**\n     * @dev Returns the address of the current owner.\n     */\n    function owner() public view returns (address) {\n        return _owner;\n    }\n\n    /**\n     * @dev Throws if called by any account other than the owner.\n     */\n    modifier onlyOwner() {\n        require(_owner == _msgSender(), \"Ownable: caller is not the owner\");\n        _;\n    }\n\n    /**\n     * @dev Leaves the contract without owner. It will not be possible to call\n     * `onlyOwner` functions anymore. Can only be called by the current owner.\n     *\n     * NOTE: Renouncing ownership will leave the contract without an owner,\n     * thereby removing any functionality that is only available to the owner.\n     */\n    function renounceOwnership() public virtual onlyOwner {\n        emit OwnershipTransferred(_owner, address(0));\n        _owner = address(0);\n    }\n\n    /**\n     * @dev Transfers ownership of the contract to a new account (`newOwner`).\n     * Can only be called by the current owner.\n     */\n    function transferOwnership(address newOwner) public virtual onlyOwner {\n        require(newOwner != address(0), \"Ownable: new owner is the zero address\");\n        emit OwnershipTransferred(_owner, newOwner);\n        _owner = newOwner;\n    }\n}\n\ncontract CoShiInu is Context, IERC20, Ownable {\n    using SafeMath for uint256;\n    using Address for address;\n\n    mapping (address =\u003e uint256) private _rOwned;\n    mapping (address =\u003e uint256) private _tOwned;\n    mapping (address =\u003e mapping (address =\u003e uint256)) private _allowances;\n\n    mapping (address =\u003e bool) private _isExcluded;\n    address[] private _excluded;\n   \n    uint256 private constant MAX = ~uint256(0);\n    uint256 private constant _tTotal = 1000000000 * 10**6 * 10**9;\n    uint256 private _rTotal = (MAX - (MAX % _tTotal));\n    uint256 private _tFeeTotal;\n\n    string private _name = \u0027CoShi Inu\u0027;\n    string private _symbol = \u0027CoShi\u0027;\n    uint8 private _decimals = 9;\n    \n    uint256 public _maxTxAmount = 10000000 * 10**6 * 10**9;\n\n    constructor () public {\n        _rOwned[_msgSender()] = _rTotal;\n        emit Transfer(address(0), _msgSender(), _tTotal);\n    }\n\n    function name() public view returns (string memory) {\n        return _name;\n    }\n\n    function symbol() public view returns (string memory) {\n        return _symbol;\n    }\n\n    function decimals() public view returns (uint8) {\n        return _decimals;\n    }\n\n    function totalSupply() public view override returns (uint256) {\n        return _tTotal;\n    }\n\n    function balanceOf(address account) public view override returns (uint256) {\n        if (_isExcluded[account]) return _tOwned[account];\n        return tokenFromReflection(_rOwned[account]);\n    }\n\n    function transfer(address recipient, uint256 amount) public override returns (bool) {\n        _transfer(_msgSender(), recipient, amount);\n        return true;\n    }\n\n    function allowance(address owner, address spender) public view override returns (uint256) {\n        return _allowances[owner][spender];\n    }\n\n    function approve(address spender, uint256 amount) public override returns (bool) {\n        _approve(_msgSender(), spender, amount);\n        return true;\n    }\n\n    function transferFrom(address sender, address recipient, uint256 amount) public override returns (bool) {\n        _transfer(sender, recipient, amount);\n        _approve(sender, _msgSender(), _allowances[sender][_msgSender()].sub(amount, \"ERC20: transfer amount exceeds allowance\"));\n        return true;\n    }\n\n    function increaseAllowance(address spender, uint256 addedValue) public virtual returns (bool) {\n        _approve(_msgSender(), spender, _allowances[_msgSender()][spender].add(addedValue));\n        return true;\n    }\n\n    function decreaseAllowance(address spender, uint256 subtractedValue) public virtual returns (bool) {\n        _approve(_msgSender(), spender, _allowances[_msgSender()][spender].sub(subtractedValue, \"ERC20: decreased allowance below zero\"));\n        return true;\n    }\n\n    function isExcluded(address account) public view returns (bool) {\n        return _isExcluded[account];\n    }\n\n    function totalFees() public view returns (uint256) {\n        return _tFeeTotal;\n    }\n    \n    \n    function setMaxTxPercent(uint256 maxTxPercent) external onlyOwner() {\n        _maxTxAmount = _tTotal.mul(maxTxPercent).div(\n            10**2\n        );\n    }\n\n    function reflect(uint256 tAmount) public {\n        address sender = _msgSender();\n        require(!_isExcluded[sender], \"Excluded addresses cannot call this function\");\n        (uint256 rAmount,,,,) = _getValues(tAmount);\n        _rOwned[sender] = _rOwned[sender].sub(rAmount);\n        _rTotal = _rTotal.sub(rAmount);\n        _tFeeTotal = _tFeeTotal.add(tAmount);\n    }\n\n    function reflectionFromToken(uint256 tAmount, bool deductTransferFee) public view returns(uint256) {\n        require(tAmount \u003c= _tTotal, \"Amount must be less than supply\");\n        if (!deductTransferFee) {\n            (uint256 rAmount,,,,) = _getValues(tAmount);\n            return rAmount;\n        } else {\n            (,uint256 rTransferAmount,,,) = _getValues(tAmount);\n            return rTransferAmount;\n        }\n    }\n\n    function tokenFromReflection(uint256 rAmount) public view returns(uint256) {\n        require(rAmount \u003c= _rTotal, \"Amount must be less than total reflections\");\n        uint256 currentRate =  _getRate();\n        return rAmount.div(currentRate);\n    }\n\n    function excludeAccount(address account) external onlyOwner() {\n        require(!_isExcluded[account], \"Account is already excluded\");\n        if(_rOwned[account] \u003e 0) {\n            _tOwned[account] = tokenFromReflection(_rOwned[account]);\n        }\n        _isExcluded[account] = true;\n        _excluded.push(account);\n    }\n\n    function includeAccount(address account) external onlyOwner() {\n        require(_isExcluded[account], \"Account is already excluded\");\n        for (uint256 i = 0; i \u003c _excluded.length; i++) {\n            if (_excluded[i] == account) {\n                _excluded[i] = _excluded[_excluded.length - 1];\n                _tOwned[account] = 0;\n                _isExcluded[account] = false;\n                _excluded.pop();\n                break;\n            }\n        }\n    }\n\n    function _approve(address owner, address spender, uint256 amount) private {\n        require(owner != address(0), \"ERC20: approve from the zero address\");\n        require(spender != address(0), \"ERC20: approve to the zero address\");\n\n        _allowances[owner][spender] = amount;\n        emit Approval(owner, spender, amount);\n    }\n\n    function _transfer(address sender, address recipient, uint256 amount) private {\n        require(sender != address(0), \"ERC20: transfer from the zero address\");\n        require(recipient != address(0), \"ERC20: transfer to the zero address\");\n        require(amount \u003e 0, \"Transfer amount must be greater than zero\");\n        if(sender != owner() \u0026\u0026 recipient != owner())\n          require(amount \u003c= _maxTxAmount, \"Transfer amount exceeds the maxTxAmount.\");\n            \n        if (_isExcluded[sender] \u0026\u0026 !_isExcluded[recipient]) {\n            _transferFromExcluded(sender, recipient, amount);\n        } else if (!_isExcluded[sender] \u0026\u0026 _isExcluded[recipient]) {\n            _transferToExcluded(sender, recipient, amount);\n        } else if (!_isExcluded[sender] \u0026\u0026 !_isExcluded[recipient]) {\n            _transferStandard(sender, recipient, amount);\n        } else if (_isExcluded[sender] \u0026\u0026 _isExcluded[recipient]) {\n            _transferBothExcluded(sender, recipient, amount);\n        } else {\n            _transferStandard(sender, recipient, amount);\n        }\n    }\n\n    function _transferStandard(address sender, address recipient, uint256 tAmount) private {\n        (uint256 rAmount, uint256 rTransferAmount, uint256 rFee, uint256 tTransferAmount, uint256 tFee) = _getValues(tAmount);\n        _rOwned[sender] = _rOwned[sender].sub(rAmount);\n        _rOwned[recipient] = _rOwned[recipient].add(rTransferAmount);       \n        _reflectFee(rFee, tFee);\n        emit Transfer(sender, recipient, tTransferAmount);\n    }\n\n    function _transferToExcluded(address sender, address recipient, uint256 tAmount) private {\n        (uint256 rAmount, uint256 rTransferAmount, uint256 rFee, uint256 tTransferAmount, uint256 tFee) = _getValues(tAmount);\n        _rOwned[sender] = _rOwned[sender].sub(rAmount);\n        _tOwned[recipient] = _tOwned[recipient].add(tTransferAmount);\n        _rOwned[recipient] = _rOwned[recipient].add(rTransferAmount);           \n        _reflectFee(rFee, tFee);\n        emit Transfer(sender, recipient, tTransferAmount);\n    }\n\n    function _transferFromExcluded(address sender, address recipient, uint256 tAmount) private {\n        (uint256 rAmount, uint256 rTransferAmount, uint256 rFee, uint256 tTransferAmount, uint256 tFee) = _getValues(tAmount);\n        _tOwned[sender] = _tOwned[sender].sub(tAmount);\n        _rOwned[sender] = _rOwned[sender].sub(rAmount);\n        _rOwned[recipient] = _rOwned[recipient].add(rTransferAmount);   \n        _reflectFee(rFee, tFee);\n        emit Transfer(sender, recipient, tTransferAmount);\n    }\n\n    function _transferBothExcluded(address sender, address recipient, uint256 tAmount) private {\n        (uint256 rAmount, uint256 rTransferAmount, uint256 rFee, uint256 tTransferAmount, uint256 tFee) = _getValues(tAmount);\n        _tOwned[sender] = _tOwned[sender].sub(tAmount);\n        _rOwned[sender] = _rOwned[sender].sub(rAmount);\n        _tOwned[recipient] = _tOwned[recipient].add(tTransferAmount);\n        _rOwned[recipient] = _rOwned[recipient].add(rTransferAmount);        \n        _reflectFee(rFee, tFee);\n        emit Transfer(sender, recipient, tTransferAmount);\n    }\n\n    function _reflectFee(uint256 rFee, uint256 tFee) private {\n        _rTotal = _rTotal.sub(rFee);\n        _tFeeTotal = _tFeeTotal.add(tFee);\n    }\n\n    function _getValues(uint256 tAmount) private view returns (uint256, uint256, uint256, uint256, uint256) {\n        (uint256 tTransferAmount, uint256 tFee) = _getTValues(tAmount);\n        uint256 currentRate =  _getRate();\n        (uint256 rAmount, uint256 rTransferAmount, uint256 rFee) = _getRValues(tAmount, tFee, currentRate);\n        return (rAmount, rTransferAmount, rFee, tTransferAmount, tFee);\n    }\n\n    function _getTValues(uint256 tAmount) private pure returns (uint256, uint256) {\n        uint256 tFee = tAmount.div(100).mul(0);\n        uint256 tTransferAmount = tAmount.sub(tFee);\n        return (tTransferAmount, tFee);\n    }\n\n    function _getRValues(uint256 tAmount, uint256 tFee, uint256 currentRate) private pure returns (uint256, uint256, uint256) {\n        uint256 rAmount = tAmount.mul(currentRate);\n        uint256 rFee = tFee.mul(currentRate);\n        uint256 rTransferAmount = rAmount.sub(rFee);\n        return (rAmount, rTransferAmount, rFee);\n    }\n\n    function _getRate() private view returns(uint256) {\n        (uint256 rSupply, uint256 tSupply) = _getCurrentSupply();\n        return rSupply.div(tSupply);\n    }\n\n    function _getCurrentSupply() private view returns(uint256, uint256) {\n        uint256 rSupply = _rTotal;\n        uint256 tSupply = _tTotal;      \n        for (uint256 i = 0; i \u003c _excluded.length; i++) {\n            if (_rOwned[_excluded[i]] \u003e rSupply || _tOwned[_excluded[i]] \u003e tSupply) return (_rTotal, _tTotal);\n            rSupply = rSupply.sub(_rOwned[_excluded[i]]);\n            tSupply = tSupply.sub(_tOwned[_excluded[i]]);\n        }\n        if (rSupply \u003c _rTotal.div(_tTotal)) return (_rTotal, _tTotal);\n        return (rSupply, tSupply);\n    }\n}"},"ethBridge.sol":{"content":"// SPDX-License-Identifier: GPL-3.0\npragma solidity ^0.6.12;\n\nimport \"./multiOwnable.sol\";\nimport \"./coshiToken.sol\";\n\ncontract ethBridge is Multiownable {\n    CoShiInu private token;\n\n    mapping(address =\u003e uint256) public tokensSent;\n    mapping(address =\u003e uint256) public tokensRecieved;\n    mapping(address =\u003e uint256) public tokensRecievedButNotSent;\n \n    address public tokenAddress; \n    \n    constructor (address _token) public {\n        tokenAddress = _token;\n        token = CoShiInu(_token);\n    }\n \n    bool transferStatus;\n    \n    bool avoidReentrancy = false;\n \n    function sendTokens(uint256 amount) public {\n        require(msg.sender != address(0), \"Zero account\");\n        require(amount \u003e 0,\"Amount of tokens should be more then 0\");\n        require(token.balanceOf(msg.sender) \u003e= amount,\"Not enough balance\");\n        \n        transferStatus = token.transferFrom(msg.sender, address(this), amount);\n        if (transferStatus == true) {\n            tokensRecieved[msg.sender] += amount;\n        }\n    }\n \n    function writeTransaction(address user, uint256 amount) public onlyAllOwners {\n        require(user != address(0), \"Zero account\");\n        require(amount \u003e 0,\"Amount of tokens should be more then 0\");\n        require(!avoidReentrancy);\n        \n        avoidReentrancy = true;\n        tokensRecievedButNotSent[user] += amount;\n        avoidReentrancy = false;\n    }\n\n    function recieveTokens(uint256[] memory commissions) public payable {\n        if (tokensRecievedButNotSent[msg.sender] != 0) {\n            require(commissions.length == owners.length, \"The number of commissions and owners does not match\");\n            uint256 sum;\n            for(uint i = 0; i \u003c commissions.length; i++) {\n                sum += commissions[i];\n            }\n            require(msg.value \u003e= sum, \"Not enough BNB (The amount of BNB is less than the amount of commissions.)\");\n            require(msg.value \u003e= owners.length * 150000 * 10**9, \"Not enough BNB (The amount of BNB is less than the internal commission.)\");\n        \n            for (uint i = 0; i \u003c owners.length; i++) {\n                address payable owner = payable(owners[i]);\n                uint256 commission = commissions[i];\n                owner.transfer(commission);\n            }\n            \n            uint256 amountToSent;\n            \n            amountToSent = tokensRecievedButNotSent[msg.sender] - tokensSent[msg.sender];\n            transferStatus = token.transfer(msg.sender, amountToSent);\n            if (transferStatus == true) {\n                tokensSent[msg.sender] += amountToSent;\n            }\n        }\n    }\n \n    function withdrawTokens(uint256 amount, address reciever) public onlyAllOwners {\n        require(amount \u003e 0,\"Amount of tokens should be more then 0\");\n        require(reciever != address(0), \"Zero account\");\n        require(token.balanceOf(address(this)) \u003e= amount,\"Not enough balance\");\n        \n        token.transfer(reciever, amount);\n    }\n    \n    function withdrawEther(uint256 amount, address payable reciever) public onlyAllOwners {\n        require(amount \u003e 0,\"Amount of tokens should be more then 0\");\n        require(reciever != address(0), \"Zero account\");\n        require(address(this).balance \u003e= amount,\"Not enough balance\");\n\n        reciever.transfer(amount);\n    }\n}"},"multiOwnable.sol":{"content":"// SPDX-License-Identifier: MIT\npragma solidity ^0.6.12;\n\ncontract Multiownable {\n\n    // VARIABLES\n\n    uint256 public ownersGeneration;\n    uint256 public howManyOwnersDecide;\n    address[] public owners;\n    bytes32[] public allOperations;\n    address internal insideCallSender;\n    uint256 internal insideCallCount;\n\n    // Reverse lookup tables for owners and allOperations\n    mapping(address =\u003e uint) public ownersIndices; // Starts from 1\n    mapping(bytes32 =\u003e uint) public allOperationsIndicies;\n\n    // Owners voting mask per operations\n    mapping(bytes32 =\u003e uint256) public votesMaskByOperation;\n    mapping(bytes32 =\u003e uint256) public votesCountByOperation;\n\n    // EVENTS\n\n    event OwnershipTransferred(address[] previousOwners, uint howManyOwnersDecide, address[] newOwners, uint newHowManyOwnersDecide);\n    event OperationCreated(bytes32 operation, uint howMany, uint ownersCount, address proposer);\n    event OperationUpvoted(bytes32 operation, uint votes, uint howMany, uint ownersCount, address upvoter);\n    event OperationPerformed(bytes32 operation, uint howMany, uint ownersCount, address performer);\n    event OperationDownvoted(bytes32 operation, uint votes, uint ownersCount,  address downvoter);\n    event OperationCancelled(bytes32 operation, address lastCanceller);\n    \n    // ACCESSORS\n\n    function isOwner(address wallet) public view returns(bool) {\n        return ownersIndices[wallet] \u003e 0;\n    }\n\n    function ownersCount() public view returns(uint) {\n        return owners.length;\n    }\n\n    function allOperationsCount() public view returns(uint) {\n        return allOperations.length;\n    }\n\n    // MODIFIERS\n\n    /**\n    * @dev Allows to perform method by any of the owners\n    */\n    modifier onlyAnyOwner {\n        if (checkHowManyOwners(1)) {\n            bool update = (insideCallSender == address(0));\n            if (update) {\n                insideCallSender = msg.sender;\n                insideCallCount = 1;\n            }\n            _;\n            if (update) {\n                insideCallSender = address(0);\n                insideCallCount = 0;\n            }\n        }\n    }\n\n    /**\n    * @dev Allows to perform method only after many owners call it with the same arguments\n    */\n    modifier onlyManyOwners {\n        if (checkHowManyOwners(howManyOwnersDecide)) {\n            bool update = (insideCallSender == address(0));\n            if (update) {\n                insideCallSender = msg.sender;\n                insideCallCount = howManyOwnersDecide;\n            }\n            _;\n            if (update) {\n                insideCallSender = address(0);\n                insideCallCount = 0;\n            }\n        }\n    }\n\n    /**\n    * @dev Allows to perform method only after all owners call it with the same arguments\n    */\n    modifier onlyAllOwners {\n        if (checkHowManyOwners(owners.length)) {\n            bool update = (insideCallSender == address(0));\n            if (update) {\n                insideCallSender = msg.sender;\n                insideCallCount = owners.length;\n            }\n            _;\n            if (update) {\n                insideCallSender = address(0);\n                insideCallCount = 0;\n            }\n        }\n    }\n\n    /**\n    * @dev Allows to perform method only after some owners call it with the same arguments\n    */\n    modifier onlySomeOwners(uint howMany) {\n        require(howMany \u003e 0, \"onlySomeOwners: howMany argument is zero\");\n        require(howMany \u003c= owners.length, \"onlySomeOwners: howMany argument exceeds the number of owners\");\n        \n        if (checkHowManyOwners(howMany)) {\n            bool update = (insideCallSender == address(0));\n            if (update) {\n                insideCallSender = msg.sender;\n                insideCallCount = howMany;\n            }\n            _;\n            if (update) {\n                insideCallSender = address(0);\n                insideCallCount = 0;\n            }\n        }\n    }\n\n    // CONSTRUCTOR\n\n    constructor() public {\n        owners.push(msg.sender);\n        ownersIndices[msg.sender] = 1;\n        howManyOwnersDecide = 1;\n    }\n\n    // INTERNAL METHODS\n\n    /**\n     * @dev onlyManyOwners modifier helper\n     */\n    function checkHowManyOwners(uint howMany) internal returns(bool) {\n        if (insideCallSender == msg.sender) {\n            require(howMany \u003c= insideCallCount, \"checkHowManyOwners: nested owners modifier check require more owners\");\n            return true;\n        }\n\n        uint ownerIndex = ownersIndices[msg.sender] - 1;\n        require(ownerIndex \u003c owners.length, \"checkHowManyOwners: msg.sender is not an owner\");\n        bytes32 operation = keccak256(abi.encodePacked(msg.data, ownersGeneration));\n\n        require((votesMaskByOperation[operation] \u0026 (2 ** ownerIndex)) == 0, \"checkHowManyOwners: owner already voted for the operation\");\n        votesMaskByOperation[operation] |= (2 ** ownerIndex);\n        uint operationVotesCount = votesCountByOperation[operation] + 1;\n        votesCountByOperation[operation] = operationVotesCount;\n        if (operationVotesCount == 1) {\n            allOperationsIndicies[operation] = allOperations.length;\n            allOperations.push(operation);\n            emit OperationCreated(operation, howMany, owners.length, msg.sender);\n        }\n        emit OperationUpvoted(operation, operationVotesCount, howMany, owners.length, msg.sender);\n\n        // If enough owners confirmed the same operation\n        if (votesCountByOperation[operation] == howMany) {\n            deleteOperation(operation);\n            emit OperationPerformed(operation, howMany, owners.length, msg.sender);\n            return true;\n        }\n\n        return false;\n    }\n\n    /**\n    * @dev Used to delete cancelled or performed operation\n    * @param operation defines which operation to delete\n    */\n    function deleteOperation(bytes32 operation) internal {\n        uint index = allOperationsIndicies[operation];\n        if (index \u003c allOperations.length - 1) { // Not last\n            allOperations[index] = allOperations[allOperations.length - 1];\n            allOperationsIndicies[allOperations[index]] = index;\n        }\n        //allOperations.length-1\n        allOperations.pop();\n\n        delete votesMaskByOperation[operation];\n        delete votesCountByOperation[operation];\n        delete allOperationsIndicies[operation];\n    }\n\n    // PUBLIC METHODS\n\n    /**\n    * @dev Allows owners to change their mind by cacnelling votesMaskByOperation operations\n    * @param operation defines which operation to delete\n    */\n    function cancelPending(bytes32 operation) public onlyAnyOwner {\n        uint ownerIndex = ownersIndices[msg.sender] - 1;\n        require((votesMaskByOperation[operation] \u0026 (2 ** ownerIndex)) != 0, \"cancelPending: operation not found for this user\");\n        votesMaskByOperation[operation] \u0026= ~(2 ** ownerIndex);\n        uint operationVotesCount = votesCountByOperation[operation] - 1;\n        votesCountByOperation[operation] = operationVotesCount;\n        emit OperationDownvoted(operation, operationVotesCount, owners.length, msg.sender);\n        if (operationVotesCount == 0) {\n            deleteOperation(operation);\n            emit OperationCancelled(operation, msg.sender);\n        }\n    }\n\n    /**\n    * @dev Allows owners to change ownership\n    * @param newOwners defines array of addresses of new owners\n    */\n    function transferOwnership(address[] memory newOwners) public {\n        transferOwnershipWithHowMany(newOwners, newOwners.length);\n    }\n\n    /**\n    * @dev Allows owners to change ownership\n    * @param newOwners defines array of addresses of new owners\n    * @param newHowManyOwnersDecide defines how many owners can decide\n    */\n    function transferOwnershipWithHowMany(address[] memory newOwners, uint256 newHowManyOwnersDecide) public onlyManyOwners {\n        require(newOwners.length \u003e 0, \"transferOwnershipWithHowMany: owners array is empty\");\n        require(newOwners.length \u003c= 256, \"transferOwnershipWithHowMany: owners count is greater then 256\");\n        require(newHowManyOwnersDecide \u003e 0, \"transferOwnershipWithHowMany: newHowManyOwnersDecide equal to 0\");\n        require(newHowManyOwnersDecide \u003c= newOwners.length, \"transferOwnershipWithHowMany: newHowManyOwnersDecide exceeds the number of owners\");\n\n        // Reset owners reverse lookup table\n        for (uint j = 0; j \u003c owners.length; j++) {\n            delete ownersIndices[owners[j]];\n        }\n        for (uint i = 0; i \u003c newOwners.length; i++) {\n            require(newOwners[i] != address(0), \"transferOwnershipWithHowMany: owners array contains zero\");\n            require(ownersIndices[newOwners[i]] == 0, \"transferOwnershipWithHowMany: owners array contains duplicates\");\n            ownersIndices[newOwners[i]] = i + 1;\n        }\n        \n        emit OwnershipTransferred(owners, howManyOwnersDecide, newOwners, newHowManyOwnersDecide);\n        owners = newOwners;\n        howManyOwnersDecide = newHowManyOwnersDecide;\n        // allOperations.length = 0;\n        allOperations.push();\n        ownersGeneration++;\n    }\n\n}"}}