{{
  "language": "Solidity",
  "sources": {
    "Token.sol": {
      "content": "pragma solidity ^0.4.24;\r\n\r\ninterface tokenRecipient { function receiveApproval(address _from, uint256 _value, address _token, bytes _extraData) external; }\r\n\r\nlibrary SafeMath {\r\n    function add(uint256 a, uint256 b) internal pure returns (uint256 c) {\r\n        c = a + b;\r\n        require(c >= a);\r\n    }\r\n    function sub(uint256 a, uint256 b) internal pure returns (uint256 c) {\r\n        require(b <= a);\r\n        c = a - b;\r\n    }\r\n    function mul(uint256 a, uint256 b) internal pure returns (uint256 c) {\r\n        c = a * b;\r\n        require(a == 0 || c / a == b);\r\n    }\r\n    function div(uint256 a, uint256 b) internal pure returns (uint256 c) {\r\n        require(b > 0);\r\n        c = a / b;\r\n    }\r\n}\r\n\r\ncontract Token {\r\n    using SafeMath for uint256;\r\n\r\n    string public name;\r\n    string public symbol;\r\n    uint8 public decimals = 6;\r\n    uint256 public totalSupply;\r\n    address public owner;\r\n\r\n    address[] public ownerContracts;\r\n    address public userPool;\r\n    address public platformPool;\r\n    address public smPool;\r\n\r\n    //  burnPoolAddresses\r\n    mapping(string => address) burnPoolAddresses;\r\n\r\n    mapping (address => uint256) public balanceOf;\r\n\r\n    mapping (address => mapping (address => uint256)) public allowance;\r\n\r\n    event Transfer(address indexed from, address indexed to, uint256 value);\r\n\r\n    event TransferETH(address indexed from, address indexed to, uint256 value);\r\n\r\n    event Burn(address indexed from, uint256 value);\r\n\r\n    //990000000,\"Alchemy Coin\",\"ALC\"\r\n    constructor(\r\n        uint256 initialSupply,\r\n        string tokenName,\r\n        string tokenSymbol\r\n    ) payable public  {\r\n        totalSupply = initialSupply * 10 ** uint256(decimals);\r\n        balanceOf[msg.sender] = totalSupply;\r\n        name = tokenName;\r\n        symbol = tokenSymbol;\r\n        owner = msg.sender;\r\n    }\r\n\r\n    // onlyOwner\r\n    modifier onlyOwner {\r\n        require(msg.sender == owner);\r\n        _;\r\n    }\r\n\r\n    function setOwnerContracts(address _adr) public onlyOwner {\r\n        if(_adr != 0x0){\r\n            ownerContracts.push(_adr);\r\n        }\r\n    }\r\n\r\n    /**\r\n     * @dev Transfers ownership of the contract to a new account (`newOwner`).\r\n     * Can only be called by the current owner.\r\n     */\r\n    function transferOwnership(address _newOwner) public onlyOwner {\r\n        if (_newOwner != address(0)) {\r\n            owner = _newOwner;\r\n        }\r\n    }\r\n\r\n    /**\r\n     * @dev See `IERC20.transfer`.\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - `recipient` cannot be the zero address.\r\n     * - the caller must have a balance of at least `amount`.\r\n     */\r\n    function _transfer(address _from, address _to, uint _value) internal {\r\n        require(userPool != 0x0);\r\n        require(platformPool != 0x0);\r\n        require(smPool != 0x0);\r\n        // check zero address\r\n        require(_to != 0x0);\r\n        // check zero address\r\n        require(_value > 0);\r\n        require(balanceOf[_from] >= _value);\r\n        require(balanceOf[_to] + _value >= balanceOf[_to]);\r\n        uint previousBalances = balanceOf[_from].add(balanceOf[_to]);\r\n        balanceOf[_from] = balanceOf[_from].sub(_value);\r\n        uint256 burnTotal = 0;\r\n        uint256 platformTotal = 0;\r\n        // burn\r\n        if (this == _to) {\r\n            burnTotal = _value*3;\r\n            platformTotal = _value.mul(15).div(100);\r\n            require(balanceOf[owner] >= (burnTotal + platformTotal));\r\n            balanceOf[userPool] = balanceOf[userPool].add(burnTotal);\r\n            balanceOf[platformPool] = balanceOf[platformPool].add(platformTotal);\r\n            balanceOf[owner] -= (burnTotal + platformTotal);\r\n            emit Transfer(_from, _to, _value);\r\n            emit Transfer(owner, userPool, burnTotal);\r\n            emit Transfer(owner, platformPool, platformTotal);\r\n            emit Burn(_from, _value);\r\n        } else if (smPool == _from) {\r\n            address smBurnAddress = burnPoolAddresses[\"smBurn\"];\r\n            require(smBurnAddress != 0x0);\r\n            burnTotal = _value*3;\r\n            platformTotal = _value.mul(15).div(100);\r\n            require(balanceOf[owner] >= (burnTotal + platformTotal));\r\n            balanceOf[userPool] = balanceOf[userPool].add(burnTotal);\r\n            balanceOf[platformPool] = balanceOf[platformPool].add(platformTotal);\r\n            balanceOf[owner] -= (burnTotal + platformTotal);\r\n            emit Transfer(_from, _to, _value);\r\n            emit Transfer(_to, smBurnAddress, _value);\r\n            emit Transfer(owner, userPool, burnTotal);\r\n            emit Transfer(owner, platformPool, platformTotal);\r\n            emit Burn(_to, _value);\r\n        } else {\r\n            address appBurnAddress = burnPoolAddresses[\"appBurn\"];\r\n            address webBurnAddress = burnPoolAddresses[\"webBurn\"];\r\n            address normalBurnAddress = burnPoolAddresses[\"normalBurn\"];\r\n            if (_to == appBurnAddress || _to == webBurnAddress || _to == normalBurnAddress) {\r\n                burnTotal = _value*3;\r\n                platformTotal = _value.mul(15).div(100);\r\n                require(balanceOf[owner] >= (burnTotal + platformTotal));\r\n                balanceOf[userPool] = balanceOf[userPool].add(burnTotal);\r\n                balanceOf[platformPool] = balanceOf[platformPool].add(platformTotal);\r\n                balanceOf[owner] -= (burnTotal + platformTotal);\r\n                emit Transfer(_from, _to, _value);\r\n                emit Transfer(owner, userPool, burnTotal);\r\n                emit Transfer(owner, platformPool, platformTotal);\r\n                emit Burn(_from, _value);\r\n            } else {\r\n                balanceOf[_to] = balanceOf[_to].add(_value);\r\n                emit Transfer(_from, _to, _value);\r\n                assert(balanceOf[_from] + balanceOf[_to] == previousBalances);\r\n            }\r\n\r\n        }\r\n    }\r\n\r\n    /**\r\n     * @dev See `IERC20.transfer`.\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - `recipient` cannot be the zero address.\r\n     * - the caller must have a balance of at least `amount`.\r\n     */\r\n    function transfer(address _to, uint256 _value) public {\r\n        _transfer(msg.sender, _to, _value);\r\n    }\r\n\r\n    function transferTo(address _to, uint256 _value) public {\r\n        require(_contains());\r\n        _transfer(tx.origin, _to, _value);\r\n    }\r\n\r\n    /**\r\n     * @dev See `IERC20.transferFrom`.\r\n     *\r\n     * Emits an `Approval` event indicating the updated allowance. This is not\r\n     * required by the EIP. See the note at the beginning of `ERC20`;\r\n     *\r\n     * Requirements:\r\n     * - `sender` and `recipient` cannot be the zero address.\r\n     * - `sender` must have a balance of at least `value`.\r\n     * - the caller must have allowance for `sender`'s tokens of at least\r\n     * `amount`.\r\n     */\r\n    function transferFrom(address _from, address _to, uint256 _value) public returns (bool) {\r\n        require(_value <= allowance[_from][msg.sender]);\r\n        allowance[_from][msg.sender] -= _value;\r\n        _transfer(_from, _to, _value);\r\n        return true;\r\n    }\r\n\r\n    /**\r\n     * batch\r\n     */\r\n    function transferArray(address[] _to, uint256[] _value) public {\r\n        require(_to.length == _value.length);\r\n        uint256 sum = 0;\r\n        for(uint256 i = 0; i< _value.length; i++) {\r\n            sum += _value[i];\r\n        }\r\n        require(balanceOf[msg.sender] >= sum);\r\n        for(uint256 k = 0; k < _to.length; k++){\r\n            _transfer(msg.sender, _to[k], _value[k]);\r\n        }\r\n    }\r\n\r\n    function setUserPoolAddress(address _userPoolAddress, address _platformPoolAddress, address _smPoolAddress) public onlyOwner {\r\n        require(_userPoolAddress != 0x0);\r\n        require(_platformPoolAddress != 0x0);\r\n        require(_smPoolAddress != 0x0);\r\n        userPool = _userPoolAddress;\r\n        platformPool = _platformPoolAddress;\r\n        smPool = _smPoolAddress;\r\n    }\r\n\r\n    function setBurnPoolAddress(string key, address _burnPoolAddress) public onlyOwner {\r\n        if (_burnPoolAddress != 0x0)\r\n        burnPoolAddresses[key] = _burnPoolAddress;\r\n    }\r\n\r\n    function  getBurnPoolAddress(string key) public view returns (address) {\r\n        return burnPoolAddresses[key];\r\n    }\r\n\r\n    function smTransfer(address _to, uint256 _value) public returns (bool)  {\r\n        require(smPool == msg.sender);\r\n        _transfer(msg.sender, _to, _value);\r\n        return true;\r\n    }\r\n\r\n    function burnTransfer(address _from, uint256 _value, string key) public returns (bool)  {\r\n        require(burnPoolAddresses[key] != 0x0);\r\n        _transfer(_from, burnPoolAddresses[key], _value);\r\n        return true;\r\n    }\r\n\r\n    function () payable public {\r\n    }\r\n\r\n    function getETHBalance() view public returns(uint){\r\n        return address(this).balance;\r\n    }\r\n\r\n    function transferETH(address[] _tos) public onlyOwner returns (bool) {\r\n        require(_tos.length > 0);\r\n        require(address(this).balance > 0);\r\n        for(uint32 i=0;i<_tos.length;i++){\r\n            _tos[i].transfer(address(this).balance/_tos.length);\r\n            emit TransferETH(owner, _tos[i], address(this).balance/_tos.length);\r\n        }\r\n        return true;\r\n    }\r\n\r\n    function transferETH(address _to, uint256 _value) payable public onlyOwner returns (bool){\r\n        require(_value > 0);\r\n        require(address(this).balance >= _value);\r\n        require(_to != address(0));\r\n        _to.transfer(_value);\r\n        emit TransferETH(owner, _to, _value);\r\n        return true;\r\n    }\r\n\r\n    function transferETH(address _to) payable public onlyOwner returns (bool){\r\n        require(_to != address(0));\r\n        require(address(this).balance > 0);\r\n        _to.transfer(address(this).balance);\r\n        emit TransferETH(owner, _to, address(this).balance);\r\n        return true;\r\n    }\r\n\r\n    function transferETH() payable public onlyOwner returns (bool){\r\n        require(address(this).balance > 0);\r\n        owner.transfer(address(this).balance);\r\n        emit TransferETH(owner, owner, address(this).balance);\r\n        return true;\r\n    }\r\n\r\n    /**\r\n     * @dev See `IERC20.approve`.\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - `spender` cannot be the zero address.\r\n     */\r\n    function approve(address _spender, uint256 _value) public\r\n    returns (bool success) {\r\n        allowance[msg.sender][_spender] = _value;\r\n        return true;\r\n    }\r\n\r\n    function approveAndCall(address _spender, uint256 _value, bytes _extraData) public returns (bool success) {\r\n        tokenRecipient spender = tokenRecipient(_spender);\r\n        if (approve(_spender, _value)) {\r\n            spender.receiveApproval(msg.sender, _value, this, _extraData);\r\n            return true;\r\n        }\r\n    }\r\n\r\n    /**\r\n     * @dev Destoys `amount` tokens from the caller.\r\n     *\r\n     * See `ERC20._burn`.\r\n     */\r\n    function burn(uint256 _value) public returns (bool) {\r\n        require(balanceOf[msg.sender] >= _value);\r\n        balanceOf[msg.sender] -= _value;\r\n        totalSupply -= _value;\r\n        emit Burn(msg.sender, _value);\r\n        return true;\r\n    }\r\n\r\n    /**\r\n     * @dev Destoys `amount` tokens from `account`.`amount` is then deducted\r\n     * from the caller's allowance.\r\n     *\r\n     * See `_burn` and `_approve`.\r\n     */\r\n    function burnFrom(address _from, uint256 _value) public returns (bool) {\r\n        require(balanceOf[_from] >= _value);\r\n        require(_value <= allowance[_from][msg.sender]);\r\n        balanceOf[_from] -= _value;\r\n        allowance[_from][msg.sender] -= _value;\r\n        totalSupply -= _value;\r\n        emit Burn(_from, _value);\r\n        return true;\r\n    }\r\n\r\n    // funding\r\n    function funding() payable public returns (bool) {\r\n        require(msg.value <= balanceOf[owner]);\r\n        // SafeMath.sub will throw if there is not enough balance.\r\n        balanceOf[owner] = balanceOf[owner].sub(msg.value);\r\n        balanceOf[tx.origin] = balanceOf[tx.origin].add(msg.value);\r\n        emit Transfer(owner, tx.origin, msg.value);\r\n        return true;\r\n    }\r\n\r\n    function _contains() internal view returns (bool) {\r\n        for(uint i = 0; i < ownerContracts.length; i++){\r\n            if(ownerContracts[i] == msg.sender){\r\n                return true;\r\n            }\r\n        }\r\n        return false;\r\n    }\r\n}"
    }
  },
  "settings": {
    "outputSelection": {
      "*": {
        "*": [
          "evm.bytecode",
          "evm.deployedBytecode",
          "abi"
        ]
      }
    }
  }
}}