{{
  "language": "Solidity",
  "sources": {
    "/mnt/c/Users/Jered/Desktop/L/Github/lambo.farm2/trunk/contracts/LamboPresale.sol": {
      "content": "//SPDX-License-Identifier: Unlicense\r\npragma solidity =0.6.6;\r\n\r\n/*\r\n * @dev Provides information about the current execution context, including the\r\n * sender of the transaction and its data. While these are generally available\r\n * via msg.sender and msg.data, they should not be accessed in such a direct\r\n * manner, since when dealing with GSN meta-transactions the account sending and\r\n * paying for execution may not be the actual sender (as far as an application\r\n * is concerned).\r\n *\r\n * This contract is only required for intermediate, library-like contracts.\r\n */\r\nabstract contract Context {\r\n    function _msgSender() internal view virtual returns (address payable) {\r\n        return msg.sender;\r\n    }\r\n\r\n    function _msgData() internal view virtual returns (bytes memory) {\r\n        this; // silence state mutability warning without generating bytecode - see https://github.com/ethereum/solidity/issues/2691\r\n        return msg.data;\r\n    }\r\n}\r\n\r\n/**\r\n * @dev Contract module which provides a basic access control mechanism, where\r\n * there is an account (an owner) that can be granted exclusive access to\r\n * specific functions.\r\n *\r\n * By default, the owner account will be the one that deploys the contract. This\r\n * can later be changed with {transferOwnership}.\r\n *\r\n * This module is used through inheritance. It will make available the modifier\r\n * `onlyOwner`, which can be applied to your functions to restrict their use to\r\n * the owner.\r\n */\r\ncontract Ownable is Context {\r\n    address private _owner;\r\n\r\n    event OwnershipTransferred(address indexed previousOwner, address indexed newOwner);\r\n\r\n    /**\r\n     * @dev Initializes the contract setting the deployer as the initial owner.\r\n     */\r\n    constructor () internal {\r\n        address msgSender = _msgSender();\r\n        _owner = msgSender;\r\n        emit OwnershipTransferred(address(0), msgSender);\r\n    }\r\n\r\n    /**\r\n     * @dev Returns the address of the current owner.\r\n     */\r\n    function owner() public view returns (address) {\r\n        return _owner;\r\n    }\r\n\r\n    /**\r\n     * @dev Throws if called by any account other than the owner.\r\n     */\r\n    modifier onlyOwner() {\r\n        require(_owner == _msgSender(), \"Ownable: caller is not the owner\");\r\n        _;\r\n    }\r\n\r\n    /**\r\n     * @dev Leaves the contract without owner. It will not be possible to call\r\n     * `onlyOwner` functions anymore. Can only be called by the current owner.\r\n     *\r\n     * NOTE: Renouncing ownership will leave the contract without an owner,\r\n     * thereby removing any functionality that is only available to the owner.\r\n     */\r\n    function renounceOwnership() public virtual onlyOwner {\r\n        emit OwnershipTransferred(_owner, address(0));\r\n        _owner = address(0);\r\n    }\r\n\r\n    /**\r\n     * @dev Transfers ownership of the contract to a new account (`newOwner`).\r\n     * Can only be called by the current owner.\r\n     */\r\n    function transferOwnership(address newOwner) public virtual onlyOwner {\r\n        require(newOwner != address(0), \"Ownable: new owner is the zero address\");\r\n        emit OwnershipTransferred(_owner, newOwner);\r\n        _owner = newOwner;\r\n    }\r\n}\r\n\r\n/**\r\n * @dev Wrappers over Solidity's arithmetic operations with added overflow\r\n * checks.\r\n *\r\n * Arithmetic operations in Solidity wrap on overflow. This can easily result\r\n * in bugs, because programmers usually assume that an overflow raises an\r\n * error, which is the standard behavior in high level programming languages.\r\n * `SafeMath` restores this intuition by reverting the transaction when an\r\n * operation overflows.\r\n *\r\n * Using this library instead of the unchecked operations eliminates an entire\r\n * class of bugs, so it's recommended to use it always.\r\n */\r\nlibrary SafeMath {\r\n    /**\r\n     * @dev Returns the addition of two unsigned integers, reverting on\r\n     * overflow.\r\n     *\r\n     * Counterpart to Solidity's `+` operator.\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - Addition cannot overflow.\r\n     */\r\n    function add(uint256 a, uint256 b) internal pure returns (uint256) {\r\n        uint256 c = a + b;\r\n        require(c >= a, \"SafeMath: addition overflow\");\r\n\r\n        return c;\r\n    }\r\n\r\n    /**\r\n     * @dev Returns the subtraction of two unsigned integers, reverting on\r\n     * overflow (when the result is negative).\r\n     *\r\n     * Counterpart to Solidity's `-` operator.\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - Subtraction cannot overflow.\r\n     */\r\n    function sub(uint256 a, uint256 b) internal pure returns (uint256) {\r\n        return sub(a, b, \"SafeMath: subtraction overflow\");\r\n    }\r\n\r\n    /**\r\n     * @dev Returns the subtraction of two unsigned integers, reverting with custom message on\r\n     * overflow (when the result is negative).\r\n     *\r\n     * Counterpart to Solidity's `-` operator.\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - Subtraction cannot overflow.\r\n     */\r\n    function sub(uint256 a, uint256 b, string memory errorMessage) internal pure returns (uint256) {\r\n        require(b <= a, errorMessage);\r\n        uint256 c = a - b;\r\n\r\n        return c;\r\n    }\r\n\r\n    /**\r\n     * @dev Returns the multiplication of two unsigned integers, reverting on\r\n     * overflow.\r\n     *\r\n     * Counterpart to Solidity's `*` operator.\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - Multiplication cannot overflow.\r\n     */\r\n    function mul(uint256 a, uint256 b) internal pure returns (uint256) {\r\n        // Gas optimization: this is cheaper than requiring 'a' not being zero, but the\r\n        // benefit is lost if 'b' is also tested.\r\n        // See: https://github.com/OpenZeppelin/openzeppelin-contracts/pull/522\r\n        if (a == 0) {\r\n            return 0;\r\n        }\r\n\r\n        uint256 c = a * b;\r\n        require(c / a == b, \"SafeMath: multiplication overflow\");\r\n\r\n        return c;\r\n    }\r\n\r\n    /**\r\n     * @dev Returns the integer division of two unsigned integers. Reverts on\r\n     * division by zero. The result is rounded towards zero.\r\n     *\r\n     * Counterpart to Solidity's `/` operator. Note: this function uses a\r\n     * `revert` opcode (which leaves remaining gas untouched) while Solidity\r\n     * uses an invalid opcode to revert (consuming all remaining gas).\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - The divisor cannot be zero.\r\n     */\r\n    function div(uint256 a, uint256 b) internal pure returns (uint256) {\r\n        return div(a, b, \"SafeMath: division by zero\");\r\n    }\r\n\r\n    /**\r\n     * @dev Returns the integer division of two unsigned integers. Reverts with custom message on\r\n     * division by zero. The result is rounded towards zero.\r\n     *\r\n     * Counterpart to Solidity's `/` operator. Note: this function uses a\r\n     * `revert` opcode (which leaves remaining gas untouched) while Solidity\r\n     * uses an invalid opcode to revert (consuming all remaining gas).\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - The divisor cannot be zero.\r\n     */\r\n    function div(uint256 a, uint256 b, string memory errorMessage) internal pure returns (uint256) {\r\n        require(b > 0, errorMessage);\r\n        uint256 c = a / b;\r\n        // assert(a == b * c + a % b); // There is no case in which this doesn't hold\r\n\r\n        return c;\r\n    }\r\n\r\n    /**\r\n     * @dev Returns the remainder of dividing two unsigned integers. (unsigned integer modulo),\r\n     * Reverts when dividing by zero.\r\n     *\r\n     * Counterpart to Solidity's `%` operator. This function uses a `revert`\r\n     * opcode (which leaves remaining gas untouched) while Solidity uses an\r\n     * invalid opcode to revert (consuming all remaining gas).\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - The divisor cannot be zero.\r\n     */\r\n    function mod(uint256 a, uint256 b) internal pure returns (uint256) {\r\n        return mod(a, b, \"SafeMath: modulo by zero\");\r\n    }\r\n\r\n    /**\r\n     * @dev Returns the remainder of dividing two unsigned integers. (unsigned integer modulo),\r\n     * Reverts with custom message when dividing by zero.\r\n     *\r\n     * Counterpart to Solidity's `%` operator. This function uses a `revert`\r\n     * opcode (which leaves remaining gas untouched) while Solidity uses an\r\n     * invalid opcode to revert (consuming all remaining gas).\r\n     *\r\n     * Requirements:\r\n     *\r\n     * - The divisor cannot be zero.\r\n     */\r\n    function mod(uint256 a, uint256 b, string memory errorMessage) internal pure returns (uint256) {\r\n        require(b != 0, errorMessage);\r\n        return a % b;\r\n    }\r\n}\r\n\r\n/**\r\n * @dev Interface of the ERC20 standard as defined in the EIP.\r\n */\r\ninterface IERC20 {\r\n    /**\r\n     * @dev Returns the amount of tokens in existence.\r\n     */\r\n    function totalSupply() external view returns (uint256);\r\n\r\n    /**\r\n     * @dev Returns the amount of tokens owned by `account`.\r\n     */\r\n    function balanceOf(address account) external view returns (uint256);\r\n\r\n    /**\r\n     * @dev Moves `amount` tokens from the caller's account to `recipient`.\r\n     *\r\n     * Returns a boolean value indicating whether the operation succeeded.\r\n     *\r\n     * Emits a {Transfer} event.\r\n     */\r\n    function transfer(address recipient, uint256 amount) external returns (bool);\r\n\r\n    /**\r\n     * @dev Returns the remaining number of tokens that `spender` will be\r\n     * allowed to spend on behalf of `owner` through {transferFrom}. This is\r\n     * zero by default.\r\n     *\r\n     * This value changes when {approve} or {transferFrom} are called.\r\n     */\r\n    function allowance(address owner, address spender) external view returns (uint256);\r\n\r\n    /**\r\n     * @dev Sets `amount` as the allowance of `spender` over the caller's tokens.\r\n     *\r\n     * Returns a boolean value indicating whether the operation succeeded.\r\n     *\r\n     * IMPORTANT: Beware that changing an allowance with this method brings the risk\r\n     * that someone may use both the old and the new allowance by unfortunate\r\n     * transaction ordering. One possible solution to mitigate this race\r\n     * condition is to first reduce the spender's allowance to 0 and set the\r\n     * desired value afterwards:\r\n     * https://github.com/ethereum/EIPs/issues/20#issuecomment-263524729\r\n     *\r\n     * Emits an {Approval} event.\r\n     */\r\n    function approve(address spender, uint256 amount) external returns (bool);\r\n\r\n    /**\r\n     * @dev Moves `amount` tokens from `sender` to `recipient` using the\r\n     * allowance mechanism. `amount` is then deducted from the caller's\r\n     * allowance.\r\n     *\r\n     * Returns a boolean value indicating whether the operation succeeded.\r\n     *\r\n     * Emits a {Transfer} event.\r\n     */\r\n    function transferFrom(address sender, address recipient, uint256 amount) external returns (bool);\r\n\r\n    /**\r\n     * @dev Emitted when `value` tokens are moved from one account (`from`) to\r\n     * another (`to`).\r\n     *\r\n     * Note that `value` may be zero.\r\n     */\r\n    event Transfer(address indexed from, address indexed to, uint256 value);\r\n\r\n    /**\r\n     * @dev Emitted when the allowance of a `spender` for an `owner` is set by\r\n     * a call to {approve}. `value` is the new allowance.\r\n     */\r\n    event Approval(address indexed owner, address indexed spender, uint256 value);\r\n}\r\n\r\n\r\ncontract LamboPresale is Ownable {\r\n  using SafeMath for uint256;\r\n\r\n  IERC20 public Token;\r\n  uint256 public TokenDecimals;\r\n\r\n  mapping(address => uint256) public investments; // total WEI invested per address (1ETH = 1e18WEI)\r\n  mapping (uint256=> address) public investors;   // list of participating investor addresses\r\n  uint256 private _investorCount = 0;             // number of unique addresses that have invested\r\n\r\n  mapping(address => bool) public whitelistAddresses; // all addresses eligible for presale\r\n  mapping(address => bool) public devAddresses;       // all addresses that are devs\r\n\r\n  uint256 public constant INVESTMENT_LIMIT_PRESALE = 1.5  ether; // 1.5 ETH is maximum investment limit for pre-sale\r\n  uint256 public constant INVESTMENT_LIMIT_DEVELOPER = 2.88 ether; // 2.88 ETH is maximum investment limit for developer pre-sale\r\n  uint256 public constant INVESTMENT_LIMIT_PUBLIC = 0.5 ether;    //0.5 ETH is maximum investment limit for public pre-sale\r\n\r\n  uint256 public constant INVESTMENT_RATIO_PRESALE   = 28;// divided by 100 // whitelist pre-sale rate is 0.28 ETH/$LAMBO\r\n  uint256 public constant INVESTMENT_RATIO_DEVELOPER = 18;// divided by 100 // developer pre-sale rate is 0.18 ETH/$LAMBO\r\n  uint256 public constant INVESTMENT_RATIO_PUBLIC = 42;   // divided by 100 // public pre-sale rate is 0.42 ETH/$LAMBO (Uniswap listing price)\r\n\r\n  bool public isPresaleActive = false; // investing is only allowed if presale is active\r\n  bool public allowPublicInvestment = false; // public investing is only allowed once the devlist/whitelist presale is over\r\n\r\n  constructor() public {\r\n    TokenDecimals = 1e18;\r\n  }\r\n\r\n  function passTokenAddress(address tokenAddress) public onlyOwner {\r\n    Token = IERC20(tokenAddress);\r\n  }\r\n\r\n  function startPresale() public onlyOwner {\r\n    isPresaleActive = true;\r\n  }\r\n\r\n  function startPublicPresale() public onlyOwner {\r\n    allowPublicInvestment = true;\r\n  }\r\n\r\n  function endPresale() public onlyOwner {\r\n    isPresaleActive = false;\r\n    payable(owner()).transfer(address(this).balance);\r\n    Token.transfer(address(Token), Token.balanceOf(address(this)));\r\n  }\r\n\r\n  function addWhitelistAddresses(address[] calldata _whitelistAddresses) external onlyOwner {\r\n    for (uint256 i = 0; i < _whitelistAddresses.length; i++) {\r\n      whitelistAddresses[_whitelistAddresses[i]] = true;\r\n    }\r\n  }\r\n\r\n  function addDevAddresses(address[] calldata _devlistAddresses) external onlyOwner {\r\n    for (uint256 i = 0; i < _devlistAddresses.length; i++) {\r\n      devAddresses[_devlistAddresses[i]] = true;\r\n    }\r\n  }\r\n\r\n  function refundInvestors() external onlyOwner {\r\n    for (uint256 i = 0; i < _investorCount; i++) {\r\n      address addressToRefund = investors[i];\r\n      uint256 refundAmount = investments[investors[i]];\r\n\r\n//      console.log(\"addressToRefund: '%s'\", addressToRefund);\r\n//      console.log(\"refundAmount: '%s'\", refundAmount);\r\n\r\n      payable(addressToRefund).transfer(refundAmount);\r\n      investments[investors[i]].sub(refundAmount);\r\n    }\r\n  }\r\n\r\n  modifier presaleActive() {\r\n    require(isPresaleActive, \"Presale is currently not active.\");\r\n    _;\r\n  }\r\n\r\n  modifier eligibleForPresale() {\r\n    require(whitelistAddresses[_msgSender()] || devAddresses[_msgSender()] || allowPublicInvestment, \"Your address is not whitelisted for either presale, or the public presale hasn't started yet.\");\r\n    _;\r\n  }\r\n\r\n  receive()\r\n    external\r\n    payable\r\n    presaleActive\r\n    eligibleForPresale\r\n  {\r\n    uint256 addressTotalInvestment = investments[_msgSender()].add(msg.value);\r\n\r\n    uint256 amountOfTokens;\r\n\r\n    if (isDevAddress(_msgSender()) && !allowPublicInvestment){\r\n\r\n      require(addressTotalInvestment <= INVESTMENT_LIMIT_DEVELOPER, \"Max investment per dev pre-sale address is 2.88 ETH.\");\r\n\r\n      amountOfTokens = msg.value.mul(100).div(INVESTMENT_RATIO_DEVELOPER);\r\n\r\n    } else if (isWhitelisted(_msgSender()) && !allowPublicInvestment) {\r\n\r\n      require(addressTotalInvestment <= INVESTMENT_LIMIT_PRESALE, \"Max investment per whitelist pre-sale address is 1.5 ETH.\");\r\n\r\n      amountOfTokens = msg.value.mul(100).div(INVESTMENT_RATIO_PRESALE);\r\n\r\n    } else if (allowPublicInvestment) {\r\n\r\n      require(addressTotalInvestment <= INVESTMENT_LIMIT_PUBLIC, \"Max investment for every address (once public presale has started) is 0.5 ETH.\");\r\n\r\n      amountOfTokens = msg.value.mul(100).div(INVESTMENT_RATIO_PUBLIC);\r\n    }\r\n\r\n    Token.transfer(_msgSender(), amountOfTokens);\r\n\r\n    investors[_investorCount] = msg.sender;\r\n    _investorCount++;\r\n\r\n    investments[_msgSender()] = addressTotalInvestment;\r\n\r\n  }\r\n\r\n  function isWhitelisted(address adr) public view returns (bool){\r\n    return whitelistAddresses[adr];\r\n  }\r\n\r\n  function isDevAddress(address adr) public view returns (bool){\r\n    return devAddresses[adr];\r\n  }\r\n\r\n  function getInvestedAmount(address adr) public view returns (uint256){\r\n      return investments[adr];\r\n  }\r\n\r\n  function getInvestorCount() public view returns (uint256){\r\n    return _investorCount;\r\n  }\r\n\r\n  function getPresaleInvestmentLimit() view public returns (uint256) {\r\n    return INVESTMENT_LIMIT_PRESALE;\r\n  }\r\n\r\n  function getDeveloperPresaleInvestmentLimit() view public returns (uint256) {\r\n    return INVESTMENT_LIMIT_DEVELOPER;\r\n  }\r\n\r\n  function getPublicPresaleInvestmentLimit() view public returns (uint256) {\r\n    return INVESTMENT_RATIO_PUBLIC;\r\n  }\r\n\r\n}"
    }
  },
  "settings": {
    "remappings": [],
    "optimizer": {
      "enabled": false,
      "runs": 200
    },
    "evmVersion": "istanbul",
    "libraries": {
      "": {}
    },
    "outputSelection": {
      "*": {
        "*": [
          "evm.bytecode",
          "evm.deployedBytecode",
          "abi"
        ]
      }
    }
  }
}}