{{
  "language": "Solidity",
  "sources": {
    "/home/mickey/Dev/fkx-bridge/contracts/ETH/ethBridge.sol": {
      "content": "// SPDX-License-Identifier: GPL-3.0\npragma solidity ^0.6.0;\n\nimport \"./multiOwnable.sol\";\nimport \"./fkxToken.sol\";\n\ncontract ethBridge is Multiownable {\n    FKX private token;\n\n    mapping(address => uint256) public tokensSent;\n    mapping(address => uint256) public tokensRecieved;\n    mapping(address => uint256) public tokensRecievedButNotSent;\n \n    address public tokenAddress; \n    \n    constructor (address _token) public {\n        tokenAddress = _token;\n        token = FKX(_token);\n    }\n \n    bool transferStatus;\n    \n    bool avoidReentrancy = false;\n \n    function sendTokens(uint256 amount) public {\n        require(msg.sender != address(0), \"Zero account\");\n        require(amount > 0,\"Amount of tokens should be more then 0\");\n        require(token.balanceOf(msg.sender) >= amount,\"Not enough balance\");\n        \n        transferStatus = token.transferFrom(msg.sender, address(this), amount);\n        if (transferStatus == true) {\n            tokensRecieved[msg.sender] += amount;\n        }\n    }\n \n    function writeTransaction(address user, uint256 amount) public onlyAllOwners {\n        require(user != address(0), \"Zero account\");\n        require(amount > 0,\"Amount of tokens should be more then 0\");\n        require(!avoidReentrancy);\n        \n        avoidReentrancy = true;\n        tokensRecievedButNotSent[user] += amount;\n        avoidReentrancy = false;\n    }\n\n    function recieveTokens(uint256[] memory commissions) public payable {\n        if (tokensRecievedButNotSent[msg.sender] != 0) {\n            require(commissions.length == owners.length, \"The number of commissions and owners does not match\");\n            uint256 sum;\n            for(uint i = 0; i < commissions.length; i++) {\n                sum += commissions[i];\n            }\n            require(msg.value >= sum, \"Not enough BNB (The amount of BNB is less than the amount of commissions.)\");\n            require(msg.value >= owners.length * 150000 * 10**9, \"Not enough BNB (The amount of BNB is less than the internal commission.)\");\n        \n            for (uint i = 0; i < owners.length; i++) {\n                address payable owner = payable(owners[i]);\n                uint256 commission = commissions[i];\n                owner.transfer(commission);\n            }\n            \n            uint256 amountToSent;\n            \n            amountToSent = tokensRecievedButNotSent[msg.sender] - tokensSent[msg.sender];\n            transferStatus = token.transfer(msg.sender, amountToSent);\n            if (transferStatus == true) {\n                tokensSent[msg.sender] += amountToSent;\n            }\n        }\n    }\n \n    function withdrawTokens(uint256 amount, address reciever) public onlyAllOwners {\n        require(amount > 0,\"Amount of tokens should be more then 0\");\n        require(reciever != address(0), \"Zero account\");\n        require(token.balanceOf(address(this)) >= amount,\"Not enough balance\");\n        \n        token.transfer(reciever, amount);\n    }\n    \n    function withdrawEther(uint256 amount, address payable reciever) public onlyAllOwners {\n        require(amount > 0,\"Amount of tokens should be more then 0\");\n        require(reciever != address(0), \"Zero account\");\n        require(address(this).balance >= amount,\"Not enough balance\");\n\n        reciever.transfer(amount);\n    }\n}"
    },
    "/home/mickey/Dev/fkx-bridge/contracts/ETH/fkxToken.sol": {
      "content": "// SPDX-License-Identifier: MIT\n\npragma solidity ^0.6.0;\n\n\n// \n/*\n * @dev Provides information about the current execution context, including the\n * sender of the transaction and its data. While these are generally available\n * via msg.sender and msg.data, they should not be accessed in such a direct\n * manner, since when dealing with GSN meta-transactions the account sending and\n * paying for execution may not be the actual sender (as far as an application\n * is concerned).\n *\n * This contract is only required for intermediate, library-like contracts.\n */\nabstract contract Context {\n    function _msgSender() internal view virtual returns (address payable) {\n        return msg.sender;\n    }\n\n    function _msgData() internal view virtual returns (bytes memory) {\n        this; // silence state mutability warning without generating bytecode - see https://github.com/ethereum/solidity/issues/2691\n        return msg.data;\n    }\n}\n\n// \n/**\n * @dev Interface of the ERC20 standard as defined in the EIP.\n */\ninterface IERC20 {\n    /**\n     * @dev Returns the amount of tokens in existence.\n     */\n    function totalSupply() external view returns (uint256);\n\n    /**\n     * @dev Returns the amount of tokens owned by `account`.\n     */\n    function balanceOf(address account) external view returns (uint256);\n\n    /**\n     * @dev Moves `amount` tokens from the caller's account to `recipient`.\n     *\n     * Returns a boolean value indicating whether the operation succeeded.\n     *\n     * Emits a {Transfer} event.\n     */\n    function transfer(address recipient, uint256 amount) external returns (bool);\n\n    /**\n     * @dev Returns the remaining number of tokens that `spender` will be\n     * allowed to spend on behalf of `owner` through {transferFrom}. This is\n     * zero by default.\n     *\n     * This value changes when {approve} or {transferFrom} are called.\n     */\n    function allowance(address owner, address spender) external view returns (uint256);\n\n    /**\n     * @dev Sets `amount` as the allowance of `spender` over the caller's tokens.\n     *\n     * Returns a boolean value indicating whether the operation succeeded.\n     *\n     * IMPORTANT: Beware that changing an allowance with this method brings the risk\n     * that someone may use both the old and the new allowance by unfortunate\n     * transaction ordering. One possible solution to mitigate this race\n     * condition is to first reduce the spender's allowance to 0 and set the\n     * desired value afterwards:\n     * https://github.com/ethereum/EIPs/issues/20#issuecomment-263524729\n     *\n     * Emits an {Approval} event.\n     */\n    function approve(address spender, uint256 amount) external returns (bool);\n\n    /**\n     * @dev Moves `amount` tokens from `sender` to `recipient` using the\n     * allowance mechanism. `amount` is then deducted from the caller's\n     * allowance.\n     *\n     * Returns a boolean value indicating whether the operation succeeded.\n     *\n     * Emits a {Transfer} event.\n     */\n    function transferFrom(address sender, address recipient, uint256 amount) external returns (bool);\n\n    /**\n     * @dev Emitted when `value` tokens are moved from one account (`from`) to\n     * another (`to`).\n     *\n     * Note that `value` may be zero.\n     */\n    event Transfer(address indexed from, address indexed to, uint256 value);\n\n    /**\n     * @dev Emitted when the allowance of a `spender` for an `owner` is set by\n     * a call to {approve}. `value` is the new allowance.\n     */\n    event Approval(address indexed owner, address indexed spender, uint256 value);\n}\n\n// \n/**\n * @dev Wrappers over Solidity's arithmetic operations with added overflow\n * checks.\n *\n * Arithmetic operations in Solidity wrap on overflow. This can easily result\n * in bugs, because programmers usually assume that an overflow raises an\n * error, which is the standard behavior in high level programming languages.\n * `SafeMath` restores this intuition by reverting the transaction when an\n * operation overflows.\n *\n * Using this library instead of the unchecked operations eliminates an entire\n * class of bugs, so it's recommended to use it always.\n */\nlibrary SafeMath {\n    /**\n     * @dev Returns the addition of two unsigned integers, reverting on\n     * overflow.\n     *\n     * Counterpart to Solidity's `+` operator.\n     *\n     * Requirements:\n     *\n     * - Addition cannot overflow.\n     */\n    function add(uint256 a, uint256 b) internal pure returns (uint256) {\n        uint256 c = a + b;\n        require(c >= a, \"SafeMath: addition overflow\");\n\n        return c;\n    }\n\n    /**\n     * @dev Returns the subtraction of two unsigned integers, reverting on\n     * overflow (when the result is negative).\n     *\n     * Counterpart to Solidity's `-` operator.\n     *\n     * Requirements:\n     *\n     * - Subtraction cannot overflow.\n     */\n    function sub(uint256 a, uint256 b) internal pure returns (uint256) {\n        return sub(a, b, \"SafeMath: subtraction overflow\");\n    }\n\n    /**\n     * @dev Returns the subtraction of two unsigned integers, reverting with custom message on\n     * overflow (when the result is negative).\n     *\n     * Counterpart to Solidity's `-` operator.\n     *\n     * Requirements:\n     *\n     * - Subtraction cannot overflow.\n     */\n    function sub(uint256 a, uint256 b, string memory errorMessage) internal pure returns (uint256) {\n        require(b <= a, errorMessage);\n        uint256 c = a - b;\n\n        return c;\n    }\n\n    /**\n     * @dev Returns the multiplication of two unsigned integers, reverting on\n     * overflow.\n     *\n     * Counterpart to Solidity's `*` operator.\n     *\n     * Requirements:\n     *\n     * - Multiplication cannot overflow.\n     */\n    function mul(uint256 a, uint256 b) internal pure returns (uint256) {\n        // Gas optimization: this is cheaper than requiring 'a' not being zero, but the\n        // benefit is lost if 'b' is also tested.\n        // See: https://github.com/OpenZeppelin/openzeppelin-contracts/pull/522\n        if (a == 0) {\n            return 0;\n        }\n\n        uint256 c = a * b;\n        require(c / a == b, \"SafeMath: multiplication overflow\");\n\n        return c;\n    }\n\n    /**\n     * @dev Returns the integer division of two unsigned integers. Reverts on\n     * division by zero. The result is rounded towards zero.\n     *\n     * Counterpart to Solidity's `/` operator. Note: this function uses a\n     * `revert` opcode (which leaves remaining gas untouched) while Solidity\n     * uses an invalid opcode to revert (consuming all remaining gas).\n     *\n     * Requirements:\n     *\n     * - The divisor cannot be zero.\n     */\n    function div(uint256 a, uint256 b) internal pure returns (uint256) {\n        return div(a, b, \"SafeMath: division by zero\");\n    }\n\n    /**\n     * @dev Returns the integer division of two unsigned integers. Reverts with custom message on\n     * division by zero. The result is rounded towards zero.\n     *\n     * Counterpart to Solidity's `/` operator. Note: this function uses a\n     * `revert` opcode (which leaves remaining gas untouched) while Solidity\n     * uses an invalid opcode to revert (consuming all remaining gas).\n     *\n     * Requirements:\n     *\n     * - The divisor cannot be zero.\n     */\n    function div(uint256 a, uint256 b, string memory errorMessage) internal pure returns (uint256) {\n        require(b > 0, errorMessage);\n        uint256 c = a / b;\n        // assert(a == b * c + a % b); // There is no case in which this doesn't hold\n\n        return c;\n    }\n\n    /**\n     * @dev Returns the remainder of dividing two unsigned integers. (unsigned integer modulo),\n     * Reverts when dividing by zero.\n     *\n     * Counterpart to Solidity's `%` operator. This function uses a `revert`\n     * opcode (which leaves remaining gas untouched) while Solidity uses an\n     * invalid opcode to revert (consuming all remaining gas).\n     *\n     * Requirements:\n     *\n     * - The divisor cannot be zero.\n     */\n    function mod(uint256 a, uint256 b) internal pure returns (uint256) {\n        return mod(a, b, \"SafeMath: modulo by zero\");\n    }\n\n    /**\n     * @dev Returns the remainder of dividing two unsigned integers. (unsigned integer modulo),\n     * Reverts with custom message when dividing by zero.\n     *\n     * Counterpart to Solidity's `%` operator. This function uses a `revert`\n     * opcode (which leaves remaining gas untouched) while Solidity uses an\n     * invalid opcode to revert (consuming all remaining gas).\n     *\n     * Requirements:\n     *\n     * - The divisor cannot be zero.\n     */\n    function mod(uint256 a, uint256 b, string memory errorMessage) internal pure returns (uint256) {\n        require(b != 0, errorMessage);\n        return a % b;\n    }\n}\n\n// \n/**\n * @dev Collection of functions related to the address type\n */\nlibrary Address {\n    /**\n     * @dev Returns true if `account` is a contract.\n     *\n     * [IMPORTANT]\n     * ====\n     * It is unsafe to assume that an address for which this function returns\n     * false is an externally-owned account (EOA) and not a contract.\n     *\n     * Among others, `isContract` will return false for the following\n     * types of addresses:\n     *\n     *  - an externally-owned account\n     *  - a contract in construction\n     *  - an address where a contract will be created\n     *  - an address where a contract lived, but was destroyed\n     * ====\n     */\n    function isContract(address account) internal view returns (bool) {\n        // This method relies in extcodesize, which returns 0 for contracts in\n        // construction, since the code is only stored at the end of the\n        // constructor execution.\n\n        uint256 size;\n        // solhint-disable-next-line no-inline-assembly\n        assembly { size := extcodesize(account) }\n        return size > 0;\n    }\n\n    /**\n     * @dev Replacement for Solidity's `transfer`: sends `amount` wei to\n     * `recipient`, forwarding all available gas and reverting on errors.\n     *\n     * https://eips.ethereum.org/EIPS/eip-1884[EIP1884] increases the gas cost\n     * of certain opcodes, possibly making contracts go over the 2300 gas limit\n     * imposed by `transfer`, making them unable to receive funds via\n     * `transfer`. {sendValue} removes this limitation.\n     *\n     * https://diligence.consensys.net/posts/2019/09/stop-using-soliditys-transfer-now/[Learn more].\n     *\n     * IMPORTANT: because control is transferred to `recipient`, care must be\n     * taken to not create reentrancy vulnerabilities. Consider using\n     * {ReentrancyGuard} or the\n     * https://solidity.readthedocs.io/en/v0.5.11/security-considerations.html#use-the-checks-effects-interactions-pattern[checks-effects-interactions pattern].\n     */\n    function sendValue(address payable recipient, uint256 amount) internal {\n        require(address(this).balance >= amount, \"Address: insufficient balance\");\n\n        // solhint-disable-next-line avoid-low-level-calls, avoid-call-value\n        (bool success, ) = recipient.call{ value: amount }(\"\");\n        require(success, \"Address: unable to send value, recipient may have reverted\");\n    }\n\n    /**\n     * @dev Performs a Solidity function call using a low level `call`. A\n     * plain`call` is an unsafe replacement for a function call: use this\n     * function instead.\n     *\n     * If `target` reverts with a revert reason, it is bubbled up by this\n     * function (like regular Solidity function calls).\n     *\n     * Returns the raw returned data. To convert to the expected return value,\n     * use https://solidity.readthedocs.io/en/latest/units-and-global-variables.html?highlight=abi.decode#abi-encoding-and-decoding-functions[`abi.decode`].\n     *\n     * Requirements:\n     *\n     * - `target` must be a contract.\n     * - calling `target` with `data` must not revert.\n     *\n     * _Available since v3.1._\n     */\n    function functionCall(address target, bytes memory data) internal returns (bytes memory) {\n      return functionCall(target, data, \"Address: low-level call failed\");\n    }\n\n    /**\n     * @dev Same as {xref-Address-functionCall-address-bytes-}[`functionCall`], but with\n     * `errorMessage` as a fallback revert reason when `target` reverts.\n     *\n     * _Available since v3.1._\n     */\n    function functionCall(address target, bytes memory data, string memory errorMessage) internal returns (bytes memory) {\n        return _functionCallWithValue(target, data, 0, errorMessage);\n    }\n\n    /**\n     * @dev Same as {xref-Address-functionCall-address-bytes-}[`functionCall`],\n     * but also transferring `value` wei to `target`.\n     *\n     * Requirements:\n     *\n     * - the calling contract must have an ETH balance of at least `value`.\n     * - the called Solidity function must be `payable`.\n     *\n     * _Available since v3.1._\n     */\n    function functionCallWithValue(address target, bytes memory data, uint256 value) internal returns (bytes memory) {\n        return functionCallWithValue(target, data, value, \"Address: low-level call with value failed\");\n    }\n\n    /**\n     * @dev Same as {xref-Address-functionCallWithValue-address-bytes-uint256-}[`functionCallWithValue`], but\n     * with `errorMessage` as a fallback revert reason when `target` reverts.\n     *\n     * _Available since v3.1._\n     */\n    function functionCallWithValue(address target, bytes memory data, uint256 value, string memory errorMessage) internal returns (bytes memory) {\n        require(address(this).balance >= value, \"Address: insufficient balance for call\");\n        return _functionCallWithValue(target, data, value, errorMessage);\n    }\n\n    function _functionCallWithValue(address target, bytes memory data, uint256 weiValue, string memory errorMessage) private returns (bytes memory) {\n        require(isContract(target), \"Address: call to non-contract\");\n\n        // solhint-disable-next-line avoid-low-level-calls\n        (bool success, bytes memory returndata) = target.call{ value: weiValue }(data);\n        if (success) {\n            return returndata;\n        } else {\n            // Look for revert reason and bubble it up if present\n            if (returndata.length > 0) {\n                // The easiest way to bubble the revert reason is using memory via assembly\n\n                // solhint-disable-next-line no-inline-assembly\n                assembly {\n                    let returndata_size := mload(returndata)\n                    revert(add(32, returndata), returndata_size)\n                }\n            } else {\n                revert(errorMessage);\n            }\n        }\n    }\n}\n\n// \n/**\n * @dev Implementation of the {IERC20} interface.\n *\n * This implementation is agnostic to the way tokens are created. This means\n * that a supply mechanism has to be added in a derived contract using {_mint}.\n * For a generic mechanism see {ERC20PresetMinterPauser}.\n *\n * TIP: For a detailed writeup see our guide\n * https://forum.zeppelin.solutions/t/how-to-implement-erc20-supply-mechanisms/226[How\n * to implement supply mechanisms].\n *\n * We have followed general OpenZeppelin guidelines: functions revert instead\n * of returning `false` on failure. This behavior is nonetheless conventional\n * and does not conflict with the expectations of ERC20 applications.\n *\n * Additionally, an {Approval} event is emitted on calls to {transferFrom}.\n * This allows applications to reconstruct the allowance for all accounts just\n * by listening to said events. Other implementations of the EIP may not emit\n * these events, as it isn't required by the specification.\n *\n * Finally, the non-standard {decreaseAllowance} and {increaseAllowance}\n * functions have been added to mitigate the well-known issues around setting\n * allowances. See {IERC20-approve}.\n */\ncontract ERC20 is Context, IERC20 {\n    using SafeMath for uint256;\n    using Address for address;\n\n    mapping (address => uint256) private _balances;\n\n    mapping (address => mapping (address => uint256)) private _allowances;\n\n    uint256 private _totalSupply;\n\n    string private _name;\n    string private _symbol;\n    uint8 private _decimals;\n\n    /**\n     * @dev Sets the values for {name} and {symbol}, initializes {decimals} with\n     * a default value of 18.\n     *\n     * To select a different value for {decimals}, use {_setupDecimals}.\n     *\n     * All three of these values are immutable: they can only be set once during\n     * construction.\n     */\n    constructor (string memory name, string memory symbol) public {\n        _name = name;\n        _symbol = symbol;\n        _decimals = 18;\n    }\n\n    /**\n     * @dev Returns the name of the token.\n     */\n    function name() public view returns (string memory) {\n        return _name;\n    }\n\n    /**\n     * @dev Returns the symbol of the token, usually a shorter version of the\n     * name.\n     */\n    function symbol() public view returns (string memory) {\n        return _symbol;\n    }\n\n    /**\n     * @dev Returns the number of decimals used to get its user representation.\n     * For example, if `decimals` equals `2`, a balance of `505` tokens should\n     * be displayed to a user as `5,05` (`505 / 10 ** 2`).\n     *\n     * Tokens usually opt for a value of 18, imitating the relationship between\n     * Ether and Wei. This is the value {ERC20} uses, unless {_setupDecimals} is\n     * called.\n     *\n     * NOTE: This information is only used for _display_ purposes: it in\n     * no way affects any of the arithmetic of the contract, including\n     * {IERC20-balanceOf} and {IERC20-transfer}.\n     */\n    function decimals() public view returns (uint8) {\n        return _decimals;\n    }\n\n    /**\n     * @dev See {IERC20-totalSupply}.\n     */\n    function totalSupply() public view override returns (uint256) {\n        return _totalSupply;\n    }\n\n    /**\n     * @dev See {IERC20-balanceOf}.\n     */\n    function balanceOf(address account) public view override returns (uint256) {\n        return _balances[account];\n    }\n\n    /**\n     * @dev See {IERC20-transfer}.\n     *\n     * Requirements:\n     *\n     * - `recipient` cannot be the zero address.\n     * - the caller must have a balance of at least `amount`.\n     */\n    function transfer(address recipient, uint256 amount) public virtual override returns (bool) {\n        _transfer(_msgSender(), recipient, amount);\n        return true;\n    }\n\n    /**\n     * @dev See {IERC20-allowance}.\n     */\n    function allowance(address owner, address spender) public view virtual override returns (uint256) {\n        return _allowances[owner][spender];\n    }\n\n    /**\n     * @dev See {IERC20-approve}.\n     *\n     * Requirements:\n     *\n     * - `spender` cannot be the zero address.\n     */\n    function approve(address spender, uint256 amount) public virtual override returns (bool) {\n        _approve(_msgSender(), spender, amount);\n        return true;\n    }\n\n    /**\n     * @dev See {IERC20-transferFrom}.\n     *\n     * Emits an {Approval} event indicating the updated allowance. This is not\n     * required by the EIP. See the note at the beginning of {ERC20};\n     *\n     * Requirements:\n     * - `sender` and `recipient` cannot be the zero address.\n     * - `sender` must have a balance of at least `amount`.\n     * - the caller must have allowance for ``sender``'s tokens of at least\n     * `amount`.\n     */\n    function transferFrom(address sender, address recipient, uint256 amount) public virtual override returns (bool) {\n        _transfer(sender, recipient, amount);\n        _approve(sender, _msgSender(), _allowances[sender][_msgSender()].sub(amount, \"ERC20: transfer amount exceeds allowance\"));\n        return true;\n    }\n\n    /**\n     * @dev Atomically increases the allowance granted to `spender` by the caller.\n     *\n     * This is an alternative to {approve} that can be used as a mitigation for\n     * problems described in {IERC20-approve}.\n     *\n     * Emits an {Approval} event indicating the updated allowance.\n     *\n     * Requirements:\n     *\n     * - `spender` cannot be the zero address.\n     */\n    function increaseAllowance(address spender, uint256 addedValue) public virtual returns (bool) {\n        _approve(_msgSender(), spender, _allowances[_msgSender()][spender].add(addedValue));\n        return true;\n    }\n\n    /**\n     * @dev Atomically decreases the allowance granted to `spender` by the caller.\n     *\n     * This is an alternative to {approve} that can be used as a mitigation for\n     * problems described in {IERC20-approve}.\n     *\n     * Emits an {Approval} event indicating the updated allowance.\n     *\n     * Requirements:\n     *\n     * - `spender` cannot be the zero address.\n     * - `spender` must have allowance for the caller of at least\n     * `subtractedValue`.\n     */\n    function decreaseAllowance(address spender, uint256 subtractedValue) public virtual returns (bool) {\n        _approve(_msgSender(), spender, _allowances[_msgSender()][spender].sub(subtractedValue, \"ERC20: decreased allowance below zero\"));\n        return true;\n    }\n\n    /**\n     * @dev Moves tokens `amount` from `sender` to `recipient`.\n     *\n     * This is internal function is equivalent to {transfer}, and can be used to\n     * e.g. implement automatic token fees, slashing mechanisms, etc.\n     *\n     * Emits a {Transfer} event.\n     *\n     * Requirements:\n     *\n     * - `sender` cannot be the zero address.\n     * - `recipient` cannot be the zero address.\n     * - `sender` must have a balance of at least `amount`.\n     */\n    function _transfer(address sender, address recipient, uint256 amount) internal virtual {\n        require(sender != address(0), \"ERC20: transfer from the zero address\");\n        require(recipient != address(0), \"ERC20: transfer to the zero address\");\n\n        _beforeTokenTransfer(sender, recipient, amount);\n\n        _balances[sender] = _balances[sender].sub(amount, \"ERC20: transfer amount exceeds balance\");\n        _balances[recipient] = _balances[recipient].add(amount);\n        emit Transfer(sender, recipient, amount);\n    }\n\n    /** @dev Creates `amount` tokens and assigns them to `account`, increasing\n     * the total supply.\n     *\n     * Emits a {Transfer} event with `from` set to the zero address.\n     *\n     * Requirements\n     *\n     * - `to` cannot be the zero address.\n     */\n    function _mint(address account, uint256 amount) internal virtual {\n        require(account != address(0), \"ERC20: mint to the zero address\");\n\n        _beforeTokenTransfer(address(0), account, amount);\n\n        _totalSupply = _totalSupply.add(amount);\n        _balances[account] = _balances[account].add(amount);\n        emit Transfer(address(0), account, amount);\n    }\n\n    /**\n     * @dev Destroys `amount` tokens from `account`, reducing the\n     * total supply.\n     *\n     * Emits a {Transfer} event with `to` set to the zero address.\n     *\n     * Requirements\n     *\n     * - `account` cannot be the zero address.\n     * - `account` must have at least `amount` tokens.\n     */\n    function _burn(address account, uint256 amount) internal virtual {\n        require(account != address(0), \"ERC20: burn from the zero address\");\n\n        _beforeTokenTransfer(account, address(0), amount);\n\n        _balances[account] = _balances[account].sub(amount, \"ERC20: burn amount exceeds balance\");\n        _totalSupply = _totalSupply.sub(amount);\n        emit Transfer(account, address(0), amount);\n    }\n\n    /**\n     * @dev Sets `amount` as the allowance of `spender` over the `owner` s tokens.\n     *\n     * This internal function is equivalent to `approve`, and can be used to\n     * e.g. set automatic allowances for certain subsystems, etc.\n     *\n     * Emits an {Approval} event.\n     *\n     * Requirements:\n     *\n     * - `owner` cannot be the zero address.\n     * - `spender` cannot be the zero address.\n     */\n    function _approve(address owner, address spender, uint256 amount) internal virtual {\n        require(owner != address(0), \"ERC20: approve from the zero address\");\n        require(spender != address(0), \"ERC20: approve to the zero address\");\n\n        _allowances[owner][spender] = amount;\n        emit Approval(owner, spender, amount);\n    }\n\n    /**\n     * @dev Sets {decimals} to a value other than the default one of 18.\n     *\n     * WARNING: This function should only be called from the constructor. Most\n     * applications that interact with token contracts will not expect\n     * {decimals} to ever change, and may work incorrectly if it does.\n     */\n    function _setupDecimals(uint8 decimals_) internal {\n        _decimals = decimals_;\n    }\n\n    /**\n     * @dev Hook that is called before any transfer of tokens. This includes\n     * minting and burning.\n     *\n     * Calling conditions:\n     *\n     * - when `from` and `to` are both non-zero, `amount` of ``from``'s tokens\n     * will be to transferred to `to`.\n     * - when `from` is zero, `amount` tokens will be minted for `to`.\n     * - when `to` is zero, `amount` of ``from``'s tokens will be burned.\n     * - `from` and `to` are never both zero.\n     *\n     * To learn more about hooks, head to xref:ROOT:extending-contracts.adoc#using-hooks[Using Hooks].\n     */\n    function _beforeTokenTransfer(address from, address to, uint256 amount) internal virtual { }\n}\n\n// \n/**\n * @title FKX\n */\ncontract FKX is ERC20 {\n    constructor() public ERC20(\"Knoxstertoken\", \"FKX\") {\n        _mint(msg.sender, 150000000 ether); // Mint fixed supply of 150 Million FKX\n    }\n}"
    },
    "/home/mickey/Dev/fkx-bridge/contracts/ETH/multiOwnable.sol": {
      "content": "// SPDX-License-Identifier: MIT\npragma solidity ^0.6.0;\n\ncontract Multiownable {\n\n    // VARIABLES\n\n    uint256 public ownersGeneration;\n    uint256 public howManyOwnersDecide;\n    address[] public owners;\n    bytes32[] public allOperations;\n    address internal insideCallSender;\n    uint256 internal insideCallCount;\n\n    // Reverse lookup tables for owners and allOperations\n    mapping(address => uint) public ownersIndices; // Starts from 1\n    mapping(bytes32 => uint) public allOperationsIndicies;\n\n    // Owners voting mask per operations\n    mapping(bytes32 => uint256) public votesMaskByOperation;\n    mapping(bytes32 => uint256) public votesCountByOperation;\n\n    // EVENTS\n\n    event OwnershipTransferred(address[] previousOwners, uint howManyOwnersDecide, address[] newOwners, uint newHowManyOwnersDecide);\n    event OperationCreated(bytes32 operation, uint howMany, uint ownersCount, address proposer);\n    event OperationUpvoted(bytes32 operation, uint votes, uint howMany, uint ownersCount, address upvoter);\n    event OperationPerformed(bytes32 operation, uint howMany, uint ownersCount, address performer);\n    event OperationDownvoted(bytes32 operation, uint votes, uint ownersCount,  address downvoter);\n    event OperationCancelled(bytes32 operation, address lastCanceller);\n    \n    // ACCESSORS\n\n    function isOwner(address wallet) public view returns(bool) {\n        return ownersIndices[wallet] > 0;\n    }\n\n    function ownersCount() public view returns(uint) {\n        return owners.length;\n    }\n\n    function allOperationsCount() public view returns(uint) {\n        return allOperations.length;\n    }\n\n    // MODIFIERS\n\n    /**\n    * @dev Allows to perform method by any of the owners\n    */\n    modifier onlyAnyOwner {\n        if (checkHowManyOwners(1)) {\n            bool update = (insideCallSender == address(0));\n            if (update) {\n                insideCallSender = msg.sender;\n                insideCallCount = 1;\n            }\n            _;\n            if (update) {\n                insideCallSender = address(0);\n                insideCallCount = 0;\n            }\n        }\n    }\n\n    /**\n    * @dev Allows to perform method only after many owners call it with the same arguments\n    */\n    modifier onlyManyOwners {\n        if (checkHowManyOwners(howManyOwnersDecide)) {\n            bool update = (insideCallSender == address(0));\n            if (update) {\n                insideCallSender = msg.sender;\n                insideCallCount = howManyOwnersDecide;\n            }\n            _;\n            if (update) {\n                insideCallSender = address(0);\n                insideCallCount = 0;\n            }\n        }\n    }\n\n    /**\n    * @dev Allows to perform method only after all owners call it with the same arguments\n    */\n    modifier onlyAllOwners {\n        if (checkHowManyOwners(owners.length)) {\n            bool update = (insideCallSender == address(0));\n            if (update) {\n                insideCallSender = msg.sender;\n                insideCallCount = owners.length;\n            }\n            _;\n            if (update) {\n                insideCallSender = address(0);\n                insideCallCount = 0;\n            }\n        }\n    }\n\n    /**\n    * @dev Allows to perform method only after some owners call it with the same arguments\n    */\n    modifier onlySomeOwners(uint howMany) {\n        require(howMany > 0, \"onlySomeOwners: howMany argument is zero\");\n        require(howMany <= owners.length, \"onlySomeOwners: howMany argument exceeds the number of owners\");\n        \n        if (checkHowManyOwners(howMany)) {\n            bool update = (insideCallSender == address(0));\n            if (update) {\n                insideCallSender = msg.sender;\n                insideCallCount = howMany;\n            }\n            _;\n            if (update) {\n                insideCallSender = address(0);\n                insideCallCount = 0;\n            }\n        }\n    }\n\n    // CONSTRUCTOR\n\n    constructor() public {\n        owners.push(msg.sender);\n        ownersIndices[msg.sender] = 1;\n        howManyOwnersDecide = 1;\n    }\n\n    // INTERNAL METHODS\n\n    /**\n     * @dev onlyManyOwners modifier helper\n     */\n    function checkHowManyOwners(uint howMany) internal returns(bool) {\n        if (insideCallSender == msg.sender) {\n            require(howMany <= insideCallCount, \"checkHowManyOwners: nested owners modifier check require more owners\");\n            return true;\n        }\n\n        uint ownerIndex = ownersIndices[msg.sender] - 1;\n        require(ownerIndex < owners.length, \"checkHowManyOwners: msg.sender is not an owner\");\n        bytes32 operation = keccak256(abi.encodePacked(msg.data, ownersGeneration));\n\n        require((votesMaskByOperation[operation] & (2 ** ownerIndex)) == 0, \"checkHowManyOwners: owner already voted for the operation\");\n        votesMaskByOperation[operation] |= (2 ** ownerIndex);\n        uint operationVotesCount = votesCountByOperation[operation] + 1;\n        votesCountByOperation[operation] = operationVotesCount;\n        if (operationVotesCount == 1) {\n            allOperationsIndicies[operation] = allOperations.length;\n            allOperations.push(operation);\n            emit OperationCreated(operation, howMany, owners.length, msg.sender);\n        }\n        emit OperationUpvoted(operation, operationVotesCount, howMany, owners.length, msg.sender);\n\n        // If enough owners confirmed the same operation\n        if (votesCountByOperation[operation] == howMany) {\n            deleteOperation(operation);\n            emit OperationPerformed(operation, howMany, owners.length, msg.sender);\n            return true;\n        }\n\n        return false;\n    }\n\n    /**\n    * @dev Used to delete cancelled or performed operation\n    * @param operation defines which operation to delete\n    */\n    function deleteOperation(bytes32 operation) internal {\n        uint index = allOperationsIndicies[operation];\n        if (index < allOperations.length - 1) { // Not last\n            allOperations[index] = allOperations[allOperations.length - 1];\n            allOperationsIndicies[allOperations[index]] = index;\n        }\n        //allOperations.length-1\n        allOperations.pop();\n\n        delete votesMaskByOperation[operation];\n        delete votesCountByOperation[operation];\n        delete allOperationsIndicies[operation];\n    }\n\n    // PUBLIC METHODS\n\n    /**\n    * @dev Allows owners to change their mind by cacnelling votesMaskByOperation operations\n    * @param operation defines which operation to delete\n    */\n    function cancelPending(bytes32 operation) public onlyAnyOwner {\n        uint ownerIndex = ownersIndices[msg.sender] - 1;\n        require((votesMaskByOperation[operation] & (2 ** ownerIndex)) != 0, \"cancelPending: operation not found for this user\");\n        votesMaskByOperation[operation] &= ~(2 ** ownerIndex);\n        uint operationVotesCount = votesCountByOperation[operation] - 1;\n        votesCountByOperation[operation] = operationVotesCount;\n        emit OperationDownvoted(operation, operationVotesCount, owners.length, msg.sender);\n        if (operationVotesCount == 0) {\n            deleteOperation(operation);\n            emit OperationCancelled(operation, msg.sender);\n        }\n    }\n\n    /**\n    * @dev Allows owners to change ownership\n    * @param newOwners defines array of addresses of new owners\n    */\n    function transferOwnership(address[] memory newOwners) public {\n        transferOwnershipWithHowMany(newOwners, newOwners.length);\n    }\n\n    /**\n    * @dev Allows owners to change ownership\n    * @param newOwners defines array of addresses of new owners\n    * @param newHowManyOwnersDecide defines how many owners can decide\n    */\n    function transferOwnershipWithHowMany(address[] memory newOwners, uint256 newHowManyOwnersDecide) public onlyManyOwners {\n        require(newOwners.length > 0, \"transferOwnershipWithHowMany: owners array is empty\");\n        require(newOwners.length <= 256, \"transferOwnershipWithHowMany: owners count is greater then 256\");\n        require(newHowManyOwnersDecide > 0, \"transferOwnershipWithHowMany: newHowManyOwnersDecide equal to 0\");\n        require(newHowManyOwnersDecide <= newOwners.length, \"transferOwnershipWithHowMany: newHowManyOwnersDecide exceeds the number of owners\");\n\n        // Reset owners reverse lookup table\n        for (uint j = 0; j < owners.length; j++) {\n            delete ownersIndices[owners[j]];\n        }\n        for (uint i = 0; i < newOwners.length; i++) {\n            require(newOwners[i] != address(0), \"transferOwnershipWithHowMany: owners array contains zero\");\n            require(ownersIndices[newOwners[i]] == 0, \"transferOwnershipWithHowMany: owners array contains duplicates\");\n            ownersIndices[newOwners[i]] = i + 1;\n        }\n        \n        emit OwnershipTransferred(owners, howManyOwnersDecide, newOwners, newHowManyOwnersDecide);\n        owners = newOwners;\n        howManyOwnersDecide = newHowManyOwnersDecide;\n        // allOperations.length = 0;\n        allOperations.push();\n        ownersGeneration++;\n    }\n\n}"
    }
  },
  "settings": {
    "remappings": [],
    "optimizer": {
      "enabled": true,
      "runs": 200
    },
    "evmVersion": "istanbul",
    "libraries": {},
    "outputSelection": {
      "*": {
        "*": [
          "evm.bytecode",
          "evm.deployedBytecode",
          "abi"
        ]
      }
    }
  }
}}