pragma solidity ^0.4.21;



interface IERC20Token {

    function totalSupply() public constant returns (uint);

    function balanceOf(address tokenlender) public constant returns (uint balance);

    function allowance(address tokenlender, address spender) public constant returns (uint remaining);

    function transfer(address to, uint tokens) public returns (bool success);

    function approve(address spender, uint tokens) public returns (bool success);

    function transferFrom(address from, address to, uint tokens) public returns (bool success);



    event Transfer(address indexed from, address indexed to, uint tokens);

    event Approval(address indexed tokenlender, address indexed spender, uint tokens);

}



contract LoanRequest_iii {

    address public borrower = msg.sender;

    IERC20Token public token;

    uint256 public collateralAmount;

    uint256 public loanAmount;

    uint256 public payoffAmount;

    uint256 public loanDuration;



    function LoanRequest(

        IERC20Token _token,

        uint256 _collateralAmount,

        uint256 _loanAmount,

        uint256 _payoffAmount,

        uint256 _loanDuration

    )

        public

    {

        token = _token;

        collateralAmount = _collateralAmount;

        loanAmount = _loanAmount;

        payoffAmount = _payoffAmount;

        loanDuration = _loanDuration;

    }



    Loan public loan;



    event LoanRequestAccepted(address loan);



    function lendEther() public payable {

        require(msg.value == loanAmount);

        loan = new Loan(

            msg.sender,

            borrower,

            token,

            collateralAmount,

            payoffAmount,

            loanDuration

        );

        require(token.transferFrom(borrower, loan, collateralAmount));

        borrower.transfer(loanAmount);

        emit LoanRequestAccepted(loan);

    }

}



contract Loan {

    address public lender;

    address public borrower;

    IERC20Token public token;

    uint256 public collateralAmount;

    uint256 public payoffAmount;

    uint256 public dueDate;



    function Loan(

        address _lender,

        address _borrower,

        IERC20Token _token,

        uint256 _collateralAmount,

        uint256 _payoffAmount,

        uint256 loanDuration

    )

        public

    {

        lender = _lender;

        borrower = _borrower;

        token = _token;

        collateralAmount = _collateralAmount;

        payoffAmount = _payoffAmount;

        dueDate = now + loanDuration;

    }



    event LoanPaid();



    function payLoan() public payable {

        require(now <= dueDate);

        require(msg.value == payoffAmount);



        require(token.transfer(borrower, collateralAmount));

        emit LoanPaid();

        selfdestruct(lender);

    }



    function repossess() public {

        require(now > dueDate);



        require(token.transfer(lender, collateralAmount));

        selfdestruct(lender);

    }

}