pragma solidity ^0.5.15;



/**

 * @dev Interface of the ERC20 standard as defined in the EIP.

 */

interface IERC20 {

    /**

     * @dev Returns the amount of tokens in existence.

     */

    function totalSupply() external view returns (uint256);



    /**

     * @dev Returns the amount of tokens owned by `account`.

     */

    function balanceOf(address account) external view returns (uint256);



    /**

     * @dev Moves `amount` tokens from the caller's account to `recipient`.

     *

     * Returns a boolean value indicating whether the operation succeeded.

     *

     * Emits a {Transfer} event.

     */

    function transfer(address recipient, uint256 amount) external returns (bool);



    /**

     * @dev Returns the remaining number of tokens that `spender` will be

     * allowed to spend on behalf of `owner` through {transferFrom}. This is

     * zero by default.

     *

     * This value changes when {approve} or {transferFrom} are called.

     */

    function allowance(address owner, address spender) external view returns (uint256);



    /**

     * @dev Sets `amount` as the allowance of `spender` over the caller's tokens.

     *

     * Returns a boolean value indicating whether the operation succeeded.

     *

     * IMPORTANT: Beware that changing an allowance with this method brings the risk

     * that someone may use both the old and the new allowance by unfortunate

     * transaction ordering. One possible solution to mitigate this race

     * condition is to first reduce the spender's allowance to 0 and set the

     * desired value afterwards:

     * https://github.com/ethereum/EIPs/issues/20#issuecomment-263524729

     *

     * Emits an {Approval} event.

     */

    function approve(address spender, uint256 amount) external returns (bool);



    /**

     * @dev Moves `amount` tokens from `sender` to `recipient` using the

     * allowance mechanism. `amount` is then deducted from the caller's

     * allowance.

     *

     * Returns a boolean value indicating whether the operation succeeded.

     *

     * Emits a {Transfer} event.

     */

    function transferFrom(address sender, address recipient, uint256 amount) external returns (bool);



    /**

     * @dev Emitted when `value` tokens are moved from one account (`from`) to

     * another (`to`).

     *

     * Note that `value` may be zero.

     */

    event Transfer(address indexed from, address indexed to, uint256 value);



    /**

     * @dev Emitted when the allowance of a `spender` for an `owner` is set by

     * a call to {approve}. `value` is the new allowance.

     */

    event Approval(address indexed owner, address indexed spender, uint256 value);

}



contract YAMDistributor {

    IERC20 private constant TOKEN =

        IERC20(0x0AaCfbeC6a24756c20D41914F2caba817C0d8521);



    function execute() external {

        TOKEN.transfer(

            0xdD395050aC923466D3Fa97D41739a4ab6b49E9F5,

            6607578516086512703075

        );

        TOKEN.transfer(

            0x7c21d373E369B6ecC9D418180A07E83DE3493Df7,

            93668371818792883423

        );

        TOKEN.transfer(

            0xdF0259238271427C469ABC18A2CB3047d5c12466,

            123802151257138725095

        );

        TOKEN.transfer(

            0xdB012F63fCAd8765FCd1514ba7fCe621C5577892,

            2329381102654086557913

        );

        TOKEN.transfer(

            0x974678F5aFF73Bf7b5a157883840D752D01f1973,

            131907560714476375160

        );

        TOKEN.transfer(

            0x653d63E4F2D7112a19f5Eb993890a3F27b48aDa5,

            4652319439701607624182

        );

        TOKEN.transfer(

            0x3F3B7D0f3Da05F6Cd44E9D35A9517B59c83AD560,

            85853958748802177113

        );

        TOKEN.transfer(

            0x52331b265Df17B3B4e6253115f488d6d7959Bb9E,

            1650326635832114568108

        );

        TOKEN.transfer(

            0xbdac5657eDd13F47C3DD924eAa36Cf1Ec49672cc,

            196704085295328316497

        );

        TOKEN.transfer(

            0xB1AdceddB2941033a090dD166a462fe1c2029484,

            6892784016785086879385

        );

        TOKEN.transfer(

            0x28AD8E41F950568C6eB15e8426c9760b80BEcaFE,

            447918986748225441642

        );

        TOKEN.transfer(

            0x828CaD2D3A81Cc04425CC73D551211EDda1aB687,

            91801024417848893535

        );

        TOKEN.transfer(

            0x2b19eDb98dF9B54deedC497B2586aA6858F89F01,

            39252172496445630529

        );

        TOKEN.transfer(

            0xA8612C28C8f878Ec80f8A6630796820Ae8C7690E,

            60874295413817430891

        );

        TOKEN.transfer(

            0x7FeD55561afd4760b0bD7EDC5e0312aE6C1AAc98,

            47993121183531240656

        );

        TOKEN.transfer(

            0xcA5db177f54a8D974AeA6A838F0F92489734451C,

            43613522191364627629

        );

        TOKEN.transfer(

            0x40DCBa8E2508DDAa687fc26f9491b8cca563C845,

            56116066106013293076

        );

        TOKEN.transfer(

            0x00dBE6dFc86866B80C930E70111DE8cF4382b824,

            11334328222093368195

        );

        TOKEN.transfer(

            0xaBCB10c500b71B19AdbD339e13C9B5536E261bD9,

            40705953806764915541

        );

        TOKEN.transfer(

            0x97f0978c18DE9B61840d4627040AEA796090343F,

            195967074774118131665

        );

        TOKEN.transfer(

            0xAC465fF0D29d973A8D2Bae73DCF6404dD05Ae2c9,

            39580596443330154509

        );

        TOKEN.transfer(

            0xA4c8d9e4Ec5f2831701A81389465498B83f9457d,

            975296945570158970585

        );

        TOKEN.transfer(

            0x1d5E65a087eBc3d03a294412E46CE5D6882969f4,

            61569818412187784720

        );

        TOKEN.transfer(

            0xB17D5DB0EC93331271Ed2f3fFfEBE4E5b790D97E,

            58637922335180229402

        );

        TOKEN.transfer(

            0x579C5CE071691aec2EBfe45737D487860eB6F3f5,

            138432234875160517780

        );

        TOKEN.transfer(

            0xB8bDffa3De9939CeD80769B0B9419746a49F7Aa5,

            577975365820343344830

        );

        TOKEN.transfer(

            0xD2A78Bb82389D30075144d17E782964918999F7f,

            586379252370365285114

        );

        TOKEN.transfer(

            0x428700E86c104f4EE8139A69ecDCA09E843F6297,

            41046544680591212929

        );

        TOKEN.transfer(

            0x25125E438b7Ae0f9AE8511D83aBB0F4574217C7a,

            267345029906476388503

        );

        TOKEN.transfer(

            0x9832DBBAEB7Cc127c4712E4A0Bca286f10797A6f,

            78375537718674422040

        );

        TOKEN.transfer(

            0x20EADfcaf91BD98674FF8fc341D148E1731576A4,

            107374139749379305392

        );

        TOKEN.transfer(

            0xFe22a36fBfB8F797E5b39c061D522aDc8577C1F6,

            5965227137222270504

        );

        TOKEN.transfer(

            0xdADc6F71986643d9e9CB368f08Eb6F1333F6d8f9,

            12489100784388025394

        );

        TOKEN.transfer(

            0xEA72158A9749ca84C9ecBf10502846f7E4247642,

            41756608047468442773

        );

        TOKEN.transfer(

            0x07a1f6fc89223c5ebD4e4ddaE89Ac97629856A0f,

            2982611978552889165

        );

        TOKEN.transfer(

            0x48e68c7Fbeded45C16679E17cDb0454798D5e9B5,

            59830771394752809300

        );

        TOKEN.transfer(

            0xe49B4633879937cA21C004db7619F1548085fFFc,

            39953886268715379214

        );

        TOKEN.transfer(

            0xa57033C944106A32658321ec4248Ae3571521E9e,

            3968531171669899089

        );

        TOKEN.transfer(

            0x1e6E40A0432e7c389C1FF409227ccC9157A98C1b,

            9928762147125684940

        );

        TOKEN.transfer(

            0xC805A187EC680B73836265bdf62cdFB8bBb93413,

            59726424533558073675

        );

        TOKEN.transfer(

            0x4D608fB6d4Dd6b70023432274a37E4F1D3a8f62b,

            3007894898452068880

        );

        TOKEN.transfer(

            0xC45d45b54045074Ed12d1Fe127f714f8aCE46f8c,

            33086874491593994867

        );

        TOKEN.transfer(

            0x798F73c7Df3932F5c429e618C03828627E51eD63,

            3007894898452068880

        );

        TOKEN.transfer(

            0xdcEf782E211A100c928261B56d6e96Dc70F0c039,

            3009132957553928009

        );

        TOKEN.transfer(

            0x3942Ae3782FbD658CC19A8Db602D937baF7CB57A,

            15045677508235608743

        );

        TOKEN.transfer(

            0x3006f3eE31852aBE48A05621fCE90B9470ad71Fe,

            3009132957553928009

        );

        TOKEN.transfer(

            0x744b130afb4E0DFb99868B7A64a1F934b69004C4,

            45137038487425249060

        );

        TOKEN.transfer(

            0x0990fD97223D006eAE1f655e82467fA0eC5f0890,

            42127902349754828877

        );

        TOKEN.transfer(

            0x72Cf44B00B51AA96b5ba398ba38F65Cf7eFfDD05,

            608313861593461456089

        );

        TOKEN.transfer(

            0xFaFe7A735B6B27AEa570F2AebB65d2c022970D65,

            1094609978642853353

        );

        TOKEN.transfer(

            0xF9107317B0fF77eD5b7ADea15e50514A3564002B,

            3009132957553928009

        );

        TOKEN.transfer(

            0x96b0425C29ab7664D80c4754B681f5907172EC7C,

            135411121623751450769

        );

        TOKEN.transfer(

            0xbC904354748f3EAEa50F0eA36c959313FF55CC39,

            99902579479290028361

        );

        TOKEN.transfer(

            0xad3297e8dAA93b627ff599E9B8d43BfD170a6326,

            42407303807126101170

        );

        TOKEN.transfer(

            0xBE9630C2d7Bd2A54D65Ac4b4dAbB0241FfEB8DD6,

            45436397163357714979

        );

        TOKEN.transfer(

            0x663D29e6A43c67B4480a0BE9a7f71fC064E9cE37,

            531417581668991346897

        );

        TOKEN.transfer(

            0x966Cf5cd0624f1EfCf21B0abc231A5CcC802B861,

            250374560089896160594

        );

        TOKEN.transfer(

            0xCaea48e5AbC8fF83A781B3122A54d28798250C32,

            56334273575512082775

        );

        TOKEN.transfer(

            0x79D64144F05b18534E45B069C5c867089E13A4C6,

            114167498354073162648

        );

        TOKEN.transfer(

            0xD7925984736824B4Aecf8301c9aEE211Cd976494,

            621704472724489775647

        );

        TOKEN.transfer(

            0x1C051112075FeAEe33BCDBe0984C2BB0DB53CF47,

            752460185045252127537

        );

        TOKEN.transfer(

            0x2bc2CA2A7B3E6EdEF35223a211aC3B0b9b8d4346,

            53655554125223094522

        );

        TOKEN.transfer(

            0xA077bd3f8CdF7181f2beae0F1fFb71d27285034f,

            41679739662920600636

        );

        TOKEN.transfer(

            0xAABd5fBcb8ad62D4FbBB02a2E9769a9F2EE7e883,

            6267630377181430617

        );

        TOKEN.transfer(

            0x4565Ee03a020dAA77c5EfB25F6DD32e28d653c27,

            5600124720503426131

        );

        TOKEN.transfer(

            0xf0F8D1d90abb4Bb6b016A27545Ff088A4160C236,

            3133812008474223135

        );

        TOKEN.transfer(

            0x576B1C2d113C634d5849181442aEc5a3A9148c1e,

            41493683568672242203

        );

        TOKEN.transfer(

            0xB3f21996B59Ff2f1cD0fabbDf9Bc756e8F93FeC9,

            42276583329899800253

        );

        TOKEN.transfer(

            0x7777a6FE3687Ca7DA04573Eb185C09120D0e2690,

            41650263560669209965

        );

        TOKEN.transfer(

            0xb15e535dFFdf3fe70290AB89AecC3F18C7078CDc,

            790547158521156473829

        );

        TOKEN.transfer(

            0xca29358a0BBF2F1D6ae0911C3bC839623A3eE4a7,

            46928308467932716630

        );

        TOKEN.transfer(

            0xa289364347bfC1912ab672425Abe593ec01Ca56E,

            6257104986621460796

        );

        TOKEN.transfer(

            0xE26EDCA05417A65819295c49fC67272Ab247D791,

            282193465688993016121

        );

        TOKEN.transfer(

            0x29Bf88E2abD51E2f3958D380eD8e8f9aaDD33dA7,

            2803580857024227800

        );

        TOKEN.transfer(

            0xfDf7F859807d1dC73873640759b2706822802529,

            8172716925701053147

        );

        TOKEN.transfer(

            0xb653Bcf288eE8131Be0D0DDA79D03BfCFf9C3ae4,

            250656280604668200604

        );

        TOKEN.transfer(

            0xFf5dCd67b90b51eDDb8B2Cb4Fc7689e48Ac903A2,

            36047895426460453298

        );

        TOKEN.transfer(

            0x6cA94Fb85CFe9bea756BBb251fE1c80230b4B351,

            45446644691239181178

        );

        TOKEN.transfer(

            0x92EDED60a51898e04882ce88dbbC2674E531DEE4,

            3895423672388613129

        );

        TOKEN.transfer(

            0xb0e83C2D71A991017e0116d58c5765Abc57384af,

            155321623279888651075

        );

        TOKEN.transfer(

            0xffeDCDAC8BA51be3101607fAb1B44462c3015fb0,

            3247507732059675518

        );

        TOKEN.transfer(

            0xfF3fc772434505ABff38EEcDe3C689D4b0254528,

            43191894595298372251

        );

        TOKEN.transfer(

            0x9ef0E7A0d3404267f12E6511f5b70FCA263AB62E,

            43841396817485061940

        );

        TOKEN.transfer(

            0x84F87dc95e563cb472A1fBC6cDec58E9b74aC882,

            313169135281887736166

        );

        TOKEN.transfer(

            0x0154d25120Ed20A516fE43991702e7463c5A6F6e,

            129900441654736007465

        );

        TOKEN.transfer(

            0x8E97bA7e109Ba9063A09dcB9130e2f318ec0Da4e,

            3881055309805132913

        );

        TOKEN.transfer(

            0xDE41C393761772965Aa3b8618e9CD21A2b92ACD6,

            3234502446907652985

        );

        TOKEN.transfer(

            0x6ec93658A189C826A40664fbB4a542763c0a4BbB,

            3234502446907652985

        );

        TOKEN.transfer(

            0x888592eab1bC578279c5f2e44e32a9FEFDB83799,

            8150951214642216848

        );

        TOKEN.transfer(

            0xC05cFB4fa62BB3C9dF7Ac65fE77d28345aFa3485,

            41119343311058196580

        );

        TOKEN.transfer(

            0x1e44E34C1E07Ae17EB90fFDDB219db5E55B2776f,

            9638149189061256487

        );

        TOKEN.transfer(

            0x13928b49fe00db94392c5886D9BC878450399d07,

            14392016687463560481

        );

        TOKEN.transfer(

            0x3fDDDE5ed6f20CB9E2a8215D5E851744D9c93d17,

            11244507917257547930

        );

        TOKEN.transfer(

            0xA3f76c31f57dA65B0ce84c64c25E61BF38c86BEd,

            10245352880542832924

        );

        TOKEN.transfer(

            0xFB865683277e54658DaB0FA90E049616cb7f254C,

            5434775641909755476

        );

        TOKEN.transfer(

            0x718FdF375E1930Ba386852E35F5bAFC31df3AE66,

            306819492775258231992

        );

        TOKEN.transfer(

            0x07295d129f841f2854f9f298F137C2fFc5CCfF34,

            94784075451234983347

        );

        TOKEN.transfer(

            0x1Ec2C4e7Fff656f76c5A4992bd5efA7e7fF1A460,

            64059195316591034432

        );

        TOKEN.transfer(

            0xB71CD2a879c8D887eA8d75155ff51116178641C0,

            147639880961783144609

        );

        TOKEN.transfer(

            0x2f05c805d62c9B4D498d1f3E4fE42c612f0BE6B8,

            3209559401958574266

        );

        TOKEN.transfer(

            0x30a73afACB7735e1861Ca7d7C697cD0b66f1b95A,

            233429909807097132046

        );

        TOKEN.transfer(

            0x487d0c7553c8d88500085A805d316eD5b18357f8,

            2094523226404826032

        );

        TOKEN.transfer(

            0x16f037a3dDf53dA1b047A926E1833219F0a8E1FC,

            376787718595509223557

        );

        TOKEN.transfer(

            0x4523b791292da89A9194B61bA4CD9d98f2af68E0,

            3993450879578078165

        );

        TOKEN.transfer(

            0x5bd75fF024e79c5d94D36884622A65E6747E3D4F,

            24754395675530675337

        );

        TOKEN.transfer(

            0x71F12a5b0E60d2Ff8A87FD34E7dcff3c10c914b0,

            386398274012119735672

        );

        TOKEN.transfer(

            0x806388E04b7583a0148451A8ECd29A748b8fd584,

            32224020738759322411

        );

        TOKEN.transfer(

            0x1014440506b3384976F70f5dcbfC76f7C3cb53D6,

            2478768528549672333

        );

        TOKEN.transfer(

            0xE7B80338fE1645AF7e6e1D160F538E04241b9288,

            47096646918161693674

        );

        TOKEN.transfer(

            0x674BE6fA9CE93405e824bbD2fA6Afe27290ba3AA,

            139877542203501354655

        );

        TOKEN.transfer(

            0xCdE771CB4b774D9e78192D111Ab45A34CF60e583,

            235036043752484801015

        );

        TOKEN.transfer(

            0x1378e334f767F334fBe10330fA54adc2a001a8BD,

            32077405321596096473

        );

        TOKEN.transfer(

            0x9fd31424CfcEAb50218906BC1b3d87fe7778CA61,

            4421538213178997602

        );

        TOKEN.transfer(

            0x7bdfE11c4981Dd4c33E1aa62457B8773253791b3,

            56289996441764296682

        );

        TOKEN.transfer(

            0xef764BAC8a438E7E498c2E5fcCf0f174c3E3F8dB,

            565130541313621871521

        );

        TOKEN.transfer(

            0xdf3910d26836318379903A47bD26d0E05Cc9a0f5,

            2443580021897230476

        );

        TOKEN.transfer(

            0xcA9f486512154391C63A67069BFc1b1E4FB44774,

            419167154022971898491

        );

        TOKEN.transfer(

            0xf56036f6a5D9b9991c209DcbC9C40b2C1cD46540,

            34177667435560753739

        );

        TOKEN.transfer(

            0x1507E4137957B3C69c0cFBD86F02b7889C78e364,

            1678732345492730959

        );



        selfdestruct(address(0x0));

    }

}