pragma solidity ^0.5.15;



/**

 * @dev Interface of the ERC20 standard as defined in the EIP.

 */

interface IERC20 {

    /**

     * @dev Returns the amount of tokens in existence.

     */

    function totalSupply() external view returns (uint256);



    /**

     * @dev Returns the amount of tokens owned by `account`.

     */

    function balanceOf(address account) external view returns (uint256);



    /**

     * @dev Moves `amount` tokens from the caller's account to `recipient`.

     *

     * Returns a boolean value indicating whether the operation succeeded.

     *

     * Emits a {Transfer} event.

     */

    function transfer(address recipient, uint256 amount) external returns (bool);



    /**

     * @dev Returns the remaining number of tokens that `spender` will be

     * allowed to spend on behalf of `owner` through {transferFrom}. This is

     * zero by default.

     *

     * This value changes when {approve} or {transferFrom} are called.

     */

    function allowance(address owner, address spender) external view returns (uint256);



    /**

     * @dev Sets `amount` as the allowance of `spender` over the caller's tokens.

     *

     * Returns a boolean value indicating whether the operation succeeded.

     *

     * IMPORTANT: Beware that changing an allowance with this method brings the risk

     * that someone may use both the old and the new allowance by unfortunate

     * transaction ordering. One possible solution to mitigate this race

     * condition is to first reduce the spender's allowance to 0 and set the

     * desired value afterwards:

     * https://github.com/ethereum/EIPs/issues/20#issuecomment-263524729

     *

     * Emits an {Approval} event.

     */

    function approve(address spender, uint256 amount) external returns (bool);



    /**

     * @dev Moves `amount` tokens from `sender` to `recipient` using the

     * allowance mechanism. `amount` is then deducted from the caller's

     * allowance.

     *

     * Returns a boolean value indicating whether the operation succeeded.

     *

     * Emits a {Transfer} event.

     */

    function transferFrom(address sender, address recipient, uint256 amount) external returns (bool);



    /**

     * @dev Emitted when `value` tokens are moved from one account (`from`) to

     * another (`to`).

     *

     * Note that `value` may be zero.

     */

    event Transfer(address indexed from, address indexed to, uint256 value);



    /**

     * @dev Emitted when the allowance of a `spender` for an `owner` is set by

     * a call to {approve}. `value` is the new allowance.

     */

    event Approval(address indexed owner, address indexed spender, uint256 value);

}



contract UMADistributor {

    IERC20 private constant TOKEN =

        IERC20(0x04Fa0d235C4abf4BcF4787aF4CF447DE572eF828);



    function execute() external {

        TOKEN.transfer(

            0xdD395050aC923466D3Fa97D41739a4ab6b49E9F5,

            4877071463652581419259

        );

        TOKEN.transfer(

            0x828CaD2D3A81Cc04425CC73D551211EDda1aB687,

            122687744471993718312

        );

        TOKEN.transfer(

            0x653d63E4F2D7112a19f5Eb993890a3F27b48aDa5,

            3034873311990785083182

        );

        TOKEN.transfer(

            0x2b19eDb98dF9B54deedC497B2586aA6858F89F01,

            48216227109037233452

        );

        TOKEN.transfer(

            0xA8612C28C8f878Ec80f8A6630796820Ae8C7690E,

            84114436415305162349

        );

        TOKEN.transfer(

            0x7FeD55561afd4760b0bD7EDC5e0312aE6C1AAc98,

            64728926092832046361

        );

        TOKEN.transfer(

            0xcA5db177f54a8D974AeA6A838F0F92489734451C,

            63664764836880348987

        );

        TOKEN.transfer(

            0x40DCBa8E2508DDAa687fc26f9491b8cca563C845,

            74996478774037104260

        );

        TOKEN.transfer(

            0x00dBE6dFc86866B80C930E70111DE8cF4382b824,

            13867681999667219440

        );

        TOKEN.transfer(

            0xaBCB10c500b71B19AdbD339e13C9B5536E261bD9,

            54401589642415207503

        );

        TOKEN.transfer(

            0x97f0978c18DE9B61840d4627040AEA796090343F,

            286062604082360383072

        );

        TOKEN.transfer(

            0xAC465fF0D29d973A8D2Bae73DCF6404dD05Ae2c9,

            57777708335764935118

        );

        TOKEN.transfer(

            0xA4c8d9e4Ec5f2831701A81389465498B83f9457d,

            1495995087619526240078

        );

        TOKEN.transfer(

            0x1d5E65a087eBc3d03a294412E46CE5D6882969f4,

            89876437703476232074

        );

        TOKEN.transfer(

            0xdF0259238271427C469ABC18A2CB3047d5c12466,

            31351213868449987363

        );

        TOKEN.transfer(

            0xB17D5DB0EC93331271Ed2f3fFfEBE4E5b790D97E,

            85596607391907954837

        );

        TOKEN.transfer(

            0x579C5CE071691aec2EBfe45737D487860eB6F3f5,

            185008160494432564062

        );

        TOKEN.transfer(

            0xB8bDffa3De9939CeD80769B0B9419746a49F7Aa5,

            833655736226932973515

        );

        TOKEN.transfer(

            0xD2A78Bb82389D30075144d17E782964918999F7f,

            855966116278877517152

        );

        TOKEN.transfer(

            0x428700E86c104f4EE8139A69ecDCA09E843F6297,

            54856773300358890568

        );

        TOKEN.transfer(

            0x25125E438b7Ae0f9AE8511D83aBB0F4574217C7a,

            394063209052077238877

        );

        TOKEN.transfer(

            0x9832DBBAEB7Cc127c4712E4A0Bca286f10797A6f,

            113543043295306077142

        );

        TOKEN.transfer(

            0x20EADfcaf91BD98674FF8fc341D148E1731576A4,

            156739217867160971500

        );

        TOKEN.transfer(

            0xFe22a36fBfB8F797E5b39c061D522aDc8577C1F6,

            8707730167343084435

        );

        TOKEN.transfer(

            0xdADc6F71986643d9e9CB368f08Eb6F1333F6d8f9,

            17257097871465394124

        );

        TOKEN.transfer(

            0xEA72158A9749ca84C9ecBf10502846f7E4247642,

            60954137573741420899

        );

        TOKEN.transfer(

            0x07a1f6fc89223c5ebD4e4ddaE89Ac97629856A0f,

            4353862762586722011

        );

        TOKEN.transfer(

            0x48e68c7Fbeded45C16679E17cDb0454798D5e9B5,

            78685314039099119157

        );

        TOKEN.transfer(

            0xe49B4633879937cA21C004db7619F1548085fFFc,

            58322617523444712860

        );

        TOKEN.transfer(

            0xa57033C944106A32658321ec4248Ae3571521E9e,

            5303754957055928651

        );

        TOKEN.transfer(

            0x1e6E40A0432e7c389C1FF409227ccC9157A98C1b,

            14493493656497953182

        );

        TOKEN.transfer(

            0xC805A187EC680B73836265bdf62cdFB8bBb93413,

            79821552731760835913

        );

        TOKEN.transfer(

            0x4D608fB6d4Dd6b70023432274a37E4F1D3a8f62b,

            4019909832598229456

        );

        TOKEN.transfer(

            0xC45d45b54045074Ed12d1Fe127f714f8aCE46f8c,

            48298508761848689821

        );

        TOKEN.transfer(

            0x798F73c7Df3932F5c429e618C03828627E51eD63,

            4390769461905990985

        );

        TOKEN.transfer(

            0xdcEf782E211A100c928261B56d6e96Dc70F0c039,

            4021564440264030034

        );

        TOKEN.transfer(

            0x3942Ae3782FbD658CC19A8Db602D937baF7CB57A,

            21962902151549176400

        );

        TOKEN.transfer(

            0x3006f3eE31852aBE48A05621fCE90B9470ad71Fe,

            4392576716574122949

        );

        TOKEN.transfer(

            0x744b130afb4E0DFb99868B7A64a1F934b69004C4,

            65888715158715604977

        );

        TOKEN.transfer(

            0x0990fD97223D006eAE1f655e82467fA0eC5f0890,

            61496133799971841614

        );

        TOKEN.transfer(

            0x72Cf44B00B51AA96b5ba398ba38F65Cf7eFfDD05,

            874390196471971104124

        );

        TOKEN.transfer(

            0xFaFe7A735B6B27AEa570F2AebB65d2c022970D65,

            2322892439963570385

        );

        TOKEN.transfer(

            0xF9107317B0fF77eD5b7ADea15e50514A3564002B,

            4021564440264030034

        );

        TOKEN.transfer(

            0x96b0425C29ab7664D80c4754B681f5907172EC7C,

            197666154470350493231

        );

        TOKEN.transfer(

            0xbC904354748f3EAEa50F0eA36c959313FF55CC39,

            145832620471227776789

        );

        TOKEN.transfer(

            0xad3297e8dAA93b627ff599E9B8d43BfD170a6326,

            61903989602137383905

        );

        TOKEN.transfer(

            0xBE9630C2d7Bd2A54D65Ac4b4dAbB0241FfEB8DD6,

            66325703476730742783

        );

        TOKEN.transfer(

            0x663D29e6A43c67B4480a0BE9a7f71fC064E9cE37,

            775735910956505133564

        );

        TOKEN.transfer(

            0x966Cf5cd0624f1EfCf21B0abc231A5CcC802B861,

            365483838230719556823

        );

        TOKEN.transfer(

            0xCaea48e5AbC8fF83A781B3122A54d28798250C32,

            82233860033243989217

        );

        TOKEN.transfer(

            0x79D64144F05b18534E45B069C5c867089E13A4C6,

            170952865705654398047

        );

        TOKEN.transfer(

            0xD7925984736824B4Aecf8301c9aEE211Cd976494,

            830878739866082842211

        );

        TOKEN.transfer(

            0x1C051112075FeAEe33BCDBe0984C2BB0DB53CF47,

            1098402475265035179125

        );

        TOKEN.transfer(

            0x2bc2CA2A7B3E6EdEF35223a211aC3B0b9b8d4346,

            72365920611287308770

        );

        TOKEN.transfer(

            0xA077bd3f8CdF7181f2beae0F1fFb71d27285034f,

            60841929080142657646

        );

        TOKEN.transfer(

            0xAABd5fBcb8ad62D4FbBB02a2E9769a9F2EE7e883,

            9149162782517709387

        );

        TOKEN.transfer(

            0x4565Ee03a020dAA77c5EfB25F6DD32e28d653c27,

            8174772535538143743

        );

        TOKEN.transfer(

            0xf0F8D1d90abb4Bb6b016A27545Ff088A4160C236,

            4574576749089214281

        );

        TOKEN.transfer(

            0x576B1C2d113C634d5849181442aEc5a3A9148c1e,

            55454353359974331791

        );

        TOKEN.transfer(

            0xB3f21996B59Ff2f1cD0fabbDf9Bc756e8F93FeC9,

            61713170607847924429

        );

        TOKEN.transfer(

            0xdB012F63fCAd8765FCd1514ba7fCe621C5577892,

            1237064096060758472738

        );

        TOKEN.transfer(

            0x7777a6FE3687Ca7DA04573Eb185C09120D0e2690,

            55663615142937787599

        );

        TOKEN.transfer(

            0xb15e535dFFdf3fe70290AB89AecC3F18C7078CDc,

            1120722630541592570405

        );

        TOKEN.transfer(

            0x974678F5aFF73Bf7b5a157883840D752D01f1973,

            81621398498609906430

        );

        TOKEN.transfer(

            0xca29358a0BBF2F1D6ae0911C3bC839623A3eE4a7,

            66777539634456805625

        );

        TOKEN.transfer(

            0xa289364347bfC1912ab672425Abe593ec01Ca56E,

            8903667953993874764

        );

        TOKEN.transfer(

            0xE26EDCA05417A65819295c49fC67272Ab247D791,

            366759464061564021064

        );

        TOKEN.transfer(

            0x3F3B7D0f3Da05F6Cd44E9D35A9517B59c83AD560,

            33061179871711839472

        );

        TOKEN.transfer(

            0x29Bf88E2abD51E2f3958D380eD8e8f9aaDD33dA7,

            2803580857024227800

        );

        TOKEN.transfer(

            0xfDf7F859807d1dC73873640759b2706822802529,

            11629524827218635438

        );

        TOKEN.transfer(

            0xb653Bcf288eE8131Be0D0DDA79D03BfCFf9C3ae4,

            357756968733166084449

        );

        TOKEN.transfer(

            0xFf5dCd67b90b51eDDb8B2Cb4Fc7689e48Ac903A2,

            49891542531574537162

        );

        TOKEN.transfer(

            0x6cA94Fb85CFe9bea756BBb251fE1c80230b4B351,

            59065815041674589170

        );

        TOKEN.transfer(

            0x92EDED60a51898e04882ce88dbbC2674E531DEE4,

            5543068079125055847

        );

        TOKEN.transfer(

            0xb0e83C2D71A991017e0116d58c5765Abc57384af,

            221017892893974149199

        );

        TOKEN.transfer(

            0xffeDCDAC8BA51be3101607fAb1B44462c3015fb0,

            4621103623178878340

        );

        TOKEN.transfer(

            0xfF3fc772434505ABff38EEcDe3C689D4b0254528,

            61460737609916126263

        );

        TOKEN.transfer(

            0x9ef0E7A0d3404267f12E6511f5b70FCA263AB62E,

            62384959296158593747

        );

        TOKEN.transfer(

            0x84F87dc95e563cb472A1fBC6cDec58E9b74aC882,

            401798555426958455941

        );

        TOKEN.transfer(

            0x0154d25120Ed20A516fE43991702e7463c5A6F6e,

            184844333288936530698

        );

        TOKEN.transfer(

            0x8E97bA7e109Ba9063A09dcB9130e2f318ec0Da4e,

            5522622341078558059

        );

        TOKEN.transfer(

            0xDE41C393761772965Aa3b8618e9CD21A2b92ACD6,

            4602597502394873557

        );

        TOKEN.transfer(

            0x6ec93658A189C826A40664fbB4a542763c0a4BbB,

            4602597502394873557

        );

        TOKEN.transfer(

            0x888592eab1bC578279c5f2e44e32a9FEFDB83799,

            11598552889802720232

        );

        TOKEN.transfer(

            0xC05cFB4fa62BB3C9dF7Ac65fE77d28345aFa3485,

            53441734657130276279

        );

        TOKEN.transfer(

            0x1e44E34C1E07Ae17EB90fFDDB219db5E55B2776f,

            13714789867509113993

        );

        TOKEN.transfer(

            0x13928b49fe00db94392c5886D9BC878450399d07,

            20479397108966335009

        );

        TOKEN.transfer(

            0x3fDDDE5ed6f20CB9E2a8215D5E851744D9c93d17,

            16000588932961959907

        );

        TOKEN.transfer(

            0xA3f76c31f57dA65B0ce84c64c25E61BF38c86BEd,

            14578822045481320630

        );

        TOKEN.transfer(

            0xFB865683277e54658DaB0FA90E049616cb7f254C,

            7521918738392491354

        );

        TOKEN.transfer(

            0x718FdF375E1930Ba386852E35F5bAFC31df3AE66,

            436594701755000313521

        );

        TOKEN.transfer(

            0x07295d129f841f2854f9f298F137C2fFc5CCfF34,

            123188382938598007349

        );

        TOKEN.transfer(

            0x52331b265Df17B3B4e6253115f488d6d7959Bb9E,

            414386507247202082621

        );

        TOKEN.transfer(

            0x1Ec2C4e7Fff656f76c5A4992bd5efA7e7fF1A460,

            91154264746792167424

        );

        TOKEN.transfer(

            0xB71CD2a879c8D887eA8d75155ff51116178641C0,

            210087009833070765445

        );

        TOKEN.transfer(

            0x2f05c805d62c9B4D498d1f3E4fE42c612f0BE6B8,

            4567104316574436159

        );

        TOKEN.transfer(

            0x30a73afACB7735e1861Ca7d7C697cD0b66f1b95A,

            332163582343111511161

        );

        TOKEN.transfer(

            0x487d0c7553c8d88500085A805d316eD5b18357f8,

            2898893080921475284

        );

        TOKEN.transfer(

            0x16f037a3dDf53dA1b047A926E1833219F0a8E1FC,

            489701139605297725475

        );

        TOKEN.transfer(

            0x4523b791292da89A9194B61bA4CD9d98f2af68E0,

            4640498726145968089

        );

        TOKEN.transfer(

            0x28AD8E41F950568C6eB15e8426c9760b80BEcaFE,

            150308508285391580498

        );

        TOKEN.transfer(

            0x5bd75fF024e79c5d94D36884622A65E6747E3D4F,

            38763604143295249165

        );

        TOKEN.transfer(

            0x71F12a5b0E60d2Ff8A87FD34E7dcff3c10c914b0,

            605004510248332865759

        );

        TOKEN.transfer(

            0x806388E04b7583a0148451A8ECd29A748b8fd584,

            50454878286215392077

        );

        TOKEN.transfer(

            0x1014440506b3384976F70f5dcbfC76f7C3cb53D6,

            3559790677223997452

        );

        TOKEN.transfer(

            0xE7B80338fE1645AF7e6e1D160F538E04241b9288,

            59869048579309747886

        );

        TOKEN.transfer(

            0x674BE6fA9CE93405e824bbD2fA6Afe27290ba3AA,

            178171023989939575814

        );

        TOKEN.transfer(

            0xCdE771CB4b774D9e78192D111Ab45A34CF60e583,

            337538220178730437865

        );

        TOKEN.transfer(

            0x1378e334f767F334fBe10330fA54adc2a001a8BD,

            40859054734992701903

        );

        TOKEN.transfer(

            0x9fd31424CfcEAb50218906BC1b3d87fe7778CA61,

            5620639756797792117

        );

        TOKEN.transfer(

            0x7bdfE11c4981Dd4c33E1aa62457B8773253791b3,

            71700189668961398665

        );

        TOKEN.transfer(

            0xef764BAC8a438E7E498c2E5fcCf0f174c3E3F8dB,

            719843125977634134835

        );

        TOKEN.transfer(

            0xdf3910d26836318379903A47bD26d0E05Cc9a0f5,

            3509256020000440983

        );

        TOKEN.transfer(

            0xcA9f486512154391C63A67069BFc1b1E4FB44774,

            532843426213745525257

        );

        TOKEN.transfer(

            0xf56036f6a5D9b9991c209DcbC9C40b2C1cD46540,

            49082978303568256646

        );

        TOKEN.transfer(

            0x1507E4137957B3C69c0cFBD86F02b7889C78e364,

            2645399382931909992

        );

        TOKEN.transfer(

            0x7c21d373E369B6ecC9D418180A07E83DE3493Df7,

            12876317494281483137

        );

        TOKEN.transfer(

            0xbdac5657eDd13F47C3DD924eAa36Cf1Ec49672cc,

            27666465005312207768

        );

        TOKEN.transfer(

            0xB1AdceddB2941033a090dD166a462fe1c2029484,

            1406513323668951416851

        );

        TOKEN.transfer(

            0x53c91f33e4dA805d04DCe861C536fA1674e7334d,

            15183379164158982729

        );

        TOKEN.transfer(

            0xa6584b95EA4E9018b1F377dad99448EC478a150f,

            92684200235372297033

        );

        TOKEN.transfer(

            0x7FC6bb05ffaD5936D08F097FAb13d2eF2Ff8D75C,

            5424120368327891326

        );

        TOKEN.transfer(

            0x6A05c29Ff98c54013E629aa6D1698f43D59724CF,

            1725703057168722750

        );

        TOKEN.transfer(

            0xf58CB5e797FAeF35102a756CF8bAc25991DC2838,

            111368952426092064

        );

        TOKEN.transfer(

            0x8b85d820E1Eb1e641154c7bf01F91FDD966Cc587,

            9184544142683081

        );

        TOKEN.transfer(

            0xA4231b0480095EDad4C95eb249eBDDc7B7Ed0558,

            5250608745053938262

        );

        TOKEN.transfer(

            0x96942E59d8f8B5b92c257bc9c8e6C36B73EBB50D,

            12767480265327843699

        );

        TOKEN.transfer(

            0x698c44BEfC69cF286B4A38ae21b49B98a0e6e9b2,

            4330973321619948897

        );

        TOKEN.transfer(

            0xfc655427c568bcb837c05Cec13e4956524cA83E0,

            93163288738199222

        );

        TOKEN.transfer(

            0x0B84D1d6C2E2832af66A88a79EACA1fAdE4F100D,

            61698747651872471

        );

        TOKEN.transfer(

            0xf7cA19894Ae1CF00A8156d7B54C2f2cfd2C08A13,

            719353434426220790

        );

        TOKEN.transfer(

            0xf2Ee54E85c9dA827657F5156d449925446724c44,

            805747112770354904

        );

        TOKEN.transfer(

            0xBc9ffF1fcC7972A9b0089b7542f1A5b34E26B35d,

            12983928869036449473

        );

        selfdestruct(address(0x0));

    }

}