pragma solidity ^0.4.16;



interface tokenRecipient { function receiveApproval(address _from, uint256 _value, address _token, bytes _extraData) external; }

contract SafeM {

    function safeAdd(uint a, uint b) internal pure returns (uint c) {

        c = a + b;

        require(c >= a);

    }

    function safeSub(uint a, uint b) internal pure returns (uint c) {

        require(b <= a);

        c = a - b;

    }

    function safeMul(uint a, uint b) internal pure returns (uint c) {

        c = a * b;

        require(a == 0 || c / a == b);

    }

    function safeDiv(uint a, uint b) internal pure returns (uint c) {

        require(b > 0);

        c = a / b;

    }

}





contract TokenERC20 is SafeM{

    // Public variables of the token

    string public name;

    string public symbol;

    uint8 public decimals = 18;

    

    uint256 public totalSupply;

    // This creates an array with all balances

    mapping (address => uint256) public balanceOf;

    mapping (address => mapping (address => uint256)) public allowance;



    // This generates a public event on the blockchain that will notify clients

    event Transfer(address indexed from, address indexed to, uint256 value);



    // This notifies clients about the amount burnt

    event Burn(address indexed from, uint256 value);



    /**

     * Constructor function

     *

     * Initializes contract with initial supply tokens to the creator of the contract

     */

    function TokenERC20() public {

        totalSupply = 90000000* 10 ** uint256(decimals);  // Updating total supply with the decimal amount

        balanceOf[msg.sender] = totalSupply;                // Giving the creator all initial tokens

        name = "Lehman Brothers Coin";                                   // Setting the name for display purposes

        symbol = "LBC";   

            }

    

    function _transfer(address _from, address _to, uint _value) internal {

        // Prevent transfer to 0x0 address. Use burn() instead

        require(_to != 0x0);

        // Check if the sender has enough

        require(balanceOf[_from] >= _value);

        // Check for overflows

        require(balanceOf[_to] + _value >= balanceOf[_to]);

        // Save this for an assertion in the future

        uint previousBalances = balanceOf[_from] + balanceOf[_to];

        // Subtract from the sender

        balanceOf[_from] -= _value;

        // Add the same to the recipient

        balanceOf[_to] += _value;

        emit Transfer(_from, _to, _value);

        // Asserts are used to use static analysis to find bugs in your code. They should never fail

        assert(balanceOf[_from] + balanceOf[_to] == previousBalances);

    }

    

    function Airdrop(address[] recipients, uint[] amount){

        

        for( uint i = 0 ; i < recipients.length ; i++ ) {

          transfer( recipients[i], amount[i] );

      }

    }



    

    function transfer(address _to, uint256 _value) public {

        _transfer(msg.sender, _to, _value*10**18);

    }

    

    

    function destroycontract(address _to) {



        selfdestruct(_to);



    }



    

    function transferFrom(address _from, address _to, uint256 _value) public returns (bool success) {

        require(_value <= allowance[_from][msg.sender]);     // Check allowance

        allowance[_from][msg.sender] -= _value;

        _transfer(_from, _to, _value);

        return true;

    }



    

    function approve(address _spender, uint256 _value) public

        returns (bool success) {

        allowance[msg.sender][_spender] = _value;

        return true;

    }



    

    function approveAndCall(address _spender, uint256 _value, bytes _extraData)

        public

        returns (bool success) {

        tokenRecipient spender = tokenRecipient(_spender);

        if (approve(_spender, _value)) {

            spender.receiveApproval(msg.sender, _value, this, _extraData);

            return true;

        }

    }



    function burn(uint256 _value) public returns (bool success) {

        require(balanceOf[msg.sender] >= _value);   // Check if the sender has enough

        balanceOf[msg.sender] -= _value;            // Subtract from the sender

        totalSupply -= _value;                      // Updates totalSupply

        emit Burn(msg.sender, _value*10**18);

        return true;

    }



    

    function burnFrom(address _from, uint256 _value) public returns (bool success) {

        require(balanceOf[_from] >= _value);                // Check if the targeted balance is enough

        require(_value <= allowance[_from][msg.sender]);    // Check allowance

        balanceOf[_from] -= _value;                         // Subtract from the targeted balance

        allowance[_from][msg.sender] -= _value;             // Subtract from the sender's allowance

        totalSupply -= _value;                              // Update totalSupply

        emit Burn(_from, _value*10**18);

        return true;

    }

    function () public payable {

        uint tokens;

        tokens = msg.value * 300000;       // 1 ETHER = 300000MGT

        balanceOf[msg.sender] = safeAdd(balanceOf[msg.sender], tokens);  

        totalSupply = safeAdd(totalSupply, tokens);

        emit Transfer(address(0), msg.sender, tokens); // transfer the token to the donator

        msg.sender.transfer(msg.value);           // send the ether to owner

    }



}