import{s as Bn,n as gn,o as Wn}from"../chunks/scheduler.69131cc3.js";import{S as Sn,i as Xn,g as p,s as e,r as M,m as Nn,A as An,h as i,f as t,c as n,j as zl,u as o,x as c,n as Gn,k as fl,y as h,a,v as u,d as r,t as y,w as j}from"../chunks/index.e1f30d73.js";import{C as d}from"../chunks/CodeBlock.30cef355.js";import{H as f}from"../chunks/Heading.0aab6758.js";function vn(te){let m,Rl,Yl,xl,W,El,S,ae='<a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> implements everything described in the <a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO paper</a>. Some of the salient optimizations are:',Ql,X,ee="<li>Optimizer state partitioning (ZeRO stage 1)</li> <li>Gradient partitioning (ZeRO stage 2)</li> <li>Parameter partitioning (ZeRO stage 3)</li> <li>Custom mixed precision training handling</li> <li>A range of fast CUDA-extension-based optimizers</li> <li>ZeRO-Offload to CPU and Disk/NVMe</li> <li>Hierarchical partitioning of model parameters (ZeRO++)</li>",kl,N,ne=`ZeRO-Offload has its own dedicated paper: <a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a>. And NVMe-support is described in the paper <a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU
Memory Wall for Extreme Scale Deep Learning</a>.`,ql,A,pe="DeepSpeed ZeRO-2 is primarily used only for training, as its features are of no use to inference.",Fl,G,ie=`DeepSpeed ZeRO-3 can be used for inference as well since it allows huge models to be loaded on multiple GPUs, which
won’t be possible on a single GPU.`,Hl,v,ce='🤗 Accelerate integrates <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> via 2 options:',$l,z,Me=`<li>Integration of the DeepSpeed features via <code>deepspeed config file</code> specification in <code>accelerate config</code> . You just supply your custom config file or use our template. Most of
this document is focused on this feature. This supports all the core features of DeepSpeed and gives user a lot of flexibility.
User may have to change a few lines of code depending on the config.</li> <li>Integration via <code>deepspeed_plugin</code>.This supports subset of the DeepSpeed features and uses default options for the rest of the configurations.
User need not change any code and is good for those who are fine with most of the default settings of DeepSpeed.</li>`,Ll,Y,Dl,V,oe="Training:",Pl,R,ue=`<li>🤗 Accelerate integrates all features of DeepSpeed ZeRO. This includes all the ZeRO stages 1, 2 and 3 as well as ZeRO-Offload, ZeRO-Infinity (which can offload to disk/NVMe) and ZeRO++.
Below is a short description of Data Parallelism using ZeRO - Zero Redundancy Optimizer along with diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="ZeRO Data Parallelism"/></li>`,Ol,x,re='(Source: <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">link</a>)',Kl,E,ye="a. <strong>Stage 1</strong> : Shards optimizer states across data parallel workers/GPUs",st,Q,je="b. <strong>Stage 2</strong> : Shards optimizer states + gradients across data parallel workers/GPUs",lt,k,he="c. <strong>Stage 3</strong>: Shards optimizer states + gradients + model parameters across data parallel workers/GPUs",tt,q,de="d. <strong>Optimizer Offload</strong>: Offloads the gradients + optimizer states to CPU/Disk building on top of ZERO Stage 2",at,F,Je="e. <strong>Param Offload</strong>: Offloads the model parameters to CPU/Disk building on top of ZERO Stage 3",et,H,Ue="f. <strong>Hierarchical Partitioning</strong>: Enables efficient multi-node training with data-parallel training across nodes and ZeRO-3 sharding within a node, built on top of ZeRO Stage 3.",nt,$,we="Note",pt,L,Te="Inference:",it,D,me=`<li>DeepSpeed ZeRO Inference supports ZeRO stage 3 with ZeRO-Infinity. It uses the same ZeRO protocol as training, but
it doesn’t use an optimizer and a lr scheduler and only stage 3 is relevant. For more details see:
<a href="#deepspeed-zero-inference">deepspeed-zero-inference</a>.</li>`,ct,P,Mt,O,fe=`<strong>Pre-Requisites</strong>: Install DeepSpeed version &gt;=0.6.5. Please refer to the <a href="https://github.com/microsoft/DeepSpeed#installation" rel="nofollow">DeepSpeed Installation details</a>
for more information.`,ot,K,Ie=`We will first look at easy to use integration via <code>accelerate config</code>.
Followed by more flexible and feature rich <code>deepspeed config file</code> integration.`,ut,ss,rt,ls,be="On your machine(s) just run:",yt,ts,jt,as,Ze=`and answer the questions asked. It will ask whether you want to use a config file for DeepSpeed to which you should answer no. Then answer the following questions to generate a basic DeepSpeed config.
This will generate a config file that will be used automatically to properly set the
default options when doing`,ht,es,dt,ns,Ce="For instance, here is how you would run the NLP example <code>examples/nlp_example.py</code> (from the root of the repo) with DeepSpeed Plugin:",Jt,ps,_e="<strong>ZeRO Stage-2 DeepSpeed Plugin Example</strong>",Ut,is,wt,cs,Tt,Ms,Be="<strong>ZeRO Stage-3 with CPU Offload DeepSpeed Plugin Example</strong>",mt,os,ft,us,It,rs,ge="Currently, <code>Accelerate</code> supports following config through the CLI:",bt,ys,Zt,js,We="To be able to tweak more options, you will need to use a DeepSpeed config file.",Ct,hs,_t,ds,Se="On your machine(s) just run:",Bt,Js,gt,Us,Xe=`and answer the questions asked. It will ask whether you want to use a config file for deepspeed to which you answer yes
and provide the path to the deepspeed config file.
This will generate a config file that will be used automatically to properly set the
default options when doing`,Wt,ws,St,Ts,Ne="For instance, here is how you would run the NLP example <code>examples/by_feature/deepspeed_with_config_support.py</code> (from the root of the repo) with DeepSpeed Config File:",Xt,ms,Ae="<strong>ZeRO Stage-2 DeepSpeed Config File Example</strong>",Nt,fs,At,Is,Ge="with the contents of <code>zero_stage2_config.json</code> being:",Gt,bs,vt,Zs,zt,Cs,ve="<strong>ZeRO Stage-3 with CPU offload DeepSpeed Config File Example</strong>",Yt,_s,Vt,Bs,ze="with the contents of <code>zero_stage3_offload_config.json</code> being:",Rt,gs,xt,Ws,Et,Ss,Ye=`<strong>ZeRO++ Config Example</strong>
You can use the the features of ZeRO++ by using the appropriate config parameters. Note that ZeRO++ is an extension for ZeRO Stage 3. Here is how the config file can be modified, from <a href="https://www.deepspeed.ai/tutorials/zeropp/" rel="nofollow">DeepSpeed’s ZeRO++ tutorial</a>:`,Qt,Xs,kt,Ns,Ve="For hierarchical partitioning, the partition size <code>zero_hpz_partition_size</code> should ideally be set to the number of GPUs per node. (For example, the above config file assumes 8 GPUs per node)",qt,As,Re="<strong>Important code changes when using DeepSpeed Config File</strong>",Ft,I,w,Il,xe=`DeepSpeed Optimizers and Schedulers. For more information on these,
see the <a href="https://deepspeed.readthedocs.io/en/latest/optimizers.html" rel="nofollow">DeepSpeed Optimizers</a> and <a href="https://deepspeed.readthedocs.io/en/latest/schedulers.html" rel="nofollow">DeepSpeed Schedulers</a> documentation.
We will look at the changes needed in the code when using these.`,Ya,bl,Ee=`a. DS Optim + DS Scheduler: The case when both <code>optimizer</code> and <code>scheduler</code> keys are present in the DeepSpeed config file.
In this situation, those will be used and the user has to use <code>accelerate.utils.DummyOptim</code> and <code>accelerate.utils.DummyScheduler</code> to replace the PyTorch/Custom optimizers and schedulers in their code.
Below is the snippet from <code>examples/by_feature/deepspeed_with_config_support.py</code> showing this:`,Va,Gs,Ra,Zl,Qe=`b. Custom Optim + Custom Scheduler: The case when both <code>optimizer</code> and <code>scheduler</code> keys are absent in the DeepSpeed config file.
In this situation, no code changes are needed from the user and this is the case when using integration via DeepSpeed Plugin.
In the above example we can see that the code remains unchanged if the <code>optimizer</code> and <code>scheduler</code> keys are absent in the DeepSpeed config file.`,xa,Cl,ke=`c. Custom Optim + DS Scheduler: The case when only <code>scheduler</code> key is present in the DeepSpeed config file.
In this situation, the user has to use <code>accelerate.utils.DummyScheduler</code> to replace the PyTorch/Custom scheduler in their code.`,Ea,_l,qe=`d. DS Optim + Custom Scheduler: The case when only <code>optimizer</code> key is present in the DeepSpeed config file.
This will result in an error because you can only use DS Scheduler when using DS Optim.`,Qa,Bl,Fe=`<p>Notice the <code>auto</code> values in the above example DeepSpeed config files. These are automatically handled by <code>prepare</code> method
based on model, dataloaders, dummy optimizer and dummy schedulers provided to <code>prepare</code> method.
Only the <code>auto</code> fields specified in above examples are handled by <code>prepare</code> method and the rest have to be explicitly specified by the user.</p>`,Ht,vs,He="The <code>auto</code> values are calculated as:",$t,zs,$e="<li><code>reduce_bucket_size</code>: <code>hidden_size * hidden_size</code></li> <li><code>stage3_prefetch_bucket_size</code>: <code>0.9 * hidden_size * hidden_size</code></li> <li><code>stage3_param_persistence_threshold</code>: <code>10 * hidden_size</code></li>",Lt,Ys,Le="For the <code>auto</code> feature to work for these 3 config entries - Accelerate will use <code>model.config.hidden_size</code> or <code>max(model.config.hidden_sizes)</code> as <code>hidden_size</code>. If neither of these is available, the launching will fail and you will have to set these 3 config entries manually. Remember the first 2 config entries are the communication buffers - the larger they are the more efficient the comms will be, and the larger they are the more GPU memory they will consume, so it’s a tunable performance trade-off.",Dt,Vs,De="<strong>Things to note when using DeepSpeed Config File</strong>",Pt,Rs,Pe="Below is a sample script using <code>deepspeed_config_file</code> in different scenarios.",Ot,xs,Oe="Code <code>test.py</code>:",Kt,Es,sa,Qs,Ke="<strong>Scenario 1</strong>: Manually tampered accelerate config file having <code>deepspeed_config_file</code> along with other entries.",la,ks,sn="<li>Content of the <code>accelerate</code> config:</li>",ta,qs,aa,b,ln="<li><code>ds_config.json</code>:</li>",ea,Fs,na,Z,tn="<li>Output of <code>accelerate launch test.py</code>:</li>",pa,Hs,ia,$s,an="<strong>Scenario 2</strong>: Use the solution of the error to create new accelerate config and check that no ambiguity error is now thrown.",ca,Ls,en="<li>Run <code>accelerate config</code>:</li>",Ma,Ds,oa,C,nn="<li>Content of the <code>accelerate</code> config:</li>",ua,Ps,ra,_,pn="<li>Output of <code>accelerate launch test.py</code>:</li>",ya,Os,ja,Ks,cn="<strong>Scenario 3</strong>: Setting the <code>accelerate launch</code> command arguments related to DeepSpeed as <code>&quot;auto&quot;</code> in the DeepSpeed` configuration file and check that things work as expected.",ha,sl,Mn="<li>New <code>ds_config.json</code> with <code>&quot;auto&quot;</code> for the <code>accelerate launch</code> DeepSpeed command arguments:</li>",da,ll,Ja,B,on="<li>Output of <code>accelerate launch --mixed_precision=&quot;fp16&quot; --zero_stage=3 --gradient_accumulation_steps=5 --gradient_clipping=1.0 --offload_param_device=&quot;cpu&quot; --offload_optimizer_device=&quot;nvme&quot; --zero3_save_16bit_model=&quot;true&quot; test.py</code>:</li>",Ua,tl,wa,al,un="<strong>Note</strong>:",Ta,el,rn=`<li>Remaining <code>&quot;auto&quot;</code> values are handled in <code>accelerator.prepare()</code> call as explained in point 2 of
<code>Important code changes when using DeepSpeed Config File</code>.</li> <li>Only when <code>gradient_accumulation_steps</code> is <code>auto</code>, the value passed while creating <code>Accelerator</code> object via <code>Accelerator(gradient_accumulation_steps=k)</code> will be used. When using DeepSpeed Plugin, the value from it will be used and it will overwrite the value passed while creating Accelerator object.</li>`,ma,nl,fa,g,gl,yn="<p>Saving and loading of models is unchanged for ZeRO Stage-1 and Stage-2.</p>",ka,J,Wl,jn=`under ZeRO Stage-3, <code>state_dict</code> contains just the placeholders since the model weights are partitioned across multiple GPUs.
ZeRO Stage-3 has 2 options:`,qa,Sl,hn=`a. Saving the entire 16bit model weights to directly load later on using <code>model.load_state_dict(torch.load(pytorch_model.bin))</code>.
For this, either set <code>zero_optimization.stage3_gather_16bit_weights_on_model_save</code> to True in DeepSpeed Config file or set
<code>zero3_save_16bit_model</code> to True in DeepSpeed Plugin.
<strong>Note that this option requires consolidation of the weights on one GPU it can be slow and memory demanding, so only use this feature when needed.</strong>
Below is the snippet from <code>examples/by_feature/deepspeed_with_config_support.py</code> showing this:`,Fa,pl,Ha,Xl,dn=`b. To get 32bit weights, first save the model using <code>model.save_checkpoint()</code>.
Below is the snippet from <code>examples/by_feature/deepspeed_with_config_support.py</code> showing this:`,$a,il,La,Nl,Jn=`This will create ZeRO model and optimizer partitions along with <code>zero_to_fp32.py</code> script in checkpoint directory.
You can use this script to do offline consolidation.
It requires no configuration files or GPUs. Here is an example of its usage:`,Da,cl,Pa,Al,Un="To get 32bit model for saving/inference, you can perform:",Oa,Ml,Ka,Gl,wn="If you are only interested in the <code>state_dict</code>, you can do the following:",se,ol,le,vl,Tn="Note that all these functions require ~2x memory (general RAM) of the size of the final checkpoint.",Ia,ul,ba,rl,mn=`DeepSpeed ZeRO Inference supports ZeRO stage 3 with ZeRO-Infinity.
It uses the same ZeRO protocol as training, but it doesn’t use an optimizer and a lr scheduler and only stage 3 is relevant.
With accelerate integration, you just need to prepare the model and dataloader as shown below:`,Za,yl,Ca,jl,_a,hl,fn="<li>Current integration doesn’t support Pipeline Parallelism of DeepSpeed.</li> <li>Current integration doesn’t support <code>mpu</code>, limiting the tensor parallelism which is supported in Megatron-LM.</li> <li>Current integration doesn’t support multiple models.</li>",Ba,dl,ga,Jl,In='The documentation for the internals related to deepspeed can be found <a href="../package_reference/deepspeed">here</a>.',Wa,Ul,bn='<li><a href="https://github.com/microsoft/deepspeed" rel="nofollow">Project’s github</a></li> <li><a href="https://www.deepspeed.ai/getting-started/" rel="nofollow">Usage docs</a></li> <li><a href="https://deepspeed.readthedocs.io/en/latest/index.html" rel="nofollow">API docs</a></li> <li><a href="https://www.microsoft.com/en-us/research/search/?q=deepspeed" rel="nofollow">Blog posts</a></li>',Sa,wl,Zn="Papers:",Xa,Tl,Cn='<li><a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO: Memory Optimizations Toward Training Trillion Parameter Models</a></li> <li><a href="https://arxiv.org/abs/2101.06840" rel="nofollow">ZeRO-Offload: Democratizing Billion-Scale Model Training</a></li> <li><a href="https://arxiv.org/abs/2104.07857" rel="nofollow">ZeRO-Infinity: Breaking the GPU Memory Wall for Extreme Scale Deep Learning</a></li> <li><a href="https://arxiv.org/abs/2306.10209" rel="nofollow">ZeRO++: Extremely Efficient Collective Communication for Giant Model Training</a></li>',Na,ml,_n=`Finally, please, remember that 🤗 <code>Accelerate</code> only integrates DeepSpeed, therefore if you
have any problems or questions with regards to DeepSpeed usage, please, file an issue with <a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">DeepSpeed GitHub</a>.`,Aa,Vl,Ga;return W=new f({props:{title:"DeepSpeed",local:"deepspeed",headingTag:"h1"}}),Y=new f({props:{title:"What is integrated?",local:"what-is-integrated",headingTag:"h2"}}),P=new f({props:{title:"How it works?",local:"how-it-works",headingTag:"h2"}}),ss=new f({props:{title:"Accelerate DeepSpeed Plugin",local:"accelerate-deepspeed-plugin",headingTag:"h3"}}),ts=new d({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),es=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15X3NjcmlwdC5weSUyMC0tYXJnc190b19teV9zY3JpcHQ=",highlighted:"accelerate launch my_script.py --args_to_my_script",wrap:!1}}),is=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwMSUwQSUyMGdyYWRpZW50X2NsaXBwaW5nJTNBJTIwMS4wJTBBJTIwb2ZmbG9hZF9vcHRpbWl6ZXJfZGV2aWNlJTNBJTIwbm9uZSUwQSUyMG9mZmxvYWRfcGFyYW1fZGV2aWNlJTNBJTIwbm9uZSUwQSUyMHplcm8zX2luaXRfZmxhZyUzQSUyMHRydWUlMEElMjB6ZXJvX3N0YWdlJTNBJTIwMiUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFmc2RwX2NvbmZpZyUzQSUyMCU3QiU3RCUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjBudWxsJTBBbWFpbl9wcm9jZXNzX3BvcnQlM0ElMjBudWxsJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
 gradient_accumulation_steps: 1
 gradient_clipping: 1.0
 offload_optimizer_device: none
 offload_param_device: none
 zero3_init_flag: <span class="hljs-literal">true</span>
 zero_stage: 2
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),cs=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGbmxwX2V4YW1wbGUucHklMjAtLW1peGVkX3ByZWNpc2lvbiUyMGZwMTY=",highlighted:"accelerate launch examples/nlp_example.py --mixed_precision fp16",wrap:!1}}),os=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwMSUwQSUyMCUyMGdyYWRpZW50X2NsaXBwaW5nJTNBJTIwMS4wJTBBJTIwJTIwb2ZmbG9hZF9vcHRpbWl6ZXJfZGV2aWNlJTNBJTIwY3B1JTBBJTIwJTIwb2ZmbG9hZF9wYXJhbV9kZXZpY2UlM0ElMjBjcHUlMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBJTIwJTIwemVybzNfc2F2ZV8xNmJpdF9tb2RlbCUzQSUyMHRydWUlMEElMjAlMjB6ZXJvX3N0YWdlJTNBJTIwMyUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFmc2RwX2NvbmZpZyUzQSUyMCU3QiU3RCUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjBudWxsJTBBbWFpbl9wcm9jZXNzX3BvcnQlM0ElMjBudWxsJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
  gradient_accumulation_steps: 1
  gradient_clipping: 1.0
  offload_optimizer_device: cpu
  offload_param_device: cpu
  zero3_init_flag: <span class="hljs-literal">true</span>
  zero3_save_16bit_model: <span class="hljs-literal">true</span>
  zero_stage: 3
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),us=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGbmxwX2V4YW1wbGUucHklMjAtLW1peGVkX3ByZWNpc2lvbiUyMGZwMTY=",highlighted:"accelerate launch examples/nlp_example.py --mixed_precision fp16",wrap:!1}}),ys=new d({props:{code:"JTYwemVyb19zdGFnZSU2MCUzQSUyMCU1QjAlNUQlMjBEaXNhYmxlZCUyQyUyMCU1QjElNUQlMjBvcHRpbWl6ZXIlMjBzdGF0ZSUyMHBhcnRpdGlvbmluZyUyQyUyMCU1QjIlNUQlMjBvcHRpbWl6ZXIlMkJncmFkaWVudCUyMHN0YXRlJTIwcGFydGl0aW9uaW5nJTIwYW5kJTIwJTVCMyU1RCUyMG9wdGltaXplciUyQmdyYWRpZW50JTJCcGFyYW1ldGVyJTIwcGFydGl0aW9uaW5nJTBBJTYwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTYwJTNBJTIwTnVtYmVyJTIwb2YlMjB0cmFpbmluZyUyMHN0ZXBzJTIwdG8lMjBhY2N1bXVsYXRlJTIwZ3JhZGllbnRzJTIwYmVmb3JlJTIwYXZlcmFnaW5nJTIwYW5kJTIwYXBwbHlpbmclMjB0aGVtLiUwQSU2MGdyYWRpZW50X2NsaXBwaW5nJTYwJTNBJTIwRW5hYmxlJTIwZ3JhZGllbnQlMjBjbGlwcGluZyUyMHdpdGglMjB2YWx1ZS4lMEElNjBvZmZsb2FkX29wdGltaXplcl9kZXZpY2UlNjAlM0ElMjAlNUJub25lJTVEJTIwRGlzYWJsZSUyMG9wdGltaXplciUyMG9mZmxvYWRpbmclMkMlMjAlNUJjcHUlNUQlMjBvZmZsb2FkJTIwb3B0aW1pemVyJTIwdG8lMjBDUFUlMkMlMjAlNUJudm1lJTVEJTIwb2ZmbG9hZCUyMG9wdGltaXplciUyMHRvJTIwTlZNZSUyMFNTRC4lMjBPbmx5JTIwYXBwbGljYWJsZSUyMHdpdGglMjBaZVJPJTIwJTNFJTNEJTIwU3RhZ2UtMi4lMEElNjBvZmZsb2FkX3BhcmFtX2RldmljZSU2MCUzQSUyMCU1Qm5vbmUlNUQlMjBEaXNhYmxlJTIwcGFyYW1ldGVyJTIwb2ZmbG9hZGluZyUyQyUyMCU1QmNwdSU1RCUyMG9mZmxvYWQlMjBwYXJhbWV0ZXJzJTIwdG8lMjBDUFUlMkMlMjAlNUJudm1lJTVEJTIwb2ZmbG9hZCUyMHBhcmFtZXRlcnMlMjB0byUyME5WTWUlMjBTU0QuJTIwT25seSUyMGFwcGxpY2FibGUlMjB3aXRoJTIwWmVSTyUyMFN0YWdlLTMuJTBBJTYwemVybzNfaW5pdF9mbGFnJTYwJTNBJTIwRGVjaWRlcyUyMHdoZXRoZXIlMjB0byUyMGVuYWJsZSUyMCU2MGRlZXBzcGVlZC56ZXJvLkluaXQlNjAlMjBmb3IlMjBjb25zdHJ1Y3RpbmclMjBtYXNzaXZlJTIwbW9kZWxzLiUyME9ubHklMjBhcHBsaWNhYmxlJTIwd2l0aCUyMFplUk8lMjBTdGFnZS0zLiUwQSU2MHplcm8zX3NhdmVfMTZiaXRfbW9kZWwlNjAlM0ElMjBEZWNpZGVzJTIwd2hldGhlciUyMHRvJTIwc2F2ZSUyMDE2LWJpdCUyMG1vZGVsJTIwd2VpZ2h0cyUyMHdoZW4lMjB1c2luZyUyMFplUk8lMjBTdGFnZS0zLiUwQSU2MG1peGVkX3ByZWNpc2lvbiU2MCUzQSUyMCU2MG5vJTYwJTIwZm9yJTIwRlAzMiUyMHRyYWluaW5nJTJDJTIwJTYwZnAxNiU2MCUyMGZvciUyMEZQMTYlMjBtaXhlZC1wcmVjaXNpb24lMjB0cmFpbmluZyUyMGFuZCUyMCU2MGJmMTYlNjAlMjBmb3IlMjBCRjE2JTIwbWl4ZWQtcHJlY2lzaW9uJTIwdHJhaW5pbmcu",highlighted:'`zero_stage`: [0] Disabled, [1] optimizer state partitioning, [2] optimizer+gradient state partitioning and [3] optimizer+gradient+parameter partitioning\n`gradient_accumulation_steps`: Number of training steps to accumulate gradients before averaging and applying them.\n`gradient_clipping`: Enable gradient clipping with value.\n`offload_optimizer_device`: [none] Disable optimizer offloading, [cpu] offload optimizer to CPU, [nvme] offload optimizer to NVMe SSD. Only applicable with ZeRO &gt;= Stage-2.\n`offload_param_device`: [none] Disable parameter offloading, [cpu] offload parameters to CPU, [nvme] offload parameters to NVMe SSD. Only applicable with ZeRO Stage-3.\n`zero3_init_flag`: Decides whether to <span class="hljs-built_in">enable</span> `deepspeed.zero.Init` <span class="hljs-keyword">for</span> constructing massive models. Only applicable with ZeRO Stage-3.\n`zero3_save_16bit_model`: Decides whether to save 16-bit model weights when using ZeRO Stage-3.\n`mixed_precision`: `no` <span class="hljs-keyword">for</span> FP32 training, `fp16` <span class="hljs-keyword">for</span> FP16 mixed-precision training and `bf16` <span class="hljs-keyword">for</span> BF16 mixed-precision training.',wrap:!1}}),hs=new f({props:{title:"DeepSpeed Config File",local:"deepspeed-config-file",headingTag:"h3"}}),Js=new d({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),ws=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15X3NjcmlwdC5weSUyMC0tYXJnc190b19teV9zY3JpcHQ=",highlighted:"accelerate launch my_script.py --args_to_my_script",wrap:!1}}),fs=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJTJGaG9tZSUyRnVidW50dSUyRmFjY2VsZXJhdGUlMkZleGFtcGxlcyUyRmNvbmZpZ3MlMkZkZWVwc3BlZWRfY29uZmlnX3RlbXBsYXRlcyUyRnplcm9fc3RhZ2UyX2NvbmZpZy5qc29uJTBBJTIwemVybzNfaW5pdF9mbGFnJTNBJTIwdHJ1ZSUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFmc2RwX2NvbmZpZyUzQSUyMCU3QiU3RCUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjBudWxsJTBBbWFpbl9wcm9jZXNzX3BvcnQlM0ElMjBudWxsJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
 deepspeed_config_file: /home/ubuntu/accelerate/examples/configs/deepspeed_config_templates/zero_stage2_config.json
 zero3_init_flag: <span class="hljs-literal">true</span>
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),bs=new d({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyZnAxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9zc19zY2FsZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsb3NzX3NjYWxlX3dpbmRvdyUyMiUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbml0aWFsX3NjYWxlX3Bvd2VyJTIyJTNBJTIwMTYlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoeXN0ZXJlc2lzJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1pbl9sb3NzX3NjYWxlJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm9wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJBZGFtVyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxyJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndlaWdodF9kZWNheSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3JjaF9hZGFtJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFkYW1fd19tb2RlJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnNjaGVkdWxlciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJXYXJtdXBEZWNheUxSJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1zJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd2FybXVwX21pbl9sciUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3YXJtdXBfbWF4X2xyJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndhcm11cF9udW1fc3RlcHMlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG90YWxfbnVtX3N0ZXBzJTIyJTNBJTIwJTIyYXV0byUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnplcm9fb3B0aW1pemF0aW9uJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhZ2UlMjIlM0ElMjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX3BhcnRpdGlvbnMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxsZ2F0aGVyX2J1Y2tldF9zaXplJTIyJTNBJTIwMmU4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlZHVjZV9zY2F0dGVyJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlZHVjZV9idWNrZXRfc2l6ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250aWd1b3VzX2dyYWRpZW50cyUyMiUzQSUyMHRydWUlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIyZ3JhZGllbnRfY2xpcHBpbmclMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3RlcHNfcGVyX3ByaW50JTIyJTNBJTIwMjAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYWluX2JhdGNoX3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMndhbGxfY2xvY2tfYnJlYWtkb3duJTIyJTNBJTIwZmFsc2UlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;torch_adam&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;adam_w_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupDecayLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;total_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_partitions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;allgather_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2e8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_scatter&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Zs=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGYnlfZmVhdHVyZSUyRmRlZXBzcGVlZF93aXRoX2NvbmZpZ19zdXBwb3J0LnB5JTIwJTVDJTBBLS1jb25maWdfbmFtZSUyMCUyMmdwdDItbGFyZ2UlMjIlMjAlNUMlMEEtLXRva2VuaXplcl9uYW1lJTIwJTIyZ3B0Mi1sYXJnZSUyMiUyMCU1QyUwQS0tZGF0YXNldF9uYW1lJTIwJTIyd2lraXRleHQlMjIlMjAlNUMlMEEtLWRhdGFzZXRfY29uZmlnX25hbWUlMjAlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyMCU1QyUwQS0tYmxvY2tfc2l6ZSUyMDEyOCUyMCU1QyUwQS0tb3V0cHV0X2RpciUyMCUyMi4lMkZjbG0lMkZjbG1fZGVlcHNwZWVkX3N0YWdlMl9hY2NlbGVyYXRlJTIyJTIwJTVDJTBBLS1sZWFybmluZ19yYXRlJTIwNWUtNCUyMCU1QyUwQS0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMjQlMjAlNUMlMEEtLXBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTIwMjQlMjAlNUMlMEEtLW51bV90cmFpbl9lcG9jaHMlMjAzJTIwJTVDJTBBLS13aXRoX3RyYWNraW5nJTIwJTVDJTBBLS1yZXBvcnRfdG8lMjAlMjJ3YW5kYiUyMiU1Qw==",highlighted:`accelerate launch examples/by_feature/deepspeed_with_config_support.py \\
--config_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--dataset_name <span class="hljs-string">&quot;wikitext&quot;</span> \\
--dataset_config_name <span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span> \\
--block_size 128 \\
--output_dir <span class="hljs-string">&quot;./clm/clm_deepspeed_stage2_accelerate&quot;</span> \\
--learning_rate 5e-4 \\
--per_device_train_batch_size 24 \\
--per_device_eval_batch_size 24 \\
--num_train_epochs 3 \\
--with_tracking \\
--report_to <span class="hljs-string">&quot;wandb&quot;</span>\\`,wrap:!1}}),_s=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJTJGaG9tZSUyRnVidW50dSUyRmFjY2VsZXJhdGUlMkZleGFtcGxlcyUyRmNvbmZpZ3MlMkZkZWVwc3BlZWRfY29uZmlnX3RlbXBsYXRlcyUyRnplcm9fc3RhZ2UzX29mZmxvYWRfY29uZmlnLmpzb24lMEElMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMERFRVBTUEVFRCUwQWZzZHBfY29uZmlnJTNBJTIwJTdCJTdEJTBBbWFjaGluZV9yYW5rJTNBJTIwMCUwQW1haW5fcHJvY2Vzc19pcCUzQSUyMG51bGwlMEFtYWluX3Byb2Nlc3NfcG9ydCUzQSUyMG51bGwlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGZwMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDIlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config:
 deepspeed_config_file: /home/ubuntu/accelerate/examples/configs/deepspeed_config_templates/zero_stage3_offload_config.json
 zero3_init_flag: <span class="hljs-literal">true</span>
distributed_type: DEEPSPEED
fsdp_config: {}
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: fp16
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),gs=new d({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;fp16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;loss_scale_window&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1000</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;initial_scale_power&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">16</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hysteresis&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;min_loss_scale&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;AdamW&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;weight_decay&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WarmupDecayLR&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;params&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;warmup_min_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_max_lr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;warmup_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;total_num_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;cpu&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;pin_memory&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_prefetch_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_param_persistence_threshold&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;sub_group_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_live_parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_max_reuse_distance&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1e9</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;wall_clock_breakdown&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ws=new d({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGYnlfZmVhdHVyZSUyRmRlZXBzcGVlZF93aXRoX2NvbmZpZ19zdXBwb3J0LnB5JTIwJTVDJTBBLS1jb25maWdfbmFtZSUyMCUyMmdwdDItbGFyZ2UlMjIlMjAlNUMlMEEtLXRva2VuaXplcl9uYW1lJTIwJTIyZ3B0Mi1sYXJnZSUyMiUyMCU1QyUwQS0tZGF0YXNldF9uYW1lJTIwJTIyd2lraXRleHQlMjIlMjAlNUMlMEEtLWRhdGFzZXRfY29uZmlnX25hbWUlMjAlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyMCU1QyUwQS0tYmxvY2tfc2l6ZSUyMDEyOCUyMCU1QyUwQS0tb3V0cHV0X2RpciUyMCUyMi4lMkZjbG0lMkZjbG1fZGVlcHNwZWVkX3N0YWdlM19vZmZsb2FkX2FjY2VsZXJhdGUlMjIlMjAlNUMlMEEtLWxlYXJuaW5nX3JhdGUlMjA1ZS00JTIwJTVDJTBBLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAzMiUyMCU1QyUwQS0tcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlMjAzMiUyMCU1QyUwQS0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEEtLXdpdGhfdHJhY2tpbmclMjAlNUMlMEEtLXJlcG9ydF90byUyMCUyMndhbmRiJTIyJTVD",highlighted:`accelerate launch examples/by_feature/deepspeed_with_config_support.py \\
--config_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--dataset_name <span class="hljs-string">&quot;wikitext&quot;</span> \\
--dataset_config_name <span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span> \\
--block_size 128 \\
--output_dir <span class="hljs-string">&quot;./clm/clm_deepspeed_stage3_offload_accelerate&quot;</span> \\
--learning_rate 5e-4 \\
--per_device_train_batch_size 32 \\
--per_device_eval_batch_size 32 \\
--num_train_epochs 3 \\
--with_tracking \\
--report_to <span class="hljs-string">&quot;wandb&quot;</span>\\`,wrap:!1}}),Xs=new d({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZWR1Y2VfYnVja2V0X3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyemVyb19xdWFudGl6ZWRfd2VpZ2h0cyUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ6ZXJvX2hwel9wYXJ0aXRpb25fc2l6ZSUyMiUzQSUyMDglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ6ZXJvX3F1YW50aXplZF9ncmFkaWVudHMlMjIlM0ElMjB0cnVlJTJDJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGlndW91c19ncmFkaWVudHMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3ZlcmxhcF9jb21tJTIyJTNBJTIwdHJ1ZSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;reduce_bucket_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>

        <span class="hljs-attr">&quot;zero_quantized_weights&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;zero_hpz_partition_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">8</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;zero_quantized_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>

        <span class="hljs-attr">&quot;contiguous_gradients&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;overlap_comm&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Gs=new d({props:{code:"JTIwJTIzJTIwQ3JlYXRlcyUyMER1bW15JTIwT3B0aW1pemVyJTIwaWYlMjAlNjBvcHRpbWl6ZXIlNjAlMjB3YXMlMjBzcGVjaWZpZWQlMjBpbiUyMHRoZSUyMGNvbmZpZyUyMGZpbGUlMjBlbHNlJTIwY3JlYXRlcyUyMEFkYW0lMjBPcHRpbWl6ZXIlMEElMjBvcHRpbWl6ZXJfY2xzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMHRvcmNoLm9wdGltLkFkYW1XJTBBJTIwJTIwJTIwJTIwJTIwaWYlMjBhY2NlbGVyYXRvci5zdGF0ZS5kZWVwc3BlZWRfcGx1Z2luJTIwaXMlMjBOb25lJTBBJTIwJTIwJTIwJTIwJTIwb3IlMjAlMjJvcHRpbWl6ZXIlMjIlMjBub3QlMjBpbiUyMGFjY2VsZXJhdG9yLnN0YXRlLmRlZXBzcGVlZF9wbHVnaW4uZGVlcHNwZWVkX2NvbmZpZyUwQSUyMCUyMCUyMCUyMCUyMGVsc2UlMjBEdW1teU9wdGltJTBBJTIwKSUwQSUyMG9wdGltaXplciUyMCUzRCUyMG9wdGltaXplcl9jbHMob3B0aW1pemVyX2dyb3VwZWRfcGFyYW1ldGVycyUyQyUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlKSUwQSUwQSUyMCUyMyUyMENyZWF0ZXMlMjBEdW1teSUyMFNjaGVkdWxlciUyMGlmJTIwJTYwc2NoZWR1bGVyJTYwJTIwd2FzJTIwc3BlY2lmaWVkJTIwaW4lMjB0aGUlMjBjb25maWclMjBmaWxlJTIwZWxzZSUyMGNyZWF0ZXMlMjAlNjBhcmdzLmxyX3NjaGVkdWxlcl90eXBlJTYwJTIwU2NoZWR1bGVyJTBBJTIwaWYlMjAoJTBBJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3Iuc3RhdGUuZGVlcHNwZWVkX3BsdWdpbiUyMGlzJTIwTm9uZSUwQSUyMCUyMCUyMCUyMCUyMG9yJTIwJTIyc2NoZWR1bGVyJTIyJTIwbm90JTIwaW4lMjBhY2NlbGVyYXRvci5zdGF0ZS5kZWVwc3BlZWRfcGx1Z2luLmRlZXBzcGVlZF9jb25maWclMEElMjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEYXJncy5scl9zY2hlZHVsZXJfdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0RhcmdzLm51bV93YXJtdXBfc3RlcHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RhcmdzLm1heF90cmFpbl9zdGVwcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCklMEElMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwRHVtbXlTY2hlZHVsZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyJTJDJTIwdG90YWxfbnVtX3N0ZXBzJTNEYXJncy5tYXhfdHJhaW5fc3RlcHMlMkMlMjB3YXJtdXBfbnVtX3N0ZXBzJTNEYXJncy5udW1fd2FybXVwX3N0ZXBzJTBBJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:` <span class="hljs-comment"># Creates Dummy Optimizer if \`optimizer\` was specified in the config file else creates Adam Optimizer</span>
 optimizer_cls = (
     torch.optim.AdamW
     <span class="hljs-keyword">if</span> accelerator.state.deepspeed_plugin <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>
     <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;optimizer&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> accelerator.state.deepspeed_plugin.deepspeed_config
     <span class="hljs-keyword">else</span> DummyOptim
 )
 optimizer = optimizer_cls(optimizer_grouped_parameters, lr=args.learning_rate)

 <span class="hljs-comment"># Creates Dummy Scheduler if \`scheduler\` was specified in the config file else creates \`args.lr_scheduler_type\` Scheduler</span>
 <span class="hljs-keyword">if</span> (
     accelerator.state.deepspeed_plugin <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>
     <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;scheduler&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> accelerator.state.deepspeed_plugin.deepspeed_config
 ):
     lr_scheduler = get_scheduler(
         name=args.lr_scheduler_type,
         optimizer=optimizer,
         num_warmup_steps=args.num_warmup_steps,
         num_training_steps=args.max_train_steps,
     )
 <span class="hljs-keyword">else</span>:
     lr_scheduler = DummyScheduler(
         optimizer, total_num_steps=args.max_train_steps, warmup_num_steps=args.num_warmup_steps
     )`,wrap:!1}}),Es=new d({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnN0YXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3JTdGF0ZSUwQSUwQSUwQWRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLnByaW50KGYlMjIlN0JBY2NlbGVyYXRvclN0YXRlKCklN0QlMjIpJTBBJTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwbWFpbigp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> AcceleratorState


<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    accelerator = Accelerator()
    accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{AcceleratorState()}</span>&quot;</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),qs=new d({props:{code:"Y29tbWFuZF9maWxlJTNBJTIwbnVsbCUwQWNvbW1hbmRzJTNBJTIwbnVsbCUwQWNvbXB1dGVfZW52aXJvbm1lbnQlM0ElMjBMT0NBTF9NQUNISU5FJTBBZGVlcHNwZWVkX2NvbmZpZyUzQSUwQSUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzQSUyMDElMEElMjAlMjBncmFkaWVudF9jbGlwcGluZyUzQSUyMDEuMCUwQSUyMCUyMG9mZmxvYWRfb3B0aW1pemVyX2RldmljZSUzQSUyMCdjcHUnJTBBJTIwJTIwb2ZmbG9hZF9wYXJhbV9kZXZpY2UlM0ElMjAnY3B1JyUwQSUyMCUyMHplcm8zX2luaXRfZmxhZyUzQSUyMHRydWUlMEElMjAlMjB6ZXJvM19zYXZlXzE2Yml0X21vZGVsJTNBJTIwdHJ1ZSUwQSUyMCUyMHplcm9fc3RhZ2UlM0ElMjAzJTBBJTIwJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJ2RzX2NvbmZpZy5qc29uJyUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBERUVQU1BFRUQlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWR5bmFtb19iYWNrZW5kJTNBJTIwJ05PJyUwQWZzZHBfY29uZmlnJTNBJTIwJTdCJTdEJTBBZ3B1X2lkcyUzQSUyMG51bGwlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl9wcm9jZXNzX2lwJTNBJTIwbnVsbCUwQW1haW5fcHJvY2Vzc19wb3J0JTNBJTIwbnVsbCUwQW1haW5fdHJhaW5pbmdfZnVuY3Rpb24lM0ElMjBtYWluJTBBbWVnYXRyb25fbG1fY29uZmlnJTNBJTIwJTdCJTdEJTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9uYW1lJTNBJTIwbnVsbCUwQXRwdV96b25lJTNBJTIwbnVsbCUwQXVzZV9jcHUlM0ElMjBmYWxzZQ==",highlighted:`<span class="hljs-attr">command_file:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">commands:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span>
  <span class="hljs-attr">gradient_accumulation_steps:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">gradient_clipping:</span> <span class="hljs-number">1.0</span>
  <span class="hljs-attr">offload_optimizer_device:</span> <span class="hljs-string">&#x27;cpu&#x27;</span>
  <span class="hljs-attr">offload_param_device:</span> <span class="hljs-string">&#x27;cpu&#x27;</span>
  <span class="hljs-attr">zero3_init_flag:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">zero3_save_16bit_model:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">zero_stage:</span> <span class="hljs-number">3</span>
  <span class="hljs-attr">deepspeed_config_file:</span> <span class="hljs-string">&#x27;ds_config.json&#x27;</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">dynamo_backend:</span> <span class="hljs-string">&#x27;NO&#x27;</span>
<span class="hljs-attr">fsdp_config:</span> {}
<span class="hljs-attr">gpu_ids:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_process_ip:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_process_port:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">megatron_lm_config:</span> {}
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_name:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">tpu_zone:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),Fs=new d({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjB0cnVlJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMDMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSUyMiUzQSUyMGZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2ZmbG9hZF9vcHRpbWl6ZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZXZpY2UlMjIlM0ElMjAlMjJub25lJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyb2ZmbG9hZF9wYXJhbSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMm5vbmUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJncmFkaWVudF9jbGlwcGluZyUyMiUzQSUyMDEuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYWluX2JhdGNoX3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMiUzQSUyMDEwJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3RlcHNfcGVyX3ByaW50JTIyJTNBJTIwMjAwMDAwMCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;none&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;none&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">10</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000000</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Hs=new d({props:{code:"VmFsdWVFcnJvciUzQSUyMFdoZW4lMjB1c2luZyUyMCU2MGRlZXBzcGVlZF9jb25maWdfZmlsZSU2MCUyQyUyMHRoZSUyMGZvbGxvd2luZyUyMGFjY2VsZXJhdGUlMjBjb25maWclMjB2YXJpYWJsZXMlMjB3aWxsJTIwYmUlMjBpZ25vcmVkJTNBJTBBJTVCJ2dyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyclMkMlMjAnZ3JhZGllbnRfY2xpcHBpbmcnJTJDJTIwJ3plcm9fc3RhZ2UnJTJDJTIwJ29mZmxvYWRfb3B0aW1pemVyX2RldmljZSclMkMlMjAnb2ZmbG9hZF9wYXJhbV9kZXZpY2UnJTJDJTBBJ3plcm8zX3NhdmVfMTZiaXRfbW9kZWwnJTJDJTIwJ21peGVkX3ByZWNpc2lvbiclNUQuJTBBUGxlYXNlJTIwc3BlY2lmeSUyMHRoZW0lMjBhcHByb3ByaWF0ZWx5JTIwaW4lMjB0aGUlMjBEZWVwU3BlZWQlMjBjb25maWclMjBmaWxlLiUwQUlmJTIweW91JTIwYXJlJTIwdXNpbmclMjBhbiUyMGFjY2VsZXJhdGUlMjBjb25maWclMjBmaWxlJTJDJTIwcmVtb3ZlJTIwb3RoZXJzJTIwY29uZmlnJTIwdmFyaWFibGVzJTIwbWVudGlvbmVkJTIwaW4lMjB0aGUlMjBhYm92ZSUyMHNwZWNpZmllZCUyMGxpc3QuJTBBVGhlJTIwZWFzaWVzdCUyMG1ldGhvZCUyMGlzJTIwdG8lMjBjcmVhdGUlMjBhJTIwbmV3JTIwY29uZmlnJTIwZm9sbG93aW5nJTIwdGhlJTIwcXVlc3Rpb25uYWlyZSUyMHZpYSUyMCU2MGFjY2VsZXJhdGUlMjBjb25maWclNjAuJTBBSXQlMjB3aWxsJTIwb25seSUyMGFzayUyMGZvciUyMHRoZSUyMG5lY2Vzc2FyeSUyMGNvbmZpZyUyMHZhcmlhYmxlcyUyMHdoZW4lMjB1c2luZyUyMCU2MGRlZXBzcGVlZF9jb25maWdfZmlsZSU2MC4=",highlighted:'ValueError: When using `deepspeed_config_file`, the following accelerate config variables will be ignored:\n[<span class="hljs-string">&#x27;gradient_accumulation_steps&#x27;</span>, <span class="hljs-string">&#x27;gradient_clipping&#x27;</span>, <span class="hljs-string">&#x27;zero_stage&#x27;</span>, <span class="hljs-string">&#x27;offload_optimizer_device&#x27;</span>, <span class="hljs-string">&#x27;offload_param_device&#x27;</span>,\n<span class="hljs-string">&#x27;zero3_save_16bit_model&#x27;</span>, <span class="hljs-string">&#x27;mixed_precision&#x27;</span>].\nPlease specify them appropriately <span class="hljs-keyword">in</span> the DeepSpeed config file.\nIf you are using an accelerate config file, remove others config variables mentioned <span class="hljs-keyword">in</span> the above specified list.\nThe easiest method is to create a new config following the questionnaire via `accelerate config`.\nIt will only ask <span class="hljs-keyword">for</span> the necessary config variables when using `deepspeed_config_file`.',wrap:!1}}),Ds=new d({props:{code:"JTI0JTIwYWNjZWxlcmF0ZSUyMGNvbmZpZyUwQS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMEFJbiUyMHdoaWNoJTIwY29tcHV0ZSUyMGVudmlyb25tZW50JTIwYXJlJTIweW91JTIwcnVubmluZyUzRiUwQVRoaXMlMjBtYWNoaW5lJTBBLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUwQVdoaWNoJTIwdHlwZSUyMG9mJTIwbWFjaGluZSUyMGFyZSUyMHlvdSUyMHVzaW5nJTNGJTBBbXVsdGktR1BVJTBBSG93JTIwbWFueSUyMGRpZmZlcmVudCUyMG1hY2hpbmVzJTIwd2lsbCUyMHlvdSUyMHVzZSUyMCh1c2UlMjBtb3JlJTIwdGhhbiUyMDElMjBmb3IlMjBtdWx0aS1ub2RlJTIwdHJhaW5pbmcpJTNGJTIwJTVCMSU1RCUzQSUwQURvJTIweW91JTIwd2lzaCUyMHRvJTIwb3B0aW1pemUlMjB5b3VyJTIwc2NyaXB0JTIwd2l0aCUyMHRvcmNoJTIwZHluYW1vJTNGJTVCeWVzJTJGTk8lNUQlM0ElMEFEbyUyMHlvdSUyMHdhbnQlMjB0byUyMHVzZSUyMERlZXBTcGVlZCUzRiUyMCU1QnllcyUyRk5PJTVEJTNBJTIweWVzJTBBRG8lMjB5b3UlMjB3YW50JTIwdG8lMjBzcGVjaWZ5JTIwYSUyMGpzb24lMjBmaWxlJTIwdG8lMjBhJTIwRGVlcFNwZWVkJTIwY29uZmlnJTNGJTIwJTVCeWVzJTJGTk8lNUQlM0ElMjB5ZXMlMEFQbGVhc2UlMjBlbnRlciUyMHRoZSUyMHBhdGglMjB0byUyMHRoZSUyMGpzb24lMjBEZWVwU3BlZWQlMjBjb25maWclMjBmaWxlJTNBJTIwZHNfY29uZmlnLmpzb24lMEFEbyUyMHlvdSUyMHdhbnQlMjB0byUyMGVuYWJsZSUyMCU2MGRlZXBzcGVlZC56ZXJvLkluaXQlNjAlMjB3aGVuJTIwdXNpbmclMjBaZVJPJTIwU3RhZ2UtMyUyMGZvciUyMGNvbnN0cnVjdGluZyUyMG1hc3NpdmUlMjBtb2RlbHMlM0YlMjAlNUJ5ZXMlMkZOTyU1RCUzQSUyMHllcyUwQUhvdyUyMG1hbnklMjBHUFUocyklMjBzaG91bGQlMjBiZSUyMHVzZWQlMjBmb3IlMjBkaXN0cmlidXRlZCUyMHRyYWluaW5nJTNGJTIwJTVCMSU1RCUzQTQlMEFhY2NlbGVyYXRlJTIwY29uZmlndXJhdGlvbiUyMHNhdmVkJTIwYXQlMjBkc19jb25maWdfc2FtcGxlLnlhbWw=",highlighted:`$ accelerate config
-------------------------------------------------------------------------------------------------------------------------------
In <span class="hljs-built_in">which</span> compute environment are you running?
This machine
-------------------------------------------------------------------------------------------------------------------------------
Which <span class="hljs-built_in">type</span> of machine are you using?
multi-GPU
How many different machines will you use (use more than 1 <span class="hljs-keyword">for</span> multi-node training)? [1]:
Do you wish to optimize your script with torch dynamo?[<span class="hljs-built_in">yes</span>/NO]:
Do you want to use DeepSpeed? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>
Do you want to specify a json file to a DeepSpeed config? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>
Please enter the path to the json DeepSpeed config file: ds_config.json
Do you want to <span class="hljs-built_in">enable</span> \`deepspeed.zero.Init\` when using ZeRO Stage-3 <span class="hljs-keyword">for</span> constructing massive models? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>
How many GPU(s) should be used <span class="hljs-keyword">for</span> distributed training? [1]:4
accelerate configuration saved at ds_config_sample.yaml`,wrap:!1}}),Ps=new d({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwZHNfY29uZmlnLmpzb24lMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMERFRVBTUEVFRCUwQWRvd25jYXN0X2JmMTYlM0ElMjAnbm8nJTBBZHluYW1vX2JhY2tlbmQlM0ElMjAnTk8nJTBBZnNkcF9jb25maWclM0ElMjAlN0IlN0QlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtZWdhdHJvbl9sbV9jb25maWclM0ElMjAlN0IlN0QlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDQlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span>
  <span class="hljs-attr">deepspeed_config_file:</span> <span class="hljs-string">ds_config.json</span>
  <span class="hljs-attr">zero3_init_flag:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">dynamo_backend:</span> <span class="hljs-string">&#x27;NO&#x27;</span>
<span class="hljs-attr">fsdp_config:</span> {}
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">megatron_lm_config:</span> {}
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),Os=new d({props:{code:"RGlzdHJpYnV0ZWQlMjBlbnZpcm9ubWVudCUzQSUyMERFRVBTUEVFRCUyMCUyMEJhY2tlbmQlM0ElMjBuY2NsJTBBTnVtJTIwcHJvY2Vzc2VzJTNBJTIwNCUwQVByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFMb2NhbCUyMHByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFEZXZpY2UlM0ElMjBjdWRhJTNBMCUwQU1peGVkJTIwcHJlY2lzaW9uJTIwdHlwZSUzQSUyMGJmMTYlMEFkc19jb25maWclM0ElMjAlN0InYmYxNiclM0ElMjAlN0InZW5hYmxlZCclM0ElMjBUcnVlJTdEJTJDJTIwJ3plcm9fb3B0aW1pemF0aW9uJyUzQSUyMCU3QidzdGFnZSclM0ElMjAzJTJDJTIwJ3N0YWdlM19nYXRoZXJfMTZiaXRfd2VpZ2h0c19vbl9tb2RlbF9zYXZlJyUzQSUyMEZhbHNlJTJDJTIwJ29mZmxvYWRfb3B0aW1pemVyJyUzQSUyMCU3QidkZXZpY2UnJTNBJTIwJ25vbmUnJTdEJTJDJTIwJ29mZmxvYWRfcGFyYW0nJTNBJTIwJTdCJ2RldmljZSclM0ElMjAnbm9uZSclN0QlN0QlMkMlMjAnZ3JhZGllbnRfY2xpcHBpbmcnJTNBJTIwMS4wJTJDJTIwJ3RyYWluX2JhdGNoX3NpemUnJTNBJTIwJ2F1dG8nJTJDJTIwJ3RyYWluX21pY3JvX2JhdGNoX3NpemVfcGVyX2dwdSclM0ElMjAnYXV0byclMkMlMjAnZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJyUzQSUyMDEwJTJDJTIwJ3N0ZXBzX3Blcl9wcmludCclM0ElMjBpbmYlMkMlMjAnZnAxNiclM0ElMjAlN0InZW5hYmxlZCclM0ElMjBGYWxzZSU3RCU3RA==",highlighted:`Distributed environment: DEEPSPEED  Backend: nccl
Num processes: 4
Process index: 0
Local process index: 0
Device: cuda:0
Mixed precision <span class="hljs-built_in">type</span>: bf16
ds_config: {<span class="hljs-string">&#x27;bf16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: True}, <span class="hljs-string">&#x27;zero_optimization&#x27;</span>: {<span class="hljs-string">&#x27;stage&#x27;</span>: 3, <span class="hljs-string">&#x27;stage3_gather_16bit_weights_on_model_save&#x27;</span>: False, <span class="hljs-string">&#x27;offload_optimizer&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;none&#x27;</span>}, <span class="hljs-string">&#x27;offload_param&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;none&#x27;</span>}}, <span class="hljs-string">&#x27;gradient_clipping&#x27;</span>: 1.0, <span class="hljs-string">&#x27;train_batch_size&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;train_micro_batch_size_per_gpu&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;gradient_accumulation_steps&#x27;</span>: 10, <span class="hljs-string">&#x27;steps_per_print&#x27;</span>: inf, <span class="hljs-string">&#x27;fp16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: False}}`,wrap:!1}}),ll=new d({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyYmYxNiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlM0ElMjAlMjJhdXRvJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyemVyb19vcHRpbWl6YXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX29wdGltaXplciUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZSUyMiUzQSUyMCUyMmF1dG8lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvZmZsb2FkX3BhcmFtJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGV2aWNlJTIyJTNBJTIwJTIyYXV0byUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2NsaXBwaW5nJTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYWluX2JhdGNoX3NpemUlMjIlM0ElMjAlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JTIyJTNBJTIwJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMiUzQSUyMCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJzdGVwc19wZXJfcHJpbnQlMjIlM0ElMjAyMDAwMDAwJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;bf16&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;enabled&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;zero_optimization&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;stage&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;stage3_gather_16bit_weights_on_model_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_optimizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;offload_param&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;device&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_clipping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;train_micro_batch_size_per_gpu&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;gradient_accumulation_steps&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;auto&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;steps_per_print&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2000000</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),tl=new d({props:{code:"RGlzdHJpYnV0ZWQlMjBlbnZpcm9ubWVudCUzQSUyMERFRVBTUEVFRCUyMCUyMEJhY2tlbmQlM0ElMjBuY2NsJTBBTnVtJTIwcHJvY2Vzc2VzJTNBJTIwNCUwQVByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFMb2NhbCUyMHByb2Nlc3MlMjBpbmRleCUzQSUyMDAlMEFEZXZpY2UlM0ElMjBjdWRhJTNBMCUwQU1peGVkJTIwcHJlY2lzaW9uJTIwdHlwZSUzQSUyMGZwMTYlMEFkc19jb25maWclM0ElMjAlN0InYmYxNiclM0ElMjAlN0InZW5hYmxlZCclM0ElMjBGYWxzZSU3RCUyQyUyMCd6ZXJvX29wdGltaXphdGlvbiclM0ElMjAlN0Inc3RhZ2UnJTNBJTIwMyUyQyUyMCdzdGFnZTNfZ2F0aGVyXzE2Yml0X3dlaWdodHNfb25fbW9kZWxfc2F2ZSclM0ElMjBUcnVlJTJDJTIwJ29mZmxvYWRfb3B0aW1pemVyJyUzQSUyMCU3QidkZXZpY2UnJTNBJTIwJ252bWUnJTdEJTJDJTIwJ29mZmxvYWRfcGFyYW0nJTNBJTIwJTdCJ2RldmljZSclM0ElMjAnY3B1JyU3RCU3RCUyQyUyMCdncmFkaWVudF9jbGlwcGluZyclM0ElMjAxLjAlMkMlMjAndHJhaW5fYmF0Y2hfc2l6ZSclM0ElMjAnYXV0byclMkMlMjAndHJhaW5fbWljcm9fYmF0Y2hfc2l6ZV9wZXJfZ3B1JyUzQSUyMCdhdXRvJyUyQyUyMCdncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMnJTNBJTIwNSUyQyUyMCdzdGVwc19wZXJfcHJpbnQnJTNBJTIwaW5mJTJDJTIwJ2ZwMTYnJTNBJTIwJTdCJ2VuYWJsZWQnJTNBJTIwVHJ1ZSUyQyUyMCdhdXRvX2Nhc3QnJTNBJTIwVHJ1ZSU3RCU3RA==",highlighted:`Distributed environment: DEEPSPEED  Backend: nccl
Num processes: 4
Process index: 0
Local process index: 0
Device: cuda:0
Mixed precision <span class="hljs-built_in">type</span>: fp16
ds_config: {<span class="hljs-string">&#x27;bf16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: False}, <span class="hljs-string">&#x27;zero_optimization&#x27;</span>: {<span class="hljs-string">&#x27;stage&#x27;</span>: 3, <span class="hljs-string">&#x27;stage3_gather_16bit_weights_on_model_save&#x27;</span>: True, <span class="hljs-string">&#x27;offload_optimizer&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;nvme&#x27;</span>}, <span class="hljs-string">&#x27;offload_param&#x27;</span>: {<span class="hljs-string">&#x27;device&#x27;</span>: <span class="hljs-string">&#x27;cpu&#x27;</span>}}, <span class="hljs-string">&#x27;gradient_clipping&#x27;</span>: 1.0, <span class="hljs-string">&#x27;train_batch_size&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;train_micro_batch_size_per_gpu&#x27;</span>: <span class="hljs-string">&#x27;auto&#x27;</span>, <span class="hljs-string">&#x27;gradient_accumulation_steps&#x27;</span>: 5, <span class="hljs-string">&#x27;steps_per_print&#x27;</span>: inf, <span class="hljs-string">&#x27;fp16&#x27;</span>: {<span class="hljs-string">&#x27;enabled&#x27;</span>: True, <span class="hljs-string">&#x27;auto_cast&#x27;</span>: True}}`,wrap:!1}}),nl=new f({props:{title:"Saving and loading",local:"saving-and-loading",headingTag:"h2"}}),pl=new d({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQSUwQSUyMyUyME5ldyUyMENvZGUlMjAlMjMlMEElMjMlMjBTYXZlcyUyMHRoZSUyMHdob2xlJTJGdW5wYXJ0aXRpb25lZCUyMGZwMTYlMjBtb2RlbCUyMHdoZW4lMjBpbiUyMFplUk8lMjBTdGFnZS0zJTIwdG8lMjB0aGUlMjBvdXRwdXQlMjBkaXJlY3RvcnklMjBpZiUwQSUyMyUyMCU2MHN0YWdlM19nYXRoZXJfMTZiaXRfd2VpZ2h0c19vbl9tb2RlbF9zYXZlJTYwJTIwaXMlMjBUcnVlJTIwaW4lMjBEZWVwU3BlZWQlMjBDb25maWclMjBmaWxlJTIwb3IlMEElMjMlMjAlNjB6ZXJvM19zYXZlXzE2Yml0X21vZGVsJTYwJTIwaXMlMjBUcnVlJTIwaW4lMjBEZWVwU3BlZWQlMjBQbHVnaW4uJTBBJTIzJTIwRm9yJTIwWmVybyUyMFN0YWdlcyUyMDElMjBhbmQlMjAyJTJDJTIwbW9kZWxzJTIwYXJlJTIwc2F2ZWQlMjBhcyUyMHVzdWFsJTIwaW4lMjB0aGUlMjBvdXRwdXQlMjBkaXJlY3RvcnkuJTBBJTIzJTIwVGhlJTIwbW9kZWwlMjBuYW1lJTIwc2F2ZWQlMjBpcyUyMCU2MHB5dG9yY2hfbW9kZWwuYmluJTYwJTBBdW53cmFwcGVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBhcmdzLm91dHB1dF9kaXIlMkMlMEElMjAlMjAlMjAlMjBpc19tYWluX3Byb2Nlc3MlM0RhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlMkMlMEElMjAlMjAlMjAlMjBzYXZlX2Z1bmN0aW9uJTNEYWNjZWxlcmF0b3Iuc2F2ZSUyQyUwQSUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlM0RhY2NlbGVyYXRvci5nZXRfc3RhdGVfZGljdChtb2RlbCklMkMlMEEp",highlighted:`unwrapped_model = accelerator.unwrap_model(model)

<span class="hljs-comment"># New Code #</span>
<span class="hljs-comment"># Saves the whole/unpartitioned fp16 model when in ZeRO Stage-3 to the output directory if</span>
<span class="hljs-comment"># \`stage3_gather_16bit_weights_on_model_save\` is True in DeepSpeed Config file or</span>
<span class="hljs-comment"># \`zero3_save_16bit_model\` is True in DeepSpeed Plugin.</span>
<span class="hljs-comment"># For Zero Stages 1 and 2, models are saved as usual in the output directory.</span>
<span class="hljs-comment"># The model name saved is \`pytorch_model.bin\`</span>
unwrapped_model.save_pretrained(
    args.output_dir,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
    state_dict=accelerator.get_state_dict(model),
)`,wrap:!1}}),il=new d({props:{code:"c3VjY2VzcyUyMCUzRCUyMG1vZGVsLnNhdmVfY2hlY2twb2ludChQQVRIJTJDJTIwY2twdF9pZCUyQyUyMGNoZWNrcG9pbnRfc3RhdGVfZGljdCklMEFzdGF0dXNfbXNnJTIwJTNEJTIwJTIyY2hlY2twb2ludGluZyUzQSUyMFBBVEglM0QlN0IlN0QlMkMlMjBja3B0X2lkJTNEJTdCJTdEJTIyLmZvcm1hdChQQVRIJTJDJTIwY2twdF9pZCklMEFpZiUyMHN1Y2Nlc3MlM0ElMEElMjAlMjAlMjAlMjBsb2dnaW5nLmluZm8oZiUyMlN1Y2Nlc3MlMjAlN0JzdGF0dXNfbXNnJTdEJTIyKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBsb2dnaW5nLndhcm5pbmcoZiUyMkZhaWx1cmUlMjAlN0JzdGF0dXNfbXNnJTdEJTIyKQ==",highlighted:`success = model.save_checkpoint(PATH, ckpt_id, checkpoint_state_dict)
status_msg = <span class="hljs-string">&quot;checkpointing: PATH={}, ckpt_id={}&quot;</span>.<span class="hljs-built_in">format</span>(PATH, ckpt_id)
<span class="hljs-keyword">if</span> success:
    logging.info(<span class="hljs-string">f&quot;Success <span class="hljs-subst">{status_msg}</span>&quot;</span>)
<span class="hljs-keyword">else</span>:
    logging.warning(<span class="hljs-string">f&quot;Failure <span class="hljs-subst">{status_msg}</span>&quot;</span>)`,wrap:!1}}),cl=new d({props:{code:"JTI0JTIwY2QlMjAlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50X2RpciUwQSUyNCUyMC4lMkZ6ZXJvX3RvX2ZwMzIucHklMjAuJTIwcHl0b3JjaF9tb2RlbC5iaW4lMEFQcm9jZXNzaW5nJTIwemVybyUyMGNoZWNrcG9pbnQlMjBhdCUyMGdsb2JhbF9zdGVwMSUwQURldGVjdGVkJTIwY2hlY2twb2ludCUyMG9mJTIwdHlwZSUyMHplcm8lMjBzdGFnZSUyMDMlMkMlMjB3b3JsZF9zaXplJTNBJTIwMiUwQVNhdmluZyUyMGZwMzIlMjBzdGF0ZSUyMGRpY3QlMjB0byUyMHB5dG9yY2hfbW9kZWwuYmluJTIwKHRvdGFsX251bWVsJTNENjA1MDY2MjQp",highlighted:`$ <span class="hljs-built_in">cd</span> /path/to/checkpoint_dir
$ ./zero_to_fp32.py . pytorch_model.bin
Processing zero checkpoint at global_step1
Detected checkpoint of <span class="hljs-built_in">type</span> zero stage 3, world_size: 2
Saving fp32 state dict to pytorch_model.bin (total_numel=60506624)`,wrap:!1}}),Ml=new d({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBsb2FkX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQlMEElMEF1bndyYXBwZWRfbW9kZWwlMjAlM0QlMjBhY2NlbGVyYXRvci51bndyYXBfbW9kZWwobW9kZWwpJTBBZnAzMl9tb2RlbCUyMCUzRCUyMGxvYWRfc3RhdGVfZGljdF9mcm9tX3plcm9fY2hlY2twb2ludCh1bndyYXBwZWRfbW9kZWwlMkMlMjBjaGVja3BvaW50X2Rpcik=",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> load_state_dict_from_zero_checkpoint

unwrapped_model = accelerator.unwrap_model(model)
fp32_model = load_state_dict_from_zero_checkpoint(unwrapped_model, checkpoint_dir)`,wrap:!1}}),ol=new d({props:{code:"ZnJvbSUyMGRlZXBzcGVlZC51dGlscy56ZXJvX3RvX2ZwMzIlMjBpbXBvcnQlMjBnZXRfZnAzMl9zdGF0ZV9kaWN0X2Zyb21femVyb19jaGVja3BvaW50JTBBJTBBc3RhdGVfZGljdCUyMCUzRCUyMGdldF9mcDMyX3N0YXRlX2RpY3RfZnJvbV96ZXJvX2NoZWNrcG9pbnQoY2hlY2twb2ludF9kaXIp",highlighted:`<span class="hljs-keyword">from</span> deepspeed.utils.zero_to_fp32 <span class="hljs-keyword">import</span> get_fp32_state_dict_from_zero_checkpoint

state_dict = get_fp32_state_dict_from_zero_checkpoint(checkpoint_dir)`,wrap:!1}}),ul=new f({props:{title:"ZeRO Inference",local:"zero-inference",headingTag:"h2"}}),yl=new d({props:{code:"bW9kZWwlMkMlMjBldmFsX2RhdGFsb2FkZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwZXZhbF9kYXRhbG9hZGVyKQ==",highlighted:"model, eval_dataloader = accelerator.prepare(model, eval_dataloader)",wrap:!1}}),jl=new f({props:{title:"Few caveats to be aware of",local:"few-caveats-to-be-aware-of",headingTag:"h2"}}),dl=new f({props:{title:"DeepSpeed Resources",local:"deepspeed-resources",headingTag:"h2"}}),{c(){m=p("meta"),Rl=e(),Yl=p("p"),xl=e(),M(W.$$.fragment),El=e(),S=p("p"),S.innerHTML=ae,Ql=e(),X=p("ol"),X.innerHTML=ee,kl=e(),N=p("p"),N.innerHTML=ne,ql=e(),A=p("p"),A.textContent=pe,Fl=e(),G=p("p"),G.textContent=ie,Hl=e(),v=p("p"),v.innerHTML=ce,$l=e(),z=p("ol"),z.innerHTML=Me,Ll=e(),M(Y.$$.fragment),Dl=e(),V=p("p"),V.textContent=oe,Pl=e(),R=p("ol"),R.innerHTML=ue,Ol=e(),x=p("p"),x.innerHTML=re,Kl=e(),E=p("p"),E.innerHTML=ye,st=e(),Q=p("p"),Q.innerHTML=je,lt=e(),k=p("p"),k.innerHTML=he,tt=e(),q=p("p"),q.innerHTML=de,at=e(),F=p("p"),F.innerHTML=Je,et=e(),H=p("p"),H.innerHTML=Ue,nt=e(),$=p("u"),$.textContent=we,pt=Nn(`: With respect to Disk Offload, the disk should be an NVME for decent speed but it technically works on any Disk
`),L=p("p"),L.textContent=Te,it=e(),D=p("ol"),D.innerHTML=me,ct=e(),M(P.$$.fragment),Mt=e(),O=p("p"),O.innerHTML=fe,ot=e(),K=p("p"),K.innerHTML=Ie,ut=e(),M(ss.$$.fragment),rt=e(),ls=p("p"),ls.textContent=be,yt=e(),M(ts.$$.fragment),jt=e(),as=p("p"),as.textContent=Ze,ht=e(),M(es.$$.fragment),dt=e(),ns=p("p"),ns.innerHTML=Ce,Jt=e(),ps=p("p"),ps.innerHTML=_e,Ut=e(),M(is.$$.fragment),wt=e(),M(cs.$$.fragment),Tt=e(),Ms=p("p"),Ms.innerHTML=Be,mt=e(),M(os.$$.fragment),ft=e(),M(us.$$.fragment),It=e(),rs=p("p"),rs.innerHTML=ge,bt=e(),M(ys.$$.fragment),Zt=e(),js=p("p"),js.textContent=We,Ct=e(),M(hs.$$.fragment),_t=e(),ds=p("p"),ds.textContent=Se,Bt=e(),M(Js.$$.fragment),gt=e(),Us=p("p"),Us.textContent=Xe,Wt=e(),M(ws.$$.fragment),St=e(),Ts=p("p"),Ts.innerHTML=Ne,Xt=e(),ms=p("p"),ms.innerHTML=Ae,Nt=e(),M(fs.$$.fragment),At=e(),Is=p("p"),Is.innerHTML=Ge,Gt=e(),M(bs.$$.fragment),vt=e(),M(Zs.$$.fragment),zt=e(),Cs=p("p"),Cs.innerHTML=ve,Yt=e(),M(_s.$$.fragment),Vt=e(),Bs=p("p"),Bs.innerHTML=ze,Rt=e(),M(gs.$$.fragment),xt=e(),M(Ws.$$.fragment),Et=e(),Ss=p("p"),Ss.innerHTML=Ye,Qt=e(),M(Xs.$$.fragment),kt=e(),Ns=p("p"),Ns.innerHTML=Ve,qt=e(),As=p("p"),As.innerHTML=Re,Ft=e(),I=p("ol"),w=p("li"),Il=p("p"),Il.innerHTML=xe,Ya=e(),bl=p("p"),bl.innerHTML=Ee,Va=e(),M(Gs.$$.fragment),Ra=e(),Zl=p("p"),Zl.innerHTML=Qe,xa=e(),Cl=p("p"),Cl.innerHTML=ke,Ea=e(),_l=p("p"),_l.innerHTML=qe,Qa=e(),Bl=p("li"),Bl.innerHTML=Fe,Ht=e(),vs=p("p"),vs.innerHTML=He,$t=e(),zs=p("ul"),zs.innerHTML=$e,Lt=e(),Ys=p("p"),Ys.innerHTML=Le,Dt=e(),Vs=p("p"),Vs.innerHTML=De,Pt=e(),Rs=p("p"),Rs.innerHTML=Pe,Ot=e(),xs=p("p"),xs.innerHTML=Oe,Kt=e(),M(Es.$$.fragment),sa=e(),Qs=p("p"),Qs.innerHTML=Ke,la=e(),ks=p("ol"),ks.innerHTML=sn,ta=e(),M(qs.$$.fragment),aa=e(),b=p("ol"),b.innerHTML=ln,ea=e(),M(Fs.$$.fragment),na=e(),Z=p("ol"),Z.innerHTML=tn,pa=e(),M(Hs.$$.fragment),ia=e(),$s=p("p"),$s.innerHTML=an,ca=e(),Ls=p("ol"),Ls.innerHTML=en,Ma=e(),M(Ds.$$.fragment),oa=e(),C=p("ol"),C.innerHTML=nn,ua=e(),M(Ps.$$.fragment),ra=e(),_=p("ol"),_.innerHTML=pn,ya=e(),M(Os.$$.fragment),ja=e(),Ks=p("p"),Ks.innerHTML=cn,ha=e(),sl=p("ol"),sl.innerHTML=Mn,da=e(),M(ll.$$.fragment),Ja=e(),B=p("ol"),B.innerHTML=on,Ua=e(),M(tl.$$.fragment),wa=e(),al=p("p"),al.innerHTML=un,Ta=e(),el=p("ol"),el.innerHTML=rn,ma=e(),M(nl.$$.fragment),fa=e(),g=p("ol"),gl=p("li"),gl.innerHTML=yn,ka=e(),J=p("li"),Wl=p("p"),Wl.innerHTML=jn,qa=e(),Sl=p("p"),Sl.innerHTML=hn,Fa=e(),M(pl.$$.fragment),Ha=e(),Xl=p("p"),Xl.innerHTML=dn,$a=e(),M(il.$$.fragment),La=e(),Nl=p("p"),Nl.innerHTML=Jn,Da=e(),M(cl.$$.fragment),Pa=e(),Al=p("p"),Al.textContent=Un,Oa=e(),M(Ml.$$.fragment),Ka=e(),Gl=p("p"),Gl.innerHTML=wn,se=e(),M(ol.$$.fragment),le=e(),vl=p("p"),vl.textContent=Tn,Ia=e(),M(ul.$$.fragment),ba=e(),rl=p("p"),rl.textContent=mn,Za=e(),M(yl.$$.fragment),Ca=e(),M(jl.$$.fragment),_a=e(),hl=p("ol"),hl.innerHTML=fn,Ba=e(),M(dl.$$.fragment),ga=e(),Jl=p("p"),Jl.innerHTML=In,Wa=e(),Ul=p("ul"),Ul.innerHTML=bn,Sa=e(),wl=p("p"),wl.textContent=Zn,Xa=e(),Tl=p("ul"),Tl.innerHTML=Cn,Na=e(),ml=p("p"),ml.innerHTML=_n,Aa=e(),Vl=p("p"),this.h()},l(s){const l=An("svelte-u9bgzb",document.head);m=i(l,"META",{name:!0,content:!0}),l.forEach(t),Rl=n(s),Yl=i(s,"P",{}),zl(Yl).forEach(t),xl=n(s),o(W.$$.fragment,s),El=n(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1ittrjc"&&(S.innerHTML=ae),Ql=n(s),X=i(s,"OL",{"data-svelte-h":!0}),c(X)!=="svelte-3z90ra"&&(X.innerHTML=ee),kl=n(s),N=i(s,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1ipy5tt"&&(N.innerHTML=ne),ql=n(s),A=i(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-iaccrf"&&(A.textContent=pe),Fl=n(s),G=i(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-l1xxpu"&&(G.textContent=ie),Hl=n(s),v=i(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1j8gyyc"&&(v.innerHTML=ce),$l=n(s),z=i(s,"OL",{"data-svelte-h":!0}),c(z)!=="svelte-15nzigp"&&(z.innerHTML=Me),Ll=n(s),o(Y.$$.fragment,s),Dl=n(s),V=i(s,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1igpel8"&&(V.textContent=oe),Pl=n(s),R=i(s,"OL",{"data-svelte-h":!0}),c(R)!=="svelte-1nija55"&&(R.innerHTML=ue),Ol=n(s),x=i(s,"P",{"data-svelte-h":!0}),c(x)!=="svelte-134sd43"&&(x.innerHTML=re),Kl=n(s),E=i(s,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1d4qqra"&&(E.innerHTML=ye),st=n(s),Q=i(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-n0e1lo"&&(Q.innerHTML=je),lt=n(s),k=i(s,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1ob4qwq"&&(k.innerHTML=he),tt=n(s),q=i(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-f1y4d9"&&(q.innerHTML=de),at=n(s),F=i(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1sgbcs5"&&(F.innerHTML=Je),et=n(s),H=i(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-yiw0au"&&(H.innerHTML=Ue),nt=n(s),$=i(s,"U",{"data-svelte-h":!0}),c($)!=="svelte-248d1k"&&($.textContent=we),pt=Gn(s,`: With respect to Disk Offload, the disk should be an NVME for decent speed but it technically works on any Disk
`),L=i(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1i9b1jx"&&(L.textContent=Te),it=n(s),D=i(s,"OL",{"data-svelte-h":!0}),c(D)!=="svelte-yjfbl7"&&(D.innerHTML=me),ct=n(s),o(P.$$.fragment,s),Mt=n(s),O=i(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1wpffgu"&&(O.innerHTML=fe),ot=n(s),K=i(s,"P",{"data-svelte-h":!0}),c(K)!=="svelte-yplg2o"&&(K.innerHTML=Ie),ut=n(s),o(ss.$$.fragment,s),rt=n(s),ls=i(s,"P",{"data-svelte-h":!0}),c(ls)!=="svelte-3pof6s"&&(ls.textContent=be),yt=n(s),o(ts.$$.fragment,s),jt=n(s),as=i(s,"P",{"data-svelte-h":!0}),c(as)!=="svelte-1ik26hy"&&(as.textContent=Ze),ht=n(s),o(es.$$.fragment,s),dt=n(s),ns=i(s,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-10u1bf7"&&(ns.innerHTML=Ce),Jt=n(s),ps=i(s,"P",{"data-svelte-h":!0}),c(ps)!=="svelte-vp1nym"&&(ps.innerHTML=_e),Ut=n(s),o(is.$$.fragment,s),wt=n(s),o(cs.$$.fragment,s),Tt=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-12x21g8"&&(Ms.innerHTML=Be),mt=n(s),o(os.$$.fragment,s),ft=n(s),o(us.$$.fragment,s),It=n(s),rs=i(s,"P",{"data-svelte-h":!0}),c(rs)!=="svelte-lh95an"&&(rs.innerHTML=ge),bt=n(s),o(ys.$$.fragment,s),Zt=n(s),js=i(s,"P",{"data-svelte-h":!0}),c(js)!=="svelte-1spmm13"&&(js.textContent=We),Ct=n(s),o(hs.$$.fragment,s),_t=n(s),ds=i(s,"P",{"data-svelte-h":!0}),c(ds)!=="svelte-3pof6s"&&(ds.textContent=Se),Bt=n(s),o(Js.$$.fragment,s),gt=n(s),Us=i(s,"P",{"data-svelte-h":!0}),c(Us)!=="svelte-1vp75xs"&&(Us.textContent=Xe),Wt=n(s),o(ws.$$.fragment,s),St=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),c(Ts)!=="svelte-17th5u9"&&(Ts.innerHTML=Ne),Xt=n(s),ms=i(s,"P",{"data-svelte-h":!0}),c(ms)!=="svelte-1l59g75"&&(ms.innerHTML=Ae),Nt=n(s),o(fs.$$.fragment,s),At=n(s),Is=i(s,"P",{"data-svelte-h":!0}),c(Is)!=="svelte-1iv8u1c"&&(Is.innerHTML=Ge),Gt=n(s),o(bs.$$.fragment,s),vt=n(s),o(Zs.$$.fragment,s),zt=n(s),Cs=i(s,"P",{"data-svelte-h":!0}),c(Cs)!=="svelte-3yuze5"&&(Cs.innerHTML=ve),Yt=n(s),o(_s.$$.fragment,s),Vt=n(s),Bs=i(s,"P",{"data-svelte-h":!0}),c(Bs)!=="svelte-15nfwtv"&&(Bs.innerHTML=ze),Rt=n(s),o(gs.$$.fragment,s),xt=n(s),o(Ws.$$.fragment,s),Et=n(s),Ss=i(s,"P",{"data-svelte-h":!0}),c(Ss)!=="svelte-1olkjml"&&(Ss.innerHTML=Ye),Qt=n(s),o(Xs.$$.fragment,s),kt=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),c(Ns)!=="svelte-14gqfge"&&(Ns.innerHTML=Ve),qt=n(s),As=i(s,"P",{"data-svelte-h":!0}),c(As)!=="svelte-1y80l2"&&(As.innerHTML=Re),Ft=n(s),I=i(s,"OL",{});var va=zl(I);w=i(va,"LI",{});var T=zl(w);Il=i(T,"P",{"data-svelte-h":!0}),c(Il)!=="svelte-19wri7m"&&(Il.innerHTML=xe),Ya=n(T),bl=i(T,"P",{"data-svelte-h":!0}),c(bl)!=="svelte-1w1lp0n"&&(bl.innerHTML=Ee),Va=n(T),o(Gs.$$.fragment,T),Ra=n(T),Zl=i(T,"P",{"data-svelte-h":!0}),c(Zl)!=="svelte-ce0g29"&&(Zl.innerHTML=Qe),xa=n(T),Cl=i(T,"P",{"data-svelte-h":!0}),c(Cl)!=="svelte-fgwfk1"&&(Cl.innerHTML=ke),Ea=n(T),_l=i(T,"P",{"data-svelte-h":!0}),c(_l)!=="svelte-jof0o2"&&(_l.innerHTML=qe),T.forEach(t),Qa=n(va),Bl=i(va,"LI",{"data-svelte-h":!0}),c(Bl)!=="svelte-1k2nlfe"&&(Bl.innerHTML=Fe),va.forEach(t),Ht=n(s),vs=i(s,"P",{"data-svelte-h":!0}),c(vs)!=="svelte-1nruzcp"&&(vs.innerHTML=He),$t=n(s),zs=i(s,"UL",{"data-svelte-h":!0}),c(zs)!=="svelte-uwy4ct"&&(zs.innerHTML=$e),Lt=n(s),Ys=i(s,"P",{"data-svelte-h":!0}),c(Ys)!=="svelte-1d6bbd1"&&(Ys.innerHTML=Le),Dt=n(s),Vs=i(s,"P",{"data-svelte-h":!0}),c(Vs)!=="svelte-nnfxti"&&(Vs.innerHTML=De),Pt=n(s),Rs=i(s,"P",{"data-svelte-h":!0}),c(Rs)!=="svelte-2eh81g"&&(Rs.innerHTML=Pe),Ot=n(s),xs=i(s,"P",{"data-svelte-h":!0}),c(xs)!=="svelte-1r2ikm1"&&(xs.innerHTML=Oe),Kt=n(s),o(Es.$$.fragment,s),sa=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-23a28o"&&(Qs.innerHTML=Ke),la=n(s),ks=i(s,"OL",{"data-svelte-h":!0}),c(ks)!=="svelte-835v9i"&&(ks.innerHTML=sn),ta=n(s),o(qs.$$.fragment,s),aa=n(s),b=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(b)!=="svelte-1f7op2x"&&(b.innerHTML=ln),ea=n(s),o(Fs.$$.fragment,s),na=n(s),Z=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(Z)!=="svelte-czp5cr"&&(Z.innerHTML=tn),pa=n(s),o(Hs.$$.fragment,s),ia=n(s),$s=i(s,"P",{"data-svelte-h":!0}),c($s)!=="svelte-57upna"&&($s.innerHTML=an),ca=n(s),Ls=i(s,"OL",{"data-svelte-h":!0}),c(Ls)!=="svelte-jop1mq"&&(Ls.innerHTML=en),Ma=n(s),o(Ds.$$.fragment,s),oa=n(s),C=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(C)!=="svelte-w41hdb"&&(C.innerHTML=nn),ua=n(s),o(Ps.$$.fragment,s),ra=n(s),_=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(_)!=="svelte-czp5cr"&&(_.innerHTML=pn),ya=n(s),o(Os.$$.fragment,s),ja=n(s),Ks=i(s,"P",{"data-svelte-h":!0}),c(Ks)!=="svelte-s6le15"&&(Ks.innerHTML=cn),ha=n(s),sl=i(s,"OL",{"data-svelte-h":!0}),c(sl)!=="svelte-q77lu7"&&(sl.innerHTML=Mn),da=n(s),o(ll.$$.fragment,s),Ja=n(s),B=i(s,"OL",{start:!0,"data-svelte-h":!0}),c(B)!=="svelte-18b0p9"&&(B.innerHTML=on),Ua=n(s),o(tl.$$.fragment,s),wa=n(s),al=i(s,"P",{"data-svelte-h":!0}),c(al)!=="svelte-pxb0rv"&&(al.innerHTML=un),Ta=n(s),el=i(s,"OL",{"data-svelte-h":!0}),c(el)!=="svelte-1x5f67y"&&(el.innerHTML=rn),ma=n(s),o(nl.$$.fragment,s),fa=n(s),g=i(s,"OL",{});var za=zl(g);gl=i(za,"LI",{"data-svelte-h":!0}),c(gl)!=="svelte-1ix3dy3"&&(gl.innerHTML=yn),ka=n(za),J=i(za,"LI",{});var U=zl(J);Wl=i(U,"P",{"data-svelte-h":!0}),c(Wl)!=="svelte-1vo2i9p"&&(Wl.innerHTML=jn),qa=n(U),Sl=i(U,"P",{"data-svelte-h":!0}),c(Sl)!=="svelte-hk8fhr"&&(Sl.innerHTML=hn),Fa=n(U),o(pl.$$.fragment,U),Ha=n(U),Xl=i(U,"P",{"data-svelte-h":!0}),c(Xl)!=="svelte-1ddq7v6"&&(Xl.innerHTML=dn),$a=n(U),o(il.$$.fragment,U),La=n(U),Nl=i(U,"P",{"data-svelte-h":!0}),c(Nl)!=="svelte-hmvopk"&&(Nl.innerHTML=Jn),Da=n(U),o(cl.$$.fragment,U),Pa=n(U),Al=i(U,"P",{"data-svelte-h":!0}),c(Al)!=="svelte-1hbu42f"&&(Al.textContent=Un),Oa=n(U),o(Ml.$$.fragment,U),Ka=n(U),Gl=i(U,"P",{"data-svelte-h":!0}),c(Gl)!=="svelte-h6u0m6"&&(Gl.innerHTML=wn),se=n(U),o(ol.$$.fragment,U),le=n(U),vl=i(U,"P",{"data-svelte-h":!0}),c(vl)!=="svelte-13dj8kw"&&(vl.textContent=Tn),U.forEach(t),za.forEach(t),Ia=n(s),o(ul.$$.fragment,s),ba=n(s),rl=i(s,"P",{"data-svelte-h":!0}),c(rl)!=="svelte-5ua48b"&&(rl.textContent=mn),Za=n(s),o(yl.$$.fragment,s),Ca=n(s),o(jl.$$.fragment,s),_a=n(s),hl=i(s,"OL",{"data-svelte-h":!0}),c(hl)!=="svelte-rz68fo"&&(hl.innerHTML=fn),Ba=n(s),o(dl.$$.fragment,s),ga=n(s),Jl=i(s,"P",{"data-svelte-h":!0}),c(Jl)!=="svelte-1aiu2sl"&&(Jl.innerHTML=In),Wa=n(s),Ul=i(s,"UL",{"data-svelte-h":!0}),c(Ul)!=="svelte-qibs9v"&&(Ul.innerHTML=bn),Sa=n(s),wl=i(s,"P",{"data-svelte-h":!0}),c(wl)!=="svelte-1pnpyer"&&(wl.textContent=Zn),Xa=n(s),Tl=i(s,"UL",{"data-svelte-h":!0}),c(Tl)!=="svelte-b1iyxy"&&(Tl.innerHTML=Cn),Na=n(s),ml=i(s,"P",{"data-svelte-h":!0}),c(ml)!=="svelte-kyi5s0"&&(ml.innerHTML=_n),Aa=n(s),Vl=i(s,"P",{}),zl(Vl).forEach(t),this.h()},h(){fl(m,"name","hf:doc:metadata"),fl(m,"content",zn),fl(b,"start","2"),fl(Z,"start","3"),fl(C,"start","2"),fl(_,"start","3"),fl(B,"start","2")},m(s,l){h(document.head,m),a(s,Rl,l),a(s,Yl,l),a(s,xl,l),u(W,s,l),a(s,El,l),a(s,S,l),a(s,Ql,l),a(s,X,l),a(s,kl,l),a(s,N,l),a(s,ql,l),a(s,A,l),a(s,Fl,l),a(s,G,l),a(s,Hl,l),a(s,v,l),a(s,$l,l),a(s,z,l),a(s,Ll,l),u(Y,s,l),a(s,Dl,l),a(s,V,l),a(s,Pl,l),a(s,R,l),a(s,Ol,l),a(s,x,l),a(s,Kl,l),a(s,E,l),a(s,st,l),a(s,Q,l),a(s,lt,l),a(s,k,l),a(s,tt,l),a(s,q,l),a(s,at,l),a(s,F,l),a(s,et,l),a(s,H,l),a(s,nt,l),a(s,$,l),a(s,pt,l),a(s,L,l),a(s,it,l),a(s,D,l),a(s,ct,l),u(P,s,l),a(s,Mt,l),a(s,O,l),a(s,ot,l),a(s,K,l),a(s,ut,l),u(ss,s,l),a(s,rt,l),a(s,ls,l),a(s,yt,l),u(ts,s,l),a(s,jt,l),a(s,as,l),a(s,ht,l),u(es,s,l),a(s,dt,l),a(s,ns,l),a(s,Jt,l),a(s,ps,l),a(s,Ut,l),u(is,s,l),a(s,wt,l),u(cs,s,l),a(s,Tt,l),a(s,Ms,l),a(s,mt,l),u(os,s,l),a(s,ft,l),u(us,s,l),a(s,It,l),a(s,rs,l),a(s,bt,l),u(ys,s,l),a(s,Zt,l),a(s,js,l),a(s,Ct,l),u(hs,s,l),a(s,_t,l),a(s,ds,l),a(s,Bt,l),u(Js,s,l),a(s,gt,l),a(s,Us,l),a(s,Wt,l),u(ws,s,l),a(s,St,l),a(s,Ts,l),a(s,Xt,l),a(s,ms,l),a(s,Nt,l),u(fs,s,l),a(s,At,l),a(s,Is,l),a(s,Gt,l),u(bs,s,l),a(s,vt,l),u(Zs,s,l),a(s,zt,l),a(s,Cs,l),a(s,Yt,l),u(_s,s,l),a(s,Vt,l),a(s,Bs,l),a(s,Rt,l),u(gs,s,l),a(s,xt,l),u(Ws,s,l),a(s,Et,l),a(s,Ss,l),a(s,Qt,l),u(Xs,s,l),a(s,kt,l),a(s,Ns,l),a(s,qt,l),a(s,As,l),a(s,Ft,l),a(s,I,l),h(I,w),h(w,Il),h(w,Ya),h(w,bl),h(w,Va),u(Gs,w,null),h(w,Ra),h(w,Zl),h(w,xa),h(w,Cl),h(w,Ea),h(w,_l),h(I,Qa),h(I,Bl),a(s,Ht,l),a(s,vs,l),a(s,$t,l),a(s,zs,l),a(s,Lt,l),a(s,Ys,l),a(s,Dt,l),a(s,Vs,l),a(s,Pt,l),a(s,Rs,l),a(s,Ot,l),a(s,xs,l),a(s,Kt,l),u(Es,s,l),a(s,sa,l),a(s,Qs,l),a(s,la,l),a(s,ks,l),a(s,ta,l),u(qs,s,l),a(s,aa,l),a(s,b,l),a(s,ea,l),u(Fs,s,l),a(s,na,l),a(s,Z,l),a(s,pa,l),u(Hs,s,l),a(s,ia,l),a(s,$s,l),a(s,ca,l),a(s,Ls,l),a(s,Ma,l),u(Ds,s,l),a(s,oa,l),a(s,C,l),a(s,ua,l),u(Ps,s,l),a(s,ra,l),a(s,_,l),a(s,ya,l),u(Os,s,l),a(s,ja,l),a(s,Ks,l),a(s,ha,l),a(s,sl,l),a(s,da,l),u(ll,s,l),a(s,Ja,l),a(s,B,l),a(s,Ua,l),u(tl,s,l),a(s,wa,l),a(s,al,l),a(s,Ta,l),a(s,el,l),a(s,ma,l),u(nl,s,l),a(s,fa,l),a(s,g,l),h(g,gl),h(g,ka),h(g,J),h(J,Wl),h(J,qa),h(J,Sl),h(J,Fa),u(pl,J,null),h(J,Ha),h(J,Xl),h(J,$a),u(il,J,null),h(J,La),h(J,Nl),h(J,Da),u(cl,J,null),h(J,Pa),h(J,Al),h(J,Oa),u(Ml,J,null),h(J,Ka),h(J,Gl),h(J,se),u(ol,J,null),h(J,le),h(J,vl),a(s,Ia,l),u(ul,s,l),a(s,ba,l),a(s,rl,l),a(s,Za,l),u(yl,s,l),a(s,Ca,l),u(jl,s,l),a(s,_a,l),a(s,hl,l),a(s,Ba,l),u(dl,s,l),a(s,ga,l),a(s,Jl,l),a(s,Wa,l),a(s,Ul,l),a(s,Sa,l),a(s,wl,l),a(s,Xa,l),a(s,Tl,l),a(s,Na,l),a(s,ml,l),a(s,Aa,l),a(s,Vl,l),Ga=!0},p:gn,i(s){Ga||(r(W.$$.fragment,s),r(Y.$$.fragment,s),r(P.$$.fragment,s),r(ss.$$.fragment,s),r(ts.$$.fragment,s),r(es.$$.fragment,s),r(is.$$.fragment,s),r(cs.$$.fragment,s),r(os.$$.fragment,s),r(us.$$.fragment,s),r(ys.$$.fragment,s),r(hs.$$.fragment,s),r(Js.$$.fragment,s),r(ws.$$.fragment,s),r(fs.$$.fragment,s),r(bs.$$.fragment,s),r(Zs.$$.fragment,s),r(_s.$$.fragment,s),r(gs.$$.fragment,s),r(Ws.$$.fragment,s),r(Xs.$$.fragment,s),r(Gs.$$.fragment,s),r(Es.$$.fragment,s),r(qs.$$.fragment,s),r(Fs.$$.fragment,s),r(Hs.$$.fragment,s),r(Ds.$$.fragment,s),r(Ps.$$.fragment,s),r(Os.$$.fragment,s),r(ll.$$.fragment,s),r(tl.$$.fragment,s),r(nl.$$.fragment,s),r(pl.$$.fragment,s),r(il.$$.fragment,s),r(cl.$$.fragment,s),r(Ml.$$.fragment,s),r(ol.$$.fragment,s),r(ul.$$.fragment,s),r(yl.$$.fragment,s),r(jl.$$.fragment,s),r(dl.$$.fragment,s),Ga=!0)},o(s){y(W.$$.fragment,s),y(Y.$$.fragment,s),y(P.$$.fragment,s),y(ss.$$.fragment,s),y(ts.$$.fragment,s),y(es.$$.fragment,s),y(is.$$.fragment,s),y(cs.$$.fragment,s),y(os.$$.fragment,s),y(us.$$.fragment,s),y(ys.$$.fragment,s),y(hs.$$.fragment,s),y(Js.$$.fragment,s),y(ws.$$.fragment,s),y(fs.$$.fragment,s),y(bs.$$.fragment,s),y(Zs.$$.fragment,s),y(_s.$$.fragment,s),y(gs.$$.fragment,s),y(Ws.$$.fragment,s),y(Xs.$$.fragment,s),y(Gs.$$.fragment,s),y(Es.$$.fragment,s),y(qs.$$.fragment,s),y(Fs.$$.fragment,s),y(Hs.$$.fragment,s),y(Ds.$$.fragment,s),y(Ps.$$.fragment,s),y(Os.$$.fragment,s),y(ll.$$.fragment,s),y(tl.$$.fragment,s),y(nl.$$.fragment,s),y(pl.$$.fragment,s),y(il.$$.fragment,s),y(cl.$$.fragment,s),y(Ml.$$.fragment,s),y(ol.$$.fragment,s),y(ul.$$.fragment,s),y(yl.$$.fragment,s),y(jl.$$.fragment,s),y(dl.$$.fragment,s),Ga=!1},d(s){s&&(t(Rl),t(Yl),t(xl),t(El),t(S),t(Ql),t(X),t(kl),t(N),t(ql),t(A),t(Fl),t(G),t(Hl),t(v),t($l),t(z),t(Ll),t(Dl),t(V),t(Pl),t(R),t(Ol),t(x),t(Kl),t(E),t(st),t(Q),t(lt),t(k),t(tt),t(q),t(at),t(F),t(et),t(H),t(nt),t($),t(pt),t(L),t(it),t(D),t(ct),t(Mt),t(O),t(ot),t(K),t(ut),t(rt),t(ls),t(yt),t(jt),t(as),t(ht),t(dt),t(ns),t(Jt),t(ps),t(Ut),t(wt),t(Tt),t(Ms),t(mt),t(ft),t(It),t(rs),t(bt),t(Zt),t(js),t(Ct),t(_t),t(ds),t(Bt),t(gt),t(Us),t(Wt),t(St),t(Ts),t(Xt),t(ms),t(Nt),t(At),t(Is),t(Gt),t(vt),t(zt),t(Cs),t(Yt),t(Vt),t(Bs),t(Rt),t(xt),t(Et),t(Ss),t(Qt),t(kt),t(Ns),t(qt),t(As),t(Ft),t(I),t(Ht),t(vs),t($t),t(zs),t(Lt),t(Ys),t(Dt),t(Vs),t(Pt),t(Rs),t(Ot),t(xs),t(Kt),t(sa),t(Qs),t(la),t(ks),t(ta),t(aa),t(b),t(ea),t(na),t(Z),t(pa),t(ia),t($s),t(ca),t(Ls),t(Ma),t(oa),t(C),t(ua),t(ra),t(_),t(ya),t(ja),t(Ks),t(ha),t(sl),t(da),t(Ja),t(B),t(Ua),t(wa),t(al),t(Ta),t(el),t(ma),t(fa),t(g),t(Ia),t(ba),t(rl),t(Za),t(Ca),t(_a),t(hl),t(Ba),t(ga),t(Jl),t(Wa),t(Ul),t(Sa),t(wl),t(Xa),t(Tl),t(Na),t(ml),t(Aa),t(Vl)),t(m),j(W,s),j(Y,s),j(P,s),j(ss,s),j(ts,s),j(es,s),j(is,s),j(cs,s),j(os,s),j(us,s),j(ys,s),j(hs,s),j(Js,s),j(ws,s),j(fs,s),j(bs,s),j(Zs,s),j(_s,s),j(gs,s),j(Ws,s),j(Xs,s),j(Gs),j(Es,s),j(qs,s),j(Fs,s),j(Hs,s),j(Ds,s),j(Ps,s),j(Os,s),j(ll,s),j(tl,s),j(nl,s),j(pl),j(il),j(cl),j(Ml),j(ol),j(ul,s),j(yl,s),j(jl,s),j(dl,s)}}}const zn='{"title":"DeepSpeed","local":"deepspeed","sections":[{"title":"What is integrated?","local":"what-is-integrated","sections":[],"depth":2},{"title":"How it works?","local":"how-it-works","sections":[{"title":"Accelerate DeepSpeed Plugin","local":"accelerate-deepspeed-plugin","sections":[],"depth":3},{"title":"DeepSpeed Config File","local":"deepspeed-config-file","sections":[],"depth":3}],"depth":2},{"title":"Saving and loading","local":"saving-and-loading","sections":[],"depth":2},{"title":"ZeRO Inference","local":"zero-inference","sections":[],"depth":2},{"title":"Few caveats to be aware of","local":"few-caveats-to-be-aware-of","sections":[],"depth":2},{"title":"DeepSpeed Resources","local":"deepspeed-resources","sections":[],"depth":2}],"depth":1}';function Yn(te){return Wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qn extends Sn{constructor(m){super(),Xn(this,m,Yn,vn,Bn,{})}}export{Qn as component};
