import{s as Bt,n as kt,o as Gt}from"../chunks/scheduler.bdbef820.js";import{S as vt,i as xt,g as p,s as l,r as h,A as Xt,h as i,f as a,c as n,j as Zt,u as c,x as m,k as y,y as $t,a as e,v as o,d as M,t as d,w as r}from"../chunks/index.c0aea24a.js";import{C as j}from"../chunks/CodeBlock.6ccca92e.js";import{H as At}from"../chunks/Heading.2eb892cb.js";function Rt(Os){let u,ms,ps,hs,C,cs,_,st=`Depth estimation datasets are used to train a model to approximate the relative distance of every pixel in an
image from the camera, also known as depth. The applications enabled by these datasets primarily lie in areas like visual machine
perception and perception in robotics. Example applications include mapping streets for self-driving cars. This guide will show you how to apply transformations
to a depth estimation dataset.`,os,I,tt="Before you start, make sure you have up-to-date versions of <code>albumentations</code> installed:",Ms,Z,ds,B,at=`<a href="https://albumentations.ai/" rel="nofollow">Albumentations</a> is a Python library for performing data augmentation
for computer vision. It supports various computer vision tasks such as image classification, object
detection, segmentation, and keypoint estimation.`,rs,k,et=`This guide uses the <a href="https://huggingface.co/datasets/sayakpaul/nyu_depth_v2" rel="nofollow">NYU Depth V2</a> dataset which is
comprised of video sequences from various indoor scenes, recorded by RGB and depth cameras. The dataset consists of scenes from 3 cities and provides images along with
their depth maps as labels.`,js,G,lt="Load the <code>train</code> split of the dataset and take a look at an example:",us,v,ys,x,nt="The dataset has two fields:",ws,X,pt="<li><code>image</code>: a PIL PNG image object with <code>uint8</code> data type.</li> <li><code>depth_map</code>: a PIL Tiff image object with <code>float32</code> data type which is the depth map of the image.</li>",gs,$,it="It is mention-worthy that JPEG/PNG format can only store <code>uint8</code> or <code>uint16</code> data. As the depth map is <code>float32</code> data, it can’t be stored using PNG/JPEG. However, we can save the depth map using TIFF format as it supports a wider range of data types, including <code>float32</code> data.",Js,A,mt="Next, check out an image with:",fs,R,Ts,w,ht='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_sample.png"/>',Us,W,ct="Before we look at the depth map, we need to first convert its data type to <code>uint8</code> using <code>.convert(&#39;RGB&#39;)</code> as PIL can’t display <code>float32</code> images. Now take a look at its corresponding depth map:",bs,H,Cs,g,ot='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_target.png"/>',_s,E,Mt='It’s all black! You’ll need to add some color to the depth map to visualize it properly. To do that, either we can apply color automatically during display using <code>plt.imshow()</code> or create a colored depth map using <code>plt.cm</code> and then display it. In this example, we have used the latter one, as we can save/write the colored depth map later. (the utility below is taken from the <a href="https://github.com/dwofk/fast-depth/blob/master/utils.py" rel="nofollow">FastDepth repository</a>).',Is,F,Zs,J,dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_target_viz.png"/>',Bs,Q,rt="You can also visualize several different images and their corresponding depth maps.",ks,V,Gs,f,jt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_collage.png"/>',vs,N,ut="Now apply some augmentations with <code>albumentations</code>. The augmentation transformations include:",xs,Y,yt="<li>Random horizontal flipping</li> <li>Random cropping</li> <li>Random brightness and contrast</li> <li>Random gamma correction</li> <li>Random hue saturation</li>",Xs,S,$s,z,wt="Additionally, define a mapping to better reflect the target key name.",As,L,Rs,q,gt=`With <code>additional_targets</code> defined, you can pass the target depth maps to the <code>depth</code> argument of <code>aug</code> instead of <code>mask</code>. You’ll notice this change
in the <code>apply_transforms()</code> function defined below.`,Ws,K,Jt="Create a function to apply the transformation to the images as well as their depth maps:",Hs,P,Es,D,ft='Use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to apply the transformation on-the-fly to batches of the dataset to consume less disk space:',Fs,O,Qs,ss,Tt="You can verify the transformation worked by indexing into the <code>pixel_values</code> and <code>labels</code> of an example image:",Vs,ts,Ns,T,Ut='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_sample_aug.png"/>',Ys,as,bt="Visualize the same transformation on the image’s corresponding depth map:",Ss,es,zs,U,Ct='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_target_aug.png"/>',Ls,ls,_t="You can also visualize multiple training samples reusing the previous <code>random_indices</code>:",qs,ns,Ks,b,It='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/depth_est_aug_collage.png"/>',Ps,is,Ds;return C=new At({props:{title:"Depth estimation",local:"depth-estimation",headingTag:"h1"}}),Z=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYWxidW1lbnRhdGlvbnMlMjA=",highlighted:"pip install -U albumentations ",wrap:!1}}),v=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzYXlha3BhdWwlMkZueXVfZGVwdGhfdjIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWluZGV4JTIwJTNEJTIwMTclMEFleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QmluZGV4JTVEJTBBZXhhbXBsZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = load_dataset(<span class="hljs-string">&quot;sayakpaul/nyu_depth_v2&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>index = <span class="hljs-number">17</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>example = train_dataset[index]
<span class="hljs-meta">&gt;&gt;&gt; </span>example
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.PngImagePlugin.PngImageFile image mode=RGB size=640x480&gt;,
 <span class="hljs-string">&#x27;depth_map&#x27;</span>: &lt;PIL.TiffImagePlugin.TiffImageFile image mode=F size=640x480&gt;}`,wrap:!1}}),R=new j({props:{code:"ZXhhbXBsZSU1QiUyMmltYWdlJTIyJTVE",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>example[<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),H=new j({props:{code:"ZXhhbXBsZSU1QiUyMmRlcHRoX21hcCUyMiU1RC5jb252ZXJ0KCUyMlJHQiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>example[<span class="hljs-string">&quot;depth_map&quot;</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)',wrap:!1}}),F=new j({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWNtYXAlMjAlM0QlMjBwbHQuY20udmlyaWRpcyUwQSUwQWRlZiUyMGNvbG9yZWRfZGVwdGhtYXAoZGVwdGglMkMlMjBkX21pbiUzRE5vbmUlMkMlMjBkX21heCUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBkX21pbiUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRfbWluJTIwJTNEJTIwbnAubWluKGRlcHRoKSUwQSUyMCUyMCUyMCUyMGlmJTIwZF9tYXglMjBpcyUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkX21heCUyMCUzRCUyMG5wLm1heChkZXB0aCklMEElMjAlMjAlMjAlMjBkZXB0aF9yZWxhdGl2ZSUyMCUzRCUyMChkZXB0aCUyMC0lMjBkX21pbiklMjAlMkYlMjAoZF9tYXglMjAtJTIwZF9taW4pJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwMjU1JTIwKiUyMGNtYXAoZGVwdGhfcmVsYXRpdmUpJTVCJTNBJTJDJTNBJTJDJTNBMyU1RCUwQSUwQWRlZiUyMHNob3dfZGVwdGhtYXAoZGVwdGhfbWFwKSUzQSUwQSUyMCUyMCUyMGlmJTIwbm90JTIwaXNpbnN0YW5jZShkZXB0aF9tYXAlMkMlMjBucC5uZGFycmF5KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlcHRoX21hcCUyMCUzRCUyMG5wLmFycmF5KGRlcHRoX21hcCklMEElMjAlMjAlMjBpZiUyMGRlcHRoX21hcC5uZGltJTIwJTNEJTNEJTIwMyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlcHRoX21hcCUyMCUzRCUyMGRlcHRoX21hcC5zcXVlZXplKCklMEElMEElMjAlMjAlMjBkX21pbiUyMCUzRCUyMG5wLm1pbihkZXB0aF9tYXApJTBBJTIwJTIwJTIwZF9tYXglMjAlM0QlMjBucC5tYXgoZGVwdGhfbWFwKSUwQSUyMCUyMCUyMGRlcHRoX21hcCUyMCUzRCUyMGNvbG9yZWRfZGVwdGhtYXAoZGVwdGhfbWFwJTJDJTIwZF9taW4lMkMlMjBkX21heCklMEElMEElMjAlMjAlMjBwbHQuaW1zaG93KGRlcHRoX21hcC5hc3R5cGUoJTIydWludDglMjIpKSUwQSUyMCUyMCUyMHBsdC5heGlzKCUyMm9mZiUyMiklMEElMjAlMjAlMjBwbHQuc2hvdygpJTBBJTBBc2hvd19kZXB0aG1hcChleGFtcGxlJTVCJTIyZGVwdGhfbWFwJTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>cmap = plt.cm.viridis

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">colored_depthmap</span>(<span class="hljs-params">depth, d_min=<span class="hljs-literal">None</span>, d_max=<span class="hljs-literal">None</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> d_min <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        d_min = np.<span class="hljs-built_in">min</span>(depth)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> d_max <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>        d_max = np.<span class="hljs-built_in">max</span>(depth)
<span class="hljs-meta">... </span>    depth_relative = (depth - d_min) / (d_max - d_min)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-number">255</span> * cmap(depth_relative)[:,:,:<span class="hljs-number">3</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">show_depthmap</span>(<span class="hljs-params">depth_map</span>):
<span class="hljs-meta">... </span>   <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">isinstance</span>(depth_map, np.ndarray):
<span class="hljs-meta">... </span>       depth_map = np.array(depth_map)
<span class="hljs-meta">... </span>   <span class="hljs-keyword">if</span> depth_map.ndim == <span class="hljs-number">3</span>:
<span class="hljs-meta">... </span>       depth_map = depth_map.squeeze()

<span class="hljs-meta">... </span>   d_min = np.<span class="hljs-built_in">min</span>(depth_map)
<span class="hljs-meta">... </span>   d_max = np.<span class="hljs-built_in">max</span>(depth_map)
<span class="hljs-meta">... </span>   depth_map = colored_depthmap(depth_map, d_min, d_max)

<span class="hljs-meta">... </span>   plt.imshow(depth_map.astype(<span class="hljs-string">&quot;uint8&quot;</span>))
<span class="hljs-meta">... </span>   plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">... </span>   plt.show()

<span class="hljs-meta">&gt;&gt;&gt; </span>show_depthmap(example[<span class="hljs-string">&quot;depth_map&quot;</span>])`,wrap:!1}}),V=new j({props:{code:"ZGVmJTIwbWVyZ2VfaW50b19yb3coaW5wdXRfaW1hZ2UlMkMlMjBkZXB0aF90YXJnZXQpJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpc2luc3RhbmNlKGlucHV0X2ltYWdlJTJDJTIwbnAubmRhcnJheSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pbWFnZSUyMCUzRCUyMG5wLmFycmF5KGlucHV0X2ltYWdlKSUwQSUyMCUyMCUyMCUyMGRfbWluJTIwJTNEJTIwbnAubWluKGRlcHRoX3RhcmdldCklMEElMjAlMjAlMjAlMjBkX21heCUyMCUzRCUyMG5wLm1heChkZXB0aF90YXJnZXQpJTBBJTIwJTIwJTIwJTIwZGVwdGhfdGFyZ2V0X2NvbCUyMCUzRCUyMGNvbG9yZWRfZGVwdGhtYXAoZGVwdGhfdGFyZ2V0JTJDJTIwZF9taW4lMkMlMjBkX21heCklMEElMjAlMjAlMjAlMjBpbWdfbWVyZ2UlMjAlM0QlMjBucC5oc3RhY2soJTVCaW5wdXRfaW1hZ2UlMkMlMjBkZXB0aF90YXJnZXRfY29sJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltZ19tZXJnZSUwQSUwQXJhbmRvbV9pbmRpY2VzJTIwJTNEJTIwbnAucmFuZG9tLmNob2ljZShsZW4odHJhaW5fZGF0YXNldCklMkMlMjA5KS50b2xpc3QoKSUwQXBsdC5maWd1cmUoZmlnc2l6ZSUzRCgxNSUyQyUyMDYpKSUwQWZvciUyMGklMkMlMjBpZHglMjBpbiUyMGVudW1lcmF0ZShyYW5kb21faW5kaWNlcyklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QmlkeCU1RCUwQSUyMCUyMCUyMCUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3QoMyUyQyUyMDMlMkMlMjBpJTIwJTJCJTIwMSklMEElMjAlMjAlMjAlMjBpbWFnZV92aXolMjAlM0QlMjBtZXJnZV9pbnRvX3JvdyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyZGVwdGhfbWFwJTIyJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHBsdC5pbXNob3coaW1hZ2Vfdml6LmFzdHlwZSglMjJ1aW50OCUyMikpJTBBJTIwJTIwJTIwJTIwcGx0LmF4aXMoJTIyb2ZmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_into_row</span>(<span class="hljs-params">input_image, depth_target</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">isinstance</span>(input_image, np.ndarray):
<span class="hljs-meta">... </span>        input_image = np.array(input_image)
...
<span class="hljs-meta">... </span>    d_min = np.<span class="hljs-built_in">min</span>(depth_target)
<span class="hljs-meta">... </span>    d_max = np.<span class="hljs-built_in">max</span>(depth_target)
<span class="hljs-meta">... </span>    depth_target_col = colored_depthmap(depth_target, d_min, d_max)
<span class="hljs-meta">... </span>    img_merge = np.hstack([input_image, depth_target_col])
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img_merge

<span class="hljs-meta">&gt;&gt;&gt; </span>random_indices = np.random.choice(<span class="hljs-built_in">len</span>(train_dataset), <span class="hljs-number">9</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">6</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(random_indices):
<span class="hljs-meta">... </span>    example = train_dataset[idx]
<span class="hljs-meta">... </span>    ax = plt.subplot(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>, i + <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image_viz = merge_into_row(
<span class="hljs-meta">... </span>        example[<span class="hljs-string">&quot;image&quot;</span>], example[<span class="hljs-string">&quot;depth_map&quot;</span>]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    plt.imshow(image_viz.astype(<span class="hljs-string">&quot;uint8&quot;</span>))
<span class="hljs-meta">... </span>    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)`,wrap:!1}}),S=new j({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMjBhcyUyMEElMEElMEFjcm9wX3NpemUlMjAlM0QlMjAoNDQ4JTJDJTIwNTc2KSUwQXRyYW5zZm9ybXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBBLkhvcml6b250YWxGbGlwKHAlM0QwLjUpJTJDJTBBJTIwJTIwJTIwJTIwQS5SYW5kb21Dcm9wKGNyb3Bfc2l6ZSU1QjAlNUQlMkMlMjBjcm9wX3NpemUlNUIxJTVEKSUyQyUwQSUyMCUyMCUyMCUyMEEuUmFuZG9tQnJpZ2h0bmVzc0NvbnRyYXN0KCklMkMlMEElMjAlMjAlMjAlMjBBLlJhbmRvbUdhbW1hKCklMkMlMEElMjAlMjAlMjAlMjBBLkh1ZVNhdHVyYXRpb25WYWx1ZSgpJTBBJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations <span class="hljs-keyword">as</span> A

<span class="hljs-meta">&gt;&gt;&gt; </span>crop_size = (<span class="hljs-number">448</span>, <span class="hljs-number">576</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transforms = [
<span class="hljs-meta">... </span>    A.HorizontalFlip(p=<span class="hljs-number">0.5</span>),
<span class="hljs-meta">... </span>    A.RandomCrop(crop_size[<span class="hljs-number">0</span>], crop_size[<span class="hljs-number">1</span>]),
<span class="hljs-meta">... </span>    A.RandomBrightnessContrast(),
<span class="hljs-meta">... </span>    A.RandomGamma(),
<span class="hljs-meta">... </span>    A.HueSaturationValue()
<span class="hljs-meta">... </span>]`,wrap:!1}}),L=new j({props:{code:"YWRkaXRpb25hbF90YXJnZXRzJTIwJTNEJTIwJTdCJTIyZGVwdGglMjIlM0ElMjAlMjJtYXNrJTIyJTdEJTBBYXVnJTIwJTNEJTIwQS5Db21wb3NlKHRyYW5zZm9ybXMlM0R0cmFuc2Zvcm1zJTJDJTIwYWRkaXRpb25hbF90YXJnZXRzJTNEYWRkaXRpb25hbF90YXJnZXRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>additional_targets = {<span class="hljs-string">&quot;depth&quot;</span>: <span class="hljs-string">&quot;mask&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>aug = A.Compose(transforms=transforms, additional_targets=additional_targets)`,wrap:!1}}),P=new j({props:{code:"ZGVmJTIwYXBwbHlfdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZF9pbWFnZXMlMkMlMjB0cmFuc2Zvcm1lZF9tYXBzJTIwJTNEJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW1hZ2UlMkMlMjBkZXB0aF9tYXAlMjBpbiUyMHppcChleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTJDJTIwZXhhbXBsZXMlNUIlMjJkZXB0aF9tYXAlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMkMlMjBkZXB0aF9tYXAlMjAlM0QlMjBucC5hcnJheShpbWFnZSklMkMlMjBucC5hcnJheShkZXB0aF9tYXApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtZWQlMjAlM0QlMjBhdWcoaW1hZ2UlM0RpbWFnZSUyQyUyMGRlcHRoJTNEZGVwdGhfbWFwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybWVkX2ltYWdlcy5hcHBlbmQodHJhbnNmb3JtZWQlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lZF9tYXBzLmFwcGVuZCh0cmFuc2Zvcm1lZCU1QiUyMmRlcHRoJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwdHJhbnNmb3JtZWRfaW1hZ2VzJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0cmFuc2Zvcm1lZF9tYXBzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">apply_transforms</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    transformed_images, transformed_maps = [], []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, depth_map <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;depth_map&quot;</span>]):
<span class="hljs-meta">... </span>        image, depth_map = np.array(image), np.array(depth_map)
<span class="hljs-meta">... </span>        transformed = aug(image=image, depth=depth_map)
<span class="hljs-meta">... </span>        transformed_images.append(transformed[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        transformed_maps.append(transformed[<span class="hljs-string">&quot;depth&quot;</span>])
...
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = transformed_images
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;labels&quot;</span>] = transformed_maps
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),O=new j({props:{code:"dHJhaW5fZGF0YXNldC5zZXRfdHJhbnNmb3JtKGFwcGx5X3RyYW5zZm9ybXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset.set_transform(apply_transforms)',wrap:!1}}),ts=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMHRyYWluX2RhdGFzZXQlNUJpbmRleCU1RCUwQSUwQXBsdC5pbXNob3coZXhhbXBsZSU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCklMEFwbHQuYXhpcyglMjJvZmYlMjIpJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = train_dataset[index]

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(example[<span class="hljs-string">&quot;pixel_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),es=new j({props:{code:"c2hvd19kZXB0aG1hcChleGFtcGxlJTVCJTIybGFiZWxzJTIyJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>show_depthmap(example[<span class="hljs-string">&quot;labels&quot;</span>])',wrap:!1}}),ns=new j({props:{code:"cGx0LmZpZ3VyZShmaWdzaXplJTNEKDE1JTJDJTIwNikpJTBBJTBBZm9yJTIwaSUyQyUyMGlkeCUyMGluJTIwZW51bWVyYXRlKHJhbmRvbV9pbmRpY2VzKSUzQSUwQSUyMCUyMCUyMCUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3QoMyUyQyUyMDMlMkMlMjBpJTIwJTJCJTIwMSklMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwdHJhaW5fZGF0YXNldCU1QmlkeCU1RCUwQSUyMCUyMCUyMCUyMGltYWdlX3ZpeiUyMCUzRCUyMG1lcmdlX2ludG9fcm93KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIybGFiZWxzJTIyJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHBsdC5pbXNob3coaW1hZ2Vfdml6LmFzdHlwZSglMjJ1aW50OCUyMikpJTBBJTIwJTIwJTIwJTIwcGx0LmF4aXMoJTIyb2ZmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">6</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(random_indices):
<span class="hljs-meta">... </span>    ax = plt.subplot(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>, i + <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    example = train_dataset[idx]
<span class="hljs-meta">... </span>    image_viz = merge_into_row(
<span class="hljs-meta">... </span>        example[<span class="hljs-string">&quot;pixel_values&quot;</span>], example[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    plt.imshow(image_viz.astype(<span class="hljs-string">&quot;uint8&quot;</span>))
<span class="hljs-meta">... </span>    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)`,wrap:!1}}),{c(){u=p("meta"),ms=l(),ps=p("p"),hs=l(),h(C.$$.fragment),cs=l(),_=p("p"),_.textContent=st,os=l(),I=p("p"),I.innerHTML=tt,Ms=l(),h(Z.$$.fragment),ds=l(),B=p("p"),B.innerHTML=at,rs=l(),k=p("p"),k.innerHTML=et,js=l(),G=p("p"),G.innerHTML=lt,us=l(),h(v.$$.fragment),ys=l(),x=p("p"),x.textContent=nt,ws=l(),X=p("ul"),X.innerHTML=pt,gs=l(),$=p("p"),$.innerHTML=it,Js=l(),A=p("p"),A.textContent=mt,fs=l(),h(R.$$.fragment),Ts=l(),w=p("div"),w.innerHTML=ht,Us=l(),W=p("p"),W.innerHTML=ct,bs=l(),h(H.$$.fragment),Cs=l(),g=p("div"),g.innerHTML=ot,_s=l(),E=p("p"),E.innerHTML=Mt,Is=l(),h(F.$$.fragment),Zs=l(),J=p("div"),J.innerHTML=dt,Bs=l(),Q=p("p"),Q.textContent=rt,ks=l(),h(V.$$.fragment),Gs=l(),f=p("div"),f.innerHTML=jt,vs=l(),N=p("p"),N.innerHTML=ut,xs=l(),Y=p("ul"),Y.innerHTML=yt,Xs=l(),h(S.$$.fragment),$s=l(),z=p("p"),z.textContent=wt,As=l(),h(L.$$.fragment),Rs=l(),q=p("p"),q.innerHTML=gt,Ws=l(),K=p("p"),K.textContent=Jt,Hs=l(),h(P.$$.fragment),Es=l(),D=p("p"),D.innerHTML=ft,Fs=l(),h(O.$$.fragment),Qs=l(),ss=p("p"),ss.innerHTML=Tt,Vs=l(),h(ts.$$.fragment),Ns=l(),T=p("div"),T.innerHTML=Ut,Ys=l(),as=p("p"),as.textContent=bt,Ss=l(),h(es.$$.fragment),zs=l(),U=p("div"),U.innerHTML=Ct,Ls=l(),ls=p("p"),ls.innerHTML=_t,qs=l(),h(ns.$$.fragment),Ks=l(),b=p("div"),b.innerHTML=It,Ps=l(),is=p("p"),this.h()},l(s){const t=Xt("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(a),ms=n(s),ps=i(s,"P",{}),Zt(ps).forEach(a),hs=n(s),c(C.$$.fragment,s),cs=n(s),_=i(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-10bebb7"&&(_.textContent=st),os=n(s),I=i(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1e3jamv"&&(I.innerHTML=tt),Ms=n(s),c(Z.$$.fragment,s),ds=n(s),B=i(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-180f5nb"&&(B.innerHTML=at),rs=n(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-rbl7ww"&&(k.innerHTML=et),js=n(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-pju1x0"&&(G.innerHTML=lt),us=n(s),c(v.$$.fragment,s),ys=n(s),x=i(s,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1wdl8tg"&&(x.textContent=nt),ws=n(s),X=i(s,"UL",{"data-svelte-h":!0}),m(X)!=="svelte-18g7ww2"&&(X.innerHTML=pt),gs=n(s),$=i(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-lgny84"&&($.innerHTML=it),Js=n(s),A=i(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-15dthpv"&&(A.textContent=mt),fs=n(s),c(R.$$.fragment,s),Ts=n(s),w=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(w)!=="svelte-1f5za0g"&&(w.innerHTML=ht),Us=n(s),W=i(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1rod9tf"&&(W.innerHTML=ct),bs=n(s),c(H.$$.fragment,s),Cs=n(s),g=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(g)!=="svelte-130rqhd"&&(g.innerHTML=ot),_s=n(s),E=i(s,"P",{"data-svelte-h":!0}),m(E)!=="svelte-16bopxj"&&(E.innerHTML=Mt),Is=n(s),c(F.$$.fragment,s),Zs=n(s),J=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(J)!=="svelte-16ha3wj"&&(J.innerHTML=dt),Bs=n(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-llua6z"&&(Q.textContent=rt),ks=n(s),c(V.$$.fragment,s),Gs=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(f)!=="svelte-16sg8kz"&&(f.innerHTML=jt),vs=n(s),N=i(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-18gbq1z"&&(N.innerHTML=ut),xs=n(s),Y=i(s,"UL",{"data-svelte-h":!0}),m(Y)!=="svelte-1r8fe9e"&&(Y.innerHTML=yt),Xs=n(s),c(S.$$.fragment,s),$s=n(s),z=i(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1yx9z74"&&(z.textContent=wt),As=n(s),c(L.$$.fragment,s),Rs=n(s),q=i(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1obm0dg"&&(q.innerHTML=gt),Ws=n(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-11hy1qw"&&(K.textContent=Jt),Hs=n(s),c(P.$$.fragment,s),Es=n(s),D=i(s,"P",{"data-svelte-h":!0}),m(D)!=="svelte-yeext9"&&(D.innerHTML=ft),Fs=n(s),c(O.$$.fragment,s),Qs=n(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-k3k6ue"&&(ss.innerHTML=Tt),Vs=n(s),c(ts.$$.fragment,s),Ns=n(s),T=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-1vylqwk"&&(T.innerHTML=Ut),Ys=n(s),as=i(s,"P",{"data-svelte-h":!0}),m(as)!=="svelte-1yo7m5l"&&(as.textContent=bt),Ss=n(s),c(es.$$.fragment,s),zs=n(s),U=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(U)!=="svelte-1wigtnh"&&(U.innerHTML=Ct),Ls=n(s),ls=i(s,"P",{"data-svelte-h":!0}),m(ls)!=="svelte-wsimbk"&&(ls.innerHTML=_t),qs=n(s),c(ns.$$.fragment,s),Ks=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-9icv47"&&(b.innerHTML=It),Ps=n(s),is=i(s,"P",{}),Zt(is).forEach(a),this.h()},h(){y(u,"name","hf:doc:metadata"),y(u,"content",Wt),y(w,"class","flex justify-center"),y(g,"class","flex justify-center"),y(J,"class","flex justify-center"),y(f,"class","flex justify-center"),y(T,"class","flex justify-center"),y(U,"class","flex justify-center"),y(b,"class","flex justify-center")},m(s,t){$t(document.head,u),e(s,ms,t),e(s,ps,t),e(s,hs,t),o(C,s,t),e(s,cs,t),e(s,_,t),e(s,os,t),e(s,I,t),e(s,Ms,t),o(Z,s,t),e(s,ds,t),e(s,B,t),e(s,rs,t),e(s,k,t),e(s,js,t),e(s,G,t),e(s,us,t),o(v,s,t),e(s,ys,t),e(s,x,t),e(s,ws,t),e(s,X,t),e(s,gs,t),e(s,$,t),e(s,Js,t),e(s,A,t),e(s,fs,t),o(R,s,t),e(s,Ts,t),e(s,w,t),e(s,Us,t),e(s,W,t),e(s,bs,t),o(H,s,t),e(s,Cs,t),e(s,g,t),e(s,_s,t),e(s,E,t),e(s,Is,t),o(F,s,t),e(s,Zs,t),e(s,J,t),e(s,Bs,t),e(s,Q,t),e(s,ks,t),o(V,s,t),e(s,Gs,t),e(s,f,t),e(s,vs,t),e(s,N,t),e(s,xs,t),e(s,Y,t),e(s,Xs,t),o(S,s,t),e(s,$s,t),e(s,z,t),e(s,As,t),o(L,s,t),e(s,Rs,t),e(s,q,t),e(s,Ws,t),e(s,K,t),e(s,Hs,t),o(P,s,t),e(s,Es,t),e(s,D,t),e(s,Fs,t),o(O,s,t),e(s,Qs,t),e(s,ss,t),e(s,Vs,t),o(ts,s,t),e(s,Ns,t),e(s,T,t),e(s,Ys,t),e(s,as,t),e(s,Ss,t),o(es,s,t),e(s,zs,t),e(s,U,t),e(s,Ls,t),e(s,ls,t),e(s,qs,t),o(ns,s,t),e(s,Ks,t),e(s,b,t),e(s,Ps,t),e(s,is,t),Ds=!0},p:kt,i(s){Ds||(M(C.$$.fragment,s),M(Z.$$.fragment,s),M(v.$$.fragment,s),M(R.$$.fragment,s),M(H.$$.fragment,s),M(F.$$.fragment,s),M(V.$$.fragment,s),M(S.$$.fragment,s),M(L.$$.fragment,s),M(P.$$.fragment,s),M(O.$$.fragment,s),M(ts.$$.fragment,s),M(es.$$.fragment,s),M(ns.$$.fragment,s),Ds=!0)},o(s){d(C.$$.fragment,s),d(Z.$$.fragment,s),d(v.$$.fragment,s),d(R.$$.fragment,s),d(H.$$.fragment,s),d(F.$$.fragment,s),d(V.$$.fragment,s),d(S.$$.fragment,s),d(L.$$.fragment,s),d(P.$$.fragment,s),d(O.$$.fragment,s),d(ts.$$.fragment,s),d(es.$$.fragment,s),d(ns.$$.fragment,s),Ds=!1},d(s){s&&(a(ms),a(ps),a(hs),a(cs),a(_),a(os),a(I),a(Ms),a(ds),a(B),a(rs),a(k),a(js),a(G),a(us),a(ys),a(x),a(ws),a(X),a(gs),a($),a(Js),a(A),a(fs),a(Ts),a(w),a(Us),a(W),a(bs),a(Cs),a(g),a(_s),a(E),a(Is),a(Zs),a(J),a(Bs),a(Q),a(ks),a(Gs),a(f),a(vs),a(N),a(xs),a(Y),a(Xs),a($s),a(z),a(As),a(Rs),a(q),a(Ws),a(K),a(Hs),a(Es),a(D),a(Fs),a(Qs),a(ss),a(Vs),a(Ns),a(T),a(Ys),a(as),a(Ss),a(zs),a(U),a(Ls),a(ls),a(qs),a(Ks),a(b),a(Ps),a(is)),a(u),r(C,s),r(Z,s),r(v,s),r(R,s),r(H,s),r(F,s),r(V,s),r(S,s),r(L,s),r(P,s),r(O,s),r(ts,s),r(es,s),r(ns,s)}}}const Wt='{"title":"Depth estimation","local":"depth-estimation","sections":[],"depth":1}';function Ht(Os){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends vt{constructor(u){super(),xt(this,u,Ht,Rt,Bt,{})}}export{Nt as component};
